/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementInsert
extends StatementDML {
    StatementInsert(Session session, Table targetTable, int[] columnMap, Expression insertExpression, boolean[] checkColumns, ParserDQL.CompileContext compileContext) {
        super(50, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable();
        this.insertColumnMap = columnMap;
        this.insertCheckColumns = checkColumns;
        this.insertExpression = insertExpression;
        this.isTransactionStatement = true;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementInsert(Session session, Table targetTable, int[] columnMap, boolean[] checkColumns, QueryExpression queryExpression, ParserDQL.CompileContext compileContext) {
        super(50, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable();
        this.insertColumnMap = columnMap;
        this.insertCheckColumns = checkColumns;
        this.queryExpression = queryExpression;
        this.isTransactionStatement = true;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        Table table = this.baseTable;
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        PersistentStore store = session.sessionData.getRowStore(this.baseTable);
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        RowSetNavigator newDataNavigator = this.queryExpression == null ? this.getInsertValuesNavigator(session) : this.getInsertSelectNavigator(session);
        Expression checkCondition = null;
        RangeVariable.RangeIteratorMain checkIterator = null;
        if (this.targetTable != this.baseTable) {
            QuerySpecification select = ((TableDerived)this.targetTable).getQueryExpression().getMainSelect();
            checkCondition = select.checkQueryCondition;
            if (checkCondition != null) {
                checkIterator = select.rangeVariables[0].getIterator(session);
            }
        }
        while (newDataNavigator.hasNext()) {
            Object[] data = newDataNavigator.getNext();
            if (checkCondition != null) {
                checkIterator.currentData = data;
                boolean check = checkCondition.testCondition(session);
                if (!check) {
                    throw Error.error(5700);
                }
            }
            table.insertRow(session, store, data);
            if (generatedNavigator == null) continue;
            Object[] generatedValues = this.getGeneratedColumns(data);
            generatedNavigator.add(generatedValues);
        }
        newDataNavigator.beforeFirst();
        table.fireTriggers(session, 0, newDataNavigator);
        if (resultOut == null) {
            resultOut = Result.getUpdateCountResult(newDataNavigator.getSize());
        } else {
            resultOut.setUpdateCount(newDataNavigator.getSize());
        }
        return resultOut;
    }

    RowSetNavigator getInsertSelectNavigator(Session session) {
        Type[] colTypes = this.baseTable.getColumnTypes();
        int[] columnMap = this.insertColumnMap;
        Result result = this.queryExpression.getResult(session, 0);
        RowSetNavigator nav = result.initialiseNavigator();
        Type[] sourceTypes = result.metaData.columnTypes;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(2);
        while (nav.hasNext()) {
            Object[] data = this.baseTable.getNewRowData(session);
            Object[] sourceData = nav.getNext();
            for (int i = 0; i < columnMap.length; ++i) {
                int j = columnMap[i];
                Type sourceType = sourceTypes[i];
                data[j] = colTypes[j].convertToType(session, sourceData[i], sourceType);
            }
            newData.add(data);
        }
        return newData;
    }

    RowSetNavigator getInsertValuesNavigator(Session session) {
        Type[] colTypes = this.baseTable.getColumnTypes();
        int[] columnMap = this.insertColumnMap;
        Expression[] list = this.insertExpression.nodes;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(list.length);
        for (int j = 0; j < list.length; ++j) {
            Expression[] rowArgs = list[j].nodes;
            Object[] data = this.baseTable.getNewRowData(session);
            session.sessionData.startRowProcessing();
            for (int i = 0; i < rowArgs.length; ++i) {
                Expression e = rowArgs[i];
                int colIndex = columnMap[i];
                if (e.getType() == 4) {
                    if (this.baseTable.identityColumn == colIndex || this.baseTable.colDefaults[colIndex] == null) continue;
                    data[colIndex] = this.baseTable.colDefaults[colIndex].getValue(session);
                    continue;
                }
                data[colIndex] = colTypes[colIndex].convertToType(session, e.getValue(session), e.getDataType());
            }
            newData.add(data);
        }
        return newData;
    }
}

