/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;

public class StatementExpression
extends StatementDMQL {
    Expression expression;

    StatementExpression(Session session, ParserDQL.CompileContext compileContext, int type, Expression expression) {
        super(type, 2007, null);
        this.isTransactionStatement = false;
        this.expression = expression;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.type) {
            case 58: {
                return this.sql;
            }
            case 1101: {
                sb.append(this.expression.getSQL());
            }
        }
        return sb.toString();
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        switch (this.type) {
            case 58: 
            case 1101: {
                return this.getResultValue(session);
            }
        }
        throw Error.runtimeError(401, "");
    }

    @Override
    public void resolve() {
        boolean resolved = false;
        switch (this.type) {
            case 58: {
                if (this.root.isProcedure()) {
                    throw Error.error(5602);
                }
                resolved = true;
                break;
            }
            case 1101: {
                resolved = true;
                break;
            }
            default: {
                throw Error.runtimeError(401, "");
            }
        }
        if (!resolved) {
            throw Error.error(5602);
        }
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    private Result getResultValue(Session session) {
        try {
            Object value = null;
            if (this.expression != null) {
                value = this.expression.getValue(session);
            }
            return Result.newPSMResult(this.type, null, value);
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
    }
}

