/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementResultUpdate;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.store.ValuePool;

public class SessionContext {
    Session session;
    HashMappedList sessionVariables;
    RangeVariable[] sessionVariablesRange;
    private HsqlArrayList stack;
    public Object[] routineArguments = ValuePool.emptyObjectArray;
    public Object[] routineVariables = ValuePool.emptyObjectArray;
    Object[] dynamicArguments = ValuePool.emptyObjectArray;
    public int depth;
    HashMappedList savepoints;
    LongDeque savepointTimestamps;
    RangeIterator[] rangeIterators;
    HashSet constraintPath;
    HashMappedList tableUpdateList;
    StatementResultUpdate rowUpdateStatement = new StatementResultUpdate();

    SessionContext(Session session) {
        this.session = session;
        this.rangeIterators = new RangeIterator[4];
        this.savepoints = new HashMappedList(4);
        this.savepointTimestamps = new LongDeque();
        this.sessionVariables = new HashMappedList();
        this.sessionVariablesRange = new RangeVariable[1];
        this.sessionVariablesRange[0] = new RangeVariable(this.sessionVariables, true);
    }

    public void push() {
        if (this.stack == null) {
            this.stack = new HsqlArrayList(true);
        }
        this.stack.add(this.dynamicArguments);
        this.stack.add(this.routineArguments);
        this.stack.add(this.routineVariables);
        this.stack.add(this.rangeIterators);
        this.stack.add(this.savepoints);
        this.stack.add(this.savepointTimestamps);
        this.rangeIterators = new RangeIterator[4];
        this.savepoints = new HashMappedList(4);
        this.savepointTimestamps = new LongDeque();
        String name = HsqlNameManager.getAutoSavepointNameString(this.session.actionTimestamp, this.depth);
        this.session.savepoint(name);
        ++this.depth;
    }

    public void pop() {
        this.savepointTimestamps = (LongDeque)this.stack.remove(this.stack.size() - 1);
        this.savepoints = (HashMappedList)this.stack.remove(this.stack.size() - 1);
        this.rangeIterators = (RangeIterator[])this.stack.remove(this.stack.size() - 1);
        this.routineVariables = (Object[])this.stack.remove(this.stack.size() - 1);
        this.routineArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        this.dynamicArguments = (Object[])this.stack.remove(this.stack.size() - 1);
        --this.depth;
    }

    public void pushDynamicArguments(Object[] args) {
        if (this.stack == null) {
            this.stack = new HsqlArrayList(true);
        }
        this.stack.add(this.dynamicArguments);
        this.dynamicArguments = args;
    }

    public void popDynamicArguments() {
        this.dynamicArguments = (Object[])this.stack.remove(this.stack.size() - 1);
    }

    void clearStructures(StatementDMQL cs) {
        int count;
        if (cs.type == 82 || cs.type == 19 || cs.type == 128) {
            if (this.constraintPath != null) {
                this.constraintPath.clear();
            }
            if (this.tableUpdateList != null) {
                for (int i = 0; i < this.tableUpdateList.size(); ++i) {
                    HashMappedList updateList = (HashMappedList)this.tableUpdateList.get(i);
                    updateList.clear();
                }
            }
        }
        if (cs.type == 50) {
            // empty if block
        }
        if ((count = cs.rangeIteratorCount) > this.rangeIterators.length) {
            count = this.rangeIterators.length;
        }
        for (int i = 0; i < count; ++i) {
            if (this.rangeIterators[i] == null) continue;
            this.rangeIterators[i].reset();
            this.rangeIterators[i] = null;
        }
    }

    public RangeVariable.RangeIteratorBase getCheckIterator(RangeVariable rangeVariable) {
        RangeIterator it = this.rangeIterators[1];
        if (it == null) {
            this.rangeIterators[1] = it = rangeVariable.getIterator(this.session);
        }
        return (RangeVariable.RangeIteratorBase)it;
    }

    public void setRangeIterator(RangeIterator iterator) {
        int position = iterator.getRangePosition();
        if (position >= this.rangeIterators.length) {
            this.rangeIterators = (RangeIterator[])ArrayUtil.resizeArray(this.rangeIterators, position + 1);
        }
        this.rangeIterators[iterator.getRangePosition()] = iterator;
    }

    public HashMappedList getTableUpdateList() {
        if (this.tableUpdateList == null) {
            this.tableUpdateList = new HashMappedList();
        }
        return this.tableUpdateList;
    }

    public HashSet getConstraintPath() {
        if (this.constraintPath == null) {
            this.constraintPath = new HashSet();
        }
        return this.constraintPath;
    }

    public void addSessionVariable(ColumnSchema variable) {
        int index = this.sessionVariables.size();
        if (!this.sessionVariables.add(variable.getName().name, variable)) {
            throw Error.error(5504);
        }
        Object[] vars = new Object[this.sessionVariables.size()];
        ArrayUtil.copyArray(this.routineVariables, vars, this.routineVariables.length);
        this.routineVariables = vars;
        this.routineVariables[index] = variable.getDefaultValue(this.session);
    }
}

