/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.hsqldb.Database;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserCommand;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SessionContext;
import org.hsqldb.SessionData;
import org.hsqldb.SessionInterface;
import org.hsqldb.Statement;
import org.hsqldb.StatementManager;
import org.hsqldb.StatementQuery;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.CountUpDownLatch;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.User;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class Session
implements SessionInterface {
    private volatile boolean isClosed;
    public Database database;
    private User sessionUser;
    private User user;
    private Grantee role;
    private volatile boolean isAutoCommit;
    private volatile boolean isReadOnly;
    boolean isReadOnlyDefault;
    int isolationModeDefault = 2;
    int isolationMode = 2;
    int actionIndex;
    long actionTimestamp;
    long transactionTimestamp;
    boolean isTransaction;
    boolean isBatch;
    volatile boolean abortTransaction;
    volatile boolean redoAction;
    HsqlArrayList rowActionList;
    volatile boolean tempUnlocked;
    OrderedHashSet waitingSessions;
    OrderedHashSet tempSet;
    CountUpDownLatch latch = new CountUpDownLatch();
    Statement currentStatement;
    Statement lockStatement;
    final String zoneString;
    final int sessionTimeZoneSeconds;
    int timeZoneSeconds;
    boolean isNetwork;
    private int currentMaxRows;
    private int sessionMaxRows;
    private Number lastIdentity = ValuePool.INTEGER_0;
    private final long sessionId;
    private boolean script;
    private JDBCConnection intConnection;
    public HsqlNameManager.HsqlName currentSchema;
    public HsqlNameManager.HsqlName loggedSchema;
    ParserCommand parser;
    boolean isProcessingScript;
    boolean isProcessingLog;
    public SessionContext sessionContext;
    int resultMaxMemoryRows;
    public SessionData sessionData;
    public StatementManager statementManager;
    private final long connectTime = System.currentTimeMillis();
    long currentDateSCN;
    long currentTimestampSCN;
    long currentMillis;
    private TimestampData currentDate;
    private TimestampData currentTimestamp;
    private TimestampData localTimestamp;
    private TimeData currentTime;
    private TimeData localTime;
    Table[] transitionTables = Table.emptyArray;
    HsqlDeque sqlWarnings;
    Calendar calendar;
    Scanner secondaryScanner;
    SimpleDateFormat simpleDateFormat;
    SimpleDateFormat simpleDateFormatGMT;
    Random randomGenerator = new Random();

    Session getSession() {
        return this;
    }

    Session(Database db, User user, boolean autocommit, boolean readonly, long id, String zoneString, int timeZoneSeconds) {
        this.sessionId = id;
        this.database = db;
        this.user = user;
        this.zoneString = zoneString;
        this.sessionTimeZoneSeconds = timeZoneSeconds;
        this.timeZoneSeconds = timeZoneSeconds;
        this.rowActionList = new HsqlArrayList(true);
        this.waitingSessions = new OrderedHashSet();
        this.tempSet = new OrderedHashSet();
        this.isAutoCommit = autocommit;
        this.isReadOnly = readonly;
        this.isolationMode = this.isolationModeDefault;
        this.sessionContext = new SessionContext(this);
        this.parser = new ParserCommand(this, new Scanner());
        this.setResultMemoryRowCount(this.database.getResultMaxMemoryRows());
        this.resetSchema();
        this.sessionData = new SessionData(this.database, this);
        this.statementManager = new StatementManager(this.database);
    }

    void resetSchema() {
        this.loggedSchema = null;
        this.currentSchema = this.user.getInitialOrDefaultSchema();
    }

    @Override
    public long getId() {
        return this.sessionId;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.rollback(false);
        try {
            this.database.logger.writeToLog(this, "DISCONNECT");
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.clearAllTables();
        this.sessionData.closeResultCache();
        this.statementManager.reset();
        this.database.sessionManager.removeSession(this);
        this.database.closeIfLast();
        this.database = null;
        this.user = null;
        this.rowActionList = null;
        this.sessionContext.savepoints = null;
        this.intConnection = null;
        this.sessionContext = null;
        this.lastIdentity = null;
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void setIsolationDefault(int level) {
        if (level == 1) {
            this.isReadOnlyDefault = true;
        }
        if (level == this.isolationModeDefault) {
            return;
        }
        this.isolationModeDefault = level;
        if (!this.isInMidTransaction()) {
            this.isolationMode = this.isolationModeDefault;
        }
        this.database.logger.writeToLog(this, this.getSessionIsolationSQL());
    }

    public void setIsolation(int level) {
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        if (level == 1) {
            this.isReadOnly = true;
        }
        this.isolationMode = level;
        if (this.isolationMode != this.isolationModeDefault) {
            this.database.logger.writeToLog(this, this.getTransactionIsolationSQL());
        }
    }

    @Override
    public synchronized int getIsolation() {
        return this.isolationMode;
    }

    void setLastIdentity(Number i) {
        this.lastIdentity = i;
    }

    public Number getLastIdentity() {
        return this.lastIdentity;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.user.getNameString();
    }

    public User getUser() {
        return this.user;
    }

    public Grantee getGrantee() {
        return this.user;
    }

    public Grantee getRole() {
        return this.role;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setRole(Grantee role) {
        this.role = role;
    }

    int getMaxRows() {
        return this.currentMaxRows;
    }

    public int getSQLMaxRows() {
        return this.sessionMaxRows;
    }

    void setSQLMaxRows(int rows) {
        this.currentMaxRows = this.sessionMaxRows = rows;
    }

    void checkAdmin() {
        this.user.checkAdmin();
    }

    void checkReadWrite() {
        if (this.isReadOnly) {
            throw Error.error(3706);
        }
    }

    void checkDDLWrite() {
        this.checkReadWrite();
        if (this.isProcessingScript || this.isProcessingLog) {
            return;
        }
    }

    public long getActionTimestamp() {
        return this.actionTimestamp;
    }

    void addDeleteAction(Table table, Row row) {
        if (this.abortTransaction) {
            // empty if block
        }
        this.database.txManager.addDeleteAction(this, table, row);
    }

    void addInsertAction(Table table, Row row) {
        this.database.txManager.addInsertAction(this, table, row);
        if (this.abortTransaction) {
            // empty if block
        }
    }

    @Override
    public synchronized void setAutoCommit(boolean autocommit) {
        if (this.isClosed) {
            return;
        }
        if (autocommit != this.isAutoCommit) {
            this.commit(false);
            this.isAutoCommit = autocommit;
        }
    }

    public void beginAction(Statement cs) {
        this.actionIndex = this.rowActionList.size();
        this.database.txManager.beginAction(this, cs);
    }

    public void endAction(Result r) {
        this.sessionData.persistentStoreCollection.clearStatementTables();
        if (r.isError()) {
            this.sessionData.persistentStoreCollection.clearResultTables(this.actionTimestamp);
            this.database.txManager.rollbackAction(this);
        } else {
            this.database.txManager.completeActions(this);
        }
    }

    public boolean hasLocks() {
        return false;
    }

    public void startTransaction() {
        this.database.txManager.beginTransaction(this);
    }

    @Override
    public synchronized void startPhasedTransaction() {
    }

    @Override
    public synchronized void prepareCommit() {
        if (this.isClosed) {
            throw Error.error(1303);
        }
        if (!this.database.txManager.prepareCommitActions(this)) {
            this.rollback(false);
            throw Error.error(4861);
        }
    }

    @Override
    public synchronized void commit(boolean chain) {
        if (this.isClosed) {
            return;
        }
        if (!this.isTransaction) {
            this.isReadOnly = this.isReadOnlyDefault;
            this.isolationMode = this.isolationModeDefault;
            return;
        }
        if (!this.database.txManager.commitTransaction(this)) {
            this.rollback(false);
            throw Error.error(4861);
        }
        this.endTransaction(true);
        if (this.database != null && this.database.logger.needsCheckpointReset()) {
            Statement checkpoint = ParserCommand.getCheckpointStatement(this.database, false);
            this.executeCompiledStatement(checkpoint, null);
        }
    }

    @Override
    public synchronized void rollback(boolean chain) {
        if (this.isClosed) {
            return;
        }
        if (!this.isTransaction) {
            this.isReadOnly = this.isReadOnlyDefault;
            this.isolationMode = this.isolationModeDefault;
            return;
        }
        try {
            this.database.logger.writeToLog(this, "ROLLBACK");
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.database.txManager.rollback(this);
        this.endTransaction(false);
    }

    private void endTransaction(boolean commit) {
        this.sessionData.updateLobUsage(commit);
        this.sessionContext.savepoints.clear();
        this.sessionContext.savepointTimestamps.clear();
        this.rowActionList.clear();
        this.sessionData.persistentStoreCollection.clearTransactionTables();
        this.sessionData.closeAllTransactionNavigators();
        this.isReadOnly = this.isReadOnlyDefault;
        this.isolationMode = this.isolationModeDefault;
        this.lockStatement = null;
    }

    @Override
    public synchronized void resetSession() {
        throw Error.error(1500);
    }

    @Override
    public synchronized void savepoint(String name) {
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index != -1) {
            this.sessionContext.savepoints.remove(name);
            this.sessionContext.savepointTimestamps.remove(index);
        }
        this.sessionContext.savepoints.add(name, ValuePool.getInt(this.rowActionList.size()));
        this.sessionContext.savepointTimestamps.addLast(this.actionTimestamp);
        try {
            this.database.logger.writeToLog(this, Session.getSavepointSQL(name));
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void rollbackToSavepoint(String name) {
        if (this.isClosed) {
            return;
        }
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index < 0) {
            throw Error.error(4821, name);
        }
        this.database.txManager.rollbackSavepoint(this, index);
        try {
            this.database.logger.writeToLog(this, Session.getSavepointRollbackSQL(name));
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public synchronized void rollbackToSavepoint() {
        if (this.isClosed) {
            return;
        }
        String name = (String)this.sessionContext.savepoints.getKey(0);
        this.database.txManager.rollbackSavepoint(this, 0);
        try {
            this.database.logger.writeToLog(this, Session.getSavepointRollbackSQL(name));
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void releaseSavepoint(String name) {
        int index = this.sessionContext.savepoints.getIndex(name);
        if (index < 0) {
            throw Error.error(4821, name);
        }
        while (this.sessionContext.savepoints.size() > index) {
            this.sessionContext.savepoints.remove(this.sessionContext.savepoints.size() - 1);
            this.sessionContext.savepointTimestamps.removeLast();
        }
    }

    public void setReadOnly(boolean readonly) {
        if (!readonly && this.database.databaseReadOnly) {
            throw Error.error(31);
        }
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        this.isReadOnly = readonly;
    }

    @Override
    public synchronized void setReadOnlyDefault(boolean readonly) {
        if (!readonly && this.database.databaseReadOnly) {
            throw Error.error(31);
        }
        this.isReadOnlyDefault = readonly;
        if (!this.isInMidTransaction()) {
            this.isReadOnly = this.isReadOnlyDefault;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public synchronized boolean isReadOnlyDefault() {
        return this.isReadOnlyDefault;
    }

    @Override
    public synchronized boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    @Override
    public synchronized int getStreamBlockSize() {
        return 524288;
    }

    public boolean isInMidTransaction() {
        return this.isTransaction;
    }

    void setScripting(boolean script) {
        this.script = script;
    }

    boolean isScripting() {
        return this.script;
    }

    JDBCConnection getInternalConnection() {
        if (this.intConnection == null) {
            this.intConnection = new JDBCConnection(this);
        }
        return this.intConnection;
    }

    public boolean isAdmin() {
        return this.user.isAdmin();
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public int getTransactionSize() {
        return this.rowActionList.size();
    }

    public long getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public Statement compileStatement(String sql) {
        this.parser.reset(sql);
        Statement cs = this.parser.compileStatement();
        return cs;
    }

    @Override
    public synchronized Result execute(Result cmd) {
        if (this.isClosed) {
            return Result.newErrorResult(Error.error(1353));
        }
        int type = cmd.getType();
        int maxRows = cmd.getUpdateCount();
        this.currentMaxRows = this.sessionMaxRows;
        JavaSystem.gc();
        switch (type) {
            case 18: {
                return this.performLOBOperation((ResultLob)cmd);
            }
            case 35: {
                if (maxRows == -1) {
                    this.currentMaxRows = 0;
                } else if (this.sessionMaxRows == 0) {
                    this.currentMaxRows = maxRows;
                }
                Result result = this.executeCompiledStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 9: {
                Result result = this.executeCompiledBatchStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 34: {
                if (maxRows == -1) {
                    this.currentMaxRows = 0;
                } else if (this.sessionMaxRows == 0) {
                    this.currentMaxRows = maxRows;
                }
                Result result = this.executeDirectStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 8: {
                Result result = this.executeDirectBatchStatement(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 37: {
                Statement cs;
                try {
                    cs = this.statementManager.compile(this, cmd);
                }
                catch (Throwable t) {
                    String errorString = cmd.getMainString();
                    if (this.database.getProperties().getErrorLevel() == 1) {
                        errorString = null;
                    }
                    return Result.newErrorResult(t, errorString);
                }
                cs.setGeneratedColumnInfo(cmd.getGeneratedResultType(), cmd.getGeneratedResultMetaData());
                Result result = Result.newPrepareResponse(cs);
                if (cs.getType() == 85 || cs.getType() == 7) {
                    this.sessionData.setResultSetProperties(cmd, result);
                }
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 40: {
                this.closeNavigator(cmd.getResultId());
                return Result.updateZeroResult;
            }
            case 41: {
                Result result = this.executeResultUpdate(cmd);
                result = this.performPostExecute(cmd, result);
                return result;
            }
            case 36: {
                this.statementManager.freeStatement(cmd.getStatementID());
                return Result.updateZeroResult;
            }
            case 7: {
                int id = cmd.getStatementType();
                return this.getAttributesResult(id);
            }
            case 6: {
                return this.setAttributes(cmd);
            }
            case 33: {
                switch (cmd.getActionType()) {
                    case 0: {
                        try {
                            this.commit(false);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 6: {
                        try {
                            this.commit(true);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 1: {
                        this.rollback(false);
                        break;
                    }
                    case 7: {
                        this.rollback(true);
                        break;
                    }
                    case 4: {
                        try {
                            String name = cmd.getMainString();
                            this.releaseSavepoint(name);
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                    case 2: {
                        try {
                            this.rollbackToSavepoint(cmd.getMainString());
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 38: {
                switch (cmd.getConnectionAttrType()) {
                    case 10027: {
                        try {
                            this.savepoint(cmd.getMainString());
                            break;
                        }
                        catch (Throwable t) {
                            return Result.newErrorResult(t);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 13: {
                return this.sessionData.getDataResultSlice(cmd.getResultId(), cmd.getUpdateCount(), cmd.getFetchSize());
            }
            case 32: {
                this.close();
                return Result.updateZeroResult;
            }
        }
        return Result.newErrorResult(Error.runtimeError(401, "Session"));
    }

    private Result performPostExecute(Result command, Result result) {
        if (result.isData()) {
            result = this.sessionData.getDataResultHead(command, result, this.isNetwork);
        }
        if (this.sqlWarnings != null && this.sqlWarnings.size() > 0) {
            HsqlException[] warnings = this.getAndClearWarnings();
            result.addWarnings(warnings);
        }
        return result;
    }

    @Override
    public RowSetNavigatorClient getRows(long navigatorId, int offset, int blockSize) {
        return this.sessionData.getRowSetSlice(navigatorId, offset, blockSize);
    }

    @Override
    public synchronized void closeNavigator(long id) {
        this.sessionData.closeNavigator(id);
    }

    public Result executeDirectStatement(Result cmd) {
        HsqlArrayList list;
        String sql = cmd.getMainString();
        try {
            list = this.parser.compileStatements(sql, cmd.getStatementType());
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        Result result = null;
        for (int i = 0; i < list.size(); ++i) {
            Statement cs = (Statement)list.get(i);
            cs.setGeneratedColumnInfo(cmd.getGeneratedResultType(), cmd.getGeneratedResultMetaData());
            result = this.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
            if (result.isError()) break;
        }
        return result;
    }

    public Result executeDirectStatement(String sql) {
        Statement cs;
        this.parser.reset(sql);
        try {
            cs = this.parser.compileStatement();
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        Result result = this.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
        return result;
    }

    public Result executeCompiledStatement(Statement cs, Object[] pvals) {
        Result r;
        if (this.abortTransaction) {
            this.rollback(false);
            return Result.newErrorResult(Error.error(4861));
        }
        this.currentStatement = cs;
        if (cs.isAutoCommitStatement()) {
            try {
                if (this.isReadOnly()) {
                    throw Error.error(3706);
                }
                this.commit(false);
            }
            catch (HsqlException e) {
                this.database.logger.logInfoEvent("Exception at commit");
            }
        }
        if (!cs.isTransactionStatement()) {
            Result r2 = cs.execute(this);
            this.currentStatement = null;
            return r2;
        }
        while (true) {
            this.beginAction(cs);
            if (this.abortTransaction) {
                this.rollback(false);
                this.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.abortTransaction) {
                this.rollback(false);
                this.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            this.sessionContext.pushDynamicArguments(pvals);
            r = cs.execute(this);
            this.sessionContext.popDynamicArguments();
            this.lockStatement = this.currentStatement;
            this.endAction(r);
            if (this.abortTransaction) {
                this.rollback(false);
                this.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            if (!this.redoAction) break;
            this.redoAction = false;
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                System.out.println("interrupted");
            }
        }
        if (this.sessionContext.depth == 0 && (this.isAutoCommit || cs.isAutoCommitStatement())) {
            try {
                if (r.isError()) {
                    this.rollback(false);
                } else {
                    this.commit(false);
                }
            }
            catch (Exception e) {
                this.currentStatement = null;
                return Result.newErrorResult(Error.error(4861, e));
            }
        }
        this.currentStatement = null;
        return r;
    }

    private Result executeCompiledBatchStatement(Result cmd) {
        long csid = cmd.getStatementID();
        Statement cs = this.statementManager.getStatement(this, csid);
        if (cs == null) {
            return Result.newErrorResult(Error.error(1251));
        }
        int count = 0;
        RowSetNavigator nav = cmd.initialiseNavigator();
        int[] updateCounts = new int[nav.getSize()];
        Result generatedResult = null;
        if (cs.hasGeneratedColumns()) {
            generatedResult = Result.newDataResult(cs.generatedResultMetaData());
        }
        Result error = null;
        this.isBatch = true;
        while (nav.hasNext()) {
            Object[] pvals = nav.getNext();
            Result in = this.executeCompiledStatement(cs, pvals);
            if (in.isUpdateCount()) {
                if (cs.hasGeneratedColumns()) {
                    RowSetNavigator navgen = in.getChainedResult().getNavigator();
                    while (navgen.hasNext()) {
                        Object[] generatedRow = navgen.getNext();
                        generatedResult.getNavigator().add(generatedRow);
                    }
                }
                updateCounts[count++] = in.getUpdateCount();
                continue;
            }
            if (in.isData()) {
                updateCounts[count++] = -2;
                continue;
            }
            if (in.isError()) {
                updateCounts = ArrayUtil.arraySlice(updateCounts, 0, count);
                error = in;
                break;
            }
            throw Error.runtimeError(401, "Session");
        }
        this.isBatch = false;
        this.sessionData.updateLobUsageForBatch();
        return Result.newBatchedExecuteResponse(updateCounts, generatedResult, error);
    }

    private Result executeDirectBatchStatement(Result cmd) {
        int count = 0;
        RowSetNavigator nav = cmd.initialiseNavigator();
        int[] updateCounts = new int[nav.getSize()];
        Result error = null;
        this.isBatch = true;
        while (nav.hasNext()) {
            Result in;
            Object[] data = nav.getNext();
            String sql = (String)data[0];
            try {
                in = this.executeDirectStatement(sql);
            }
            catch (Throwable t) {
                in = Result.newErrorResult(t);
            }
            if (in.isUpdateCount()) {
                updateCounts[count++] = in.getUpdateCount();
                continue;
            }
            if (in.isData()) {
                updateCounts[count++] = -2;
                continue;
            }
            if (in.isError()) {
                updateCounts = ArrayUtil.arraySlice(updateCounts, 0, count);
                error = in;
                break;
            }
            throw Error.runtimeError(401, "Session");
        }
        this.isBatch = false;
        this.sessionData.updateLobUsageForBatch();
        return Result.newBatchedExecuteResponse(updateCounts, null, error);
    }

    private Result executeCompiledStatement(Result cmd) {
        long csid;
        Statement cs = cmd.getStatement();
        if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp() && (cs = this.statementManager.getStatement(this, csid = cmd.getStatementID())) == null) {
            return Result.newErrorResult(Error.error(1252));
        }
        Object[] pvals = cmd.getParameterData();
        return this.executeCompiledStatement(cs, pvals);
    }

    private Result executeResultUpdate(Result cmd) {
        long id = cmd.getResultId();
        int actionType = cmd.getActionType();
        Result result = this.sessionData.getDataResult(id);
        if (result == null) {
            return Result.newErrorResult(Error.error(3601));
        }
        Object[] pvals = cmd.getParameterData();
        Type[] types = cmd.metaData.columnTypes;
        StatementQuery statement = (StatementQuery)result.getStatement();
        QueryExpression qe = statement.queryExpression;
        Table baseTable = qe.getBaseTable();
        int[] columnMap = qe.getBaseTableColumnMap();
        this.sessionContext.rowUpdateStatement.setRowActionProperties(actionType, baseTable, types, columnMap);
        Result resultOut = this.executeCompiledStatement(this.sessionContext.rowUpdateStatement, pvals);
        return resultOut;
    }

    @Override
    public synchronized TimestampData getCurrentDate() {
        this.resetCurrentTimestamp();
        if (this.currentDate == null) {
            this.currentDate = (TimestampData)Type.SQL_DATE.getValue(this.currentMillis / 1000L, 0, this.getZoneSeconds());
        }
        return this.currentDate;
    }

    synchronized TimeData getCurrentTime(boolean withZone) {
        this.resetCurrentTimestamp();
        if (withZone) {
            if (this.currentTime == null) {
                int seconds = (int)HsqlDateTime.getNormalisedTime(this.currentMillis) / 1000;
                int nanos = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTime = new TimeData(seconds, nanos, this.getZoneSeconds());
            }
            return this.currentTime;
        }
        if (this.localTime == null) {
            int seconds = (int)HsqlDateTime.getNormalisedTime(this.currentMillis + (long)(this.getZoneSeconds() * 1000)) / 1000;
            int nanos = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTime = new TimeData(seconds, nanos, 0);
        }
        return this.localTime;
    }

    synchronized TimestampData getCurrentTimestamp(boolean withZone) {
        this.resetCurrentTimestamp();
        if (withZone) {
            if (this.currentTimestamp == null) {
                int nanos = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTimestamp = new TimestampData(this.currentMillis / 1000L, nanos, this.getZoneSeconds());
            }
            return this.currentTimestamp;
        }
        if (this.localTimestamp == null) {
            int nanos = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTimestamp = new TimestampData(this.currentMillis / 1000L + (long)this.getZoneSeconds(), nanos, 0);
        }
        return this.localTimestamp;
    }

    private void resetCurrentTimestamp() {
        if (this.currentTimestampSCN != this.actionTimestamp) {
            this.currentTimestampSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTimestamp = null;
            this.localTimestamp = null;
            this.currentTime = null;
            this.localTime = null;
        }
    }

    @Override
    public int getZoneSeconds() {
        return this.timeZoneSeconds;
    }

    public void setZoneSeconds(int seconds) {
        if (seconds == this.sessionTimeZoneSeconds) {
            this.calendar = null;
        } else {
            TimeZone zone = TimeZone.getDefault();
            zone.setRawOffset(seconds * 1000);
            this.calendar = new GregorianCalendar(zone);
            this.timeZoneSeconds = seconds;
        }
    }

    private Result getAttributesResult(int id) {
        Result r = Result.newSessionAttributesResult();
        Object[] data = r.getSingleRowData();
        data[0] = ValuePool.getInt(id);
        switch (id) {
            case 0: {
                data[1] = ValuePool.getInt(this.isolationMode);
                break;
            }
            case 1: {
                data[2] = ValuePool.getBoolean(this.isAutoCommit);
                break;
            }
            case 2: {
                data[2] = ValuePool.getBoolean(this.isReadOnly);
                break;
            }
            case 3: {
                data[3] = this.database.getCatalogName().name;
            }
        }
        return r;
    }

    private Result setAttributes(Result r) {
        Object[] row = r.getSessionAttributes();
        int id = (Integer)row[0];
        try {
            switch (id) {
                case 1: {
                    boolean value = (Boolean)row[2];
                    this.setAutoCommit(value);
                    break;
                }
                case 2: {
                    boolean value = (Boolean)row[2];
                    this.setReadOnlyDefault(value);
                    break;
                }
                case 0: {
                    int value = (Integer)row[1];
                    this.setIsolation(value);
                    break;
                }
                case 3: {
                    String value = (String)row[3];
                    this.setCatalog(value);
                }
            }
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        return Result.updateZeroResult;
    }

    @Override
    public synchronized Object getAttribute(int id) {
        switch (id) {
            case 0: {
                return ValuePool.getInt(this.isolationMode);
            }
            case 1: {
                return ValuePool.getBoolean(this.isAutoCommit);
            }
            case 2: {
                return ValuePool.getBoolean(this.isReadOnly);
            }
            case 3: {
                return this.database.getCatalogName().name;
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(int id, Object object) {
        switch (id) {
            case 1: {
                boolean value = (Boolean)object;
                this.setAutoCommit(value);
                break;
            }
            case 2: {
                boolean value = (Boolean)object;
                this.setReadOnlyDefault(value);
                break;
            }
            case 0: {
                int value = (Integer)object;
                this.setIsolation(value);
                break;
            }
            case 3: {
                String value = (String)object;
                this.setCatalog(value);
            }
        }
    }

    @Override
    public BlobDataID createBlob(long length) {
        long lobID = this.database.lobManager.createBlob(length);
        if (lobID == 0L) {
            throw Error.error(3474);
        }
        this.sessionData.addToCreatedLobs(lobID);
        return new BlobDataID(lobID);
    }

    @Override
    public ClobDataID createClob(long length) {
        long lobID = this.database.lobManager.createClob(length);
        if (lobID == 0L) {
            throw Error.error(3474);
        }
        this.sessionData.addToCreatedLobs(lobID);
        return new ClobDataID(lobID);
    }

    public void registerResultLobs(Result result) {
        this.sessionData.registerLobForResult(result);
    }

    @Override
    public void allocateResultLob(ResultLob result, InputStream inputStream) {
        this.sessionData.allocateLobForResult(result, inputStream);
    }

    Result performLOBOperation(ResultLob cmd) {
        long id = cmd.getLobID();
        int operation = cmd.getSubType();
        switch (operation) {
            case 11: {
                return this.database.lobManager.getLob(this, id, cmd.getOffset(), cmd.getBlockLength());
            }
            case 10: {
                return this.database.lobManager.getLength(this, id);
            }
            case 1: {
                return this.database.lobManager.getBytes(this, id, cmd.getOffset(), (int)cmd.getBlockLength());
            }
            case 2: {
                return this.database.lobManager.setBytes(this, id, cmd.getByteArray(), cmd.getOffset());
            }
            case 3: {
                return this.database.lobManager.getChars(this, id, cmd.getOffset(), (int)cmd.getBlockLength());
            }
            case 4: {
                return this.database.lobManager.setChars(this, id, cmd.getOffset(), cmd.getCharArray());
            }
            case 9: {
                return this.database.lobManager.truncate(this, id, cmd.getOffset());
            }
        }
        throw Error.runtimeError(401, "Session");
    }

    @Override
    public String getInternalConnectionURL() {
        return "jdbc:hsqldb:" + this.database.getURI();
    }

    boolean isProcessingScript() {
        return this.isProcessingScript;
    }

    boolean isProcessingLog() {
        return this.isProcessingLog;
    }

    public void setSchema(String schema) {
        this.currentSchema = this.database.schemaManager.getSchemaHsqlName(schema);
    }

    public void setCatalog(String catalog) {
        if (this.database.getCatalogName().name.equals(catalog)) {
            return;
        }
        throw Error.error(4840);
    }

    HsqlNameManager.HsqlName getSchemaHsqlName(String name) {
        return name == null ? this.currentSchema : this.database.schemaManager.getSchemaHsqlName(name);
    }

    public String getSchemaName(String name) {
        return name == null ? this.currentSchema.name : this.database.schemaManager.getSchemaName(name);
    }

    public void setCurrentSchemaHsqlName(HsqlNameManager.HsqlName name) {
        this.currentSchema = name;
    }

    public HsqlNameManager.HsqlName getCurrentSchemaHsqlName() {
        return this.currentSchema;
    }

    public void setSessionTables(Table[] tables) {
        this.transitionTables = tables;
    }

    public Table findSessionTable(String name) {
        for (int i = 0; i < this.transitionTables.length; ++i) {
            if (!name.equals(this.transitionTables[i].getName().name)) continue;
            return this.transitionTables[i];
        }
        return null;
    }

    public int getResultMemoryRowCount() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMemoryRowCount(int count) {
        if (this.database.logger.getTempDirectoryPath() != null) {
            if (count <= 0) {
                count = Integer.MAX_VALUE;
            }
            this.resultMaxMemoryRows = count;
        }
    }

    @Override
    public void addWarning(HsqlException warning) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = new HsqlDeque();
        }
        if (this.sqlWarnings.size() > 9) {
            this.sqlWarnings.removeFirst();
        }
        if (this.sqlWarnings.contains(warning)) {
            return;
        }
        this.sqlWarnings.add(warning);
    }

    public HsqlException[] getAndClearWarnings() {
        if (this.sqlWarnings == null) {
            return HsqlException.emptyArray;
        }
        Object[] array = new HsqlException[this.sqlWarnings.size()];
        this.sqlWarnings.toArray(array);
        this.sqlWarnings.clear();
        return array;
    }

    public HsqlException getLastWarning() {
        if (this.sqlWarnings == null || this.sqlWarnings.size() == 0) {
            return null;
        }
        return (HsqlException)this.sqlWarnings.getLast();
    }

    public void clearWarnings() {
        if (this.sqlWarnings != null) {
            this.sqlWarnings.clear();
        }
    }

    @Override
    public Calendar getCalendar() {
        if (this.calendar == null) {
            if (this.zoneString == null) {
                this.calendar = new GregorianCalendar();
            } else {
                TimeZone zone = TimeZone.getTimeZone(this.zoneString);
                this.calendar = new GregorianCalendar(zone);
            }
        }
        return this.calendar;
    }

    public double random(long seed) {
        this.randomGenerator.setSeed(seed);
        return this.randomGenerator.nextDouble();
    }

    public double random() {
        return this.randomGenerator.nextDouble();
    }

    @Override
    public Scanner getScanner() {
        if (this.secondaryScanner == null) {
            this.secondaryScanner = new Scanner();
        }
        return this.secondaryScanner;
    }

    public SimpleDateFormat getSimpleDateFormatGMT() {
        if (this.simpleDateFormatGMT == null) {
            this.simpleDateFormatGMT = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            this.simpleDateFormatGMT.setCalendar(cal);
        }
        return this.simpleDateFormatGMT;
    }

    void logSequences() {
        OrderedHashSet set = this.sessionData.sequenceUpdateSet;
        if (set == null || set.isEmpty()) {
            return;
        }
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            NumberSequence sequence = (NumberSequence)set.get(i);
            this.database.logger.writeSequenceStatement(this, sequence);
        }
        this.sessionData.sequenceUpdateSet.clear();
    }

    static String getSavepointSQL(String name) {
        StringBuffer sb = new StringBuffer("SAVEPOINT");
        sb.append(' ').append('\"').append(name).append('\"');
        return sb.toString();
    }

    static String getSavepointRollbackSQL(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append("ROLLBACK").append(' ').append("TO").append(' ');
        sb.append("SAVEPOINT").append(' ');
        sb.append('\"').append(name).append('\"');
        return sb.toString();
    }

    String getStartTransactionSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("START").append(' ').append("TRANSACTION");
        if (this.isolationMode != this.isolationModeDefault) {
            sb.append(' ');
            Session.appendIsolationSQL(sb, this.isolationMode);
        }
        return sb.toString();
    }

    String getTransactionIsolationSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ').append("TRANSACTION");
        sb.append(' ');
        Session.appendIsolationSQL(sb, this.isolationMode);
        return sb.toString();
    }

    String getSessionIsolationSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ').append("SESSION");
        sb.append(' ').append("CHARACTERISTICS").append(' ');
        sb.append("AS").append(' ');
        Session.appendIsolationSQL(sb, this.isolationModeDefault);
        return sb.toString();
    }

    static void appendIsolationSQL(StringBuffer sb, int isolationLevel) {
        sb.append("ISOLATION").append(' ');
        sb.append("LEVEL").append(' ');
        switch (isolationLevel) {
            case 1: 
            case 2: {
                sb.append("READ").append(' ');
                sb.append("COMMITTED");
                break;
            }
            case 4: 
            case 8: {
                sb.append("SERIALIZABLE");
            }
        }
    }

    String getSetSchemaStatement() {
        return "SET SCHEMA " + this.currentSchema.statementName;
    }
}

