/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.store.BitMap;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class Routine
implements SchemaObject {
    public static final int NO_SQL = 1;
    public static final int CONTAINS_SQL = 2;
    public static final int READS_SQL = 3;
    public static final int MODIFIES_SQL = 4;
    public static final int LANGUAGE_JAVA = 1;
    public static final int LANGUAGE_SQL = 2;
    public static final int PARAM_STYLE_JAVA = 1;
    public static final int PARAM_STYLE_SQL = 2;
    static final Routine[] emptyArray = new Routine[0];
    RoutineSchema routineSchema;
    private HsqlNameManager.HsqlName name;
    private HsqlNameManager.HsqlName specificName;
    Type[] parameterTypes;
    int typeGroups;
    Type returnType;
    Type[] tableType;
    TableDerived returnTable;
    final int routineType;
    int language = 2;
    int dataImpact = 2;
    int parameterStyle;
    boolean isDeterministic;
    boolean isNullInputOutput;
    boolean isNewSavepointLevel = true;
    boolean isPSM;
    boolean returnsTable;
    Statement statement;
    private String methodName;
    Method javaMethod;
    boolean javaMethodWithConnection;
    private boolean isLibraryRoutine;
    HashMappedList parameterList = new HashMappedList();
    int scopeVariableCount;
    RangeVariable[] ranges = new RangeVariable[]{new RangeVariable(this.parameterList, false)};
    int variableCount;

    public Routine(int type) {
        this.routineType = type;
        this.returnType = Type.SQL_ALL_TYPES;
    }

    @Override
    public int getType() {
        return this.routineType;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        if (this.statement == null) {
            return new OrderedHashSet();
        }
        return this.statement.getReferences();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        if (this.routineType == 17) {
            sb.append("PROCEDURE");
        } else {
            sb.append("FUNCTION");
        }
        sb.append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName());
        sb.append('(');
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            ColumnSchema param = (ColumnSchema)this.parameterList.get(i);
            sb.append(param.getSQL());
        }
        sb.append(')');
        sb.append(' ');
        if (this.routineType == 16) {
            sb.append("RETURNS");
            sb.append(' ');
            sb.append(this.returnType.getTypeDefinition());
            sb.append(' ');
        }
        if (this.specificName != null) {
            sb.append("SPECIFIC");
            sb.append(' ');
            sb.append(this.specificName.getStatementName());
            sb.append(' ');
        }
        sb.append("LANGUAGE");
        sb.append(' ');
        if (this.language == 1) {
            sb.append("JAVA");
        } else {
            sb.append("SQL");
        }
        sb.append(' ');
        if (!this.isDeterministic) {
            sb.append("NOT");
            sb.append(' ');
        }
        sb.append("DETERMINISTIC");
        sb.append(' ');
        sb.append(this.getDataImpactString());
        sb.append(' ');
        if (this.routineType == 16) {
            if (this.isNullInputOutput) {
                sb.append("RETURNS").append(' ').append("NULL");
            } else {
                sb.append("CALLED");
            }
            sb.append(' ').append("ON").append(' ');
            sb.append("NULL").append(' ').append("INPUT");
            sb.append(' ');
        } else {
            if (this.isNewSavepointLevel) {
                sb.append("NEW");
            } else {
                sb.append("OLD");
            }
            sb.append(' ').append("SAVEPOINT").append(' ');
            sb.append("LEVEL").append(' ');
        }
        if (this.language == 1) {
            sb.append("EXTERNAL").append(' ').append("NAME");
            sb.append(' ').append('\'').append(this.methodName).append('\'');
        } else {
            sb.append(this.statement.getSQL());
        }
        return sb.toString();
    }

    public void addParameter(ColumnSchema param) {
        HsqlNameManager.HsqlName name = param.getName();
        String paramName = name == null ? HsqlNameManager.getAutoNoNameColumnString(this.parameterList.size()) : name.name;
        this.parameterList.add(paramName, param);
    }

    public void setLanguage(int lang) {
        this.language = lang;
        this.isPSM = this.language == 2;
    }

    public int getLanguage() {
        return this.language;
    }

    boolean isPSM() {
        return this.isPSM;
    }

    public void setDataImpact(int impact) {
        this.dataImpact = impact;
    }

    public int getDataImpact() {
        return this.dataImpact;
    }

    public String getDataImpactString() {
        StringBuffer sb = new StringBuffer();
        switch (this.dataImpact) {
            case 1: {
                sb.append("NO").append(' ').append("SQL");
                break;
            }
            case 2: {
                sb.append("CONTAINS").append(' ').append("SQL");
                break;
            }
            case 3: {
                sb.append("READS").append(' ').append("SQL").append(' ').append("DATA");
                break;
            }
            case 4: {
                sb.append("MODIFIES").append(' ').append("SQL").append(' ').append("DATA");
            }
        }
        return sb.toString();
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setTableType(Type[] types) {
        this.tableType = types;
    }

    public Type[] getTableType() {
        return this.tableType;
    }

    public void setProcedure(Statement statement) {
        this.statement = statement;
    }

    public Statement getProcedure() {
        return this.statement;
    }

    public void setSpecificName(HsqlNameManager.HsqlName name) {
        this.specificName = name;
    }

    public void setName(HsqlNameManager.HsqlName name) {
        this.name = name;
    }

    public HsqlNameManager.HsqlName getSpecificName() {
        return this.specificName;
    }

    public void setDeterministic(boolean value) {
        this.isDeterministic = value;
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public void setNullInputOutput(boolean value) {
        this.isNullInputOutput = value;
    }

    public boolean isNullInputOutput() {
        return this.isNullInputOutput;
    }

    public void setNewSavepointLevel(boolean value) {
        this.isNewSavepointLevel = value;
    }

    public void setParameterStyle(int style) {
        this.parameterStyle = style;
    }

    public void setMethodURL(String url) {
        this.methodName = url;
    }

    public Method getMethod() {
        return this.javaMethod;
    }

    public void setMethod(Method method) {
        this.javaMethod = method;
    }

    public void setReturnTable(TableDerived table) {
        this.returnTable = table;
        this.returnsTable = true;
    }

    public boolean returnsTable() {
        return this.returnsTable;
    }

    public void resolve() {
        if (this.routineType == 17 && this.isNewSavepointLevel && this.dataImpact != 4) {
            throw Error.error(5604);
        }
        this.setLanguage(this.language);
        if (this.language == 2) {
            if (this.dataImpact == 1) {
                throw Error.error(5604);
            }
            if (this.parameterStyle == 1) {
                throw Error.error(5604);
            }
        }
        if (this.language == 2 && this.parameterStyle != 0 && this.parameterStyle != 2) {
            throw Error.error(5604);
        }
        this.parameterTypes = new Type[this.parameterList.size()];
        this.typeGroups = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            ColumnSchema param = (ColumnSchema)this.parameterList.get(i);
            this.parameterTypes[i] = param.dataType;
            if (i >= 4) continue;
            BitMap.setByte(this.typeGroups, (byte)param.dataType.typeComparisonGroup, i * 8);
        }
        if (this.statement != null) {
            this.statement.resolve();
        }
        if (this.methodName != null && this.javaMethod == null) {
            boolean[] hasConnection = new boolean[1];
            this.javaMethod = Routine.getMethod(this.methodName, this, hasConnection);
            if (this.javaMethod == null) {
                throw Error.error(6013);
            }
            this.javaMethodWithConnection = hasConnection[0];
        }
    }

    public boolean isProcedure() {
        return this.routineType == 17;
    }

    public boolean isFunction() {
        return this.routineType == 16;
    }

    public ColumnSchema getParameter(int i) {
        return (ColumnSchema)this.parameterList.get(i);
    }

    Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    int getParameterSignature() {
        return this.typeGroups;
    }

    public int getParameterCount() {
        return this.parameterTypes.length;
    }

    public int getParameterCount(int type) {
        int count = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            ColumnSchema col = (ColumnSchema)this.parameterList.get(i);
            if (col.getParameterMode() != type) continue;
            ++count;
        }
        return count;
    }

    public int getParameterIndex(String name) {
        return this.parameterList.getIndex(name);
    }

    public RangeVariable[] getParameterRangeVariables() {
        return this.ranges;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public boolean isLibraryRoutine() {
        return this.isLibraryRoutine;
    }

    public HsqlNameManager.HsqlName[] getTableNamesForRead() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForRead();
    }

    public HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        if (this.statement == null) {
            return HsqlNameManager.HsqlName.emptyArray;
        }
        return this.statement.getTableNamesForWrite();
    }

    static Method getMethod(String name, Routine routine, boolean[] hasConnection) {
        int i = name.indexOf(58);
        if (i != -1) {
            if (!name.substring(0, i).equals("CLASSPATH")) {
                throw Error.error(6012, name);
            }
            name = name.substring(i + 1);
        }
        Method method = null;
        Method[] methods = Routine.getMethods(name);
        for (i = 0; i < methods.length; ++i) {
            Class<?> param;
            Type methodParamType;
            Type methodReturnType;
            int offset = 0;
            Class<?>[] params = methods[i].getParameterTypes();
            if (params.length > 0 && params[0].equals(Connection.class)) {
                offset = 1;
                hasConnection[0] = true;
            }
            if (params.length - offset != routine.parameterTypes.length || (methodReturnType = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(methods[i].getReturnType()))) == null || methodReturnType.typeCode != routine.returnType.typeCode) continue;
            method = methods[i];
            for (int j = 0; j < routine.parameterTypes.length && (methodParamType = Type.getDefaultType(Types.getParameterSQLTypeNumber(param = params[j + offset]))) != null; ++j) {
                routine.getParameter(j).setNullable(!params[i].isPrimitive());
                if (routine.parameterTypes[j].typeCode == methodParamType.typeCode) continue;
                method = null;
                break;
            }
            if (method != null) break;
        }
        return method;
    }

    static Method[] getMethods(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            throw Error.error(5501, name);
        }
        String classname = name.substring(0, i);
        String methodname = name.substring(i + 1);
        Class<?> classinstance = null;
        try {
            classinstance = Class.forName(classname);
        }
        catch (Throwable t) {
            throw Error.error(t, 5501, 115, new Object[]{t.getMessage(), classname});
        }
        Method[] methods = classinstance.getMethods();
        HsqlArrayList list = new HsqlArrayList();
        for (i = 0; i < methods.length; ++i) {
            Type methodReturnType;
            int offset = 0;
            Method m = methods[i];
            int modifiers = m.getModifiers();
            if (!m.getName().equals(methodname) || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            Class<?>[] params = methods[i].getParameterTypes();
            if (params.length > 0 && params[0].equals(Connection.class)) {
                offset = 1;
            }
            for (int j = offset; j < params.length; ++j) {
                Class<?> param = params[j];
                Type methodParamType = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(param));
                if (methodParamType != null) continue;
                m = null;
                break;
            }
            if (m == null || (methodReturnType = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(m.getReturnType()))) == null) continue;
            list.add(methods[i]);
        }
        methods = new Method[list.size()];
        list.toArray(methods);
        return methods;
    }

    public static Routine[] newRoutines(Method[] methods) {
        Routine[] routines = new Routine[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            routines[i] = Routine.newRoutine(method);
        }
        return routines;
    }

    public static Routine newRoutine(Method method) {
        Routine routine = new Routine(16);
        int offset = 0;
        Class<?>[] params = method.getParameterTypes();
        String className = method.getDeclaringClass().getName();
        StringBuffer sb = new StringBuffer();
        sb.append("CLASSPATH:");
        sb.append(method.getDeclaringClass().getName()).append('.');
        sb.append(method.getName());
        if (params.length > 0 && params[0].equals(Connection.class)) {
            offset = 1;
        }
        String name = sb.toString();
        if (className.equals("org.hsqldb.Library") || className.equals("java.lang.Math")) {
            routine.isLibraryRoutine = true;
        }
        for (int j = offset; j < params.length; ++j) {
            Type methodParamType = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(params[j]));
            ColumnSchema param = new ColumnSchema(null, methodParamType, !params[j].isPrimitive(), false, null);
            routine.addParameter(param);
        }
        routine.setLanguage(1);
        routine.setMethod(method);
        routine.setMethodURL(name);
        routine.setDataImpact(1);
        Type methodReturnType = Type.getDefaultTypeWithSize(Types.getParameterSQLTypeNumber(method.getReturnType()));
        routine.javaMethodWithConnection = offset == 1;
        routine.setReturnType(methodReturnType);
        routine.resolve();
        return routine;
    }

    public static void createRoutines(Session session, HsqlNameManager.HsqlName schema, String name) {
        Method[] methods = Routine.getMethods(name);
        Routine[] routines = Routine.newRoutines(methods);
        HsqlNameManager.HsqlName routineName = session.database.nameManager.newHsqlName(schema, name, true, 16);
        for (int i = 0; i < routines.length; ++i) {
            routines[i].setName(routineName);
            session.database.schemaManager.addSchemaObject(routines[i]);
        }
    }
}

