/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserBase {
    private Scanner scanner;
    protected Token token;
    protected boolean isRecording;
    protected HsqlArrayList recordedStatement;
    protected boolean isCheckOrTriggerCondition;
    protected boolean isSchemaDefinition;
    protected int parsePosition;
    static final BigDecimal LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    private static final IntKeyIntValueHashMap expressionTypeMap = new IntKeyIntValueHashMap(37);

    ParserBase(Scanner t) {
        this.scanner = t;
        this.token = this.scanner.token;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public int getParsePosition() {
        return this.parsePosition;
    }

    public void setParsePosition(int parsePosition) {
        this.parsePosition = parsePosition;
    }

    void reset(String sql) {
        this.scanner.reset(sql);
        this.parsePosition = 0;
        this.isCheckOrTriggerCondition = false;
        this.isSchemaDefinition = false;
        this.isRecording = false;
        this.recordedStatement = null;
    }

    int getPosition() {
        return this.scanner.getTokenPosition();
    }

    void rewind(int position) {
        if (position == this.scanner.getTokenPosition()) {
            return;
        }
        this.scanner.position(position);
        if (this.isRecording) {
            int i;
            for (i = this.recordedStatement.size() - 1; i >= 0; --i) {
                Token token = (Token)this.recordedStatement.get(i);
                if (token.position < position) break;
            }
            this.recordedStatement.setSize(i + 1);
        }
        this.read();
    }

    String getLastPart() {
        return this.scanner.getPart(this.parsePosition, this.scanner.getTokenPosition());
    }

    String getLastPart(int position) {
        return this.scanner.getPart(position, this.scanner.getTokenPosition());
    }

    String getLastPartAndCurrent(int position) {
        return this.scanner.getPart(position, this.scanner.getPosition());
    }

    String getStatement(int startPosition, short[] startTokens) {
        int semiPosition = 0;
        while (true) {
            if (this.token.tokenType == 699) {
                semiPosition = this.scanner.getPosition();
            } else {
                if (this.token.tokenType == 748) {
                    if (semiPosition == 0) break;
                    this.rewind(semiPosition);
                    break;
                }
                semiPosition = 0;
                if (ArrayUtil.find(startTokens, this.token.tokenType) != -1) break;
            }
            this.read();
        }
        String sql = this.scanner.getPart(startPosition, this.scanner.getPosition());
        return sql;
    }

    void startRecording() {
        this.recordedStatement = new HsqlArrayList();
        this.recordedStatement.add(this.token.duplicate());
        this.isRecording = true;
    }

    void recordExpressionForToken(ExpressionColumn expression) {
        if (this.isRecording) {
            Token recordToken = (Token)this.recordedStatement.get(this.recordedStatement.size() - 1);
            recordToken.columnExpression = expression;
        }
    }

    Token[] getRecordedStatement() {
        this.isRecording = false;
        this.recordedStatement.remove(this.recordedStatement.size() - 1);
        Token[] tokens = new Token[this.recordedStatement.size()];
        this.recordedStatement.toArray(tokens);
        this.recordedStatement = null;
        return tokens;
    }

    void read() {
        this.scanner.scanNext();
        if (this.token.isMalformed) {
            int errorCode = -1;
            switch (this.token.tokenType) {
                case 756: {
                    errorCode = 5587;
                    break;
                }
                case 755: {
                    errorCode = 5588;
                    break;
                }
                case 757: {
                    errorCode = 5586;
                    break;
                }
                case 753: {
                    errorCode = 5584;
                    break;
                }
                case -1: {
                    errorCode = 5582;
                    break;
                }
                case 754: {
                    errorCode = 5585;
                    break;
                }
                case 758: {
                    errorCode = 5589;
                    break;
                }
                case 759: {
                    errorCode = 5583;
                }
            }
            throw Error.error(errorCode);
        }
        if (this.isRecording) {
            Token dup = this.token.duplicate();
            dup.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(dup);
        }
    }

    boolean isReservedKey() {
        return this.scanner.token.isReservedIdentifier;
    }

    boolean isCoreReservedKey() {
        return this.scanner.token.isCoreReservedIdentifier;
    }

    boolean isNonReservedIdentifier() {
        return !this.scanner.token.isReservedIdentifier && (this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier);
    }

    void checkIsNonReservedIdentifier() {
        if (!this.isNonReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isNonCoreReservedIdentifier() {
        return !this.scanner.token.isCoreReservedIdentifier && (this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier);
    }

    void checkIsNonCoreReservedIdentifier() {
        if (!this.isNonCoreReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isIdentifier() {
        return this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier;
    }

    void checkIsIdentifier() {
        if (!this.isIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isDelimitedIdentifier() {
        return this.scanner.token.isDelimitedIdentifier;
    }

    void checkIsDelimitedIdentifier() {
        if (this.token.tokenType != 747) {
            throw Error.error(5569);
        }
    }

    void checkIsNotQuoted() {
        if (this.token.tokenType == 747) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue() {
        if (this.token.tokenType != 745) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue(int dataTypeCode) {
        if (this.token.tokenType != 745 || this.token.dataType.typeCode != dataTypeCode) {
            throw this.unexpectedToken();
        }
    }

    void checkIsThis(int type) {
        if (this.token.tokenType != type) {
            throw this.unexpectedToken();
        }
    }

    boolean isUndelimitedSimpleName() {
        return this.token.isUndelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isDelimitedSimpleName() {
        return this.token.isDelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isSimpleName() {
        return this.isNonCoreReservedIdentifier() && this.token.namePrefix == null;
    }

    void checkIsSimpleName() {
        if (!this.isSimpleName()) {
            throw this.unexpectedToken();
        }
    }

    String readQuotedString() {
        if (this.token.dataType.typeCode != 1) {
            throw Error.error(5565);
        }
        String value = this.token.tokenString;
        this.read();
        return value;
    }

    void readThis(int tokenId) {
        if (this.token.tokenType != tokenId) {
            String required = Tokens.getKeyword(tokenId);
            throw this.unexpectedTokenRequire(required);
        }
        this.read();
    }

    boolean readIfThis(int tokenId) {
        if (this.token.tokenType == tokenId) {
            this.read();
            return true;
        }
        return false;
    }

    Integer readIntegerObject() {
        int value = this.readInteger();
        return ValuePool.getInt(value);
    }

    int readInteger() {
        boolean minus = false;
        if (this.token.tokenType == 693) {
            minus = true;
            this.read();
        }
        this.checkIsValue();
        if (minus && this.token.dataType.typeCode == 25 && ((Number)this.token.tokenValue).longValue() == 0x80000000L) {
            this.read();
            return Integer.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4) {
            throw Error.error(5565);
        }
        int val = ((Number)this.token.tokenValue).intValue();
        if (minus) {
            val = -val;
        }
        this.read();
        return val;
    }

    long readBigint() {
        boolean minus = false;
        if (this.token.tokenType == 693) {
            minus = true;
            this.read();
        }
        this.checkIsValue();
        if (minus && this.token.dataType.typeCode == 2 && LONG_MAX_VALUE_INCREMENT.equals(this.token.tokenValue)) {
            this.read();
            return Long.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4 && this.token.dataType.typeCode != 25) {
            throw Error.error(5565);
        }
        long val = ((Number)this.token.tokenValue).longValue();
        if (minus) {
            val = -val;
        }
        this.read();
        return val;
    }

    Expression readDateTimeIntervalLiteral() {
        int pos = this.getPosition();
        switch (this.token.tokenType) {
            case 71: {
                this.read();
                if (this.token.tokenType != 745 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimestampData date = this.scanner.newDate(s);
                return new ExpressionValue(date, Type.SQL_DATE);
            }
            case 279: {
                this.read();
                if (this.token.tokenType != 745 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimeData value = this.scanner.newTime(s);
                Type dataType = this.scanner.dateTimeType;
                return new ExpressionValue(value, dataType);
            }
            case 280: {
                this.read();
                if (this.token.tokenType != 745 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                TimestampData date = this.scanner.newTimestamp(s);
                Type dataType = this.scanner.dateTimeType;
                return new ExpressionValue(date, dataType);
            }
            case 138: {
                boolean minus = false;
                this.read();
                if (this.token.tokenType == 693) {
                    this.read();
                    minus = true;
                } else if (this.token.tokenType == 696) {
                    this.read();
                }
                if (this.token.tokenType != 745 || this.token.dataType.typeCode != 1) break;
                String s = this.token.tokenString;
                this.read();
                IntervalType dataType = this.readIntervalType(false);
                Object interval = this.scanner.newInterval(s, dataType);
                dataType = (IntervalType)this.scanner.dateTimeType;
                if (minus) {
                    interval = dataType.negate(interval);
                }
                return new ExpressionValue(interval, dataType);
            }
            default: {
                throw Error.runtimeError(401, "ParserBase");
            }
        }
        this.rewind(pos);
        return null;
    }

    IntervalType readIntervalType(boolean maxPrecisionDefault) {
        int endToken;
        int precision = maxPrecisionDefault ? 9 : -1;
        int scale = -1;
        int startToken = endToken = this.token.tokenType;
        this.read();
        if (this.token.tokenType == 695) {
            this.read();
            precision = this.readInteger();
            if (precision <= 0) {
                throw Error.error(5592);
            }
            if (this.token.tokenType == 684) {
                if (startToken != 248) {
                    throw this.unexpectedToken();
                }
                this.read();
                scale = this.readInteger();
                if (scale < 0) {
                    throw Error.error(5592);
                }
            }
            this.readThis(682);
        }
        if (this.token.tokenType == 283) {
            this.read();
            endToken = this.token.tokenType;
            this.read();
        }
        if (this.token.tokenType == 695) {
            if (endToken != 248 || endToken == startToken) {
                throw this.unexpectedToken();
            }
            this.read();
            scale = this.readInteger();
            if (scale < 0) {
                throw Error.error(5592);
            }
            this.readThis(682);
        }
        int startIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, startToken);
        int endIndex = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, endToken);
        return IntervalType.getIntervalType(startIndex, endIndex, precision, scale);
    }

    static int getExpressionType(int tokenT) {
        int type = expressionTypeMap.get(tokenT, -1);
        if (type == -1) {
            throw Error.runtimeError(401, "ParserBase");
        }
        return type;
    }

    HsqlException unexpectedToken(String tokenS) {
        return Error.error(5581, tokenS);
    }

    HsqlException unexpectedTokenRequire(String required) {
        if (this.token.tokenType == 748) {
            return Error.error(null, 5590, 1, new Object[]{"", required});
        }
        String tokenS = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.error(null, 5581, 1, new Object[]{tokenS, required});
    }

    HsqlException unexpectedToken() {
        if (this.token.tokenType == 748) {
            return Error.error(5590);
        }
        String tokenS = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.error(5581, tokenS);
    }

    HsqlException tooManyIdentifiers() {
        String tokenS = this.token.namePrePrePrefix != null ? this.token.namePrePrePrefix : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString));
        return Error.error(5551, tokenS);
    }

    HsqlException unsupportedFeature() {
        return Error.error(1551, this.token.tokenString);
    }

    HsqlException unsupportedFeature(String string) {
        return Error.error(1551, string);
    }

    public Number convertToNumber(String s, NumberType type) {
        return this.scanner.convertToNumber(s, type);
    }

    static {
        expressionTypeMap.put(396, 41);
        expressionTypeMap.put(680, 43);
        expressionTypeMap.put(691, 44);
        expressionTypeMap.put(690, 42);
        expressionTypeMap.put(692, 45);
        expressionTypeMap.put(694, 46);
        expressionTypeMap.put(51, 71);
        expressionTypeMap.put(161, 74);
        expressionTypeMap.put(166, 73);
        expressionTypeMap.put(272, 72);
        expressionTypeMap.put(15, 75);
        expressionTypeMap.put(96, 76);
        expressionTypeMap.put(6, 77);
        expressionTypeMap.put(256, 77);
        expressionTypeMap.put(267, 78);
        expressionTypeMap.put(268, 79);
        expressionTypeMap.put(307, 80);
        expressionTypeMap.put(308, 81);
    }
}

