/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public final class NumberSequence
implements SchemaObject {
    public static final NumberSequence[] emptyArray = new NumberSequence[0];
    HsqlNameManager.HsqlName name;
    private long currValue;
    private long lastValue;
    private boolean limitReached;
    private long startValue;
    private long minValue;
    private long maxValue;
    private long increment;
    private Type dataType;
    private boolean isCycle;
    private boolean isAlways;
    private boolean restartValueDefault;

    public NumberSequence() {
        try {
            this.setDefaults(null, Type.SQL_BIGINT);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public NumberSequence(HsqlNameManager.HsqlName name, Type type) {
        this.setDefaults(name, type);
    }

    public void setDefaults(HsqlNameManager.HsqlName name, Type type) {
        long min;
        long max;
        this.name = name;
        this.dataType = type;
        this.name = name;
        this.dataType = type;
        switch (this.dataType.typeCode) {
            case 5: {
                max = 32767L;
                min = -32768L;
                break;
            }
            case 4: {
                max = Integer.MAX_VALUE;
                min = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                if (type.scale == 0) {
                    max = Long.MAX_VALUE;
                    min = Long.MIN_VALUE;
                    break;
                }
            }
            default: {
                throw Error.error(5565);
            }
        }
        this.minValue = min;
        this.maxValue = max;
        this.increment = 1L;
    }

    public NumberSequence(HsqlNameManager.HsqlName name, long value, long increment, Type type) {
        this(name, type);
        this.setStartValue(value);
        this.setIncrement(increment);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(128);
        if (this.name == null) {
            sb.append("GENERATED").append(' ');
            if (this.isAlways()) {
                sb.append("ALWAYS");
            } else {
                sb.append("BY").append(' ').append("DEFAULT");
            }
            sb.append(' ').append("AS").append(' ').append("IDENTITY").append("(");
        } else {
            sb.append("CREATE").append(' ');
            sb.append("SEQUENCE").append(' ');
            sb.append(this.getName().getSchemaQualifiedStatementName()).append(' ');
            sb.append("AS").append(' ');
            sb.append(this.getDataType().getNameString()).append(' ');
        }
        sb.append("START").append(' ');
        sb.append("WITH").append(' ');
        sb.append(this.startValue);
        if (this.getIncrement() != 1L) {
            sb.append(' ').append("INCREMENT").append(' ');
            sb.append("BY").append(' ');
            sb.append(this.getIncrement());
        }
        if (!this.hasDefaultMinMax()) {
            sb.append(' ').append("MINVALUE").append(' ');
            sb.append(this.getMinValue());
            sb.append(' ').append("MAXVALUE").append(' ');
            sb.append(this.getMaxValue());
        }
        if (this.isCycle()) {
            sb.append(' ').append("CYCLE");
        }
        if (this.name == null) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String getRestartSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("ALTER").append(' ');
        sb.append("SEQUENCE");
        sb.append(' ').append(this.name.getSchemaQualifiedStatementName());
        sb.append(' ').append("RESTART");
        sb.append(' ').append("WITH").append(' ').append(this.peek());
        return sb.toString();
    }

    public static String getRestartSQL(Table t) {
        String colname = t.getColumn((int)t.identityColumn).getName().statementName;
        NumberSequence seq = t.identitySequence;
        StringBuffer sb = new StringBuffer(128);
        sb.append("ALTER").append(' ').append("TABLE");
        sb.append(' ').append(t.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("ALTER").append(' ');
        sb.append("COLUMN");
        sb.append(' ').append(colname);
        sb.append(' ').append("RESTART");
        sb.append(' ').append("WITH").append(' ').append(seq.peek());
        return sb.toString();
    }

    public Type getDataType() {
        return this.dataType;
    }

    public long getIncrement() {
        return this.increment;
    }

    public synchronized long getStartValue() {
        return this.startValue;
    }

    public synchronized long getMinValue() {
        return this.minValue;
    }

    public synchronized long getMaxValue() {
        return this.maxValue;
    }

    public synchronized boolean isCycle() {
        return this.isCycle;
    }

    public synchronized boolean isAlways() {
        return this.isAlways;
    }

    public synchronized boolean hasDefaultMinMax() {
        long min;
        long max;
        switch (this.dataType.typeCode) {
            case 5: {
                max = 32767L;
                min = -32768L;
                break;
            }
            case 4: {
                max = Integer.MAX_VALUE;
                min = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(401, "NumberSequence");
            }
        }
        return this.minValue == min && this.maxValue == max;
    }

    synchronized void setStartValue(long value) {
        if (value < this.minValue || value > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = (this.startValue = value);
    }

    synchronized void setMinValue(long value) {
        this.checkInTypeRange(value);
        if (value >= this.maxValue || this.currValue < value) {
            throw Error.error(5597);
        }
        this.minValue = value;
    }

    synchronized void setDefaultMinValue() {
        this.minValue = this.getDefaultMinOrMax(false);
    }

    synchronized void setMaxValue(long value) {
        this.checkInTypeRange(value);
        if (value <= this.minValue || this.currValue > value) {
            throw Error.error(5597);
        }
        this.maxValue = value;
    }

    synchronized void setDefaultMaxValue() {
        this.maxValue = this.getDefaultMinOrMax(true);
    }

    synchronized void setIncrement(long value) {
        if (value < -16384L || value > 16383L) {
            throw Error.error(5597);
        }
        this.increment = value;
    }

    synchronized void setCurrentValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.currValue = this.lastValue = value;
    }

    synchronized void setStartValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.currValue = this.lastValue = (this.startValue = value);
    }

    synchronized void setStartValueDefault() {
        this.restartValueDefault = true;
    }

    synchronized void setMinValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.minValue = value;
    }

    synchronized void setMaxValueNoCheck(long value) {
        this.checkInTypeRange(value);
        this.maxValue = value;
    }

    synchronized void setCycle(boolean value) {
        this.isCycle = value;
    }

    synchronized void setAlways(boolean value) {
        this.isAlways = value;
    }

    private long getDefaultMinOrMax(boolean isMax) {
        long min;
        long max;
        switch (this.dataType.typeCode) {
            case 5: {
                max = 32767L;
                min = -32768L;
                break;
            }
            case 4: {
                max = Integer.MAX_VALUE;
                min = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(401, "NumberSequence");
            }
        }
        return isMax ? max : min;
    }

    private void checkInTypeRange(long value) {
        long min;
        long max;
        switch (this.dataType.typeCode) {
            case 5: {
                max = 32767L;
                min = -32768L;
                break;
            }
            case 4: {
                max = Integer.MAX_VALUE;
                min = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                max = Long.MAX_VALUE;
                min = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(401, "NumberSequence");
            }
        }
        if (value < min || value > max) {
            throw Error.error(5597);
        }
    }

    synchronized void checkValues() {
        if (this.restartValueDefault) {
            this.currValue = this.lastValue = this.startValue;
            this.restartValueDefault = false;
        }
        if (this.minValue >= this.maxValue || this.startValue < this.minValue || this.startValue > this.maxValue || this.currValue < this.minValue || this.currValue > this.maxValue) {
            throw Error.error(5597);
        }
    }

    synchronized NumberSequence duplicate() {
        NumberSequence copy = new NumberSequence();
        copy.name = this.name;
        copy.startValue = this.startValue;
        copy.currValue = this.currValue;
        copy.lastValue = this.lastValue;
        copy.increment = this.increment;
        copy.dataType = this.dataType;
        copy.minValue = this.minValue;
        copy.maxValue = this.maxValue;
        copy.isCycle = this.isCycle;
        copy.isAlways = this.isAlways;
        return copy;
    }

    synchronized void reset(NumberSequence other) {
        this.name = other.name;
        this.startValue = other.startValue;
        this.currValue = other.currValue;
        this.lastValue = other.lastValue;
        this.increment = other.increment;
        this.dataType = other.dataType;
        this.minValue = other.minValue;
        this.maxValue = other.maxValue;
        this.isCycle = other.isCycle;
        this.isAlways = other.isAlways;
    }

    synchronized long userUpdate(long value) {
        if (value == this.currValue) {
            this.currValue += this.increment;
            return value;
        }
        if (this.increment > 0L) {
            if (value > this.currValue) {
                this.currValue += (value - this.currValue + this.increment) / this.increment * this.increment;
            }
        } else if (value < this.currValue) {
            this.currValue += (value - this.currValue + this.increment) / this.increment * this.increment;
        }
        return value;
    }

    synchronized long systemUpdate(long value) {
        if (value == this.currValue) {
            this.currValue += this.increment;
            return value;
        }
        if (this.increment > 0L) {
            if (value > this.currValue) {
                this.currValue = value + this.increment;
            }
        } else if (value < this.currValue) {
            this.currValue = value + this.increment;
        }
        return value;
    }

    synchronized Object getValueObject() {
        Number result;
        long value = this.getValue();
        switch (this.dataType.typeCode) {
            default: {
                result = ValuePool.getInt((int)value);
                break;
            }
            case 25: {
                result = ValuePool.getLong(value);
                break;
            }
            case 2: 
            case 3: {
                result = ValuePool.getBigDecimal(new BigDecimal(value));
            }
        }
        return result;
    }

    public synchronized long getValue() {
        long nextValue;
        if (this.limitReached) {
            throw Error.error(3416);
        }
        if (this.increment > 0L) {
            if (this.currValue > this.maxValue - this.increment) {
                if (this.isCycle) {
                    nextValue = this.minValue;
                } else {
                    this.limitReached = true;
                    nextValue = this.minValue;
                }
            } else {
                nextValue = this.currValue + this.increment;
            }
        } else if (this.currValue < this.minValue - this.increment) {
            if (this.isCycle) {
                nextValue = this.maxValue;
            } else {
                this.limitReached = true;
                nextValue = this.minValue;
            }
        } else {
            nextValue = this.currValue + this.increment;
        }
        long result = this.currValue;
        this.currValue = nextValue;
        return result;
    }

    synchronized void reset() {
        this.lastValue = this.currValue = this.startValue;
    }

    public synchronized long peek() {
        return this.currValue;
    }

    synchronized boolean resetWasUsed() {
        boolean result = this.lastValue != this.currValue;
        this.lastValue = this.currValue;
        return result;
    }

    public synchronized void reset(long value) {
        if (value < this.minValue || value > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = value;
        this.startValue = this.lastValue;
    }
}

