/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;

public final class HsqlNameManager {
    public static final String DEFAULT_CATALOG_NAME = "PUBLIC";
    private static final HsqlNameManager staticManager = new HsqlNameManager(null);
    private static final HsqlName[] autoColumnNames;
    private static final String[] autoNoNameColumnNames;
    private int serialNumber = 1;
    private int sysNumber = 10000;
    private HsqlName catalogName = new HsqlName(this, "PUBLIC", 1, false);

    public HsqlNameManager(Database database) {
    }

    public HsqlName getCatalogName() {
        return this.catalogName;
    }

    public static HsqlName newSystemObjectName(String name, int type) {
        return new HsqlName(staticManager, name, type, false);
    }

    public static HsqlName newInfoSchemaColumnName(String name, HsqlName table) {
        HsqlName hsqlName = new HsqlName(staticManager, name, false, 9);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        hsqlName.parent = table;
        return hsqlName;
    }

    public static HsqlName newInfoSchemaTableName(String name) {
        HsqlName hsqlName = new HsqlName(staticManager, name, 3, false);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public static HsqlName newInfoSchemaObjectName(String name, boolean isQuoted, int type) {
        HsqlName hsqlName = new HsqlName(staticManager, name, type, isQuoted);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public HsqlName newHsqlName(HsqlName schema, String name, int type) {
        HsqlName hsqlName = new HsqlName(this, name, type, false);
        hsqlName.schema = schema;
        return hsqlName;
    }

    public HsqlName newHsqlName(String name, boolean isquoted, int type) {
        return new HsqlName(this, name, isquoted, type);
    }

    public HsqlName newHsqlName(HsqlName schema, String name, boolean isquoted, int type) {
        HsqlName hsqlName = new HsqlName(this, name, isquoted, type);
        hsqlName.schema = schema;
        return hsqlName;
    }

    public HsqlName newHsqlName(HsqlName schema, String name, boolean isquoted, int type, HsqlName parent) {
        HsqlName hsqlName = new HsqlName(this, name, isquoted, type);
        hsqlName.schema = schema;
        hsqlName.parent = parent;
        return hsqlName;
    }

    public HsqlName newColumnSchemaHsqlName(HsqlName table, SimpleName name) {
        return this.newColumnHsqlName(table, name.name, name.isNameQuoted);
    }

    public HsqlName newColumnHsqlName(HsqlName table, String name, boolean isquoted) {
        HsqlName hsqlName = new HsqlName(this, name, isquoted, 9);
        hsqlName.schema = table.schema;
        hsqlName.parent = table;
        return hsqlName;
    }

    public HsqlName getSubqueryTableName() {
        HsqlName hsqlName = new HsqlName(this, "SYSTEM_SUBQUERY", false, 3);
        hsqlName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public HsqlName newAutoName(String prefix, HsqlName schema, HsqlName parent, int type) {
        HsqlName name = this.newAutoName(prefix, null, schema, parent, type);
        return name;
    }

    public HsqlName newSpecificRoutineName(HsqlName name) {
        StringBuffer sb = new StringBuffer();
        sb.append(name.name).append('_').append(++this.sysNumber);
        HsqlName hsqlName = new HsqlName(this, sb.toString(), 24, name.isNameQuoted);
        hsqlName.parent = name;
        hsqlName.schema = name.schema;
        return hsqlName;
    }

    public static HsqlName getAutoColumnName(int i) {
        if (i < autoColumnNames.length) {
            return autoColumnNames[i];
        }
        return new HsqlName(staticManager, "C_" + (i + 1), 0, false);
    }

    public static String getAutoColumnNameString(int i) {
        if (i < autoColumnNames.length) {
            return HsqlNameManager.autoColumnNames[i].name;
        }
        return "C" + (i + 1);
    }

    public static String getAutoNoNameColumnString(int i) {
        if (i < autoColumnNames.length) {
            return autoNoNameColumnNames[i];
        }
        return String.valueOf(i);
    }

    public static String getAutoSavepointNameString(long i, int j) {
        StringBuffer sb = new StringBuffer("S");
        sb.append(i).append('_').append(j);
        return sb.toString();
    }

    HsqlName newAutoName(String prefix, String namepart, HsqlName schema, HsqlName parent, int type) {
        StringBuffer sb = new StringBuffer();
        if (prefix != null) {
            if (prefix.length() != 0) {
                sb.append("SYS_");
                sb.append(prefix);
                sb.append('_');
                if (namepart != null) {
                    sb.append(namepart);
                    sb.append('_');
                }
                sb.append(++this.sysNumber);
            }
        } else {
            sb.append(namepart);
        }
        HsqlName name = new HsqlName(this, sb.toString(), type, false);
        name.schema = schema;
        name.parent = parent;
        return name;
    }

    void resetNumbering() {
        this.sysNumber = 0;
        this.serialNumber = 0;
    }

    public static SimpleName getSimpleName(String name, boolean isNameQuoted) {
        return new SimpleName(name, isNameQuoted);
    }

    static {
        HsqlNameManager.staticManager.serialNumber = Integer.MIN_VALUE;
        autoColumnNames = new HsqlName[32];
        autoNoNameColumnNames = new String[32];
        for (int i = 0; i < autoColumnNames.length; ++i) {
            HsqlNameManager.autoColumnNames[i] = new HsqlName(staticManager, "C" + (i + 1), 0, false);
            HsqlNameManager.autoNoNameColumnNames[i] = String.valueOf(i);
        }
    }

    public static final class HsqlName
    extends SimpleName {
        static HsqlName[] emptyArray = new HsqlName[0];
        HsqlNameManager manager;
        public String statementName;
        public HsqlName schema;
        public HsqlName parent;
        public Grantee owner;
        public final int type;
        private final int hashCode;
        static final String[] sysPrefixes = new String[]{"SYS_IDX_", "SYS_PK_", "SYS_REF_", "SYS_CT_", "SYS_FK_"};

        private HsqlName(HsqlNameManager man, int type) {
            this.manager = man;
            this.type = type;
            this.hashCode = this.manager.serialNumber++;
        }

        private HsqlName(HsqlNameManager man, String name, boolean isquoted, int type) {
            this(man, type);
            this.rename(name, isquoted);
        }

        private HsqlName(HsqlNameManager man, String name, int type, boolean isQuoted) {
            this(man, type);
            this.name = this.statementName = name;
            this.isNameQuoted = isQuoted;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(name, '\"', true);
            }
        }

        @Override
        public String getStatementName() {
            return this.statementName;
        }

        public String getSchemaQualifiedStatementName() {
            if (this.type == 9) {
                if (this.parent == null || "SYSTEM_SUBQUERY".equals(this.parent.name)) {
                    return this.statementName;
                }
                StringBuffer sb = new StringBuffer();
                if (this.schema != null) {
                    sb.append(this.schema.getStatementName());
                    sb.append('.');
                }
                sb.append(this.parent.getStatementName());
                sb.append('.');
                sb.append(this.statementName);
                return sb.toString();
            }
            if (this.schema == null) {
                return this.statementName;
            }
            StringBuffer sb = new StringBuffer();
            if (this.schema != null) {
                sb.append(this.schema.getStatementName());
                sb.append('.');
            }
            sb.append(this.statementName);
            return sb.toString();
        }

        public void rename(HsqlName name) {
            this.rename(name.name, name.isNameQuoted);
        }

        public void rename(String name, boolean isquoted) {
            int length;
            if (name.length() > 128) {
                throw Error.error(5501, name);
            }
            this.name = name;
            this.statementName = name;
            this.isNameQuoted = isquoted;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(name, '\"', true);
            }
            if (name.startsWith("SYS_") && (length = HsqlName.sysPrefixLength(name)) > 0) {
                try {
                    int temp = Integer.parseInt(name.substring(length));
                    if (temp > this.manager.sysNumber) {
                        this.manager.sysNumber = temp;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }

        void rename(String prefix, String name, boolean isquoted) {
            StringBuffer sbname = new StringBuffer(prefix);
            sbname.append('_');
            sbname.append(name);
            this.rename(sbname.toString(), isquoted);
        }

        public void setSchemaIfNull(HsqlName schema) {
            if (this.schema == null) {
                this.schema = schema;
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof HsqlName) {
                return this.hashCode == ((HsqlName)other).hashCode;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        static int sysPrefixLength(String name) {
            for (int i = 0; i < sysPrefixes.length; ++i) {
                if (!name.startsWith(sysPrefixes[i])) continue;
                return sysPrefixes[i].length();
            }
            return 0;
        }

        static boolean isReservedName(String name) {
            return HsqlName.sysPrefixLength(name) > 0;
        }

        boolean isReservedName() {
            return HsqlName.isReservedName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        public int compareTo(Object o) {
            return this.hashCode - o.hashCode();
        }

        static boolean isRegularIdentifier(String name) {
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char c = name.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '_' && i > 0 || c >= '0' && c <= '9') continue;
                return false;
            }
            return !Tokens.isKeyword(name);
        }
    }

    public static class SimpleName {
        public String name;
        public boolean isNameQuoted;

        private SimpleName() {
        }

        private SimpleName(String name, boolean isNameQuoted) {
            this.name = name;
            this.isNameQuoted = isNameQuoted;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof SimpleName) {
                return ((SimpleName)other).isNameQuoted == this.isNameQuoted && ((SimpleName)other).name.equals(this.name);
            }
            return false;
        }

        public String getStatementName() {
            return this.isNameQuoted ? StringConverter.toQuotedString(this.name, '\"', true) : this.name;
        }
    }
}

