/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringUtil;

public class HsqlDateTime {
    private static long currentDateMillis;
    private static final Calendar tempCalDefault;
    public static final Calendar tempCalGMT;
    private static final java.sql.Date tempDate;
    private static final String sdfdPattern = "yyyy-MM-dd";
    static SimpleDateFormat sdfd;
    private static final String sdftPattern = "HH:mm:ss";
    static SimpleDateFormat sdft;
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss";
    static SimpleDateFormat sdfts;
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    static SimpleDateFormat sdftsSys;
    private static Date sysDate;
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    private static final char e = '\uffff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDateSeconds(String s) {
        try {
            SimpleDateFormat simpleDateFormat = sdfd;
            synchronized (simpleDateFormat) {
                Date d = sdfd.parse(s);
                return d.getTime() / 1000L;
            }
        }
        catch (Exception e) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(long seconds) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sysDate.setTime(seconds * 1000L);
            return sdfd.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampSeconds(String s) {
        try {
            SimpleDateFormat simpleDateFormat = sdfts;
            synchronized (simpleDateFormat) {
                Date d = sdfts.parse(s);
                return d.getTime() / 1000L;
            }
        }
        catch (Exception e) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTimestampString(StringBuffer sb, long seconds, int nanos, int scale) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            tempDate.setTime(seconds * 1000L);
            sb.append(sdfts.format(tempDate));
            if (scale > 0) {
                sb.append('.');
                sb.append(StringUtil.toZeroPaddedString(nanos, 9, scale));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long millis) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(millis);
            return sdfts.format(sysDate);
        }
    }

    public static synchronized long getCurrentDateMillis(long millis) {
        if (millis - currentDateMillis >= 86400000L) {
            currentDateMillis = HsqlDateTime.getNormalisedDate(millis);
        }
        return currentDateMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSytemTimeString() {
        SimpleDateFormat simpleDateFormat = sdftsSys;
        synchronized (simpleDateFormat) {
            sysDate.setTime(System.currentTimeMillis());
            return sdftsSys.format(sysDate);
        }
    }

    public static void resetToDate(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static void resetToTime(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long millis) {
        calendar.clear();
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            tempCalGMT.setTimeInMillis(millis);
            calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar calendar, long millis) {
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            tempCalGMT.clear();
            calendar.setTimeInMillis(millis);
            tempCalGMT.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
            return tempCalGMT.getTimeInMillis();
        }
    }

    public static void setTimeInMillis(Calendar cal, long millis) {
        cal.setTimeInMillis(millis);
    }

    public static long getTimeInMillis(Calendar cal) {
        return cal.getTimeInMillis();
    }

    public static long convertToNormalisedTime(long t) {
        return HsqlDateTime.convertToNormalisedTime(t, tempCalGMT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedTime(long t, Calendar cal) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToDate(cal);
            long t1 = HsqlDateTime.getTimeInMillis(cal);
            return t - t1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedDate(long t, Calendar cal) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToDate(cal);
            return HsqlDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(long t) {
        Calendar cal;
        Calendar calendar = cal = tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToTime(cal);
            return HsqlDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar cal, long t) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToTime(cal);
            return HsqlDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long d) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalGMT, d);
            HsqlDateTime.resetToDate(tempCalGMT);
            return HsqlDateTime.getTimeInMillis(tempCalGMT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar cal, long d) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, d);
            HsqlDateTime.resetToDate(cal);
            return HsqlDateTime.getTimeInMillis(cal);
        }
    }

    public static int getZoneSeconds(Calendar cal) {
        return (cal.get(15) + cal.get(16)) / 1000;
    }

    public static int getZoneMillis(Calendar cal, long millis) {
        return cal.getTimeZone().getOffset(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDateTimePart(long m, int part) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(m);
            return tempCalGMT.get(part);
        }
    }

    public static String toJavaDatePattern(String format) {
        int len = format.length();
        StringBuffer sb = new StringBuffer(len);
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= len; ++i) {
            char ch;
            char c = ch = i == len ? (char)'\uffff' : (char)format.charAt(i);
            if (!tokenizer.next(ch, dateTokens)) {
                int index = tokenizer.getLastMatch();
                if (index >= 0) {
                    sb.setLength(sb.length() - tokenizer.length());
                    sb.append(javaDateTokens[index]);
                }
                tokenizer.reset();
                if (tokenizer.isConsumed()) continue;
            }
            sb.append(ch);
        }
        sb.setLength(sb.length() - 1);
        String javaPattern = sb.toString();
        return javaPattern;
    }

    static {
        tempCalDefault = new GregorianCalendar();
        tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        tempDate = new java.sql.Date(0L);
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
        sdftsSys = new SimpleDateFormat(sdftsSysPattern);
        tempCalGMT.setLenient(false);
        sdfd.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT")));
        sdfd.setLenient(false);
        sdft.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT")));
        sdft.setLenient(false);
        sdfts.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT")));
        sdfts.setLenient(false);
        currentDateMillis = HsqlDateTime.getNormalisedDate(System.currentTimeMillis());
        sysDate = new Date();
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F'}};
        javaDateTokens = new String[]{"yyyy", "yyyy", "yyyy", "yy", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "EEEE", "EE", "w", "dd", "D", "k", "K", "K", "mm", "ss", "aaa", "aaa", "aaa", "aaa", "S"};
    }

    static class Tokenizer {
        private int last;
        private int offset;
        private long state;
        private boolean consumed;

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.last = -1;
            this.offset = -1;
            this.state = 0L;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.last;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        private boolean isZeroBit(int bit) {
            return (this.state & 1L << bit) == 0L;
        }

        private void setBit(int bit) {
            this.state |= 1L << bit;
        }

        public boolean next(char ch, char[][] tokens) {
            int index = ++this.offset;
            int len = this.offset + 1;
            int left = 0;
            this.consumed = false;
            int i = tokens.length;
            while (--i >= 0) {
                if (!this.isZeroBit(i)) continue;
                if (tokens[i][index] == ch) {
                    this.consumed = true;
                    if (tokens[i].length == len) {
                        this.setBit(i);
                        this.last = i;
                        continue;
                    }
                    ++left;
                    continue;
                }
                this.setBit(i);
            }
            return left > 0;
        }
    }
}

