/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.Session;
import org.hsqldb.error.Error;

public class ExpressionOrderBy
extends Expression {
    private boolean isDescending;
    private boolean isNullsLast;

    ExpressionOrderBy(Expression e) {
        super(94);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
    }

    void setDescending() {
        this.isDescending = true;
    }

    boolean isDescending() {
        return this.isDescending;
    }

    void setNullsLast() {
        this.isNullsLast = true;
    }

    boolean isNullsLast() {
        return this.isNullsLast;
    }

    @Override
    public Object getValue(Session session) {
        return this.nodes[0].getValue(session);
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        this.nodes[0].resolveTypes(session, parent);
        if (this.nodes[0].isParam) {
            throw Error.error(5567);
        }
        this.dataType = this.nodes[0].dataType;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("ORDER").append(' ').append("BY").append(' ');
        if (this.nodes[0].alias != null) {
            sb.append(this.nodes[0].alias.name);
        } else {
            sb.append(this.nodes[0].getSQL());
        }
        if (this.isDescending) {
            sb.append(' ').append("DESC");
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("ORDER").append(' ').append("BY");
        sb.append(' ');
        if (this.isDescending) {
            sb.append("DESC").append(' ');
        }
        return sb.toString();
    }
}

