/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class ExpressionOp
extends Expression {
    ExpressionOp(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 92: 
            case 93: 
            case 95: 
            case 96: {
                return;
            }
        }
        throw Error.runtimeError(401, "ExpressionOp");
    }

    ExpressionOp(Expression e, Type dataType) {
        super(91);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        this.dataType = dataType;
        this.alias = e.alias;
    }

    ExpressionOp(Expression e) {
        super(e.dataType.isDateTimeTypeWithZone() ? 91 : 92);
        switch (e.dataType.typeCode) {
            case 94: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, e, null);
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(92, e.dataType.scale);
                break;
            }
            case 95: {
                this.nodes = new Expression[1];
                this.nodes[0] = new ExpressionOp(92, e, null);
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(93, e.dataType.scale);
                break;
            }
            case 92: {
                this.nodes = new Expression[2];
                this.nodes[0] = e;
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(94, e.dataType.scale);
                break;
            }
            case 93: {
                this.nodes = new Expression[2];
                this.nodes[0] = e;
                this.nodes[0].dataType = e.dataType;
                this.dataType = DateTimeType.getDateTimeType(95, e.dataType.scale);
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionOp");
            }
        }
        this.alias = e.alias;
    }

    public static Expression getCastExpression(Session session, Expression e, Type dataType) {
        if (e.getType() == 1) {
            Object value = dataType.castToType(session, e.getValue(session), e.getDataType());
            return new ExpressionValue(value, dataType);
        }
        return new ExpressionOp(e, dataType);
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        String left = ExpressionOp.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String right = ExpressionOp.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(401, "ExpressionOp");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
            case 91: {
                sb.append(' ').append("CAST").append('(');
                sb.append(left).append(' ').append("AS").append(' ');
                sb.append(this.dataType.getTypeDefinition());
                sb.append(')');
                return sb.toString();
            }
            case 93: {
                sb.append(' ').append("CASEWHEN").append('(');
                sb.append(left).append(',').append(right).append(')');
                return sb.toString();
            }
            case 96: {
                sb.append(left).append(',').append(right);
                return sb.toString();
            }
            case 95: {
                sb.append(' ').append("OFFSET").append(' ');
                sb.append(left).append(' ');
                sb.append("FETCH").append(' ').append("FIRST");
                sb.append(right).append(' ').append(right).append(' ');
                sb.append("ROWS").append(' ').append("ONLY");
                sb.append(' ');
                break;
            }
            case 92: {
                sb.append(left).append(' ').append("AT").append(' ');
                if (this.nodes[1] == null) {
                    sb.append("LOCAL").append(' ');
                    break;
                }
                sb.append(right);
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionOp");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 26: {
                sb.append("VALUELIST ");
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + 1));
                    sb.append(' ');
                }
                break;
            }
            case 91: {
                sb.append("CAST ");
                sb.append(this.dataType.getTypeDefinition());
                sb.append(' ');
                break;
            }
            case 93: {
                sb.append("CASEWHEN ");
            }
        }
        if (this.nodes[0] != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.nodes[1] != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        switch (this.opType) {
            case 93: {
                acceptsSequences = false;
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        block0 : switch (this.opType) {
            case 1: {
                break;
            }
            case 91: {
                Type type = this.nodes[0].dataType;
                if (type != null && !this.dataType.canConvertFrom(type)) {
                    throw Error.error(5561);
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 92: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                    }
                    if (this.nodes[1].dataType.typeCode != 111) {
                        throw Error.error(5565);
                    }
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 92: {
                        this.dataType = DateTimeType.getDateTimeType(94, this.nodes[0].dataType.scale);
                        break block0;
                    }
                    case 93: {
                        this.dataType = DateTimeType.getDateTimeType(95, this.nodes[0].dataType.scale);
                        break block0;
                    }
                    case 94: 
                    case 95: {
                        this.dataType = this.nodes[0].dataType;
                        break block0;
                    }
                }
                throw Error.error(5565);
            }
            case 93: {
                this.resolveTypesForCaseWhen(session);
                break;
            }
            case 96: {
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionOp");
            }
        }
    }

    void resolveTypesForCaseWhen(Session session) {
        if (this.dataType != null) {
            return;
        }
        Expression expr = this;
        while (expr.opType == 93) {
            expr.nodes[0].resolveTypes(session, expr);
            if (expr.nodes[0].isParam) {
                expr.nodes[0].dataType = Type.SQL_BOOLEAN;
            }
            expr.nodes[1].nodes[0].resolveTypes(session, this.nodes[1]);
            expr.nodes[1].nodes[1].resolveTypes(session, this.nodes[1]);
            expr = expr.nodes[1].nodes[1];
        }
        expr = this;
        while (expr.opType == 93) {
            this.dataType = Type.getAggregateType(expr.nodes[1].nodes[0].dataType, this.dataType);
            this.dataType = Type.getAggregateType(expr.nodes[1].nodes[1].dataType, this.dataType);
            expr = expr.nodes[1].nodes[1];
        }
        expr = this;
        while (expr.opType == 93) {
            if (expr.nodes[1].nodes[0].dataType == null) {
                expr.nodes[1].nodes[0].dataType = this.dataType;
            }
            if (expr.nodes[1].nodes[1].dataType == null) {
                expr.nodes[1].nodes[1].dataType = this.dataType;
            }
            if (expr.nodes[1].dataType == null) {
                expr.nodes[1].dataType = this.dataType;
            }
            expr = expr.nodes[1].nodes[1];
        }
        if (this.dataType == null) {
            throw Error.error(5567);
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object[] data = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
                return data[this.columnIndex];
            }
            case 94: {
                return this.nodes[0].getValue(session);
            }
            case 91: {
                Object value = this.dataType.castToType(session, this.nodes[0].getValue(session), this.nodes[0].dataType);
                if (this.dataType.userTypeModifier != null) {
                    Constraint[] constraints = this.dataType.userTypeModifier.getConstraints();
                    for (int i = 0; i < constraints.length; ++i) {
                        constraints[i].checkCheckConstraint(session, null, value);
                    }
                }
                return value;
            }
            case 93: {
                Boolean result = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(result)) {
                    return this.nodes[1].nodes[0].getValue(session, this.dataType);
                }
                return this.nodes[1].nodes[1].getValue(session, this.dataType);
            }
            case 92: {
                Object rightValue;
                Object leftValue = this.nodes[0].getValue(session);
                Object object = rightValue = this.nodes[1] == null ? null : this.nodes[1].getValue(session);
                if (leftValue == null) {
                    return null;
                }
                if (this.nodes[1] != null && rightValue == null) {
                    return null;
                }
                long zoneSeconds = this.nodes[1] == null ? (long)session.getZoneSeconds() : ((IntervalType)this.nodes[1].dataType).getSeconds(rightValue);
                return ((DateTimeType)this.dataType).changeZone(leftValue, this.nodes[0].dataType, (int)zoneSeconds, session.getZoneSeconds());
            }
        }
        throw Error.runtimeError(401, "ExpressionOp");
    }
}

