/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionValue;
import org.hsqldb.Like;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Set;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.Type;

public final class ExpressionLike
extends ExpressionLogical {
    private static final int ESCAPE = 2;
    private static final int TERNARY = 3;
    private Like likeObject;

    ExpressionLike(Expression left, Expression right, Expression escape, boolean noOptimisation) {
        super(53);
        this.nodes = new Expression[3];
        this.nodes[0] = left;
        this.nodes[1] = right;
        this.nodes[2] = escape;
        this.likeObject = new Like();
        this.noOptimisation = noOptimisation;
    }

    private ExpressionLike(ExpressionLike other) {
        super(53);
        this.nodes = other.nodes;
        this.likeObject = other.likeObject;
    }

    @Override
    void collectObjectNames(Set set) {
        super.collectObjectNames(set);
    }

    @Override
    public HsqlList resolveColumnReferences(RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Session session) {
        Object escapeValue;
        if (this.opType != 53) {
            return super.getValue(session);
        }
        Object leftValue = this.nodes[0].getValue(session);
        Object rightValue = this.nodes[1].getValue(session);
        Object object = escapeValue = this.nodes[2] == null ? null : this.nodes[2].getValue(session);
        if (this.likeObject.isVariable) {
            Like like = this.likeObject;
            synchronized (like) {
                this.likeObject.setPattern(session, rightValue, escapeValue, this.nodes[2] != null);
                return this.likeObject.compare(session, leftValue);
            }
        }
        return this.likeObject.compare(session, leftValue);
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        boolean isRightArgFixedConstant;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        boolean isEscapeFixedConstant = true;
        if (this.nodes[2] != null) {
            if (this.nodes[2].isParam) {
                throw Error.error(5567);
            }
            this.nodes[2].resolveTypes(session, this);
            boolean bl = isEscapeFixedConstant = this.nodes[2].opType == 1;
            if (isEscapeFixedConstant) {
                this.nodes[2].setAsConstantValue(session);
                if (this.nodes[2].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[2].valueData != null) {
                    long length;
                    switch (this.nodes[2].dataType.typeCode) {
                        case 1: 
                        case 12: {
                            length = ((String)this.nodes[2].valueData).length();
                            break;
                        }
                        case 60: 
                        case 61: {
                            length = ((BinaryData)this.nodes[2].valueData).length(session);
                            break;
                        }
                        default: {
                            throw Error.error(5565);
                        }
                    }
                    if (length != 1L) {
                        throw Error.error(3439);
                    }
                }
            }
        }
        if (this.nodes[0].isParam) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].isParam) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType() && (this.nodes[2] == null || this.nodes[2].dataType.isCharacterType())) {
            boolean ignoreCase = this.nodes[0].dataType.typeCode == 100 || this.nodes[1].dataType.typeCode == 100;
            this.likeObject.setIgnoreCase(ignoreCase);
        } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType() && (this.nodes[2] == null || this.nodes[2].dataType.isBinaryType())) {
            this.likeObject.isBinary = true;
        } else {
            throw Error.error(5565);
        }
        this.likeObject.dataType = this.nodes[0].dataType;
        boolean bl = isRightArgFixedConstant = this.nodes[1].opType == 1;
        if (isRightArgFixedConstant && isEscapeFixedConstant && this.nodes[0].opType == 1) {
            this.setAsConstantValue(session);
            this.likeObject = null;
            return;
        }
        if (!isRightArgFixedConstant || !isEscapeFixedConstant) {
            return;
        }
        this.likeObject.isVariable = false;
        Object pattern = isRightArgFixedConstant ? this.nodes[1].getConstantValue(session) : null;
        boolean constantEscape = isEscapeFixedConstant && this.nodes[2] != null;
        Object escape = constantEscape ? this.nodes[2].getConstantValue(session) : null;
        this.likeObject.setPattern(session, pattern, escape, this.nodes[2] != null);
        if (this.noOptimisation) {
            return;
        }
        if (this.likeObject.isEquivalentToUnknownPredicate()) {
            this.setAsConstantValue(null);
            this.likeObject = null;
        } else if (this.likeObject.isEquivalentToEqualsPredicate()) {
            this.opType = 41;
            this.nodes[1] = new ExpressionValue(this.likeObject.getRangeLow(), Type.SQL_VARCHAR);
            this.likeObject = null;
        } else if (this.likeObject.isEquivalentToNotNullPredicate()) {
            ExpressionLogical notNull = new ExpressionLogical(47, this.nodes[0]);
            this.opType = 48;
            this.nodes = new Expression[1];
            this.nodes[0] = notNull;
            this.likeObject = null;
        } else {
            if (this.nodes[0].opType != 2) {
                return;
            }
            if (!this.nodes[0].dataType.isCharacterType()) {
                return;
            }
            boolean between = false;
            boolean like = false;
            boolean larger = false;
            if (this.likeObject.isEquivalentToBetweenPredicate()) {
                larger = this.likeObject.hasCollation;
                between = !larger;
                like = larger;
            } else if (this.likeObject.isEquivalentToBetweenPredicateAugmentedWithLike()) {
                larger = this.likeObject.hasCollation;
                between = !larger;
                like = true;
            }
            if (!between && !larger) {
                return;
            }
            ExpressionValue leftBound = new ExpressionValue(this.likeObject.getRangeLow(), Type.SQL_VARCHAR);
            ExpressionValue rightBound = new ExpressionValue(this.likeObject.getRangeHigh(session), Type.SQL_VARCHAR);
            if (between && !like) {
                Expression leftOld = this.nodes[0];
                this.nodes = new Expression[2];
                this.nodes[0] = new ExpressionLogical(42, leftOld, leftBound);
                this.nodes[1] = new ExpressionLogical(45, leftOld, rightBound);
                this.opType = 49;
                this.likeObject = null;
            } else if (between && like) {
                ExpressionLogical gte = new ExpressionLogical(42, this.nodes[0], leftBound);
                ExpressionLogical lte = new ExpressionLogical(45, this.nodes[0], rightBound);
                ExpressionLike newLike = new ExpressionLike(this);
                this.nodes = new Expression[2];
                this.likeObject = null;
                this.nodes[0] = new ExpressionLogical(49, gte, lte);
                this.nodes[1] = newLike;
                this.opType = 49;
            } else if (larger) {
                ExpressionLogical gte = new ExpressionLogical(42, this.nodes[0], leftBound);
                ExpressionLike newLike = new ExpressionLike(this);
                this.nodes = new Expression[2];
                this.likeObject = null;
                this.nodes[0] = gte;
                this.nodes[1] = newLike;
                this.opType = 49;
            }
        }
    }

    @Override
    public String getSQL() {
        String left = ExpressionLike.getContextSQL(this.nodes[0]);
        String right = ExpressionLike.getContextSQL(this.nodes[1]);
        StringBuffer sb = new StringBuffer();
        sb.append(left).append(' ').append("LIKE").append(' ');
        sb.append(right);
        if (this.nodes[2] != null) {
            sb.append(' ').append("ESCAPE").append(' ');
            sb.append(this.nodes[2].getSQL());
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("LIKE ");
        sb.append(this.likeObject.describe(session));
        return sb.toString();
    }
}

