/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionOp;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public class ExpressionArithmetic
extends Expression {
    ExpressionArithmetic(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return;
            }
        }
        throw Error.runtimeError(401, "Expression");
    }

    ExpressionArithmetic(int type, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        switch (this.opType) {
            case 31: {
                return;
            }
        }
        throw Error.runtimeError(401, "Expression");
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(401, "Expression");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        String left = ExpressionArithmetic.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String right = ExpressionArithmetic.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 91: {
                sb.append(' ').append("CAST").append('(');
                sb.append(left).append(' ').append("AS").append(' ');
                sb.append(this.dataType.getTypeDefinition());
                sb.append(')');
                break;
            }
            case 31: {
                sb.append('-').append(left);
                break;
            }
            case 32: {
                sb.append(left).append('+').append(right);
                break;
            }
            case 33: {
                sb.append(left).append('-').append(right);
                break;
            }
            case 34: {
                sb.append(left).append('*').append(right);
                break;
            }
            case 35: {
                sb.append(left).append('/').append(right);
                break;
            }
            case 36: {
                sb.append(left).append("||").append(right);
                break;
            }
            default: {
                throw Error.runtimeError(401, "Expression");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 25: 
            case 26: {
                sb.append("VALUELIST ");
                sb.append(" TYPE = ").append(this.dataType.getNameString());
                for (i = 0; i < this.nodes.length; ++i) {
                    sb.append(this.nodes[i].describe(session, blanks + blanks));
                    sb.append(' ');
                }
                break;
            }
            case 31: {
                sb.append("NEGATE ");
                break;
            }
            case 32: {
                sb.append("ADD ");
                break;
            }
            case 33: {
                sb.append("SUBTRACT ");
                break;
            }
            case 34: {
                sb.append("MULTIPLY ");
                break;
            }
            case 35: {
                sb.append("DIVIDE ");
                break;
            }
            case 36: {
                sb.append("CONCAT ");
                break;
            }
            case 91: {
                sb.append("CAST ");
                sb.append(this.dataType.getTypeDefinition());
                sb.append(' ');
            }
        }
        if (this.nodes[0] != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.nodes[1] != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        if (this.opType == 1) {
            return unresolvedSet;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].resolveColumnReferences(rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
        }
        return unresolvedSet;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 31: {
                if (this.nodes[0].isParam || this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                this.dataType = this.nodes[0].dataType;
                if (!this.dataType.isNumberType()) {
                    throw Error.error(5565);
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 32: {
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isCharacterType() || this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) {
                    this.opType = 36;
                    this.resolveTypesForConcat(session);
                    break;
                }
            }
            case 33: 
            case 34: 
            case 35: {
                this.resolveTypesForArithmetic(session);
                break;
            }
            case 36: {
                this.resolveTypesForConcat(session);
                break;
            }
            default: {
                throw Error.runtimeError(401, "Expression");
            }
        }
    }

    void resolveTypesForArithmetic(Session session) {
        if (this.nodes[0].isParam && this.nodes[1].isParam) {
            throw Error.error(5567);
        }
        if (this.nodes[0].isParam) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].isParam) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.nodes[0].dataType.isDateTimeType() && this.nodes[1].dataType.isDateTimeType()) {
            if (this.dataType == null) {
                throw Error.error(5566);
            }
            if (!this.dataType.isIntervalType() || this.nodes[0].dataType.typeCode != this.nodes[1].dataType.typeCode) {
                throw Error.error(5562);
            }
        } else {
            this.dataType = this.nodes[0].dataType.getCombinedType(this.nodes[1].dataType, this.opType);
            if (this.dataType.isDateTimeType() && this.nodes[0].dataType.isIntervalType()) {
                if (this.opType != 32) {
                    throw Error.error(5565);
                }
                Expression temp = this.nodes[0];
                this.nodes[0] = this.nodes[1];
                this.nodes[1] = temp;
            }
        }
        if (this.nodes[0].opType == 1 && this.nodes[1].opType == 1) {
            this.setAsConstantValue(session);
        }
    }

    void resolveTypesForConcat(Session session) {
        if (this.dataType != null) {
            return;
        }
        if (this.nodes[0].isParam) {
            this.nodes[0].dataType = this.nodes[1].dataType;
        } else if (this.nodes[1].isParam) {
            this.nodes[1].dataType = this.nodes[0].dataType;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.nodes[0].dataType.isBinaryType() ^ this.nodes[1].dataType.isBinaryType()) {
            throw Error.error(5565);
        }
        if (this.nodes[0].dataType.isCharacterType() && !this.nodes[1].dataType.isCharacterType()) {
            Type newType = CharacterType.getCharacterType(12, this.nodes[1].dataType.displaySize());
            this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], newType);
        }
        this.dataType = this.nodes[0].dataType.getCombinedType(this.nodes[1].dataType, 36);
        if (this.nodes[0].opType == 1 && this.nodes[1].opType == 1) {
            this.setAsConstantValue(session);
        }
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object[] data = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
                return data[this.columnIndex];
            }
            case 31: {
                return ((NumberType)this.dataType).negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
        }
        Object a = this.nodes[0].getValue(session);
        Object b = this.nodes[1].getValue(session);
        switch (this.opType) {
            case 32: {
                return this.dataType.add(a, b, this.nodes[1].dataType);
            }
            case 33: {
                return this.dataType.subtract(a, b, this.nodes[1].dataType);
            }
            case 34: {
                return this.dataType.multiply(a, b);
            }
            case 35: {
                return this.dataType.divide(a, b);
            }
            case 36: {
                return this.dataType.concat(session, a, b);
            }
        }
        throw Error.runtimeError(401, "Expression");
    }
}

