/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.viewer.undo;

import com.onpositive.richtexteditor.viewer.RichTextViewer;
import com.onpositive.richtexteditor.viewer.undo.IRichDocumentUndoListener;
import com.onpositive.richtexteditor.viewer.undo.IRichDocumentUndoManager;
import com.onpositive.richtexteditor.viewer.undo.RichDocumentUndoEvent;
import com.onpositive.richtexteditor.viewer.undo.RichDocumentUndoManager;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RichViewerUndoManager
implements IUndoManager,
IUndoManagerExtension {
    private KeyAndMouseListener fKeyAndMouseListener;
    private TextInputListener fTextInputListener;
    private RichTextViewer fTextViewer;
    private int fUndoLevel;
    private IRichDocumentUndoManager fDocumentUndoManager;
    private IDocument fDocument;
    private IRichDocumentUndoListener fDocumentUndoListener;

    public RichViewerUndoManager(int undoLevel) {
        this.fUndoLevel = undoLevel;
    }

    private boolean isConnected() {
        return this.fTextViewer != null && this.fDocumentUndoManager != null;
    }

    public void beginCompoundChange() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.beginCompoundChange();
        }
    }

    public void endCompoundChange() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.endCompoundChange();
        }
    }

    private void addListeners() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            this.fKeyAndMouseListener = new KeyAndMouseListener();
            text.addMouseListener((MouseListener)this.fKeyAndMouseListener);
            text.addKeyListener((KeyListener)this.fKeyAndMouseListener);
            this.fTextInputListener = new TextInputListener();
            this.fTextViewer.addTextInputListener(this.fTextInputListener);
        }
    }

    private void removeListeners() {
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null) {
            if (this.fKeyAndMouseListener != null) {
                text.removeMouseListener((MouseListener)this.fKeyAndMouseListener);
                text.removeKeyListener((KeyListener)this.fKeyAndMouseListener);
                this.fKeyAndMouseListener = null;
            }
            if (this.fTextInputListener != null) {
                this.fTextViewer.removeTextInputListener(this.fTextInputListener);
                this.fTextInputListener = null;
            }
        }
    }

    private void openErrorDialog(final String title, final Exception ex) {
        StyledText st;
        Shell shell = null;
        if (this.isConnected() && (st = this.fTextViewer.getTextWidget()) != null && !st.isDisposed()) {
            shell = st.getShell();
        }
        if (Display.getCurrent() != null) {
            MessageDialog.openError(shell, (String)title, (String)ex.getLocalizedMessage());
        } else {
            final Shell finalShell = shell;
            Display display = finalShell != null ? finalShell.getDisplay() : Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)finalShell, (String)title, (String)ex.getLocalizedMessage());
                }
            });
        }
    }

    public void setMaximalUndoLevel(int undoLevel) {
        this.fUndoLevel = Math.max(0, undoLevel);
        if (this.isConnected()) {
            this.fDocumentUndoManager.setMaximalUndoLevel(this.fUndoLevel);
        }
    }

    public void connect(ITextViewer textViewer) {
        if (this.fTextViewer == null && textViewer != null) {
            this.fTextViewer = (RichTextViewer)textViewer;
            this.addListeners();
        }
        IDocument doc = this.fTextViewer.getDocument();
        this.connectDocumentUndoManager(doc);
    }

    public void disconnect() {
        if (this.fTextViewer != null) {
            this.removeListeners();
            this.fTextViewer = null;
        }
        this.disconnectDocumentUndoManager();
    }

    public void reset() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.reset();
        }
    }

    public boolean redoable() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.redoable();
        }
        return false;
    }

    public boolean undoable() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.undoable();
        }
        return false;
    }

    public void redo() {
        if (this.isConnected()) {
            try {
                this.fDocumentUndoManager.redo();
            }
            catch (ExecutionException ex) {
                this.openErrorDialog("Redo Failed", (Exception)((Object)ex));
            }
        }
    }

    public void undo() {
        if (this.isConnected()) {
            try {
                this.fDocumentUndoManager.undo();
            }
            catch (ExecutionException ex) {
                this.openErrorDialog("Undo failed", (Exception)((Object)ex));
            }
        }
    }

    private void selectAndReveal(int offset, int length) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else if (!this.fTextViewer.overlapsWithVisibleRegion(offset, length)) {
            this.fTextViewer.resetVisibleRegion();
        }
        this.fTextViewer.setSelectedRange(offset, length);
        this.fTextViewer.revealRange(offset, length);
    }

    public IUndoContext getUndoContext() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.getUndoContext();
        }
        return null;
    }

    private void connectDocumentUndoManager(IDocument document) {
        this.disconnectDocumentUndoManager();
        if (document != null) {
            this.fDocument = document;
            this.fDocumentUndoManager = new RichDocumentUndoManager(this.fDocument, this.fTextViewer.getLayerManager());
            this.fDocumentUndoManager.connect(this);
            this.setMaximalUndoLevel(this.fUndoLevel);
            this.fDocumentUndoListener = new DocumentUndoListener();
            this.fDocumentUndoManager.addDocumentUndoListener(this.fDocumentUndoListener);
        }
    }

    private void disconnectDocumentUndoManager() {
        if (this.fDocumentUndoManager != null) {
            this.fDocumentUndoManager.disconnect(this);
            this.fDocumentUndoManager.removeDocumentUndoListener(this.fDocumentUndoListener);
            this.fDocumentUndoListener = null;
            this.fDocumentUndoManager = null;
        }
    }

    private class DocumentUndoListener
    implements IRichDocumentUndoListener {
        private DocumentUndoListener() {
        }

        @Override
        public void documentUndoNotification(RichDocumentUndoEvent event) {
            if (!RichViewerUndoManager.this.isConnected()) {
                return;
            }
            int eventType = event.getEventType();
            if ((eventType & 1) != 0 || (eventType & 2) != 0) {
                event.isCompound();
                RichViewerUndoManager.this.fTextViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RichViewerUndoManager.this.fTextViewer.ignoreAutoEditStrategies(true);
                    }
                });
            } else if ((eventType & 4) != 0 || (eventType & 8) != 0) {
                RichViewerUndoManager.this.fTextViewer.getTextWidget().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RichViewerUndoManager.this.fTextViewer.ignoreAutoEditStrategies(false);
                    }
                });
                if (event.isCompound()) {
                    RichTextViewer extension = null;
                    if (RichViewerUndoManager.this.fTextViewer instanceof ITextViewerExtension) {
                        extension = RichViewerUndoManager.this.fTextViewer;
                    }
                    if (extension != null) {
                        extension.setRedraw(true);
                    }
                }
                if (RichViewerUndoManager.this.fTextViewer != null) {
                    StyledText widget = RichViewerUndoManager.this.fTextViewer.getTextWidget();
                    if (event.isRevealSelection() && widget != null && !widget.isDisposed() && widget.isFocusControl()) {
                        RichViewerUndoManager.this.selectAndReveal(event.getOffset(), event.getText() == null ? 0 : event.getText().length());
                    }
                }
            }
        }
    }

    private class KeyAndMouseListener
    implements MouseListener,
    KeyListener {
        private KeyAndMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1 && RichViewerUndoManager.this.isConnected()) {
                RichViewerUndoManager.this.fDocumentUndoManager.commit();
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    if (!RichViewerUndoManager.this.isConnected()) break;
                    RichViewerUndoManager.this.fDocumentUndoManager.commit();
                }
            }
        }
    }

    private class TextInputListener
    implements ITextInputListener {
        private TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            RichViewerUndoManager.this.disconnectDocumentUndoManager();
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            RichViewerUndoManager.this.connectDocumentUndoManager(newInput);
        }
    }
}

