/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.BasePartitionLayer;
import com.onpositive.richtexteditor.model.IPartition;
import com.onpositive.richtexteditor.model.LayerEvent;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.ObjectPartition;
import com.onpositive.richtexteditor.model.resources.ImageManager;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ImagePartition
extends ObjectPartition {
    protected Image image;
    protected String imagePath;
    protected boolean loadSheduled;

    public ImagePartition(BasePartitionLayer layer, int offset, int length, Image image, String imageFileName) {
        super(layer, offset, length);
        this.image = image;
        this.imagePath = imageFileName;
    }

    public ImagePartition(BasePartitionLayer layer, int offset, int length, Image image) {
        super(layer, offset, length);
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public Object getObject() {
        return this.image;
    }

    @Override
    public void setObject(Object object) {
        this.image = (Image)object;
    }

    @Override
    public StyleRange getStyleRange(final LayerManager manager) {
        if (!this.loadSheduled && this.image == null) {
            this.loadSheduled = true;
            ImageManager imageCache = manager.getImageManager();
            this.image = imageCache.getImage(this.imagePath, new Observer(){

                @Override
                public void update(Observable o, final Object arg) {
                    Display display = Display.getDefault();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ImagePartition.this.image = (Image)arg;
                            if (ImagePartition.this.getPosition() != -1) {
                                ArrayList<IPartition> changedPartitions = new ArrayList<IPartition>();
                                changedPartitions.add(ImagePartition.this);
                                manager.layerChanged(new LayerEvent((this).ImagePartition.this.layer, changedPartitions));
                            }
                        }
                    });
                }
            });
        }
        StyleRange style = new StyleRange();
        style.start = this.getOffset();
        style.length = 1;
        Rectangle rect = this.image != null ? this.image.getBounds() : new Rectangle(0, 0, 20, 20);
        style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        return style;
    }

    @Override
    public Color getColor(LayerManager manager) {
        return null;
    }

    @Override
    public Color getBgColor(LayerManager manager) {
        return null;
    }

    @Override
    public boolean equalsByStyle(BasePartition partition2) {
        return false;
    }

    public String getImageFileName() {
        return this.imagePath;
    }

    public void setImageFileName(String imageFileName) {
        this.imagePath = imageFileName;
    }
}

