/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.BasePartitionEvent;
import com.onpositive.richtexteditor.model.BasePartitionLayer;
import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.IPartition;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.Logger;
import com.onpositive.richtexteditor.model.partitions.LinkPartition;
import com.onpositive.richtexteditor.model.partitions.ObjectPartition;
import com.onpositive.richtexteditor.model.partitions.PartitionFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class BasePartition
implements IPartition {
    BasePartitionLayer layer;
    int length;
    int offset;
    int index = -1;
    int mask = 0;
    private RGB colorRGB = null;
    private RGB bgColorRGB = null;
    private boolean refreshVisibleState = true;
    protected String fontDataName = FontStyle.NORMAL_FONT_NAME;
    private static String ADDITION = "_bold_italic";

    public static String getBoldItalicNameByFontName(String name) {
        return String.valueOf(name) + ADDITION;
    }

    public int getPosition() {
        return this.index;
    }

    public BasePartition(BasePartitionLayer layer, int offset, int length) {
        this.layer = layer;
        this.length = length;
        this.offset = offset;
        this.mask = 0;
    }

    public boolean isRefreshVisibleState() {
        return this.refreshVisibleState;
    }

    public void setRefreshVisibleState(boolean refreshVisibleState) {
        this.refreshVisibleState = refreshVisibleState;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean requiresSingleLine() {
        return false;
    }

    public boolean requiresFullDeletion() {
        return false;
    }

    public boolean allowsInnerTyping() {
        return true;
    }

    public boolean isBold() {
        return (this.mask & 1) > 0;
    }

    public void setBold(boolean bold) {
        this.mask = bold ? (this.mask |= 1) : (this.mask &= 0xFFFFFFFE);
        if (this.refreshVisibleState) {
            this.layer.handlePartitionEvent(new BasePartitionEvent(this));
        }
    }

    public boolean isItalic() {
        return (this.mask & 2) > 0;
    }

    public void setItalic(boolean italic) {
        this.mask = italic ? (this.mask |= 2) : (this.mask &= 0xFFFFFFFD);
        if (this.refreshVisibleState) {
            this.layer.handlePartitionEvent(new BasePartitionEvent(this));
        }
    }

    public void setUnderlined(boolean underlined) {
        this.mask = underlined ? (this.mask |= 4) : (this.mask &= 0xFFFFFFFB);
        if (this.refreshVisibleState) {
            this.layer.handlePartitionEvent(new BasePartitionEvent(this));
        }
    }

    public void setStrikethrough(boolean strikeThrough) {
        this.mask = strikeThrough ? (this.mask |= 8) : (this.mask &= 0xFFFFFFF7);
        if (this.refreshVisibleState) {
            this.layer.handlePartitionEvent(new BasePartitionEvent(this));
        }
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    @Override
    public String getText() {
        try {
            return this.layer.getDoc().get(this.offset, this.length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void applyAttributes(BasePartition oldPartition) {
        this.mask |= oldPartition.mask;
        if (oldPartition.fontDataName != FontStyle.NORMAL_FONT_NAME) {
            this.fontDataName = oldPartition.fontDataName;
        }
        if (oldPartition.colorRGB != null) {
            this.colorRGB = oldPartition.colorRGB;
        }
        if (oldPartition.bgColorRGB != null) {
            this.bgColorRGB = oldPartition.bgColorRGB;
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        return "{ (" + this.offset + "," + this.length + ") " + " bold: " + this.isBold() + " italic: " + this.isItalic() + "   " + this.getText() + "}";
    }

    public BasePartition extractLeftPartition(int divisionOffset) {
        if (divisionOffset <= this.offset) {
            throw new RuntimeException("Wrong extractLeftPartition argument (" + divisionOffset + " < " + this.offset + ")");
        }
        if (divisionOffset == this.offset + this.length) {
            return this;
        }
        int oldOffset = this.offset;
        this.offset = divisionOffset;
        this.length -= divisionOffset - oldOffset;
        return PartitionFactory.createAsSample(this, oldOffset, divisionOffset - oldOffset);
    }

    public BasePartition extractLeftPartitionWithStyle(int divisionOffset) {
        if (divisionOffset <= this.offset) {
            throw new RuntimeException("Wrong extractLeftPartition argument (" + divisionOffset + " < " + this.offset + ")");
        }
        if (divisionOffset == this.offset + this.length) {
            return this;
        }
        int oldOffset = this.offset;
        this.offset = divisionOffset;
        this.length -= divisionOffset - oldOffset;
        return PartitionFactory.createAsSampleStyle(this, this.layer, oldOffset, divisionOffset - oldOffset);
    }

    public int getStyleMask() {
        return this.mask;
    }

    public void setStyleMask(int newMask) {
        this.mask = newMask;
        if (this.refreshVisibleState) {
            this.layer.handlePartitionEvent(new BasePartitionEvent(this));
        }
    }

    boolean equalsByCoords(BasePartition partition2) {
        return partition2.offset == this.offset && partition2.length == this.length;
    }

    public boolean equalsByStyle(BasePartition partition2) {
        if (partition2 instanceof ObjectPartition || this instanceof ObjectPartition) {
            return false;
        }
        if (partition2 instanceof LinkPartition || this instanceof LinkPartition) {
            return false;
        }
        return this.mask == partition2.mask && this.fontDataName.equals(partition2.fontDataName) && this.colorRGB == partition2.colorRGB && this.bgColorRGB == partition2.bgColorRGB;
    }

    public String getFontDataName() {
        return this.fontDataName;
    }

    public void setFontDataName(String fontDataName) {
        this.fontDataName = fontDataName;
    }

    public String getTextFromOffset(int offset) {
        if (offset < this.offset || offset >= this.offset + this.length) {
            throw new RuntimeException("Invalid getTextFromOffset argument - " + offset);
        }
        try {
            return this.layer.getDoc().get(offset, this.length - (offset - this.offset));
        }
        catch (BadLocationException e) {
            Logger.log(e);
            return null;
        }
    }

    public String getTextUpToOffset(int offset) {
        if (offset < this.offset || offset > this.offset + this.length) {
            throw new RuntimeException("Invalid getTextFromOffset argument - " + offset);
        }
        try {
            return this.layer.getDoc().get(this.offset, offset - this.offset);
        }
        catch (BadLocationException e) {
            Logger.log(e);
            return null;
        }
    }

    public String getTextRegion(int offset, int length) {
        if (offset < this.offset || offset >= this.offset + this.length || length <= 0) {
            throw new RuntimeException("Invalid getTextFromOffset argument - " + offset);
        }
        try {
            return this.layer.getDoc().get(offset, length);
        }
        catch (BadLocationException e) {
            Logger.log(e);
            return null;
        }
    }

    public RGB getColorRGB() {
        return this.colorRGB;
    }

    public RGB getBgColorRGB() {
        return this.bgColorRGB;
    }

    public boolean isUnderlined() {
        return (this.mask & 4) > 0;
    }

    public boolean isStrikethrough() {
        return (this.mask & 8) > 0;
    }

    public StyleRange getStyleRange(LayerManager manager) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = this.getOffset();
        styleRange.length = this.getLength();
        styleRange.underline = this.isUnderlined();
        styleRange.strikeout = this.isStrikethrough();
        if (this.colorRGB != null) {
            styleRange.foreground = manager.getColorRegistry().getColor(this.colorRGB);
        }
        if (this.bgColorRGB != null) {
            styleRange.background = manager.getColorRegistry().getColor(this.bgColorRGB);
        }
        this.refreshVisibleState = true;
        return styleRange;
    }

    public Color getColor(LayerManager manager) {
        if (this.colorRGB != null) {
            return manager.getColorRegistry().getColor(this.colorRGB);
        }
        return null;
    }

    public Color getBgColor(LayerManager manager) {
        if (this.bgColorRGB != null) {
            return manager.getColorRegistry().getColor(this.bgColorRGB);
        }
        return null;
    }

    public void setColorRGB(RGB color) {
        this.colorRGB = color;
    }

    public void setBgColorRGB(RGB bgColor) {
        this.bgColorRGB = bgColor;
    }

    @Override
    public BasePartition clone() {
        try {
            BasePartition clone = (BasePartition)super.clone();
            if (clone.colorRGB != null) {
                clone.colorRGB = new RGB(clone.colorRGB.red, clone.colorRGB.green, clone.colorRGB.blue);
            }
            if (clone.bgColorRGB != null) {
                clone.bgColorRGB = new RGB(clone.bgColorRGB.red, clone.bgColorRGB.green, clone.bgColorRGB.blue);
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Should never happen");
        }
    }
}

