/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.actions;

import com.onpositive.richtexteditor.model.LayerManager;
import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public abstract class ColorAction
extends Action
implements IMenuCreator {
    private HashMap<RGB, Color> colors = new HashMap();
    private HashMap<RGB, Image> images = new HashMap();
    private Color color;
    protected LayerManager manager;

    public ColorAction(LayerManager manager) {
        super("", 4);
        this.setMenuCreator(this);
        this.setColor(this.getDefaultColor());
        this.manager = manager;
    }

    protected RGB getDefaultColor() {
        return new RGB(255, 255, 255);
    }

    public void setColor(RGB clr) {
        if (clr == null) {
            clr = this.getDefaultColor();
        }
        this.processColor(clr);
        Image image2 = this.images.get(clr);
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image2));
        this.color = this.colors.get(clr);
    }

    private void processColor(RGB clr) {
        Color color2 = this.colors.get(clr);
        if (color2 == null) {
            RGB clr1 = clr;
            if (clr.blue == 0 && clr.green == 0 && clr.red == 0) {
                clr1 = new RGB(1, 1, 1);
            }
            Color s = new Color((Device)Display.getCurrent(), clr1);
            this.colors.put(clr, s);
            ImageData da = new ImageData(16, 16, 32, new PaletteData(1, 1, 1));
            da.transparentPixel = 0;
            Image im = new Image((Device)Display.getCurrent(), da);
            GC gc = new GC((Drawable)im);
            this.createImage(s, gc);
            gc.dispose();
            this.images.put(clr, im);
        }
    }

    protected void createImage(Color s, GC gc) {
        gc.setBackground(s);
        gc.fillRectangle(0, 4, 16, 10);
    }

    public Color getColor() {
        return this.color;
    }

    public void dispose() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
        for (Image image : this.images.values()) {
            image.dispose();
        }
    }

    public void run() {
        ColorDialog colorDialog = new ColorDialog(Display.getCurrent().getActiveShell());
        colorDialog.setText("Select color");
        RGB open = colorDialog.open();
        if (open != null) {
            this.setIntervalColor(open);
            this.setColor(open);
        }
    }

    public Menu getMenu(Control parent) {
        MenuManager ma = new MenuManager();
        int n = 0;
        for (final RGB r : this.manager.getColorRegistry().getColors()) {
            RGB rgb;
            this.processColor(r);
            Image image2 = this.images.get(r);
            Action a = new Action(){

                public void run() {
                    ColorAction.this.setIntervalColor(r);
                    ColorAction.this.setColor(r);
                }
            };
            a.setImageDescriptor(ImageDescriptor.createFromImage((Image)image2));
            if (this.color != null && (rgb = this.color.getRGB()).equals((Object)r)) {
                a.setChecked(true);
            }
            String text = this.manager.getColorRegistry().getColorName(n);
            a.setText(text);
            ma.add((IAction)a);
            ++n;
        }
        Menu createContextMenu = ma.createContextMenu(parent);
        return createContextMenu;
    }

    public abstract void setIntervalColor(RGB var1);

    public Menu getMenu(Menu parent) {
        throw new UnsupportedOperationException();
    }
}

