/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.widgets.datechooser.DateChooserTheme;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;

public class DateChooser
extends Composite {
    public static final String BUNDLE_NAME = "org.eclipse.nebula.widgets.datechooser.resources";
    protected static final int HEADER_SPACING = 3;
    protected static final int NOFOCUS = -100;
    protected boolean multi;
    protected List selection;
    protected Date beginInterval;
    protected Date endInterval;
    protected boolean autoSelectOnFooter = false;
    protected Composite monthPanel;
    protected Button prevMonth;
    protected Label currentMonth;
    protected Button nextMonth;
    protected Menu monthsMenu;
    protected Composite gridPanel;
    protected DateChooserLayout gridLayout;
    protected Composite headersPanel;
    protected Label[] headers;
    protected Composite daysPanel;
    protected Cell[] days;
    protected Composite weeksPanel;
    protected Cell[] weeks;
    protected int firstDayIndex;
    protected Label todayLabel;
    protected Locale locale;
    protected SimpleDateFormat df1;
    protected DateFormat df2;
    protected int firstDayOfWeek;
    protected int minimalDaysInFirstWeek;
    protected ResourceBundle resources;
    protected Calendar currentMonthCal;
    protected Calendar todayCal;
    protected DateChooserTheme theme;
    protected boolean gridVisible = true;
    protected boolean weeksVisible = false;
    protected boolean footerVisible = false;
    protected boolean navigationEnabled = true;
    protected boolean autoChangeOnAdjacent = true;
    protected Listener listener;
    protected Listener filter;
    protected boolean hasFocus = false;
    protected int focusIndex = -100;
    private int redraw = 0;

    public DateChooser(Composite parent, int style) {
        super(parent, style);
        this.multi = (style & 2) > 0;
        this.selection = new ArrayList();
        this.createContent();
        this.setLocale(Locale.getDefault());
        this.setTheme(DateChooserTheme.getDefaultTheme());
        this.setTodayDate(new Date());
        this.setCurrentMonth(this.todayCal.getTime());
        this.computeSize(-1, -1, true);
    }

    public void addSelectionListener(SelectionListener lsnr) {
        this.checkWidget();
        if (lsnr == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)lsnr);
        this.addListener(13, (Listener)typedListener);
    }

    protected void buttonsEvent(Event event) {
        switch (event.type) {
            case 4: {
                boolean ctrl;
                Rectangle r = ((Control)event.widget).getBounds();
                if (event.x < 0 || event.x >= r.width || event.y < 0 || event.y >= r.height) {
                    return;
                }
                boolean bl = ctrl = (event.stateMask & 0x40000) != 0;
                if (event.widget == this.prevMonth) {
                    this.changeCurrentMonth(ctrl ? -12 : -1);
                    break;
                }
                if (event.widget != this.nextMonth) break;
                this.changeCurrentMonth(ctrl ? 12 : 1);
                break;
            }
            case 15: {
                this.handleFocus(event.type);
            }
        }
    }

    protected void calendarEvent(Event event) {
        block0 : switch (event.type) {
            case 31: {
                switch (event.detail) {
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        event.doit = false;
                        break block0;
                    }
                }
                event.doit = true;
                break;
            }
            case 15: {
                this.handleFocus(event.type);
                break;
            }
            case 1: {
                boolean ctrl = (event.stateMask & 0x40000) != 0;
                switch (event.keyCode) {
                    case 0x1000003: {
                        if (event.stateMask != 0) {
                            return;
                        }
                        this.setFocus(this.focusIndex - 1);
                        break;
                    }
                    case 0x1000004: {
                        if (event.stateMask != 0) {
                            return;
                        }
                        this.setFocus(this.focusIndex + 1);
                        break;
                    }
                    case 0x1000001: {
                        if (event.stateMask != 0) {
                            return;
                        }
                        this.setFocus(this.focusIndex - 7);
                        break;
                    }
                    case 0x1000002: {
                        if (event.stateMask != 0) {
                            return;
                        }
                        this.setFocus(this.focusIndex + 7);
                        break;
                    }
                    case 0x1000006: {
                        if (event.stateMask != 0 || !this.navigationEnabled) {
                            return;
                        }
                        this.changeCurrentMonth(ctrl ? 12 : 1);
                        break;
                    }
                    case 0x1000005: {
                        if (event.stateMask != 0 || !this.navigationEnabled) {
                            return;
                        }
                        this.changeCurrentMonth(ctrl ? -12 : -1);
                        break;
                    }
                    case 32: {
                        this.select(this.focusIndex, event.stateMask);
                        break;
                    }
                    case 0x1000007: {
                        if (event.stateMask != 0) {
                            return;
                        }
                        this.setFocusOnToday(this.autoSelectOnFooter);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (!this.hasFocus) break;
                this.gridPanel.redraw();
                this.daysPanel.redraw();
                break;
            }
            case 12: {
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.removeFilter(1, this.filter);
                this.hasFocus = false;
            }
        }
    }

    protected void changeCurrentMonth(int add) {
        if (add == 0) {
            return;
        }
        this.currentMonthCal.add(2, add);
        this.refreshDisplay();
    }

    public void clearSelection() {
        this.clearSelection(true);
    }

    protected void clearSelection(boolean refresh) {
        this.selection.clear();
        int i = 0;
        while (i < this.days.length) {
            this.days[i].selected = false;
            ++i;
        }
        this.beginInterval = null;
        if (refresh) {
            this.refreshDisplay();
        }
    }

    private void createContent() {
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        super.setLayout((Layout)layout);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 3 && !DateChooser.this.hasFocus) {
                    DateChooser.this.setFocus();
                    return;
                }
                if (DateChooser.this == event.widget && event.type != 1) {
                    DateChooser.this.calendarEvent(event);
                } else if (DateChooser.this.prevMonth == event.widget || DateChooser.this.nextMonth == event.widget) {
                    DateChooser.this.buttonsEvent(event);
                } else if (DateChooser.this.todayLabel == event.widget) {
                    DateChooser.this.footerEvent(event);
                } else if (DateChooser.this.daysPanel == event.widget || event.widget instanceof Label) {
                    DateChooser.this.gridEvent(event);
                } else if (DateChooser.this.monthsMenu == event.widget || event.widget instanceof MenuItem) {
                    DateChooser.this.menuEvent(event);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 15: {
                        DateChooser.this.handleFocus(16);
                        break;
                    }
                    case 1: {
                        DateChooser.this.calendarEvent(event);
                    }
                }
            }
        };
        this.createHeader();
        this.createGrid();
        this.addListener(12, this.listener);
        this.addListener(31, this.listener);
        this.addListener(1, this.listener);
        this.addListener(15, this.listener);
    }

    private void createGrid() {
        this.gridPanel = new Composite((Composite)this, 0);
        this.gridLayout = new DateChooserLayout();
        this.gridPanel.setLayout((Layout)this.gridLayout);
        this.weeksPanel = new Composite(this.gridPanel, 0);
        this.weeks = new Cell[6];
        int i = 0;
        while (i < 6) {
            this.weeks[i] = new Cell(this.weeksPanel, i);
            ++i;
        }
        this.headersPanel = new Composite(this.gridPanel, 0);
        this.headers = new Label[8];
        i = 0;
        while (i < 8) {
            this.headers[i] = new Label(this.headersPanel, 0x1000000);
            this.headers[i].addListener(3, this.listener);
            ++i;
        }
        this.daysPanel = new Composite(this.gridPanel, 0);
        this.days = new Cell[42];
        i = 0;
        while (i < 42) {
            this.days[i] = new Cell(this.daysPanel, i);
            this.days[i].label.addListener(4, this.listener);
            ++i;
        }
        this.daysPanel.addListener(9, this.listener);
        this.todayLabel = new Label(this.gridPanel, 0x1000000);
        this.todayLabel.addListener(8, this.listener);
        this.todayLabel.addListener(3, this.listener);
    }

    private void createHeader() {
        this.monthPanel = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(3, 0).margins(3, 3).applyTo(this.monthPanel);
        GridDataFactory.fillDefaults().applyTo((Control)this.monthPanel);
        this.monthPanel.addListener(3, this.listener);
        this.prevMonth = new Button(this.monthPanel, 0x804004);
        this.prevMonth.addListener(4, this.listener);
        this.prevMonth.addListener(15, this.listener);
        this.currentMonth = new Label(this.monthPanel, 0x1000000);
        this.currentMonth.setLayoutData((Object)new GridData(768));
        this.currentMonth.addListener(3, this.listener);
        this.nextMonth = new Button(this.monthPanel, 8519684);
        this.nextMonth.addListener(4, this.listener);
        this.nextMonth.addListener(15, this.listener);
        this.monthsMenu = new Menu((Decorations)this.getShell(), 8);
        this.currentMonth.setMenu(this.monthsMenu);
        int i = 0;
        while (i < 12) {
            MenuItem item = new MenuItem(this.monthsMenu, 8);
            item.addListener(13, this.listener);
            item.setData((Object)new Integer(i));
            ++i;
        }
        this.monthsMenu.addListener(22, this.listener);
    }

    public void dispose() {
        this.getDisplay().removeFilter(1, this.filter);
        this.getDisplay().removeFilter(15, this.filter);
        super.dispose();
    }

    private void drawFocus(GC gc) {
        if (this.hasFocus) {
            if (this.focusIndex < 0) {
                this.setFocus(-1);
            }
            Rectangle r = this.days[this.focusIndex].label.getBounds();
            gc.setLineWidth(1);
            gc.setForeground(this.theme.focusColor);
            gc.drawRectangle(r.x - 1, r.y - 1, r.width + 1, r.height + 1);
            int line = this.focusIndex / 7;
            int col = this.focusIndex % 7;
            if (line == 0 || line == 5 && this.footerVisible || col == 0 && this.weeksVisible) {
                Rectangle rg = this.daysPanel.getBounds();
                GC gridGc = new GC((Drawable)this.gridPanel);
                gridGc.setForeground(this.theme.focusColor);
                if (line == 0) {
                    gridGc.drawLine(rg.x + r.x - 1, rg.y - 1, rg.x + r.x + r.width, rg.y - 1);
                } else if (line == 5 && this.footerVisible) {
                    gridGc.drawLine(rg.x + r.x - 1, rg.y + rg.height, rg.x + r.x + r.width, rg.y + rg.height);
                }
                if (col == 0 && this.weeksVisible) {
                    gridGc.drawLine(rg.x + r.x - 1, rg.y + r.y - 1, rg.x + r.x - 1, rg.y + r.y + r.height);
                }
                gridGc.dispose();
            }
        }
    }

    protected void footerEvent(Event event) {
        switch (event.type) {
            case 8: {
                this.setFocusOnToday(this.autoSelectOnFooter);
            }
        }
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (super.forceFocus()) {
            this.handleFocus(15);
            return true;
        }
        return false;
    }

    private int getCellIndex(Label label) {
        int i = 0;
        while (i < this.days.length) {
            if (this.days[i].label == label) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Date getCurrentMonth() {
        this.checkWidget();
        return this.currentMonthCal.getTime();
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public Date getSelectedDate() {
        this.checkWidget();
        return this.selection.isEmpty() ? null : (Date)this.selection.get(0);
    }

    public Collection getSelectedDates() {
        this.checkWidget();
        ArrayList<Date> returnSelection = new ArrayList<Date>(this.selection.size());
        Iterator it = this.selection.iterator();
        while (it.hasNext()) {
            Date d = (Date)it.next();
            if (returnSelection.contains(d)) continue;
            returnSelection.add(d);
        }
        return returnSelection;
    }

    public Date getTodayDate() {
        this.checkWidget();
        return this.todayCal.getTime();
    }

    protected void gridEvent(Event event) {
        switch (event.type) {
            case 4: {
                Rectangle r = ((Control)event.widget).getBounds();
                if (event.x < 0 || event.x >= r.width || event.y < 0 || event.y >= r.height) {
                    return;
                }
                this.setFocus(this.getCellIndex((Label)event.widget));
                this.select(this.focusIndex, event.stateMask);
                break;
            }
            case 9: {
                this.drawFocus(event.gc);
            }
        }
    }

    private void handleFocus(int mode) {
        switch (mode) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Display display = this.getDisplay();
                display.removeFilter(1, this.filter);
                display.removeFilter(15, this.filter);
                if (this.focusIndex < 0) {
                    this.setFocus(-100);
                }
                this.notifyListeners(15, new Event());
                display.addFilter(15, this.filter);
                display.addFilter(1, this.filter);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this || focusControl == this.nextMonth || focusControl == this.prevMonth) {
                    return;
                }
                this.hasFocus = false;
                this.getDisplay().removeFilter(1, this.filter);
                this.getDisplay().removeFilter(15, this.filter);
                this.notifyListeners(16, new Event());
            }
        }
        this.daysPanel.redraw();
    }

    public boolean isAutoChangeOnAdjacent() {
        return this.autoChangeOnAdjacent;
    }

    public boolean isAutoSelectOnFooter() {
        this.checkWidget();
        return this.autoSelectOnFooter;
    }

    public boolean isDateSelected(Date date) {
        this.checkWidget();
        Iterator it = this.selection.iterator();
        while (it.hasNext()) {
            if (!((Date)it.next()).equals(date)) continue;
            return true;
        }
        return false;
    }

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    public boolean isFooterVisible() {
        this.checkWidget();
        return this.footerVisible;
    }

    public boolean isGridVisible() {
        this.checkWidget();
        return this.gridVisible;
    }

    public boolean isNavigationEnabled() {
        this.checkWidget();
        return this.navigationEnabled;
    }

    public boolean isWeeksVisible() {
        this.checkWidget();
        return this.weeksVisible;
    }

    protected void menuEvent(Event event) {
        switch (event.type) {
            case 22: {
                this.monthsMenu.setDefaultItem(this.monthsMenu.getItems()[this.currentMonthCal.get(2)]);
                break;
            }
            case 13: {
                this.currentMonthCal.set(2, (Integer)event.widget.getData());
                this.refreshDisplay();
            }
        }
    }

    protected void notifySelection() {
        Event event = new Event();
        if (!this.multi) {
            event.data = this.getSelectedDate();
        }
        this.notifyListeners(13, event);
    }

    private void redrawDec() {
        --this.redraw;
        if (this.redraw == 0) {
            this.setRedraw(true);
        }
    }

    private void redrawInc() {
        if (this.redraw == 0) {
            this.setRedraw(false);
        }
        ++this.redraw;
    }

    private void refreshDisplay() {
        if (this.currentMonthCal == null || this.theme == null) {
            return;
        }
        this.redrawInc();
        this.currentMonth.setText(this.df1.format(this.currentMonthCal.getTime()));
        int maxDay = this.currentMonthCal.getActualMaximum(5);
        Calendar cal = (Calendar)this.currentMonthCal.clone();
        int delta = -((cal.get(7) - this.firstDayOfWeek + 7) % 7);
        cal.add(5, delta);
        int i = 0;
        while (i < 42) {
            if (i % 7 == 0) {
                int w = cal.get(3);
                this.weeks[i / 7].label.setText(w < 10 ? "0" + w : "" + w);
            }
            if (delta == 0) {
                this.firstDayIndex = i;
            }
            int weekDay = cal.get(7);
            this.days[i].weekend = weekDay == 1 || weekDay == 7;
            this.days[i].adjacent = delta < 0 ? -1 : (delta >= maxDay ? 1 : 0);
            this.days[i].today = cal.equals(this.todayCal);
            if (this.days[i].cal == null) {
                this.days[i].cal = (Calendar)cal.clone();
            } else {
                this.days[i].cal.setTimeInMillis(cal.getTimeInMillis());
            }
            this.days[i].label.setText("" + this.days[i].cal.get(5));
            this.days[i].selected = this.isDateSelected(cal.getTime());
            this.setCellColors(this.days[i]);
            cal.add(5, 1);
            ++delta;
            ++i;
        }
        this.redrawDec();
    }

    public void removeSelectedDate(Date d) {
        this.checkWidget();
        this.removeSelectedDate(d, true);
    }

    private void removeSelectedDate(Date d, boolean refresh) {
        Iterator it = this.selection.iterator();
        while (it.hasNext()) {
            Date itDate = (Date)it.next();
            if (!itDate.equals(d)) continue;
            this.selection.remove(itDate);
            break;
        }
        if (refresh) {
            this.refreshDisplay();
        }
    }

    public void removeSelectionListener(SelectionListener lsnr) {
        this.checkWidget();
        if (lsnr == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)lsnr);
    }

    private void select(int index, int stateMask) {
        boolean shift;
        Cell cell = this.days[index];
        if (!this.navigationEnabled && cell.adjacent != 0) {
            return;
        }
        boolean ctrl = (stateMask & 0x40000) != 0;
        boolean bl = shift = (stateMask & 0x20000) != 0;
        if (shift && this.beginInterval == null) {
            ctrl = true;
            shift = false;
        }
        if (!this.multi || !ctrl && !shift) {
            this.clearSelection(false);
        }
        Date selectedDate = cell.cal.getTime();
        if (this.multi && ctrl && cell.selected) {
            this.removeSelectedDate(selectedDate, false);
            this.beginInterval = null;
            this.endInterval = null;
        } else if (this.multi && shift) {
            Date d;
            int delta;
            Calendar c = (Calendar)cell.cal.clone();
            if (this.endInterval != null) {
                delta = this.endInterval.after(this.beginInterval) ? -1 : 1;
                c.setTime(this.endInterval);
                d = c.getTime();
                while (d.compareTo(this.beginInterval) != 0) {
                    this.removeSelectedDate(d, false);
                    c.add(5, delta);
                    d = c.getTime();
                }
            }
            this.endInterval = selectedDate;
            delta = this.endInterval.after(this.beginInterval) ? -1 : 1;
            c.setTime(this.endInterval);
            d = c.getTime();
            while (d.compareTo(this.beginInterval) != 0) {
                this.selection.add(d);
                c.add(5, delta);
                d = c.getTime();
            }
        } else {
            this.selection.add(selectedDate);
            this.beginInterval = cell.cal.getTime();
            this.endInterval = null;
        }
        if (cell.adjacent != 0 && this.autoChangeOnAdjacent) {
            this.changeCurrentMonth(cell.adjacent);
        } else {
            this.refreshDisplay();
        }
        this.notifySelection();
    }

    public void setAutoChangeOnAdjacent(boolean autoChangeOnAdjacent) {
        this.autoChangeOnAdjacent = autoChangeOnAdjacent;
    }

    public void setAutoSelectOnFooter(boolean autoselectOnFooter) {
        this.checkWidget();
        this.autoSelectOnFooter = autoselectOnFooter;
    }

    private void setCellColors(Cell cell) {
        if (cell.selected) {
            cell.label.setBackground(this.theme.selectedBackground);
            cell.label.setForeground(this.theme.selectedForeground);
        } else if (cell.today) {
            cell.label.setBackground(this.theme.todayBackground);
            cell.label.setForeground(this.theme.todayForeground);
        } else {
            cell.label.setBackground(this.theme.dayCellBackground);
            cell.label.setForeground(cell.adjacent != 0 ? this.theme.extraMonthForeground : (cell.weekend ? this.theme.weekendForeground : this.theme.dayCellForeground));
        }
    }

    public void setCurrentMonth(Date month) {
        this.checkWidget();
        if (month == null) {
            SWT.error((int)4);
        }
        if (this.currentMonthCal == null) {
            this.currentMonthCal = Calendar.getInstance(this.locale);
            this.currentMonthCal.setFirstDayOfWeek(this.firstDayOfWeek);
            this.currentMonthCal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
        }
        this.currentMonthCal.setTime(month);
        this.trunc(this.currentMonthCal);
        this.currentMonthCal.set(5, 1);
        this.refreshDisplay();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        this.currentMonthCal.setFirstDayOfWeek(firstDayOfWeek);
        this.todayCal.setFirstDayOfWeek(firstDayOfWeek);
    }

    public boolean setFocus() {
        this.checkWidget();
        if (super.setFocus()) {
            this.handleFocus(15);
            return true;
        }
        return false;
    }

    private void setFocus(int index) {
        if (index == -100) {
            int i;
            if (this.todayCal.get(2) == this.currentMonthCal.get(2) && this.todayCal.get(1) == this.currentMonthCal.get(1)) {
                i = 0;
                while (i < this.days.length) {
                    if (this.days[i].today) {
                        this.focusIndex = i;
                        return;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < this.days.length) {
                if (this.days[i].cal.get(5) == 1) {
                    this.focusIndex = i;
                    return;
                }
                ++i;
            }
        }
        if (index < 0) {
            if (!this.navigationEnabled) {
                return;
            }
            this.changeCurrentMonth(-1);
            this.focusIndex = index + 42;
        } else if (index >= 42) {
            if (!this.navigationEnabled) {
                return;
            }
            this.changeCurrentMonth(1);
            this.focusIndex = index - 42;
        } else {
            this.focusIndex = index;
        }
    }

    public void setFocusOnDate(Date date) {
        Calendar dateCal = (Calendar)this.currentMonthCal.clone();
        dateCal.setTime(date);
        if (dateCal.get(2) != this.currentMonthCal.get(2) || dateCal.get(1) != this.currentMonthCal.get(1)) {
            this.setCurrentMonth(date);
        }
        this.focusIndex = this.firstDayIndex + dateCal.get(5) - 1;
    }

    public void setFocusOnToday(boolean autoselect) {
        this.checkWidget();
        this.redrawInc();
        if (this.currentMonthCal.get(2) != this.todayCal.get(2) || this.currentMonthCal.get(1) != this.todayCal.get(1)) {
            this.setCurrentMonth(this.todayCal.getTime());
        }
        this.setFocus(-100);
        if (autoselect) {
            this.select(this.focusIndex, 0);
        }
        this.refreshDisplay();
        this.redrawDec();
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.redrawInc();
        super.setFont(font);
        this.currentMonth.setFont(font);
        int i = 0;
        while (i < this.headers.length) {
            this.headers[i].setFont(font);
            ++i;
        }
        i = 0;
        while (i < this.days.length) {
            this.days[i].label.setFont(font);
            ++i;
        }
        i = 0;
        while (i < this.weeks.length) {
            this.weeks[i].label.setFont(font);
            ++i;
        }
        this.todayLabel.setFont(font);
        this.redrawDec();
    }

    public void setFooterVisible(boolean footerVisible) {
        this.checkWidget();
        if (footerVisible != this.footerVisible) {
            this.footerVisible = footerVisible;
            this.layout(true);
        }
    }

    public void setGridVisible(boolean gridVisible) {
        this.checkWidget();
        if (gridVisible != this.gridVisible) {
            this.gridVisible = gridVisible;
            this.headersPanel.setBackground(gridVisible ? this.theme.gridLinesColor : this.theme.gridHeaderBackground);
            this.daysPanel.setBackground(gridVisible ? this.theme.gridLinesColor : this.theme.dayCellBackground);
            this.weeksPanel.setBackground(gridVisible ? this.theme.gridLinesColor : this.theme.gridHeaderBackground);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setLocale(Locale locale) {
        this.checkWidget();
        if (locale == null) {
            SWT.error((int)4);
        }
        this.locale = locale;
        this.resources = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        this.prevMonth.setToolTipText(this.resources.getString("DateChooser.previousButton"));
        this.nextMonth.setToolTipText(this.resources.getString("DateChooser.nextButton"));
        this.df1 = new SimpleDateFormat("MMMM yyyy", locale);
        this.df2 = DateFormat.getDateInstance(3, locale);
        Calendar c = Calendar.getInstance(TimeZone.getDefault(), locale);
        this.firstDayOfWeek = c.getFirstDayOfWeek();
        this.minimalDaysInFirstWeek = Integer.parseInt(this.resources.getString("minimalDaysInFirstWeek"));
        if (this.currentMonthCal != null) {
            this.currentMonthCal.setFirstDayOfWeek(this.firstDayOfWeek);
            this.currentMonthCal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
        }
        if (this.todayCal != null) {
            this.todayCal.setFirstDayOfWeek(this.firstDayOfWeek);
            this.todayCal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
        }
        String[] months = this.df1.getDateFormatSymbols().getMonths();
        MenuItem[] items = this.monthsMenu.getItems();
        int i = 0;
        while (i < 12) {
            items[i].setText(months[i]);
            ++i;
        }
        this.redrawInc();
        DateFormatSymbols symboles = this.df1.getDateFormatSymbols();
        String[] sn = symboles.getShortWeekdays();
        String[] ln = symboles.getWeekdays();
        int f = this.firstDayOfWeek;
        int i2 = 1;
        while (i2 < this.headers.length) {
            this.headers[i2].setText(sn[f].substring(0, 1).toUpperCase());
            this.headers[i2].setToolTipText(ln[f]);
            f = f % 7 + 1;
            ++i2;
        }
        this.updateTodayLabel();
        this.refreshDisplay();
        this.redrawDec();
    }

    public void setMinimalDaysInFirstWeek(int minimalDaysInFirstWeek) {
        this.minimalDaysInFirstWeek = minimalDaysInFirstWeek;
        this.currentMonthCal.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
        this.todayCal.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
    }

    public void setNavigationEnabled(boolean navigationEnabled) {
        this.checkWidget();
        if (navigationEnabled != this.navigationEnabled) {
            this.navigationEnabled = navigationEnabled;
            this.prevMonth.setVisible(navigationEnabled);
            this.nextMonth.setVisible(navigationEnabled);
            if (navigationEnabled) {
                this.currentMonth.setMenu(this.monthsMenu);
            } else {
                this.currentMonth.setMenu(null);
            }
        }
    }

    public void setSelectedDate(Date date) {
        this.checkWidget();
        if (date == null) {
            SWT.error((int)4);
        }
        Calendar c = (Calendar)this.currentMonthCal.clone();
        c.setTime(date);
        this.trunc(c);
        Date d = c.getTime();
        if (!this.selection.contains(d)) {
            if (!this.multi) {
                this.clearSelection(false);
            }
            this.selection.add(d);
        }
        this.setCurrentMonth(d);
    }

    public void setTheme(DateChooserTheme theme) {
        this.checkWidget();
        if (theme == null) {
            SWT.error((int)4);
        }
        this.theme = theme;
        this.gridVisible = theme.gridVisible;
        this.redrawInc();
        this.monthPanel.setBackground(theme.headerBackground);
        this.currentMonth.setBackground(theme.headerBackground);
        this.currentMonth.setForeground(theme.headerForeground);
        this.gridPanel.setBackground(this.gridVisible ? theme.gridLinesColor : theme.gridHeaderBackground);
        this.todayLabel.setBackground(theme.headerBackground);
        this.todayLabel.setForeground(theme.headerForeground);
        this.headersPanel.setBackground(this.gridVisible ? theme.gridLinesColor : theme.gridHeaderBackground);
        int i = 0;
        while (i < this.headers.length) {
            this.headers[i].setBackground(theme.gridHeaderBackground);
            this.headers[i].setForeground(theme.gridHeaderForeground);
            ++i;
        }
        this.daysPanel.setBackground(this.gridVisible ? theme.gridLinesColor : theme.dayCellBackground);
        i = 0;
        while (i < this.days.length) {
            this.days[i].label.setBackground(theme.dayCellBackground);
            ++i;
        }
        this.weeksPanel.setBackground(this.gridVisible ? theme.gridLinesColor : theme.gridHeaderBackground);
        i = 0;
        while (i < this.weeks.length) {
            this.weeks[i].label.setBackground(theme.gridHeaderBackground);
            this.weeks[i].label.setForeground(theme.gridHeaderForeground);
            ++i;
        }
        this.setFont(theme.font);
        this.refreshDisplay();
        this.redrawDec();
    }

    public void setTodayDate(Date today) {
        this.checkWidget();
        if (today == null) {
            SWT.error((int)4);
        }
        if (this.todayCal == null) {
            this.todayCal = Calendar.getInstance(this.locale);
            this.todayCal.setFirstDayOfWeek(this.firstDayOfWeek);
            this.todayCal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
        }
        this.todayCal.setTime(today);
        this.trunc(this.todayCal);
        this.updateTodayLabel();
        this.refreshDisplay();
    }

    public void setWeeksVisible(boolean weeksVisible) {
        this.checkWidget();
        if (weeksVisible != this.weeksVisible) {
            this.weeksVisible = weeksVisible;
            this.layout(true);
        }
    }

    private void trunc(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private void updateTodayLabel() {
        if (this.todayCal != null) {
            this.todayLabel.setText(String.valueOf(this.resources.getString("DateChooser.today")) + " " + this.df2.format(this.todayCal.getTime()));
        }
    }

    protected class Cell {
        Label label;
        int index;
        Calendar cal;
        boolean weekend;
        int adjacent;
        boolean selected;
        boolean today;

        Cell(Composite parent, int idx) {
            this.label = new Label(parent, 0x1000000);
            this.index = idx;
            this.label.addListener(3, DateChooser.this.listener);
            this.label.setData((Object)this);
        }
    }

    protected class DateChooserLayout
    extends Layout {
        private Point gridPanelSize = new Point(0, 0);
        private Point headersPanelSize = new Point(0, 0);
        private Point weeksPanelSize = new Point(0, 0);
        private Point daysPanelSize = new Point(0, 0);
        private Point todayLabelSize = new Point(0, 0);
        private int cellWidth = 0;
        private int cellHeight = 0;

        protected DateChooserLayout() {
        }

        protected void compute() {
            GC gc = new GC((Drawable)DateChooser.this.days[0].label);
            int headerWidth = 0;
            String[] months = DateChooser.this.df1.getDateFormatSymbols().getMonths();
            int i = 0;
            while (i < months.length) {
                headerWidth = Math.max(headerWidth, gc.textExtent((String)months[i]).x);
                ++i;
            }
            this.cellWidth = gc.textExtent((String)"99").x + DateChooser.this.theme.cellPadding * 2;
            this.cellWidth = Math.max(this.cellWidth, ((headerWidth += DateChooser.this.prevMonth.computeSize((int)-1, (int)-1, (boolean)false).x * 2 + 12 + gc.textExtent((String)" 9999").x) - 8) / 7 + 1);
            this.cellHeight = DateChooser.this.days[0].label.computeSize((int)-1, (int)-1, (boolean)false).y;
            DateChooser.this.weeksPanel.setVisible(DateChooser.this.weeksVisible);
            DateChooser.this.headers[0].setVisible(DateChooser.this.weeksVisible);
            if (DateChooser.this.weeksVisible) {
                this.gridPanelSize.x = (this.cellWidth + 1) * 8 + 1;
                this.weeksPanelSize.x = this.cellWidth + 1;
                this.weeksPanelSize.y = (this.cellHeight + 1) * 6 - 1;
            } else {
                this.gridPanelSize.x = (this.cellWidth + 1) * 7 + 1;
                ++this.headersPanelSize.x;
            }
            this.headersPanelSize.x = this.gridPanelSize.x;
            this.headersPanelSize.y = this.cellHeight + 1;
            this.daysPanelSize.x = this.headersPanelSize.x;
            this.daysPanelSize.y = (this.cellHeight + 1) * 6 - 1;
            this.gridPanelSize.y = this.headersPanelSize.y + this.daysPanelSize.y + 2;
            DateChooser.this.todayLabel.setVisible(DateChooser.this.footerVisible);
            if (DateChooser.this.footerVisible) {
                this.todayLabelSize.x = this.gridPanelSize.x;
                this.todayLabelSize.y = this.headersPanelSize.y + 1;
                this.gridPanelSize.y += this.todayLabelSize.y;
            }
            gc.dispose();
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (flushCache) {
                this.compute();
            }
            return this.gridPanelSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            int i;
            if (flushCache) {
                this.compute();
            }
            DateChooser.this.headersPanel.setBounds(0, 0, this.headersPanelSize.x, this.headersPanelSize.y);
            if (DateChooser.this.weeksVisible) {
                i = 0;
                while (i < 8) {
                    DateChooser.this.headers[i].setBounds((this.cellWidth + 1) * i + 1, 1, this.cellWidth, this.cellHeight);
                    ++i;
                }
                DateChooser.this.weeksPanel.setBounds(0, this.headersPanelSize.y + 1, this.weeksPanelSize.x, this.weeksPanelSize.y);
                i = 0;
                while (i < 6) {
                    DateChooser.this.weeks[i].label.setBounds(1, (this.cellHeight + 1) * i, this.cellWidth, this.cellHeight);
                    ++i;
                }
            } else {
                i = 0;
                while (i < 7) {
                    DateChooser.this.headers[i + 1].setBounds((this.cellWidth + 1) * i + 1, 1, this.cellWidth, this.cellHeight);
                    ++i;
                }
            }
            int x = DateChooser.this.weeksVisible ? 0 : 1;
            int px = DateChooser.this.weeksVisible ? this.weeksPanelSize.x + 1 : 0;
            DateChooser.this.daysPanel.setBounds(px, this.headersPanelSize.y + 1, this.daysPanelSize.x, this.daysPanelSize.y);
            int r = 0;
            while (r < 6) {
                int c = 0;
                while (c < 7) {
                    DateChooser.this.days[r * 7 + c].label.setBounds(x + (this.cellWidth + 1) * c, (this.cellHeight + 1) * r, this.cellWidth, this.cellHeight);
                    ++c;
                }
                ++r;
            }
            DateChooser.this.todayLabel.setBounds(0, this.headersPanelSize.y + this.daysPanelSize.y + 2, this.todayLabelSize.x, this.todayLabelSize.y);
        }
    }
}

