package de.ugoe.cs.swe.memos.database;

import java.sql.*;

import de.ugoe.cs.swe.memos.SettingsManager;

public class Connector {

	public static Connection getConnection() {
		if (SettingsManager.getInstance().getDBType() == SettingsManager.DatabaseType.MySQL) {
			return MySQLConnector.getInstance().getConnection();
		} else if (SettingsManager.getInstance().getDBType() == SettingsManager.DatabaseType.HSQL) {
			return HSQLConnector.getInstance().getConnection();
		}
		return null;
	}

	public static void closeConnection() throws DatabaseException, SQLException {
		if (SettingsManager.getInstance().getDBType() == SettingsManager.DatabaseType.MySQL) {
			MySQLConnector.getInstance().close();
		} else if (SettingsManager.getInstance().getDBType() == SettingsManager.DatabaseType.HSQL) {
			HSQLConnector.getInstance().close();
		}
	}

//	public Connection reconnect() {
//		try {
//			closeConnection();
//			return getConnection();
//		} catch (DatabaseException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (SQLException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		return null;
//	}

}
