/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.partitions.IRegionCompositeWrapper;
import com.onpositive.richtexteditor.model.partitions.IRegionCompositeWrapperListener;
import com.onpositive.richtexteditor.model.partitions.RegionCompositeEvent;
import java.util.ArrayList;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CompositeEditorWrapper
implements IRegionCompositeWrapper {
    ArrayList<IRegionCompositeWrapperListener> listeners = new ArrayList(2);
    protected Composite widget;
    protected StyledText innerStyledText;
    protected int oldLineCount;

    public CompositeEditorWrapper(Composite widget) {
        this.widget = widget;
        this.innerStyledText = widget instanceof StyledText ? (StyledText)widget : this.tryToSearchStyledText(widget);
        if (this.innerStyledText != null) {
            this.oldLineCount = this.innerStyledText.getLineCount();
            this.innerStyledText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (CompositeEditorWrapper.this.innerStyledText.getLineCount() != CompositeEditorWrapper.this.oldLineCount) {
                        CompositeEditorWrapper.this.oldLineCount = CompositeEditorWrapper.this.innerStyledText.getLineCount();
                        CompositeEditorWrapper.this.setSize(CompositeEditorWrapper.this.getWidth(), CompositeEditorWrapper.this.innerStyledText.getLineCount() * CompositeEditorWrapper.this.innerStyledText.getLineHeight());
                        CompositeEditorWrapper.this.notifyListeners(new RegionCompositeEvent(CompositeEditorWrapper.this, 1));
                    }
                }
            });
            Listener caretListener = new Listener(){
                int caretPos = 0;

                public void paintControl(PaintEvent e) {
                }

                public void handleEvent(Event event) {
                    if (CompositeEditorWrapper.this.innerStyledText.getCaretOffset() != this.caretPos) {
                        CompositeEditorWrapper.this.notifyListeners(new RegionCompositeEvent(CompositeEditorWrapper.this, 2, CompositeEditorWrapper.this.innerStyledText.getCaret()));
                        this.caretPos = CompositeEditorWrapper.this.innerStyledText.getCaretOffset();
                    }
                }
            };
            this.innerStyledText.addListener(3, caretListener);
            this.innerStyledText.addListener(1, caretListener);
        }
    }

    @Override
    public void addRegionCompositeWrapperListener(IRegionCompositeWrapperListener listener) {
        this.listeners.add(listener);
    }

    protected void notifyListeners(RegionCompositeEvent event) {
        for (IRegionCompositeWrapperListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    @Override
    public int getHeight() {
        return this.widget.getBounds().height;
    }

    @Override
    public int getInitialHeight() {
        return this.innerStyledText.getLineHeight() * Math.max(1, this.innerStyledText.getLineCount());
    }

    @Override
    public Point getSize() {
        return this.widget.getSize();
    }

    @Override
    public int getWidth() {
        return this.widget.getBounds().width;
    }

    @Override
    public void removeRegionCompositeWrapperListener(IRegionCompositeWrapperListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Point getLocation() {
        return this.widget.getLocation();
    }

    @Override
    public int getX() {
        return this.widget.getBounds().x;
    }

    @Override
    public int getY() {
        return this.widget.getBounds().y;
    }

    @Override
    public Rectangle getBounds() {
        return this.widget.getBounds();
    }

    protected StyledText tryToSearchStyledText(Composite parent) {
        if (parent instanceof StyledText) {
            return (StyledText)parent;
        }
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            StyledText styledText;
            if (children[i] instanceof Composite && (styledText = this.tryToSearchStyledText((Composite)children[i])) != null) {
                return styledText;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Composite getMainObject() {
        return this.innerStyledText;
    }

    @Override
    public void dispose() {
        this.widget.dispose();
    }

    @Override
    public void setLocation(int x, int y) {
        this.widget.setLocation(x, y);
    }

    @Override
    public void setSize(int width, int height) {
        this.widget.setSize(width, height);
    }

    @Override
    public Composite getTopLevelObject() {
        return this.widget;
    }
}

