/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.io.html;

import com.onpositive.richtexteditor.io.html.IHTMLLoader;
import com.onpositive.richtexteditor.io.html_scaner.HTMLLexListener;
import com.onpositive.richtexteditor.io.html_scaner.Scanner;
import com.onpositive.richtexteditor.model.BasePartitionLayer;
import com.onpositive.richtexteditor.model.BulletFactory;
import com.onpositive.richtexteditor.model.ISimpleRichTextModel;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.ImagePartition;
import com.onpositive.richtexteditor.model.partitions.LinkPartition;
import com.onpositive.richtexteditor.model.resources.FontStyleManager;
import com.onpositive.richtexteditor.model.resources.ImageManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.graphics.Image;

public class DefaultHTMLLoader
implements IHTMLLoader {
    private BasePartitionLayer layer;
    private FontStyleManager fontStyleManager;
    private ImageManager imageManager;
    private BasePartition linkPrototypePartition;
    private LayerManager currentManager;

    public DefaultHTMLLoader(LayerManager manager) {
        this.layer = manager.getLayer();
        this.fontStyleManager = manager.getFontStyleManager();
        this.imageManager = manager.getImageManager();
        this.linkPrototypePartition = manager.getLinkPrototype();
    }

    @Override
    public ISimpleRichTextModel parse(String html) {
        Scanner scanner = new Scanner();
        final HTMLLexListener listener = this.createLexingListener(scanner);
        scanner.addLexListener(listener);
        try {
            scanner.process(new StringReader(html), html.length());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        final ArrayList<BasePartition> partitions = listener.getPartitions();
        this.setNewPartitionsFonts(partitions);
        final ArrayList<Integer> lineAligns = listener.getLineAligns();
        final ArrayList<Integer> lineBullets = listener.getLineBullets();
        ISimpleRichTextModel z = new ISimpleRichTextModel(){

            @Override
            public int getAlign(int line) {
                return (Integer)lineAligns.get(line);
            }

            @Override
            public Object getBullet(int line) {
                int bulletNum = (Integer)lineBullets.get(line);
                Bullet bullet = BulletFactory.getBulletForNum(bulletNum);
                return bullet;
            }

            @Override
            public int getLineCount() {
                return lineAligns.size();
            }

            @Override
            public List<BasePartition> getPartitions() {
                return partitions;
            }

            @Override
            public String getText() {
                return listener.getText();
            }
        };
        return z;
    }

    private HTMLLexListener createLexingListener(Scanner scanner) {
        return new HTMLLexListener(this.layer, scanner);
    }

    protected void setNewPartitionsFonts(ArrayList<BasePartition> partitions) {
        for (BasePartition basePartition : partitions) {
            Image image;
            ImagePartition imagePartition;
            if (!basePartition.getFontDataName().equals("")) {
                String innerName = this.fontStyleManager.getNameForStyleString(basePartition.getFontDataName());
                basePartition.setFontDataName(innerName);
            }
            if (basePartition instanceof LinkPartition) {
                basePartition.applyAttributes(this.linkPrototypePartition);
            }
            if (!(basePartition instanceof ImagePartition) || this.imageManager.checkImage((imagePartition = (ImagePartition)basePartition).getImageFileName()) != null || (image = ((ImagePartition)basePartition).getImage()) == null) continue;
            this.imageManager.registerImage(imagePartition.getImageFileName(), image);
        }
    }

    @Override
    public ISimpleRichTextModel parse(Reader reader) throws IOException {
        int read;
        StringBuilder bld = new StringBuilder();
        while ((read = reader.read()) != -1) {
            bld.append((char)read);
        }
        return this.parse(bld.toString());
    }

    @Override
    public ISimpleRichTextModel parse(InputStream stream) throws IOException {
        return this.parse(new InputStreamReader(stream));
    }

    public LayerManager getCurrentManager() {
        return this.currentManager;
    }
}

