/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobType;
import org.hsqldb.types.Type;

public class BinaryType
extends Type {
    static final long maxBinaryPrecision = Integer.MAX_VALUE;

    protected BinaryType(int type, long precision) {
        super(61, type, precision, 0);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode == 60 ? -2 : -3;
    }

    @Override
    public String getJDBCClassName() {
        return "[B";
    }

    @Override
    public String getNameString() {
        return this.typeCode == 60 ? "BINARY" : "VARBINARY";
    }

    public String getNameFullString() {
        return this.typeCode == 60 ? "BINARY" : "BINARY VARYING";
    }

    @Override
    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(this.precision);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean requiresPrecision() {
        return this.typeCode == 61;
    }

    @Override
    public int precedenceDegree(Type other) {
        if (other.typeCode == this.typeCode) {
            return 0;
        }
        if (!other.isBinaryType()) {
            return Integer.MIN_VALUE;
        }
        switch (this.typeCode) {
            case 14: 
            case 15: {
                return Integer.MIN_VALUE;
            }
            case 60: {
                return other.typeCode == 30 ? 4 : 2;
            }
            case 61: {
                return other.typeCode == 30 ? 4 : 2;
            }
            case 30: {
                return other.typeCode == 60 ? -4 : -2;
            }
        }
        throw Error.runtimeError(401, "BinaryType");
    }

    @Override
    public Type getAggregateType(Type other) {
        if (this.typeCode == other.typeCode) {
            return this.precision >= other.precision ? this : other;
        }
        if (other.isCharacterType()) {
            return other.getAggregateType(this);
        }
        switch (other.typeCode) {
            case 0: {
                return this;
            }
            case 14: 
            case 15: {
                long bytePrecision = (other.precision + 7L) / 8L;
                return this.precision >= bytePrecision ? this : BinaryType.getBinaryType(this.typeCode, bytePrecision);
            }
            case 60: {
                return this.precision >= other.precision ? this : BinaryType.getBinaryType(this.typeCode, other.precision);
            }
            case 61: {
                if (this.typeCode == 30) {
                    return this.precision >= other.precision ? this : BinaryType.getBinaryType(this.typeCode, other.precision);
                }
                return other.precision >= this.precision ? other : BinaryType.getBinaryType(other.typeCode, this.precision);
            }
            case 30: {
                return other.precision >= this.precision ? other : BinaryType.getBinaryType(other.typeCode, this.precision);
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Type other, int operation) {
        Type newType;
        if (operation != 36) {
            return this.getAggregateType(other);
        }
        long newPrecision = this.precision + other.precision;
        switch (other.typeCode) {
            case 0: {
                return this;
            }
            case 14: 
            case 15: {
                newPrecision = this.precision + (other.precision + 7L) / 8L;
                newType = this;
                break;
            }
            case 60: {
                newType = this;
                break;
            }
            case 61: {
                newType = this.typeCode == 30 ? this : other;
                break;
            }
            case 30: {
                newType = other;
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        if (newPrecision > Integer.MAX_VALUE) {
            if (this.typeCode == 60) {
                throw Error.error(5570);
            }
            if (this.typeCode == 61) {
                newPrecision = Integer.MAX_VALUE;
            }
        }
        return BinaryType.getBinaryType(newType.typeCode, newPrecision);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof BinaryData && b instanceof BinaryData) {
            byte[] data2;
            byte[] data1 = ((BinaryData)a).getBytes();
            int length = data1.length > (data2 = ((BinaryData)b).getBytes()).length ? data2.length : data1.length;
            for (int i = 0; i < length; ++i) {
                if (data1[i] == data2[i]) continue;
                return (data1[i] & 0xFF) > (data2[i] & 0xFF) ? 1 : -1;
            }
            if (data1.length == data2.length) {
                return 0;
            }
            return data1.length > data2.length ? 1 : -1;
        }
        throw Error.runtimeError(401, "BinaryType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return this.castOrConvertToType(session, a, this, false);
    }

    @Override
    public Object castToType(SessionInterface session, Object a, Type otherType) {
        return this.castOrConvertToType(session, a, otherType, true);
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        return this.castOrConvertToType(session, a, otherType, false);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a instanceof byte[]) {
            return new BinaryData((byte[])a, true);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        return ((BlobData)a).getBytes();
    }

    Object castOrConvertToType(SessionInterface session, Object a, Type otherType, boolean cast) {
        BlobData b;
        if (a == null) {
            return null;
        }
        switch (otherType.typeCode) {
            case 1: 
            case 12: {
                b = session.getScanner().convertToBinary((String)a);
                otherType = BinaryType.getBinaryType(61, b.length(session));
                break;
            }
            case 14: {
                b = (BlobData)a;
                otherType = BinaryType.getBinaryType(61, b.length(session));
                break;
            }
            case 30: 
            case 60: 
            case 61: {
                b = (BlobData)a;
                break;
            }
            default: {
                throw Error.error(3471);
            }
        }
        if (this.precision == 0L) {
            return b;
        }
        if (b.length(session) > this.precision && b.nonZeroLength(session) > this.precision) {
            if (!cast) {
                throw Error.error(3401);
            }
            session.addWarning(Error.error(1004));
        }
        if (otherType.typeCode == 30) {
            byte[] bytes = b.getBytes(session, 0L, (int)this.precision);
            b = new BinaryData(bytes, false);
        }
        switch (this.typeCode) {
            case 60: {
                byte[] data;
                if (b.length(session) > this.precision) {
                    data = b.getBytes(session, 0L, (int)this.precision);
                    b = new BinaryData(data, false);
                } else if (b.length(session) < this.precision) {
                    data = (byte[])ArrayUtil.resizeArray(b.getBytes(), (int)this.precision);
                    b = new BinaryData(data, false);
                }
                return b;
            }
            case 61: {
                byte[] data;
                if (b.length(session) > this.precision) {
                    data = b.getBytes(session, 0L, (int)this.precision);
                    b = new BinaryData(data, false);
                }
                return b;
            }
        }
        throw Error.error(3471);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (a instanceof byte[]) {
            return new BinaryData((byte[])a, false);
        }
        if (a instanceof BinaryData) {
            return a;
        }
        if (a instanceof String) {
            return this.castOrConvertToType(session, a, Type.SQL_VARCHAR, false);
        }
        throw Error.error(3471);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return StringConverter.byteArrayToHexString(((BlobData)a).getBytes());
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return StringConverter.byteArrayToSQLHexString(((BinaryData)a).getBytes());
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return otherType.typeCode == 0 || otherType.isBinaryType() || otherType.isCharacterType();
    }

    public long position(SessionInterface session, BlobData data, BlobData otherData, Type otherType, long offset) {
        if (data == null || otherData == null) {
            return -1L;
        }
        long otherLength = data.length(session);
        if (offset + otherLength > data.length(session)) {
            return -1L;
        }
        return data.position(session, otherData, offset);
    }

    public BlobData substring(SessionInterface session, BlobData data, long offset, long length, boolean hasLength) {
        long end;
        long dataLength = data.length(session);
        if (hasLength) {
            end = offset + length;
        } else {
            long l = end = dataLength > offset ? dataLength : offset;
        }
        if (offset > end) {
            throw Error.error(3431);
        }
        if (offset > end || end < 0L) {
            offset = 0L;
            end = 0L;
        }
        if (offset < 0L) {
            offset = 0L;
        }
        if (end > dataLength) {
            end = dataLength;
        }
        length = end - offset;
        byte[] bytes = data.getBytes(session, offset, (int)length);
        return new BinaryData(bytes, false);
    }

    int getRightTrimSize(BlobData data) {
        byte[] bytes = data.getBytes();
        int endindex = bytes.length;
        --endindex;
        while (endindex >= 0 && bytes[endindex] == 0) {
            --endindex;
        }
        return ++endindex;
    }

    public BlobData trim(Session session, BlobData data, int trim, boolean leading, boolean trailing) {
        int startindex;
        if (data == null) {
            return null;
        }
        byte[] bytes = data.getBytes();
        int endindex = bytes.length;
        if (trailing) {
            --endindex;
            while (endindex >= 0 && bytes[endindex] == trim) {
                --endindex;
            }
            ++endindex;
        }
        if (leading) {
            for (startindex = 0; startindex < endindex && bytes[startindex] == trim; ++startindex) {
            }
        }
        byte[] newBytes = bytes;
        if (startindex != 0 || endindex != bytes.length) {
            newBytes = new byte[endindex - startindex];
            System.arraycopy(bytes, startindex, newBytes, 0, endindex - startindex);
        }
        if (this.typeCode == 30) {
            BlobDataID blob = session.createBlob(newBytes.length);
            blob.setBytes(session, 0L, newBytes);
            return blob;
        }
        return new BinaryData(newBytes, newBytes == bytes);
    }

    public BlobData overlay(Session session, BlobData data, BlobData overlay, long offset, long length, boolean hasLength) {
        if (data == null || overlay == null) {
            return null;
        }
        if (!hasLength) {
            length = overlay.length(session);
        }
        switch (this.typeCode) {
            case 60: 
            case 61: {
                BinaryData binary = new BinaryData(session, this.substring(session, data, 0L, offset, true), overlay);
                binary = new BinaryData(session, binary, this.substring(session, data, offset + length, 0L, false));
                return binary;
            }
            case 30: {
                byte[] bytes = this.substring(session, data, 0L, offset, false).getBytes();
                long blobLength = data.length(session) + overlay.length(session) - length;
                BlobDataID blob = session.createBlob(blobLength);
                blob.setBytes(session, 0L, bytes);
                blob.setBytes(session, blob.length(session), overlay.getBytes());
                bytes = this.substring(session, data, offset + length, 0L, false).getBytes();
                blob.setBytes(session, blob.length(session), bytes);
                return blob;
            }
        }
        throw Error.runtimeError(401, "BinaryType");
    }

    @Override
    public Object concat(Session session, Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        long length = ((BlobData)a).length(session) + ((BlobData)b).length(session);
        if (length > this.precision) {
            throw Error.error(3401);
        }
        if (this.typeCode == 30) {
            BlobDataID blob = session.createBlob(length);
            blob.setBytes(session, 0L, ((BlobData)b).getBytes());
            blob.setBytes(session, ((BlobData)a).length(session), ((BlobData)b).getBytes());
            return blob;
        }
        return new BinaryData(session, (BlobData)a, (BlobData)b);
    }

    public static BinaryType getBinaryType(int type, long precision) {
        switch (type) {
            case 60: 
            case 61: {
                return new BinaryType(type, precision);
            }
            case 30: {
                return new BlobType(precision);
            }
        }
        throw Error.runtimeError(401, "BinaryType");
    }
}

