/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.Crypto;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderText;

public class ScriptReaderDecode
extends ScriptReaderText {
    DataInputStream dataInput;
    Crypto crypto;
    byte[] buffer = new byte[256];

    public ScriptReaderDecode(Database db, String fileName, Crypto crypto) throws IOException {
        super(db);
        InputStream d = this.database.logger.getFileAccess().openInputStreamElement(fileName);
        InputStream stream = crypto.getInputStream(d);
        stream = new GZIPInputStream(stream);
        this.dataStreamIn = new BufferedReader(new InputStreamReader(stream));
        this.rowIn = new RowInputTextLog();
    }

    public ScriptReaderDecode(Database db, String fileName, Crypto crypto, boolean forLog) throws IOException {
        super(db);
        this.crypto = crypto;
        InputStream d = this.database.logger.getFileAccess().openInputStreamElement(fileName);
        this.dataInput = new DataInputStream(new BufferedInputStream(d));
        this.rowIn = new RowInputTextLog();
    }

    @Override
    public boolean readLoggedStatement(Session session) throws IOException {
        int count;
        if (this.dataInput == null) {
            return super.readLoggedStatement(session);
        }
        try {
            count = this.dataInput.readInt();
            if (count * 2 > this.buffer.length) {
                this.buffer = new byte[count * 2];
            }
            this.dataInput.readFully(this.buffer, 0, count);
        }
        catch (Throwable t) {
            return false;
        }
        count = this.crypto.decode(this.buffer, 0, count, this.buffer, 0);
        String s = new String(this.buffer, 0, count, "ISO-8859-1");
        ++this.lineCount;
        this.statement = StringConverter.unicodeStringToString(s);
        if (this.statement == null) {
            return false;
        }
        this.processStatement(session);
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.dataStreamIn != null) {
                this.dataStreamIn.close();
            }
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

