/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.result;

import java.io.IOException;
import org.hsqldb.ColumnBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Type;

public final class ResultMetaData {
    public static final int RESULT_METADATA = 1;
    public static final int SIMPLE_RESULT_METADATA = 2;
    public static final int UPDATE_RESULT_METADATA = 3;
    public static final int PARAM_METADATA = 4;
    public static final int GENERATED_INDEX_METADATA = 5;
    public static final int GENERATED_NAME_METADATA = 6;
    private int type;
    public String[] columnLabels;
    public Type[] columnTypes;
    private int columnCount;
    private int extendedColumnCount;
    public static final ResultMetaData emptyResultMetaData = ResultMetaData.newResultMetaData(0);
    public static final ResultMetaData emptyParamMetaData = ResultMetaData.newParameterMetaData(0);
    public int[] colIndexes;
    public ColumnBase[] columns;
    public byte[] paramModes;
    public byte[] paramNullable;

    private ResultMetaData(int type) {
        this.type = type;
    }

    public static ResultMetaData newUpdateResultMetaData(Type[] types) {
        ResultMetaData md = new ResultMetaData(3);
        md.columnTypes = new Type[types.length];
        md.columnCount = types.length;
        md.extendedColumnCount = types.length;
        ArrayUtil.copyArray(types, md.columnTypes, types.length);
        return md;
    }

    public static ResultMetaData newSimpleResultMetaData(Type[] types) {
        ResultMetaData md = new ResultMetaData(2);
        md.columnTypes = types;
        md.columnCount = types.length;
        md.extendedColumnCount = types.length;
        return md;
    }

    public static ResultMetaData newResultMetaData(int colCount) {
        Type[] types = new Type[colCount];
        return ResultMetaData.newResultMetaData(types, null, colCount, colCount);
    }

    public static ResultMetaData newResultMetaData(Type[] types, int[] baseColumnIndexes, int colCount, int extColCount) {
        ResultMetaData md = new ResultMetaData(1);
        md.columnLabels = new String[colCount];
        md.columns = new ColumnBase[colCount];
        md.columnTypes = types;
        md.colIndexes = baseColumnIndexes;
        md.columnCount = colCount;
        md.extendedColumnCount = extColCount;
        return md;
    }

    public static ResultMetaData newParameterMetaData(int colCount) {
        ResultMetaData md = new ResultMetaData(4);
        md.columnTypes = new Type[colCount];
        md.columnLabels = new String[colCount];
        md.paramModes = new byte[colCount];
        md.paramNullable = new byte[colCount];
        md.columnCount = colCount;
        md.extendedColumnCount = colCount;
        return md;
    }

    public static ResultMetaData newGeneratedColumnsMetaData(int[] columnIndexes, String[] columnNames) {
        if (columnIndexes != null) {
            ResultMetaData md = new ResultMetaData(5);
            md.columnCount = columnIndexes.length;
            md.extendedColumnCount = columnIndexes.length;
            md.colIndexes = new int[columnIndexes.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                md.colIndexes[i] = columnIndexes[i] - 1;
            }
            return md;
        }
        if (columnNames != null) {
            ResultMetaData md = new ResultMetaData(6);
            md.columnLabels = new String[columnNames.length];
            md.columnCount = columnNames.length;
            md.extendedColumnCount = columnNames.length;
            md.columnLabels = columnNames;
            return md;
        }
        return null;
    }

    public void prepareData() {
        if (this.columns != null) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columnTypes[i] != null) continue;
                this.columnTypes[i] = this.columns[i].getDataType();
            }
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getExtendedColumnCount() {
        return this.extendedColumnCount;
    }

    public void resetExtendedColumnCount() {
        this.extendedColumnCount = this.columnCount;
    }

    public Type[] getParameterTypes() {
        return this.columnTypes;
    }

    public String[] getGeneratedColumnNames() {
        return this.columnLabels;
    }

    public int[] getGeneratedColumnIndexes() {
        return this.colIndexes;
    }

    public boolean isTableColumn(int i) {
        String colName = this.columns[i].getNameString();
        String tableName = this.columns[i].getTableNameString();
        return tableName != null && tableName.length() > 0 && colName != null && colName.length() > 0;
    }

    private static void decodeTableColumnAttrs(int in, ColumnBase column) {
        column.setNullability((byte)(in & 3));
        column.setIdentity((in & 4) != 0);
        column.setWriteable((in & 8) != 0);
    }

    private static int encodeTableColumnAttrs(ColumnBase column) {
        int out = column.getNullability();
        if (column.isIdentity()) {
            out |= 4;
        }
        if (column.isWriteable()) {
            out |= 8;
        }
        return out;
    }

    private void decodeParamColumnAttrs(int in, int columnIndex) {
        this.paramNullable[columnIndex] = (byte)(in & 3);
        this.paramModes[columnIndex] = (byte)(in >> 4 & 0xF);
    }

    private int encodeParamColumnAttrs(int columnIndex) {
        int out = this.paramModes[columnIndex] << 4;
        return out |= this.paramNullable[columnIndex];
    }

    ResultMetaData(RowInputBinary in) throws IOException {
        this.type = in.readInt();
        this.columnCount = in.readInt();
        switch (this.type) {
            case 2: 
            case 3: {
                this.columnTypes = new Type[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    int type = in.readType();
                    this.columnTypes[i] = Type.getDefaultType(type);
                }
                return;
            }
            case 5: {
                this.colIndexes = new int[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.colIndexes[i] = in.readInt();
                }
                return;
            }
            case 6: {
                this.columnLabels = new String[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.columnLabels[i] = in.readString();
                }
                return;
            }
            case 4: {
                this.columnTypes = new Type[this.columnCount];
                this.columnLabels = new String[this.columnCount];
                this.paramModes = new byte[this.columnCount];
                this.paramNullable = new byte[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.columnTypes[i] = this.readDataType(in);
                    this.columnLabels[i] = in.readString();
                    this.decodeParamColumnAttrs(in.readByte(), i);
                }
                return;
            }
            case 1: {
                int i;
                this.extendedColumnCount = in.readInt();
                this.columnTypes = new Type[this.extendedColumnCount];
                this.columnLabels = new String[this.columnCount];
                this.columns = new ColumnBase[this.columnCount];
                if (this.columnCount != this.extendedColumnCount) {
                    this.colIndexes = new int[this.columnCount];
                }
                for (i = 0; i < this.extendedColumnCount; ++i) {
                    Type type;
                    this.columnTypes[i] = type = this.readDataType(in);
                }
                for (i = 0; i < this.columnCount; ++i) {
                    this.columnLabels[i] = in.readString();
                    String catalog = in.readString();
                    String schema = in.readString();
                    String table = in.readString();
                    String name = in.readString();
                    ColumnBase column = new ColumnBase(catalog, schema, table, name);
                    column.setType(this.columnTypes[i]);
                    ResultMetaData.decodeTableColumnAttrs(in.readByte(), column);
                    this.columns[i] = column;
                }
                if (this.columnCount != this.extendedColumnCount) {
                    for (i = 0; i < this.columnCount; ++i) {
                        this.colIndexes[i] = in.readInt();
                    }
                }
                return;
            }
        }
        throw Error.runtimeError(401, "ResultMetaData");
    }

    Type readDataType(RowInputBinary in) throws IOException {
        int typeCode = in.readType();
        long size = in.readLong();
        int scale = in.readInt();
        return Type.getType(typeCode, 0, size, scale);
    }

    void writeDataType(RowOutputInterface out, Type type) {
        out.writeType(type.typeCode);
        out.writeLong(type.precision);
        out.writeInt(type.scale);
    }

    void write(RowOutputInterface out) throws IOException {
        out.writeInt(this.type);
        out.writeInt(this.columnCount);
        switch (this.type) {
            case 2: 
            case 3: {
                for (int i = 0; i < this.columnCount; ++i) {
                    out.writeType(this.columnTypes[i].typeCode);
                }
                return;
            }
            case 5: {
                for (int i = 0; i < this.columnCount; ++i) {
                    out.writeInt(this.colIndexes[i]);
                }
                return;
            }
            case 6: {
                for (int i = 0; i < this.columnCount; ++i) {
                    out.writeString(this.columnLabels[i]);
                }
                return;
            }
            case 4: {
                for (int i = 0; i < this.columnCount; ++i) {
                    this.writeDataType(out, this.columnTypes[i]);
                    out.writeString(this.columnLabels[i]);
                    out.writeByte(this.encodeParamColumnAttrs(i));
                }
                return;
            }
            case 1: {
                ColumnBase column;
                int i;
                out.writeInt(this.extendedColumnCount);
                for (i = 0; i < this.extendedColumnCount; ++i) {
                    if (this.columnTypes[i] == null) {
                        column = this.columns[i];
                        this.columnTypes[i] = column.getDataType();
                    }
                    this.writeDataType(out, this.columnTypes[i]);
                }
                for (i = 0; i < this.columnCount; ++i) {
                    column = this.columns[i];
                    out.writeString(this.columnLabels[i]);
                    out.writeString(column.getCatalogNameString());
                    out.writeString(column.getSchemaNameString());
                    out.writeString(column.getTableNameString());
                    out.writeString(column.getNameString());
                    out.writeByte(ResultMetaData.encodeTableColumnAttrs(column));
                }
                if (this.columnCount != this.extendedColumnCount) {
                    for (i = 0; i < this.colIndexes.length; ++i) {
                        out.writeInt(this.colIndexes[i]);
                    }
                }
                return;
            }
        }
        throw Error.runtimeError(401, "ResultMetaData");
    }

    public ResultMetaData getNewMetaData(int[] columnMap) {
        ResultMetaData newMeta = ResultMetaData.newResultMetaData(columnMap.length);
        ArrayUtil.projectRow(this.columnLabels, columnMap, newMeta.columnLabels);
        ArrayUtil.projectRow(this.columnTypes, columnMap, newMeta.columnTypes);
        ArrayUtil.projectRow(this.columns, columnMap, newMeta.columns);
        return newMeta;
    }
}

