/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.RowAVLDiskData;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLDiskData
extends RowStoreAVLDisk {
    public RowStoreAVLDiskData(PersistentStoreCollection manager, Table table) {
        super(manager, null, table);
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public void add(CachedObject object) {
        int size = object.getRealSize(this.cache.rowOut);
        object.setStorageSize(size);
        this.cache.add(object);
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        try {
            return new RowAVLDiskData((TableBase)this.table, in);
        }
        catch (IOException e) {
            throw Error.error(77, e);
        }
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object) {
        RowAVLDiskData row = new RowAVLDiskData((TableBase)this.table, (Object[])object);
        this.add(row);
        if (session != null) {
            RowAction.addAction(session, (byte)1, this.table, row);
        }
        return row;
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void remove(int i) {
        if (this.cache != null) {
            this.cache.remove(i, this);
        }
    }

    @Override
    public void removePersistence(int i) {
        if (this.cache != null) {
            this.cache.removePersistence(i);
        }
    }

    @Override
    public void release(int i) {
        if (this.cache != null) {
            this.cache.release(i);
        }
    }

    @Override
    public void commitPersistence(CachedObject row) {
        try {
            if (this.cache != null) {
                this.cache.saveRow(row);
            }
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.table.database.logger.closeTextCache(this.table);
        this.cache = null;
    }
}

