/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Enumeration;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public class HsqlDatabaseProperties
extends HsqlProperties {
    private static final String hsqldb_method_class_names = "hsqldb.method_class_names";
    private static HashSet accessibleJavaMethodNames;
    public static final int SYSTEM_PROPERTY = 0;
    public static final int FILE_PROPERTY = 1;
    public static final int SQL_PROPERTY = 2;
    public static final int FILES_NOT_MODIFIED = 0;
    public static final int FILES_MODIFIED = 1;
    public static final int FILES_NEW = 2;
    private static final String MODIFIED_NO = "no";
    private static final String MODIFIED_YES = "yes";
    private static final String MODIFIED_NEW = "no-new-files";
    private static final HashMap dbMeta;
    private static final HashMap textMeta;
    public static final String VERSION_STRING_1_8_0 = "1.8.0";
    public static final String VERSION_STRING_1_9_0 = "1.9.0";
    public static final String THIS_VERSION = "1.9.0";
    public static final String THIS_FULL_VERSION = "1.9.0.0";
    public static final String THIS_CACHE_VERSION = "1.9.0";
    public static final String PRODUCT_NAME = "HSQL Database Engine";
    public static final int MAJOR = 1;
    public static final int MINOR = 9;
    public static final int REVISION = 0;
    public static final String system_lockfile_poll_retries_property = "hsqldb.lockfile_poll_retries";
    public static final String system_max_char_or_varchar_display_size = "hsqldb.max_char_or_varchar_display_size";
    public static final String hsqldb_inc_backup = "hsqldb.incremental_backup";
    public static final String hsqldb_version = "version";
    public static final String hsqldb_readonly = "readonly";
    private static final String hsqldb_modified = "modified";
    public static final String runtime_gc_interval = "runtime.gc_interval";
    public static final String url_ifexists = "ifexists";
    public static final String url_default_schema = "default_schema";
    public static final String hsqldb_tx = "hsqldb.tx";
    public static final String hsqldb_applog = "hsqldb.applog";
    public static final String hsqldb_cache_file_scale = "hsqldb.cache_file_scale";
    public static final String hsqldb_cache_free_count_scale = "hsqldb.cache_free_count_scale";
    public static final String hsqldb_cache_rows = "hsqldb.cache_rows";
    public static final String hsqldb_cache_size = "hsqldb.cache_size";
    public static final String hsqldb_default_table_type = "hsqldb.default_table_type";
    public static final String hsqldb_defrag_limit = "hsqldb.defrag_limit";
    public static final String hsqldb_files_readonly = "files_readonly";
    public static final String hsqldb_lock_file = "hsqldb.lock_file";
    public static final String hsqldb_log_size = "hsqldb.log_size";
    public static final String hsqldb_nio_data_file = "hsqldb.nio_data_file";
    public static final String hsqldb_max_nio_scale = "hsqldb.max_nio_scale";
    public static final String hsqldb_script_format = "hsqldb.script_format";
    public static final String hsqldb_temp_directory = "hsqldb.temp_directory";
    public static final String hsqldb_result_max_memory_rows = "hsqldb.result_max_memory_rows";
    public static final String hsqldb_write_delay = "hsqldb.write_delay";
    public static final String sql_compare_in_locale = "sql.compare_in_locale";
    public static final String sql_enforce_size = "sql.enforce_size";
    public static final String sql_enforce_strict_size = "sql.enforce_strict_size";
    public static final String sql_enforce_names = "sql.enforce_names";
    public static final String textdb_cache_scale = "textdb.cache_scale";
    public static final String textdb_cache_size_scale = "textdb.cache_size_scale";
    public static final String textdb_all_quoted = "textdb.all_quoted";
    public static final String textdb_allow_full_path = "textdb.allow_full_path";
    public static final String textdb_encoding = "textdb.encoding";
    public static final String textdb_ignore_first = "textdb.ignore_first";
    public static final String textdb_quoted = "textdb.quoted";
    public static final String textdb_fs = "textdb.fs";
    public static final String textdb_vs = "textdb.vs";
    public static final String textdb_lvs = "textdb.lvs";
    public static final String url_storage_class_name = "storage_class_name";
    public static final String url_fileaccess_class_name = "fileaccess_class_name";
    public static final String url_storage_key = "storage_key";
    public static final String url_shutdown = "shutdown";
    public static final String url_crypt_key = "crypt_key";
    public static final String url_crypt_type = "crypt_type";
    public static final String url_crypt_provider = "crypt_provider";
    private Database database;
    public static final int NO_MESSAGE = 1;

    public static boolean supportsJavaMethod(String name) {
        if (accessibleJavaMethodNames == null) {
            return true;
        }
        if (name.startsWith("org.hsqldb.Library.")) {
            return true;
        }
        if (name.startsWith("java.lang.Math.")) {
            return true;
        }
        if (accessibleJavaMethodNames.contains(name)) {
            return true;
        }
        Iterator it = accessibleJavaMethodNames.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            int limit = className.lastIndexOf(".*");
            if (limit < 1 || !name.startsWith(className.substring(0, limit + 1))) continue;
            return true;
        }
        return false;
    }

    public HsqlDatabaseProperties(Database db) {
        super(dbMeta, db.getPath(), db.logger.getFileAccess(), db.isFilesInJar());
        this.database = db;
        this.setNewDatabaseProperties();
    }

    void setNewDatabaseProperties() {
        this.setProperty(hsqldb_version, "1.9.0");
        this.setProperty(hsqldb_modified, MODIFIED_NEW);
        if (this.database.logger.isStoredFileAccess()) {
            this.setProperty(hsqldb_cache_rows, 25000);
            this.setProperty(hsqldb_cache_size, 6000);
            this.setProperty(hsqldb_log_size, 10);
            this.setProperty(sql_enforce_size, true);
            this.setProperty(hsqldb_nio_data_file, false);
        }
    }

    @Override
    public boolean load() {
        boolean exists;
        if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType())) {
            return true;
        }
        try {
            exists = super.load();
        }
        catch (Throwable t) {
            throw Error.error(t, 29, 116, new Object[]{t.getMessage(), this.fileName});
        }
        if (!exists) {
            return false;
        }
        this.filterLoadedProperties();
        String version = this.getStringProperty(hsqldb_version);
        int check = version.substring(0, 5).compareTo(VERSION_STRING_1_8_0);
        if (check < 0) {
            throw Error.error(30);
        }
        check = version.substring(0, 5).compareTo("1.9.0");
        if (check > 0) {
            throw Error.error(30);
        }
        if (check < 0 && !MODIFIED_NO.equals(this.getStringProperty(hsqldb_modified))) {
            throw Error.error(27);
        }
        if (this.getIntegerProperty(hsqldb_script_format) != 0) {
            throw Error.error(30);
        }
        return true;
    }

    @Override
    public void save() {
        if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType()) || this.database.isFilesReadOnly() || this.database.isFilesInJar()) {
            return;
        }
        try {
            HsqlProperties props = new HsqlProperties(dbMeta, this.database.getPath(), this.database.logger.getFileAccess(), false);
            props.setProperty(hsqldb_version, "1.9.0");
            props.setProperty(hsqldb_modified, this.getProperty(hsqldb_modified));
            props.save(this.fileName + ".properties" + ".new");
            this.fa.renameElement(this.fileName + ".properties" + ".new", this.fileName + ".properties");
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("save failed", t);
            throw Error.error(t, 29, 116, new Object[]{t.getMessage(), this.fileName});
        }
    }

    void filterLoadedProperties() {
        Enumeration<?> en = this.stringProps.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            boolean accept = dbMeta.containsKey(key);
            if (accept) continue;
            this.stringProps.remove(key);
        }
    }

    public void setURLProperties(HsqlProperties p) {
        if (p == null) {
            return;
        }
        Enumeration e = p.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            Object[] row = (Object[])dbMeta.get(propertyName);
            if (row == null || (Integer)row[1] != 2) continue;
            this.setDatabaseProperty(propertyName, p.getProperty(propertyName));
        }
    }

    public Set getUserDefinedPropertyData() {
        HashSet set = new HashSet();
        Iterator it = dbMeta.values().iterator();
        while (it.hasNext()) {
            Object[] row = (Object[])it.next();
            if ((Integer)row[1] != 2) continue;
            set.add(row);
        }
        return set;
    }

    public boolean isUserDefinedProperty(String key) {
        Object[] row = (Object[])dbMeta.get(key);
        return row != null && (Integer)row[1] == 2;
    }

    public boolean isBoolean(String key) {
        Object[] row = (Object[])dbMeta.get(key);
        return row != null && row[2].equals("Boolean") && (Integer)row[1] == 2;
    }

    public boolean isIntegral(String key) {
        Object[] row = (Object[])dbMeta.get(key);
        return row != null && row[2].equals("Integer") && (Integer)row[1] == 2;
    }

    public boolean isString(String key) {
        Object[] row = (Object[])dbMeta.get(key);
        return row != null && row[2].equals("String") && (Integer)row[1] == 2;
    }

    public boolean setDatabaseProperty(String key, String value) {
        Object[] meta = (Object[])dbMeta.get(key);
        String error = HsqlProperties.validateProperty(key, value, meta);
        if (error != null) {
            return false;
        }
        this.stringProps.put(key, value);
        return true;
    }

    public int getDefaultWriteDelay() {
        if (this.database.logger.isStoredFileAccess()) {
            return 2000;
        }
        return 10000;
    }

    public int getErrorLevel() {
        return 1;
    }

    public boolean divisionByZero() {
        return false;
    }

    public void setDBModified(int mode) {
        String value = MODIFIED_NO;
        if (mode == 1) {
            value = MODIFIED_YES;
        } else if (mode == 2) {
            value = MODIFIED_NEW;
        }
        this.stringProps.put(hsqldb_modified, value);
        this.save();
    }

    public int getDBModified() {
        String value = this.getStringProperty(hsqldb_modified);
        if (MODIFIED_YES.equals(value)) {
            return 1;
        }
        if (MODIFIED_NEW.equals(value)) {
            return 2;
        }
        return 0;
    }

    @Override
    public String getProperty(String key) {
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5511);
        }
        return this.stringProps.getProperty(key);
    }

    @Override
    public boolean isPropertyTrue(String key) {
        boolean isSystem;
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5511);
        }
        Boolean value = (Boolean)metaData[4];
        String prop = this.stringProps.getProperty(key);
        boolean bl = isSystem = (Integer)metaData[1] == 0;
        if (prop == null && isSystem) {
            prop = System.getProperty(key);
        }
        if (prop != null) {
            value = Boolean.valueOf(prop);
        }
        return value;
    }

    public String getStringProperty(String key) {
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5511);
        }
        String value = (String)metaData[4];
        String prop = this.stringProps.getProperty(key);
        if (prop != null) {
            value = prop;
        }
        return value;
    }

    public int getIntegerProperty(String key) {
        Object[] metaData = (Object[])dbMeta.get(key);
        if (metaData == null) {
            throw Error.error(5511);
        }
        int value = (Integer)metaData[4];
        String prop = this.stringProps.getProperty(key);
        if (prop != null) {
            try {
                value = Integer.parseInt(prop);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return value;
    }

    public static Iterator getPropertiesMetaIterator() {
        return dbMeta.values().iterator();
    }

    static {
        try {
            String prop = System.getProperty(hsqldb_method_class_names);
            if (prop != null) {
                accessibleJavaMethodNames = new HashSet();
                String[] names = StringUtil.split(prop, ";");
                for (int i = 0; i < names.length; ++i) {
                    accessibleJavaMethodNames.add(names[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        dbMeta = new HashMap(67);
        textMeta = new HashMap(17);
        textMeta.put(textdb_allow_full_path, HsqlProperties.getMeta(textdb_allow_full_path, 0, false));
        textMeta.put(textdb_quoted, HsqlProperties.getMeta(textdb_quoted, 2, false));
        textMeta.put(textdb_all_quoted, HsqlProperties.getMeta(textdb_all_quoted, 2, false));
        textMeta.put(textdb_ignore_first, HsqlProperties.getMeta(textdb_ignore_first, 2, false));
        textMeta.put(textdb_fs, HsqlProperties.getMeta(textdb_fs, 2, ","));
        textMeta.put(textdb_vs, HsqlProperties.getMeta(textdb_vs, 2, null));
        textMeta.put(textdb_lvs, HsqlProperties.getMeta(textdb_lvs, 2, null));
        textMeta.put(textdb_encoding, HsqlProperties.getMeta(textdb_encoding, 2, "ISO-8859-1"));
        textMeta.put(textdb_cache_scale, HsqlProperties.getMeta(textdb_cache_scale, 2, 10, 8, 16));
        textMeta.put(textdb_cache_size_scale, HsqlProperties.getMeta(textdb_cache_size_scale, 2, 10, 6, 20));
        dbMeta.putAll(textMeta);
        dbMeta.put(hsqldb_version, HsqlProperties.getMeta(hsqldb_version, 1, null));
        dbMeta.put(hsqldb_modified, HsqlProperties.getMeta(hsqldb_modified, 1, null));
        dbMeta.put(hsqldb_readonly, HsqlProperties.getMeta(hsqldb_readonly, 1, false));
        dbMeta.put(hsqldb_files_readonly, HsqlProperties.getMeta(hsqldb_files_readonly, 1, false));
        dbMeta.put(hsqldb_cache_file_scale, HsqlProperties.getMeta(hsqldb_cache_file_scale, 1, 8, new int[]{1, 8}));
        dbMeta.put(hsqldb_tx, HsqlProperties.getMeta(hsqldb_tx, 2, "LOCKS"));
        dbMeta.put(hsqldb_temp_directory, HsqlProperties.getMeta(hsqldb_temp_directory, 2, null));
        dbMeta.put(hsqldb_default_table_type, HsqlProperties.getMeta(hsqldb_default_table_type, 2, "MEMORY"));
        dbMeta.put(hsqldb_inc_backup, HsqlProperties.getMeta(hsqldb_inc_backup, 2, true));
        dbMeta.put(hsqldb_lock_file, HsqlProperties.getMeta(hsqldb_lock_file, 2, true));
        dbMeta.put(hsqldb_nio_data_file, HsqlProperties.getMeta(hsqldb_nio_data_file, 2, true));
        dbMeta.put(sql_enforce_size, HsqlProperties.getMeta(sql_enforce_size, 2, true));
        dbMeta.put(sql_enforce_strict_size, HsqlProperties.getMeta(sql_enforce_strict_size, 2, true));
        dbMeta.put(sql_enforce_names, HsqlProperties.getMeta(sql_enforce_names, 2, false));
        dbMeta.put(sql_compare_in_locale, HsqlProperties.getMeta(sql_compare_in_locale, 2, false));
        dbMeta.put(hsqldb_write_delay, HsqlProperties.getMeta(hsqldb_write_delay, 2, true));
        dbMeta.put(hsqldb_applog, HsqlProperties.getMeta(hsqldb_applog, 2, 0, 0, 2));
        dbMeta.put(hsqldb_script_format, HsqlProperties.getMeta(hsqldb_script_format, 2, 0, new int[]{0, 1, 3}));
        dbMeta.put(hsqldb_log_size, HsqlProperties.getMeta(hsqldb_log_size, 2, 50, 0, 1000));
        dbMeta.put(hsqldb_defrag_limit, HsqlProperties.getMeta(hsqldb_defrag_limit, 2, 20, 0, 100));
        dbMeta.put(runtime_gc_interval, HsqlProperties.getMeta(runtime_gc_interval, 2, 0, 0, 1000000));
        dbMeta.put(hsqldb_cache_size, HsqlProperties.getMeta(hsqldb_cache_size, 2, 10000, 100, 1000000));
        dbMeta.put(hsqldb_cache_rows, HsqlProperties.getMeta(hsqldb_cache_rows, 2, 50000, 100, 1000000));
        dbMeta.put(hsqldb_cache_free_count_scale, HsqlProperties.getMeta(hsqldb_cache_free_count_scale, 2, 9, 6, 12));
        dbMeta.put(hsqldb_result_max_memory_rows, HsqlProperties.getMeta(hsqldb_result_max_memory_rows, 2, 0, 0, 1000000));
        dbMeta.put(hsqldb_max_nio_scale, HsqlProperties.getMeta(hsqldb_max_nio_scale, 2, 28, 24, 31));
    }
}

