/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database db, DataFileCache cache, String dataFileName) {
        this.database = db;
        this.cache = cache;
        this.scale = cache.cacheFileScale;
        this.dataFileName = dataFileName;
    }

    void process() {
        boolean complete = false;
        Error.printSystemOut("Defrag process begins");
        this.transactionRowLookup = this.database.txManager.getTransactionIDList();
        Error.printSystemOut("transaction count: " + this.transactionRowLookup.size());
        HsqlArrayList allTables = this.database.schemaManager.getAllTables();
        this.rootsList = new int[allTables.size()][];
        Storage dest = null;
        try {
            int i;
            OutputStream fos = this.database.logger.getFileAccess().openOutputStreamElement(this.dataFileName + ".new");
            this.fileStreamOut = new BufferedOutputStream(fos, 4096);
            for (i = 0; i < 32; ++i) {
                this.fileStreamOut.write(0);
            }
            this.fileOffset = 32L;
            int tSize = allTables.size();
            for (i = 0; i < tSize; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() == 4) {
                    int[] rootsArray = this.writeTableToDataFile(t);
                    this.rootsList[i] = rootsArray;
                } else {
                    this.rootsList[i] = null;
                }
                Error.printSystemOut("table: " + t.getName().name + " complete");
            }
            this.fileStreamOut.flush();
            this.fileStreamOut.close();
            this.fileStreamOut = null;
            dest = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
            dest.seek(12L);
            dest.writeLong(this.fileOffset);
            int flags = 0;
            if (this.database.logger.propIncrementBackup) {
                flags = BitMap.set(flags, 1);
            }
            flags = BitMap.set(flags, 4);
            flags = BitMap.set(flags, 2);
            dest.seek(28L);
            dest.writeInt(flags);
            dest.close();
            dest = null;
            for (int[] roots : this.rootsList) {
                if (roots == null) continue;
                Error.printSystemOut("roots: " + StringUtil.getList(roots, ",", ""));
            }
            complete = true;
        }
        catch (IOException e) {
            throw Error.error(29, e);
        }
        catch (OutOfMemoryError e) {
            throw Error.error(72, e);
        }
        catch (Throwable t) {
            throw Error.error(40, t);
        }
        finally {
            try {
                if (this.fileStreamOut != null) {
                    this.fileStreamOut.close();
                }
                if (dest != null) {
                    dest.close();
                }
            }
            catch (Throwable t) {
                this.database.logger.logSevereEvent("backupFile failed", t);
            }
            if (!complete) {
                this.database.logger.getFileAccess().removeElement(this.dataFileName + ".new");
            }
        }
        Error.printSystemOut("Defrag transfer complete: " + this.stopw.elapsedTime());
    }

    void updateTableIndexRoots() {
        HsqlArrayList allTables = this.database.schemaManager.getAllTables();
        int size = allTables.size();
        for (int i = 0; i < size; ++i) {
            Table t = (Table)allTables.get(i);
            if (t.getTableType() != 4) continue;
            int[] rootsArray = this.rootsList[i];
            t.setIndexRoots(rootsArray);
        }
    }

    void updateTransactionRowIDs() {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        PersistentStore store = session.sessionData.getRowStore(table);
        RowOutputInterface rowOut = this.cache.rowOut.clone();
        DoubleIntIndex pointerLookup = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(store), false);
        int[] rootsArray = table.getIndexRootsArray();
        long pos = this.fileOffset;
        int count = 0;
        pointerLookup.setKeysSearchTarget();
        Error.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator it = table.rowIterator(store);
        while (it.hasNext()) {
            row = it.getNextRow();
            pointerLookup.addUnsorted(row.getPos(), (int)(pos / (long)this.scale));
            if (count % 50000 == 0) {
                Error.printSystemOut("pointer pair for row " + count + " " + row.getPos() + " " + pos);
            }
            pos += (long)row.getStorageSize();
            ++count;
        }
        Error.printSystemOut("table: " + table.getName().name + " list done: " + this.stopw.elapsedTime());
        count = 0;
        it = table.rowIterator(store);
        while (it.hasNext()) {
            row = it.getNextRow();
            rowOut.reset();
            row.write(rowOut, pointerLookup);
            this.fileStreamOut.write(rowOut.getOutputStream().getBuffer(), 0, rowOut.size());
            this.fileOffset += (long)row.getStorageSize();
            if (count % 50000 == 0) {
                Error.printSystemOut(count + " rows " + this.stopw.elapsedTime());
            }
            ++count;
        }
        for (int i = 0; i < rootsArray.length; ++i) {
            if (rootsArray[i] == -1) continue;
            int lookupIndex = pointerLookup.findFirstEqualKeyIndex(rootsArray[i]);
            if (lookupIndex == -1) {
                throw Error.error(129);
            }
            rootsArray[i] = pointerLookup.getValue(lookupIndex);
        }
        this.setTransactionRowLookups(pointerLookup);
        Error.printSystemOut("table: " + table.getName().name + " : table converted");
        return rootsArray;
    }

    public int[][] getIndexRoots() {
        return this.rootsList;
    }

    void setTransactionRowLookups(DoubleIntIndex pointerLookup) {
        int size = this.transactionRowLookup.size();
        for (int i = 0; i < size; ++i) {
            int key = this.transactionRowLookup.getKey(i);
            int lookupIndex = pointerLookup.findFirstEqualKeyIndex(key);
            if (lookupIndex == -1) continue;
            this.transactionRowLookup.setValue(i, pointerLookup.getValue(lookupIndex));
        }
    }
}

