/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.hsqldb.lib.BasicTextJdkLogFormatter;

public class FrameworkLogger {
    private static Map loggerInstances = new HashMap();
    private static Map jdkToLog4jLevels = new HashMap();
    private static Method log4jGetLogger;
    private static Method log4jLogMethod;
    private Object log4jLogger;
    private Logger jdkLogger;
    private static boolean haveLoadedOurDefault;
    private static ConsoleHandler consoleHandler;

    static void reconfigure() {
        Class<?> log4jLoggerClass = null;
        loggerInstances.clear();
        try {
            log4jLoggerClass = Class.forName("org.apache.log4j.Logger");
        }
        catch (Exception e) {
            log4jLoggerClass = null;
        }
        if (log4jLoggerClass == null) {
            try {
                log4jGetLogger = null;
                log4jLogMethod = null;
                LogManager lm = LogManager.getLogManager();
                if (haveLoadedOurDefault || FrameworkLogger.isDefaultJdkConfig()) {
                    haveLoadedOurDefault = true;
                    consoleHandler.setFormatter(new BasicTextJdkLogFormatter(false));
                    consoleHandler.setLevel(Level.INFO);
                    lm.readConfiguration(FrameworkLogger.class.getResourceAsStream("/org/hsqldb/resources/jdklogging-default.properties"));
                    Logger.getLogger("org.hsqldb.cmdline").addHandler(consoleHandler);
                }
                lm.readConfiguration();
            }
            catch (Exception e) {
                throw new RuntimeException("<clinit> failure initializing JDK logging system", e);
            }
        } else {
            try {
                Method log4jToLevel = Class.forName("org.apache.log4j.Level").getMethod("toLevel", String.class);
                jdkToLog4jLevels.put(Level.ALL, log4jToLevel.invoke(null, "ALL"));
                jdkToLog4jLevels.put(Level.FINER, log4jToLevel.invoke(null, "DEBUG"));
                jdkToLog4jLevels.put(Level.WARNING, log4jToLevel.invoke(null, "ERROR"));
                jdkToLog4jLevels.put(Level.SEVERE, log4jToLevel.invoke(null, "FATAL"));
                jdkToLog4jLevels.put(Level.INFO, log4jToLevel.invoke(null, "INFO"));
                jdkToLog4jLevels.put(Level.OFF, log4jToLevel.invoke(null, "OFF"));
                jdkToLog4jLevels.put(Level.FINEST, log4jToLevel.invoke(null, "TRACE"));
                jdkToLog4jLevels.put(Level.WARNING, log4jToLevel.invoke(null, "WARN"));
                log4jLogMethod = log4jLoggerClass.getMethod("log", String.class, Class.forName("org.apache.log4j.Priority"), Object.class, Throwable.class);
                log4jGetLogger = log4jLoggerClass.getMethod("getLogger", String.class);
            }
            catch (Exception e) {
                throw new RuntimeException("<clinit> failure instantiating present Log4j system", e);
            }
        }
    }

    private FrameworkLogger(String s) {
        if (log4jGetLogger == null) {
            this.jdkLogger = Logger.getLogger(s);
        } else {
            try {
                this.log4jLogger = log4jGetLogger.invoke(null, s);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate Log4j Logger", e);
            }
        }
        loggerInstances.put(s, this);
    }

    public static FrameworkLogger getLog(Class c) {
        return FrameworkLogger.getLog(c.getName());
    }

    public static FrameworkLogger getLog(Class c, String contextId) {
        return contextId == null ? FrameworkLogger.getLog(c) : FrameworkLogger.getLog(contextId + '.' + c.getName());
    }

    public static FrameworkLogger getLog(String s) {
        if (loggerInstances.containsKey(s)) {
            return (FrameworkLogger)loggerInstances.get(s);
        }
        return new FrameworkLogger(s);
    }

    public void log(Level level, String message, Throwable t) {
        this.privlog(level, message, t, 2, FrameworkLogger.class);
    }

    public void privlog(Level level, String message, Throwable t, int revertMethods, Class skipClass) {
        if (this.log4jLogger == null) {
            StackTraceElement[] elements = new Throwable().getStackTrace();
            String c = elements[revertMethods].getClassName();
            String m = elements[revertMethods].getMethodName();
            if (t == null) {
                this.jdkLogger.logp(level, c, m, message);
            } else {
                this.jdkLogger.logp(level, c, m, message, t);
            }
        } else {
            try {
                log4jLogMethod.invoke(this.log4jLogger, skipClass.getName(), jdkToLog4jLevels.get(level), message, t);
            }
            catch (Exception e) {
                throw new RuntimeException("Logging failed when attempting to log: " + message, e);
            }
        }
    }

    public void enduserlog(Level level, String message) {
        if (this.log4jLogger == null) {
            String c = FrameworkLogger.class.getName();
            String m = "\\l";
            this.jdkLogger.logp(level, c, m, message);
        } else {
            try {
                log4jLogMethod.invoke(this.log4jLogger, FrameworkLogger.class.getName(), jdkToLog4jLevels.get(level), message, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Logging failed when attempting to log: " + message, e);
            }
        }
    }

    public void log(Level level, String message) {
        this.privlog(level, message, null, 2, FrameworkLogger.class);
    }

    public void finer(String message) {
        this.privlog(Level.FINER, message, null, 2, FrameworkLogger.class);
    }

    public void warning(String message) {
        this.privlog(Level.WARNING, message, null, 2, FrameworkLogger.class);
    }

    public void severe(String message) {
        this.privlog(Level.SEVERE, message, null, 2, FrameworkLogger.class);
    }

    public void info(String message) {
        this.privlog(Level.INFO, message, null, 2, FrameworkLogger.class);
    }

    public void finest(String message) {
        this.privlog(Level.FINEST, message, null, 2, FrameworkLogger.class);
    }

    public void error(String message) {
        this.privlog(Level.WARNING, message, null, 2, FrameworkLogger.class);
    }

    public void finer(String message, Throwable t) {
        this.privlog(Level.FINER, message, t, 2, FrameworkLogger.class);
    }

    public void warning(String message, Throwable t) {
        this.privlog(Level.WARNING, message, t, 2, FrameworkLogger.class);
    }

    public void severe(String message, Throwable t) {
        this.privlog(Level.SEVERE, message, t, 2, FrameworkLogger.class);
    }

    public void info(String message, Throwable t) {
        this.privlog(Level.INFO, message, t, 2, FrameworkLogger.class);
    }

    public void finest(String message, Throwable t) {
        this.privlog(Level.FINEST, message, t, 2, FrameworkLogger.class);
    }

    public void error(String message, Throwable t) {
        this.privlog(Level.WARNING, message, t, 2, FrameworkLogger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDefaultJdkConfig() {
        File globalCfgFile = new File(System.getProperty("java.home"), "lib/logging.properties");
        if (!globalCfgFile.isFile()) {
            return false;
        }
        FileInputStream fis = null;
        LogManager lm = LogManager.getLogManager();
        try {
            fis = new FileInputStream(globalCfgFile);
            Properties defaultProps = new Properties();
            defaultProps.load(fis);
            Enumeration<?> names = defaultProps.propertyNames();
            int i = 0;
            while (names.hasMoreElements()) {
                ++i;
                String name = (String)names.nextElement();
                String liveVal = lm.getProperty(name);
                if (liveVal == null) {
                    boolean bl = false;
                    return bl;
                }
                if (lm.getProperty(name).equals(liveVal)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    static {
        consoleHandler = new ConsoleHandler();
        FrameworkLogger.reconfigure();
    }
}

