/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil = new FileUtil();
    private static FileAccessRes fileAccessRes = new FileAccessRes();
    public final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    final Random random = new Random(System.currentTimeMillis());

    FileUtil() {
    }

    public static FileUtil getFileUtil() {
        return fileUtil;
    }

    public static FileAccess getFileAccess(boolean isResource) {
        return isResource ? fileAccessRes : fileUtil;
    }

    @Override
    public boolean isStreamElement(String elementName) {
        return new File(elementName).exists();
    }

    @Override
    public InputStream openInputStreamElement(String streamName) throws IOException {
        try {
            return new FileInputStream(new File(streamName));
        }
        catch (Throwable e) {
            throw JavaSystem.toIOException(e);
        }
    }

    @Override
    public void createParentDirs(String filename) {
        this.makeParentDirectories(new File(filename));
    }

    @Override
    public void removeElement(String filename) {
        if (this.isStreamElement(filename)) {
            this.delete(filename);
        }
    }

    @Override
    public void renameElement(String oldName, String newName) {
        this.renameOverwrite(oldName, newName);
    }

    @Override
    public OutputStream openOutputStreamElement(String streamName) throws IOException {
        return new FileOutputStream(new File(streamName));
    }

    public boolean delete(String filename) {
        return new File(filename).delete();
    }

    public void deleteOnExit(File f) {
        JavaSystem.deleteOnExit(f);
    }

    public boolean exists(String filename) {
        return new File(filename).exists();
    }

    public boolean exists(String fileName, boolean resource, Class cla) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return resource ? null != cla.getResource(fileName) : FileUtil.getFileUtil().exists(fileName);
    }

    private boolean renameOverwrite(String oldname, String newname) {
        boolean deleted = this.delete(newname);
        if (this.exists(oldname)) {
            File file = new File(oldname);
            return file.renameTo(new File(newname));
        }
        return deleted;
    }

    public String absolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    public File canonicalFile(File f) throws IOException {
        return new File(f.getCanonicalPath());
    }

    public File canonicalFile(String path) throws IOException {
        return new File(new File(path).getCanonicalPath());
    }

    public String canonicalPath(File f) throws IOException {
        return f.getCanonicalPath();
    }

    public String canonicalPath(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    public String canonicalOrAbsolutePath(String path) {
        try {
            return this.canonicalPath(path);
        }
        catch (Exception e) {
            return this.absolutePath(path);
        }
    }

    public void makeParentDirectories(File f) {
        String parent = f.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        } else {
            parent = f.getPath();
            int index = parent.lastIndexOf(47);
            if (index > 0) {
                parent = parent.substring(0, index);
                new File(parent).mkdirs();
            }
        }
    }

    public static String makeDirectories(String path) {
        try {
            File file = new File(path);
            file.mkdirs();
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public FileAccess.FileSync getFileSync(OutputStream os) throws IOException {
        return new FileSync((FileOutputStream)os);
    }

    public static class FileAccessRes
    implements FileAccess {
        @Override
        public boolean isStreamElement(String elementName) {
            return this.getClass().getResource(elementName) != null;
        }

        @Override
        public InputStream openInputStreamElement(String streamName) throws IOException {
            try {
                return this.getClass().getResourceAsStream(streamName);
            }
            catch (Throwable e) {
                throw JavaSystem.toIOException(e);
            }
        }

        @Override
        public void createParentDirs(String filename) {
        }

        @Override
        public void removeElement(String filename) {
        }

        @Override
        public void renameElement(String oldName, String newName) {
        }

        @Override
        public OutputStream openOutputStreamElement(String streamName) throws IOException {
            throw new IOException();
        }

        @Override
        public FileAccess.FileSync getFileSync(OutputStream os) throws IOException {
            throw new IOException();
        }
    }

    public static class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream os) throws IOException {
            this.outDescriptor = os.getFD();
        }

        @Override
        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

