/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementSimple;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.result.Result;

public class StatementCompound
extends Statement {
    final boolean isLoop;
    HsqlNameManager.HsqlName label;
    StatementHandler[] handlers = StatementHandler.emptyExceptionHandlerArray;
    Statement loopCursor;
    Statement[] statements;
    StatementExpression condition;
    boolean isAtomic;
    ColumnSchema[] variables = ColumnSchema.emptyArray;
    HashMappedList scopeVariables;
    RangeVariable[] rangeVariables = RangeVariable.emptyArray;
    public static final StatementCompound[] emptyStatementArray = new StatementCompound[0];

    StatementCompound(int type, HsqlNameManager.HsqlName label) {
        super(type, 2007);
        this.label = label;
        this.isTransactionStatement = false;
        switch (type) {
            case 90: 
            case 95: 
            case 97: {
                this.isLoop = true;
                break;
            }
            case 12: 
            case 88: {
                this.isLoop = false;
                break;
            }
            default: {
                throw Error.runtimeError(401, "StatementCompound");
            }
        }
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("STATEMENT");
        return sb.toString();
    }

    public void setLocalDeclarations(Object[] declarations) {
        int i;
        int varCount = 0;
        int handlerCount = 0;
        for (i = 0; i < declarations.length; ++i) {
            if (declarations[i] instanceof ColumnSchema) {
                ++varCount;
                continue;
            }
            ++handlerCount;
        }
        this.variables = new ColumnSchema[varCount];
        this.handlers = new StatementHandler[handlerCount];
        varCount = 0;
        handlerCount = 0;
        for (i = 0; i < declarations.length; ++i) {
            if (declarations[i] instanceof ColumnSchema) {
                this.variables[varCount++] = (ColumnSchema)declarations[i];
                continue;
            }
            StatementHandler handler = (StatementHandler)declarations[i];
            handler.setParent(this);
            this.handlers[handlerCount++] = handler;
        }
        this.setVariables();
        this.setHandlers();
    }

    public void setLoopStatement(Statement cursorStatement) {
        this.loopCursor = cursorStatement;
    }

    void setStatements(Statement[] statements) {
        for (int i = 0; i < statements.length; ++i) {
            statements[i].setParent(this);
        }
        this.statements = statements;
    }

    public void setCondition(StatementExpression condition) {
        this.condition = condition;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        switch (this.type) {
            case 12: {
                this.initialiseVariables(session);
                result = this.executeBlock(session);
                break;
            }
            case 90: 
            case 95: 
            case 97: {
                result = this.executeLoop(session);
                break;
            }
            case 88: {
                result = this.executeIf(session);
                break;
            }
            default: {
                throw Error.runtimeError(401, "StatementCompound");
            }
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    private Result executeBlock(Session session) {
        Result result = Result.updateZeroResult;
        session.sessionContext.push();
        for (int i = 0; i < this.statements.length; ++i) {
            result = this.statements[i].execute(session);
            if ((result = this.handleCondition(session, result)).isError() || result.getType() == 42) break;
        }
        if (result.getType() == 42 && result.getErrorCode() == 89) {
            if (result.getMainString() == null) {
                result = Result.updateZeroResult;
            } else if (this.label != null && this.label.name.equals(result.getMainString())) {
                result = Result.updateZeroResult;
            }
        }
        session.sessionContext.pop();
        return result;
    }

    private Result handleCondition(Session session, Result result) {
        String sqlState = null;
        if (result.isError()) {
            sqlState = result.getSubString();
        } else if (session.getLastWarning() != null) {
            sqlState = session.getLastWarning().getSQLState();
        } else {
            return result;
        }
        if (sqlState != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                StatementHandler handler = this.handlers[i];
                session.clearWarnings();
                if (!handler.handlesCondition(result.getSubString())) continue;
                session.resetSchema();
                switch (handler.handlerType) {
                    case 5: {
                        result = Result.updateZeroResult;
                        break;
                    }
                    case 7: {
                        session.rollbackToSavepoint();
                        result = Result.newPSMResult(89, null, null);
                        break;
                    }
                    case 6: {
                        result = Result.newPSMResult(89, null, null);
                    }
                }
                Result actionResult = handler.statement.execute(session);
                if (actionResult.isError()) {
                    result = actionResult;
                    this.handleCondition(session, result);
                    continue;
                }
                return result;
            }
            if (this.parent != null) {
                return this.parent.handleCondition(session, result);
            }
        }
        return result;
    }

    private Result executeLoop(Session session) {
        Result result;
        block9: {
            result = Result.updateZeroResult;
            while (true) {
                if (this.type == 97) {
                    result = this.condition.execute(session);
                    if (result.isError()) break block9;
                    if (!Boolean.TRUE.equals(result.getValueObject())) {
                        result = Result.updateZeroResult;
                        break block9;
                    }
                }
                for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42; ++i) {
                }
                if (result.isError()) break block9;
                if (result.getType() == 42) {
                    if (result.getErrorCode() == 102) {
                        if (result.getMainString() == null || this.label != null && this.label.name.equals(result.getMainString())) {
                            continue;
                        }
                        break block9;
                    }
                    if (result.getErrorCode() == 89) {
                        if (result.getMainString() == null) {
                            result = Result.updateZeroResult;
                        }
                        if (this.label == null || !this.label.name.equals(result.getMainString())) break block9;
                        result = Result.updateZeroResult;
                        break block9;
                    }
                    if (result.getErrorCode() == 58) break block9;
                }
                if (this.type != 95) continue;
                result = this.condition.execute(session);
                if (result.isError()) break block9;
                if (Boolean.TRUE.equals(result.getValueObject())) break;
            }
            result = Result.updateZeroResult;
        }
        return result;
    }

    private Result executeIf(Session session) {
        Result result = Result.updateZeroResult;
        boolean execute = false;
        for (int i = 0; i < this.statements.length; ++i) {
            if (this.statements[i].getType() == 1101) {
                if (execute || (result = this.statements[i].execute(session)).isError()) break;
                Object value = result.getValueObject();
                execute = Boolean.TRUE.equals(value);
                ++i;
            }
            result = Result.updateZeroResult;
            if (execute && ((result = this.statements[i].execute(session)).isError() || result.getType() == 42)) break;
        }
        return result;
    }

    @Override
    public void resolve() {
        int i;
        for (i = 0; i < this.statements.length; ++i) {
            if (this.statements[i].getType() == 89 || this.statements[i].getType() == 102) {
                if (this.findLabel((StatementSimple)this.statements[i])) continue;
                throw Error.error(5508, ((StatementSimple)this.statements[i]).label.name);
            }
            if (this.statements[i].getType() != 58 || this.root.isFunction()) continue;
            throw Error.error(5602, "RETURN");
        }
        for (i = 0; i < this.statements.length; ++i) {
            this.statements[i].resolve();
        }
    }

    @Override
    public void setRoot(Routine routine) {
        this.root = routine;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public OrderedHashSet getReferences() {
        int i;
        OrderedHashSet set = new OrderedHashSet();
        for (i = 0; i < this.statements.length; ++i) {
            set.addAll(this.statements[i].getReferences());
        }
        for (i = 0; i < this.handlers.length; ++i) {
            set.addAll(this.handlers[i].getReferences());
        }
        return set;
    }

    public void setAtomic(boolean atomic) {
        this.isAtomic = atomic;
    }

    private void setVariables() {
        int i;
        if (this.variables.length == 0) {
            this.rangeVariables = this.parent == null ? this.root.getParameterRangeVariables() : this.parent.rangeVariables;
            return;
        }
        HashMappedList list = new HashMappedList();
        if (this.parent != null) {
            for (i = 0; i < this.parent.scopeVariables.size(); ++i) {
                list.add(this.parent.scopeVariables.getKey(i), this.parent.scopeVariables.get(i));
            }
        }
        for (i = 0; i < this.variables.length; ++i) {
            String name = this.variables[i].getName().name;
            boolean added = list.add(name, this.variables[i]);
            if (!added) {
                throw Error.error(5606, name);
            }
            if (this.root.getParameterIndex(name) == -1) continue;
            throw Error.error(5606, name);
        }
        RangeVariable range = new RangeVariable(list, true);
        this.rangeVariables = new RangeVariable[]{this.root.getParameterRangeVariables()[0], range};
        this.root.variableCount = list.size();
    }

    private void setHandlers() {
        if (this.handlers.length == 0) {
            return;
        }
        HashSet statesSet = new HashSet();
        OrderedIntHashSet typesSet = new OrderedIntHashSet();
        for (int i = 0; i < this.handlers.length; ++i) {
            int[] types = this.handlers[i].getConditionTypes();
            for (int j = 0; j < types.length; ++j) {
                if (typesSet.add(types[j])) continue;
                throw Error.error(5601);
            }
            String[] states = this.handlers[i].getConditionStates();
            for (int j = 0; j < states.length; ++j) {
                if (statesSet.add(states[j])) continue;
                throw Error.error(5601);
            }
        }
    }

    private boolean findLabel(StatementSimple statement) {
        if (this.label != null && statement.label.name.equals(this.label.name)) {
            return this.isLoop || statement.getType() != 102;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.findLabel(statement);
    }

    private void initialiseVariables(Session session) {
        Object[] vars = session.sessionContext.routineVariables;
        int offset = this.parent == null ? 0 : this.parent.scopeVariables.size();
        for (int i = 0; i < this.variables.length; ++i) {
            try {
                vars[offset + i] = this.variables[i].getDefaultValue(session);
                continue;
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }
}

