/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementInsert;
import org.hsqldb.StatementProcedure;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.types.Type;

public class ParserDML
extends ParserDQL {
    ParserDML(Session session, Scanner t) {
        super(session, t);
    }

    StatementDMQL compileInsertStatement(RangeVariable[] outerRanges) {
        int enforcedDefaultIndex;
        this.read();
        this.readThis(139);
        Table table = this.readTableName();
        boolean overridingUser = false;
        boolean overridingSystem = false;
        boolean assignsToIdentity = false;
        boolean[] columnCheckList = null;
        int[] columnMap = table.getColumnMap();
        int colCount = table.getColumnCount();
        int position = this.getPosition();
        if (!table.isInsertable()) {
            throw Error.error(5545);
        }
        Table baseTable = table.getBaseTable();
        switch (this.token.tokenType) {
            case 77: {
                this.read();
                this.readThis(306);
                Expression insertExpression = new Expression(25, new Expression[0]);
                insertExpression = new Expression(26, new Expression[]{insertExpression});
                columnCheckList = table.getNewColumnCheckList();
                for (int i = 0; i < table.colDefaults.length; ++i) {
                    if (table.colDefaults[i] != null || table.identityColumn == i || table.getColumn(i).isGenerated()) continue;
                    throw Error.error(5544);
                }
                StatementInsert cs = new StatementInsert(this.session, table, columnMap, insertExpression, columnCheckList, this.compileContext);
                return cs;
            }
            case 695: {
                int brackets = this.readOpenBrackets();
                if (brackets == 1) {
                    boolean isQuery = false;
                    switch (this.token.tokenType) {
                        case 249: 
                        case 276: 
                        case 317: {
                            this.rewind(position);
                            isQuery = true;
                            break;
                        }
                    }
                    if (isQuery) break;
                    OrderedHashSet columnNames = new OrderedHashSet();
                    this.readSimpleColumnNames(columnNames, table);
                    this.readThis(682);
                    colCount = columnNames.size();
                    columnMap = table.getColumnIndexes(columnNames);
                    if (this.token.tokenType != 306 && this.token.tokenType != 460) {
                        break;
                    }
                } else {
                    this.rewind(position);
                    break;
                }
            }
            case 460: {
                if (this.token.tokenType == 460) {
                    this.read();
                    if (this.token.tokenType == 303) {
                        this.read();
                        overridingUser = true;
                    } else if (this.token.tokenType == 274) {
                        this.read();
                        overridingSystem = true;
                    } else {
                        this.unexpectedToken();
                    }
                }
                if (this.token.tokenType != 306) break;
            }
            case 306: {
                this.read();
                columnCheckList = table.getColumnCheckList(columnMap);
                Expression insertExpressions = this.XreadContextuallyTypedTable(colCount);
                HsqlList unresolved = insertExpressions.resolveColumnReferences(outerRanges, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                insertExpressions.resolveTypes(this.session, null);
                ParserDML.setParameterTypes(insertExpressions, table, columnMap);
                if (table != baseTable) {
                    int[] baseColumnMap = table.getBaseTableColumnMap();
                    int[] newColumnMap = new int[columnMap.length];
                    ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
                    columnMap = newColumnMap;
                }
                Expression[] rowList = insertExpressions.nodes;
                for (int j = 0; j < rowList.length; ++j) {
                    Expression[] rowArgs = rowList[j].nodes;
                    for (int i = 0; i < rowArgs.length; ++i) {
                        Expression e = rowArgs[i];
                        ColumnSchema column = baseTable.getColumn(columnMap[i]);
                        if (column.isIdentity()) {
                            assignsToIdentity = true;
                            if (e.getType() != 4 && table.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                                throw Error.error(5543);
                            }
                        } else if (!column.hasDefault()) {
                            if (column.isGenerated()) {
                                if (e.getType() != 4) {
                                    throw Error.error(5541);
                                }
                            } else if (e.getType() == 4) {
                                throw Error.error(5544);
                            }
                        }
                        if (!e.isParam()) continue;
                        e.setAttributesAsColumn(column, true);
                    }
                }
                if (!assignsToIdentity && (overridingUser || overridingSystem)) {
                    this.unexpectedTokenRequire("OVERRIDING");
                }
                StatementInsert cs = new StatementInsert(this.session, table, columnMap, insertExpressions, columnCheckList, this.compileContext);
                return cs;
            }
            case 249: 
            case 276: 
            case 317: {
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        columnCheckList = table.getColumnCheckList(columnMap);
        if (table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
        }
        if ((enforcedDefaultIndex = table.getIdentityColumnIndex()) != -1 && ArrayUtil.find(columnMap, enforcedDefaultIndex) > -1) {
            if (table.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                throw Error.error(5543);
            }
        } else if (overridingUser || overridingSystem) {
            this.unexpectedTokenRequire("OVERRIDING");
        }
        Object[] types = new Type[columnMap.length];
        ArrayUtil.projectRow(baseTable.getColumnTypes(), columnMap, types);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setAsTopLevel();
        queryExpression.resolve(this.session, outerRanges, (Type[])types);
        if (colCount != queryExpression.getColumnCount()) {
            throw Error.error(5546);
        }
        StatementInsert cs = new StatementInsert(this.session, table, columnMap, columnCheckList, queryExpression, this.compileContext);
        return cs;
    }

    private static void setParameterTypes(Expression tableExpression, Table table, int[] columnMap) {
        for (int i = 0; i < tableExpression.nodes.length; ++i) {
            Expression[] list = tableExpression.nodes[i].nodes;
            for (int j = 0; j < list.length; ++j) {
                if (!list[j].isParam()) continue;
                list[j].setAttributesAsColumn(table.getColumn(columnMap[j]), true);
            }
        }
    }

    StatementDMQL compileDeleteStatement(RangeVariable[] outerRanges) {
        Expression condition = null;
        boolean truncate = false;
        boolean restartIdentity = false;
        switch (this.token.tokenType) {
            case 293: {
                this.read();
                this.readThis(276);
                truncate = true;
                break;
            }
            case 78: {
                this.read();
                this.readThis(114);
            }
        }
        RangeVariable[] rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(19)};
        Table table = rangeVariables[0].getTable();
        Table baseTable = table.getBaseTable();
        if (!table.isUpdatable()) {
            throw Error.error(5000);
        }
        if (truncate) {
            switch (this.token.tokenType) {
                case 376: {
                    this.read();
                    this.readThis(127);
                    break;
                }
                case 483: {
                    this.read();
                    this.readThis(127);
                    restartIdentity = true;
                }
            }
            for (int i = 0; i < table.constraintList.length; ++i) {
                if (table.constraintList[i].getConstraintType() != 1) continue;
                throw Error.error(8);
            }
        }
        if (truncate && table != baseTable) {
            throw Error.error(5000);
        }
        if (!truncate && this.token.tokenType == 314) {
            this.read();
            condition = this.XreadBooleanValueExpression();
            HsqlList unresolved = condition.resolveColumnReferences(outerRanges, null);
            unresolved = Expression.resolveColumnSet(rangeVariables, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.isParam()) {
                condition.dataType = Type.SQL_BOOLEAN;
            }
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (table != baseTable) {
            QuerySpecification select = ((TableDerived)table).getQueryExpression().getMainSelect();
            if (condition != null) {
                condition = condition.replaceColumnReferences(rangeVariables[0], select.exprColumns);
            }
            rangeVariables[0] = new RangeVariable(select.rangeVariables[0]);
            condition = ExpressionLogical.andExpressions(select.queryCondition, condition);
        }
        if (condition != null) {
            RangeVariableResolver resolver = new RangeVariableResolver(rangeVariables, condition, this.compileContext);
            resolver.processConditions();
            rangeVariables = resolver.rangeVariables;
        }
        StatementDML cs = new StatementDML(this.session, table, rangeVariables, this.compileContext, restartIdentity);
        return cs;
    }

    StatementDMQL compileUpdateStatement(RangeVariable[] outerRanges) {
        this.read();
        OrderedHashSet colNames = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable[] rangeVariables = new RangeVariable[]{this.readSimpleRangeVariable(82)};
        Table table = rangeVariables[0].rangeTable;
        Table baseTable = table.getBaseTable();
        this.readThis(252);
        this.readSetClauseList(rangeVariables, colNames, exprList);
        int[] columnMap = table.getColumnIndexes(colNames);
        boolean[] columnCheckList = table.getColumnCheckList(columnMap);
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        Expression condition = null;
        if (this.token.tokenType == 314) {
            this.read();
            condition = this.XreadBooleanValueExpression();
            HsqlList unresolved = condition.resolveColumnReferences(outerRanges, null);
            unresolved = Expression.resolveColumnSet(rangeVariables, unresolved, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.isParam()) {
                condition.dataType = Type.SQL_BOOLEAN;
            } else if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        this.resolveUpdateExpressions(table, rangeVariables, columnMap, updateExpressions, outerRanges);
        if (table != baseTable) {
            QuerySpecification select = ((TableDerived)table).getQueryExpression().getMainSelect();
            if (condition != null) {
                condition = condition.replaceColumnReferences(rangeVariables[0], select.exprColumns);
            }
            rangeVariables[0] = new RangeVariable(select.rangeVariables[0]);
            condition = ExpressionLogical.andExpressions(select.queryCondition, condition);
        }
        if (condition != null) {
            RangeVariableResolver resolver = new RangeVariableResolver(rangeVariables, condition, this.compileContext);
            resolver.processConditions();
            rangeVariables = resolver.rangeVariables;
        }
        if (table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
            for (int i = 0; i < columnMap.length; ++i) {
                if (!baseTable.colGenerated[columnMap[i]]) continue;
                throw Error.error(5513);
            }
        }
        StatementDML cs = new StatementDML(this.session, table, rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext);
        return cs;
    }

    void resolveUpdateExpressions(Table targetTable, RangeVariable[] rangeVariables, int[] columnMap, Expression[] colExpressions, RangeVariable[] outerRanges) {
        HsqlList unresolved = null;
        int enforcedDefaultIndex = -1;
        if (targetTable.hasIdentityColumn() && targetTable.identitySequence.isAlways()) {
            enforcedDefaultIndex = targetTable.getIdentityColumnIndex();
        }
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            Expression e;
            int j;
            Expression expr = colExpressions[ix];
            if (targetTable.colGenerated[columnMap[i]]) {
                throw Error.error(5513);
            }
            if (expr.getType() == 25) {
                Expression[] elements = expr.nodes;
                j = 0;
                while (j < elements.length) {
                    e = elements[j];
                    if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                        throw Error.error(5541);
                    }
                    if (e.isParam()) {
                        e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]), true);
                    } else if (e.getType() == 4) {
                        if (targetTable.colDefaults[columnMap[i]] == null && targetTable.identityColumn != columnMap[i]) {
                            throw Error.error(5544);
                        }
                    } else {
                        unresolved = expr.resolveColumnReferences(outerRanges, null);
                        unresolved = Expression.resolveColumnSet(rangeVariables, unresolved, null);
                        ExpressionColumn.checkColumnsResolved(unresolved);
                        unresolved = null;
                        e.resolveTypes(this.session, null);
                    }
                    ++j;
                    ++i;
                }
            } else if (expr.getType() == 23) {
                unresolved = expr.resolveColumnReferences(outerRanges, null);
                unresolved = Expression.resolveColumnSet(rangeVariables, unresolved, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                expr.resolveTypes(this.session, null);
                int count = expr.subQuery.queryExpression.getColumnCount();
                j = 0;
                while (j < count) {
                    if (enforcedDefaultIndex == columnMap[i]) {
                        throw Error.error(5541);
                    }
                    ++j;
                    ++i;
                }
            } else {
                e = expr;
                if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                    throw Error.error(5541);
                }
                if (e.isParam()) {
                    e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]), true);
                } else if (e.getType() == 4) {
                    if (targetTable.colDefaults[columnMap[i]] == null && targetTable.identityColumn != columnMap[i]) {
                        throw Error.error(5544);
                    }
                } else {
                    unresolved = expr.resolveColumnReferences(outerRanges, null);
                    unresolved = Expression.resolveColumnSet(rangeVariables, unresolved, null);
                    ExpressionColumn.checkColumnsResolved(unresolved);
                    e.resolveTypes(this.session, null);
                }
                ++i;
            }
            ++ix;
        }
        if (!targetTable.isView) {
            return;
        }
        QuerySpecification select = ((TableDerived)targetTable).getQueryExpression().getMainSelect();
        for (int i2 = 0; i2 < colExpressions.length; ++i2) {
            colExpressions[i2] = colExpressions[i2].replaceColumnReferences(rangeVariables[0], select.exprColumns);
        }
    }

    void readSetClauseList(RangeVariable[] rangeVars, OrderedHashSet colNames, HsqlArrayList expressions) {
        while (true) {
            Expression e;
            int degree;
            if (this.token.tokenType == 695) {
                this.read();
                int oldCount = colNames.size();
                this.readColumnNames(colNames, rangeVars);
                degree = colNames.size() - oldCount;
                this.readThis(682);
            } else {
                ColumnSchema column = this.readColumnName(rangeVars);
                if (!colNames.add(column.getName().name)) {
                    throw Error.error(5578, column.getName().name);
                }
                degree = 1;
            }
            this.readThis(396);
            int position = this.getPosition();
            int brackets = this.readOpenBrackets();
            if (this.token.tokenType == 249) {
                this.rewind(position);
                SubQuery sq = this.XreadSubqueryBody(false, 22);
                if (degree != sq.queryExpression.getColumnCount()) {
                    throw Error.error(5546);
                }
                Expression e2 = new Expression(22, sq);
                expressions.add(e2);
                if (this.token.tokenType != 684) break;
                this.read();
                continue;
            }
            if (brackets > 0) {
                this.rewind(position);
            }
            if (degree > 1) {
                int rowDegree;
                this.readThis(695);
                e = this.readRow();
                this.readThis(682);
                int n = rowDegree = e.getType() == 25 ? e.nodes.length : 1;
                if (degree != rowDegree) {
                    throw Error.error(5546);
                }
                expressions.add(e);
            } else {
                e = this.XreadValueExpressionWithContext();
                expressions.add(e);
            }
            if (this.token.tokenType != 684) break;
            this.read();
        }
    }

    StatementDMQL compileMergeStatement(RangeVariable[] outerRanges) {
        int[] insertColumnMap = null;
        int[] updateColumnMap = null;
        HsqlArrayList updateList = new HsqlArrayList();
        Expression[] updateExpressions = null;
        HsqlArrayList insertList = new HsqlArrayList();
        Expression insertExpression = null;
        this.read();
        this.readThis(139);
        RangeVariable targetRange = this.readSimpleRangeVariable(128);
        Table table = targetRange.rangeTable;
        this.readThis(304);
        RangeVariable sourceRange = this.readTableOrSubquery();
        this.readThis(192);
        Expression mergeCondition = this.XreadBooleanValueExpression();
        if (mergeCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        RangeVariable[] fullRangeVars = new RangeVariable[]{sourceRange, targetRange};
        RangeVariable[] sourceRangeVars = new RangeVariable[]{sourceRange};
        RangeVariable[] targetRangeVars = new RangeVariable[]{targetRange};
        insertColumnMap = table.getColumnMap();
        boolean[] insertColumnCheckList = table.getNewColumnCheckList();
        OrderedHashSet updateColNames = new OrderedHashSet();
        OrderedHashSet insertColNames = new OrderedHashSet();
        this.readMergeWhen(insertColNames, updateColNames, insertList, updateList, targetRangeVars, sourceRange);
        if (insertList.size() > 0) {
            int colCount = insertColNames.size();
            if (colCount != 0) {
                insertColumnMap = table.getColumnIndexes(insertColNames);
                insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
            }
            insertExpression = (Expression)insertList.get(0);
            ParserDML.setParameterTypes(insertExpression, table, insertColumnMap);
        }
        if (updateList.size() > 0) {
            updateExpressions = new Expression[updateList.size()];
            updateList.toArray(updateExpressions);
            updateColumnMap = table.getColumnIndexes(updateColNames);
        }
        if (updateExpressions != null) {
            Table baseTable = table.getBaseTable();
            int[] baseUpdateColumnMap = updateColumnMap;
            if (table != baseTable) {
                baseUpdateColumnMap = new int[updateColumnMap.length];
                ArrayUtil.projectRow(table.getBaseTableColumnMap(), updateColumnMap, baseUpdateColumnMap);
            }
            this.resolveUpdateExpressions(table, sourceRangeVars, updateColumnMap, updateExpressions, outerRanges);
        }
        HsqlList unresolved = null;
        unresolved = mergeCondition.resolveColumnReferences(fullRangeVars, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        mergeCondition.resolveTypes(this.session, null);
        if (mergeCondition.isParam()) {
            mergeCondition.dataType = Type.SQL_BOOLEAN;
        }
        if (mergeCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        RangeVariableResolver resolver = new RangeVariableResolver(fullRangeVars, mergeCondition, this.compileContext);
        resolver.processConditions();
        fullRangeVars = resolver.rangeVariables;
        if (insertExpression != null) {
            unresolved = insertExpression.resolveColumnReferences(sourceRangeVars, unresolved);
            ExpressionColumn.checkColumnsResolved(unresolved);
            insertExpression.resolveTypes(this.session, null);
        }
        StatementDML cs = new StatementDML(this.session, fullRangeVars, insertColumnMap, updateColumnMap, insertColumnCheckList, mergeCondition, insertExpression, updateExpressions, this.compileContext);
        return cs;
    }

    private void readMergeWhen(OrderedHashSet insertColumnNames, OrderedHashSet updateColumnNames, HsqlArrayList insertExpressions, HsqlArrayList updateExpressions, RangeVariable[] targetRangeVars, RangeVariable sourceRangeVar) {
        Table table = targetRangeVars[0].rangeTable;
        int columnCount = table.getColumnCount();
        this.readThis(312);
        if (this.token.tokenType == 436) {
            if (updateExpressions.size() != 0) {
                throw Error.error(5547);
            }
            this.read();
            this.readThis(278);
            this.readThis(301);
            this.readThis(252);
            this.readSetClauseList(targetRangeVars, updateColumnNames, updateExpressions);
        } else if (this.token.tokenType == 181) {
            if (insertExpressions.size() != 0) {
                throw Error.error(5548);
            }
            this.read();
            this.readThis(436);
            this.readThis(278);
            this.readThis(133);
            int brackets = this.readOpenBrackets();
            if (brackets == 1) {
                this.readSimpleColumnNames(insertColumnNames, targetRangeVars[0]);
                this.readThis(682);
                brackets = 0;
            }
            this.readThis(306);
            Expression e = this.XreadContextuallyTypedTable(columnCount);
            if (e.nodes.length != 1) {
                throw Error.error(3201);
            }
            insertExpressions.add(e);
        } else {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 312) {
            this.readMergeWhen(insertColumnNames, updateColumnNames, insertExpressions, updateExpressions, targetRangeVars, sourceRangeVar);
        }
    }

    StatementDMQL compileCallStatement(RangeVariable[] outerRanges, boolean isStrictlyProcedure) {
        this.read();
        if (this.isIdentifier()) {
            this.checkValidCatalogName(this.token.namePrePrefix);
            RoutineSchema routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(this.token.tokenString, this.session.getSchemaName(this.token.namePrefix), 17);
            if (routineSchema != null) {
                int i;
                this.read();
                HsqlArrayList list = new HsqlArrayList();
                this.readThis(695);
                if (this.token.tokenType == 682) {
                    this.read();
                } else {
                    while (true) {
                        Expression e = this.XreadValueExpression();
                        list.add(e);
                        if (this.token.tokenType != 684) break;
                        this.read();
                    }
                    this.readThis(682);
                }
                Expression[] arguments = new Expression[list.size()];
                list.toArray(arguments);
                Routine routine = routineSchema.getSpecificRoutine(arguments.length);
                HsqlList unresolved = null;
                for (i = 0; i < arguments.length; ++i) {
                    Expression e = arguments[i];
                    if (e.isParam()) {
                        e.setAttributesAsColumn(routine.getParameter(i), routine.getParameter(i).isWriteable());
                        continue;
                    }
                    byte paramMode = routine.getParameter(i).getParameterMode();
                    unresolved = arguments[i].resolveColumnReferences(outerRanges, unresolved);
                    if (paramMode == 1 || e.getType() == 6) continue;
                    throw Error.error(5603);
                }
                ExpressionColumn.checkColumnsResolved(unresolved);
                for (i = 0; i < arguments.length; ++i) {
                    arguments[i].resolveTypes(this.session, null);
                }
                StatementProcedure cs = new StatementProcedure(this.session, routine, arguments, this.compileContext);
                return cs;
            }
        }
        if (isStrictlyProcedure) {
            throw Error.error(5501, this.token.tokenString);
        }
        Expression expression = this.XreadValueExpression();
        HsqlList unresolved = expression.resolveColumnReferences(outerRanges, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        expression.resolveTypes(this.session, null);
        StatementProcedure cs = new StatementProcedure(this.session, expression, this.compileContext);
        return cs;
    }
}

