/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Library;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.Crypto;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ISAUTOCOMMIT = 71;
    private static final int FUNC_ISREADONLYSESSION = 72;
    private static final int FUNC_ISREADONLYDATABASE = 73;
    private static final int FUNC_ISREADONLYDATABASEFILES = 74;
    private static final int FUNC_DATABASE = 75;
    private static final int FUNC_IDENTITY = 76;
    private static final int FUNC_SYSDATE = 77;
    private static final int FUNC_TIMESTAMPADD = 78;
    private static final int FUNC_TIMESTAMPDIFF = 79;
    private static final int FUNC_TRUNCATE = 80;
    private static final int FUNC_TO_CHAR = 81;
    private static final int FUNC_TIMESTAMP = 82;
    private static final int FUNC_CRYPT_KEY = 83;
    private static final int FUNC_ACOS = 101;
    private static final int FUNC_ASIN = 102;
    private static final int FUNC_ATAN = 103;
    private static final int FUNC_ATAN2 = 104;
    private static final int FUNC_COS = 105;
    private static final int FUNC_COT = 106;
    private static final int FUNC_DEGREES = 107;
    private static final int FUNC_LOG10 = 110;
    private static final int FUNC_PI = 111;
    private static final int FUNC_RADIANS = 112;
    private static final int FUNC_RAND = 113;
    private static final int FUNC_ROUND = 114;
    private static final int FUNC_SIGN = 115;
    private static final int FUNC_SIN = 116;
    private static final int FUNC_TAN = 117;
    private static final int FUNC_BITAND = 118;
    private static final int FUNC_BITOR = 119;
    private static final int FUNC_BITXOR = 120;
    private static final int FUNC_ROUNDMAGIC = 121;
    private static final int FUNC_ASCII = 122;
    private static final int FUNC_CHAR = 123;
    private static final int FUNC_CONCAT = 124;
    private static final int FUNC_DIFFERENCE = 125;
    private static final int FUNC_HEXTORAW = 126;
    private static final int FUNC_LEFT = 128;
    private static final int FUNC_LOCATE = 130;
    private static final int FUNC_LTRIM = 131;
    private static final int FUNC_RAWTOHEX = 132;
    private static final int FUNC_REPEAT = 133;
    private static final int FUNC_REPLACE = 134;
    private static final int FUNC_REVERSE = 135;
    private static final int FUNC_RIGHT = 136;
    private static final int FUNC_RTRIM = 137;
    private static final int FUNC_SOUNDEX = 138;
    private static final int FUNC_SPACE = 139;
    private static final int FUNC_SUBSTR = 140;
    private static final int FUNC_DATEADD = 141;
    private static final int FUNC_DATEDIFF = 142;
    private static final int FUNC_SECONDS_MIDNIGHT = 143;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;

    public static FunctionSQL newCustomFunction(String token, int tokenType) {
        int id = customRegularFuncMap.get(tokenType, -1);
        if (id == -1) {
            id = customValueFuncMap.get(tokenType, -1);
        }
        if (id == -1) {
            return null;
        }
        switch (tokenType) {
            case 154: 
            case 431: 
            case 608: 
            case 636: 
            case 647: 
            case 664: 
            case 669: 
            case 671: {
                return new FunctionSQL(id);
            }
            case 646: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = optionalNoParamList;
                return function;
            }
            case 615: 
            case 616: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = emptyParamList;
                return function;
            }
            case 663: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = tripleParamList;
                return function;
            }
        }
        FunctionCustom function = new FunctionCustom(id);
        if (id == 29) {
            switch (tokenType) {
                case 640: {
                    function.extractSpec = 149;
                    break;
                }
                case 657: {
                    function.extractSpec = 284;
                }
            }
        }
        if (id == 5) {
            switch (tokenType) {
                case 623: {
                    function.extractSpec = 621;
                    break;
                }
                case 642: {
                    function.extractSpec = 641;
                    break;
                }
                case 624: {
                    function.extractSpec = 620;
                    break;
                }
                case 625: {
                    function.extractSpec = 621;
                    break;
                }
                case 626: {
                    function.extractSpec = 622;
                    break;
                }
                default: {
                    function.extractSpec = tokenType;
                }
            }
        }
        if (function.name == null) {
            function.name = token;
        }
        return function;
    }

    public static boolean isRegularFunction(int tokenType) {
        return customRegularFuncMap.get(tokenType, -1) != -1;
    }

    public static boolean isValueFunction(int tokenType) {
        return customValueFuncMap.get(tokenType, -1) != -1;
    }

    private FunctionCustom(int id) {
        this.funcType = id;
        switch (id) {
            case 124: 
            case 128: {
                this.parseList = doubleParamList;
                break;
            }
            case 75: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.parseList = emptyParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 29: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 30: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 76: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 78: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{695, 741, 9, 731, 732, 733, 734, 735, 736, 737, 738, 739, 684, 697, 684, 697, 682};
                break;
            }
            case 79: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{695, 741, 9, 731, 732, 733, 734, 735, 736, 737, 738, 739, 684, 697, 684, 697, 682};
                break;
            }
            case 80: {
                this.parseList = doubleParamList;
                break;
            }
            case 81: {
                this.parseList = doubleParamList;
                break;
            }
            case 82: {
                this.name = "TIMESTAMP";
                this.parseList = new short[]{695, 697, 742, 2, 684, 697, 682};
                break;
            }
            case 111: {
                this.parseList = emptyParamList;
                break;
            }
            case 113: {
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 121: 
            case 122: 
            case 123: 
            case 126: 
            case 132: 
            case 135: 
            case 138: 
            case 139: {
                this.parseList = singleParamList;
                break;
            }
            case 114: 
            case 118: 
            case 119: 
            case 120: 
            case 125: 
            case 133: 
            case 136: {
                this.parseList = doubleParamList;
                break;
            }
            case 83: {
                this.parseList = doubleParamList;
                break;
            }
            case 130: {
                this.parseList = new short[]{695, 697, 684, 697, 742, 2, 684, 697, 682};
                break;
            }
            case 134: 
            case 141: 
            case 142: {
                this.parseList = tripleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(401, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] nodes) {
        switch (this.funcType) {
            case 30: {
                Expression start = nodes[1];
                Expression length = nodes[2];
                nodes[1] = nodes[3];
                nodes[2] = start;
                nodes[3] = length;
                break;
            }
            case 5: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), nodes[0]};
                nodes = newNodes;
                break;
            }
            case 29: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), nodes[0]};
                nodes = newNodes;
            }
        }
        super.setArguments(nodes);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 124: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    @Override
    Object getValue(Session session, Object[] data) {
        switch (this.funcType) {
            case 5: 
            case 29: 
            case 30: {
                return super.getValue(session, data);
            }
            case 75: {
                return session.getDatabase().getPath();
            }
            case 71: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 72: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 73: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 74: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 76: {
                Number id = session.getLastIdentity();
                if (id instanceof Long) {
                    return id;
                }
                return ValuePool.getLong(id.longValue());
            }
            case 78: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                long units = ((Number)data[1]).longValue();
                TimestampData source = (TimestampData)data[2];
                switch (part) {
                    case 731: {
                        long seconds = units / 1000000000L;
                        int nanos = (int)(units % 1000000000L);
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 732: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND;
                        IntervalSecondData o = IntervalSecondData.newIntervalSeconds(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 733: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE;
                        IntervalSecondData o = IntervalSecondData.newIntervalMinute(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 734: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR;
                        IntervalSecondData o = IntervalSecondData.newIntervalHour(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 735: {
                        IntervalType t = Type.SQL_INTERVAL_DAY;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 736: {
                        IntervalType t = Type.SQL_INTERVAL_DAY;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units * 7L, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 737: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 738: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 3L, t);
                        return this.dataType.add(source, o, t);
                    }
                    case 739: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units, t);
                        return this.dataType.add(source, o, t);
                    }
                }
                throw Error.runtimeError(401, "FunctionCustom");
            }
            case 79: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                TimestampData a = (TimestampData)data[2];
                TimestampData b = (TimestampData)data[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    a = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, a, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    b = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, b, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (part) {
                    case 731: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(a, b, null);
                        return new Long(1000000000L * interval.getSeconds() + (long)interval.getNanos());
                    }
                    case 732: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 733: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 734: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 735: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 736: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)) / 7L);
                    }
                    case 737: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                    case 738: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)) / 3L);
                    }
                    case 739: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(t.convertToLong(t.subtract(a, b, null)));
                    }
                }
                throw Error.runtimeError(401, "FunctionCustom");
            }
            case 143: {
                if (data[0] == null) {
                    return null;
                }
            }
            case 80: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).truncate(data[0], ((Number)data[1]).intValue());
            }
            case 81: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                String javaPattern = HsqlDateTime.toJavaDatePattern((String)data[1]);
                try {
                    format.applyPattern(javaPattern);
                }
                catch (Exception e) {
                    throw Error.error(3472);
                }
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, data[0]);
                return format.format(date);
            }
            case 82: {
                boolean unary;
                boolean bl = unary = this.nodes[1] == null;
                if (data[0] == null) {
                    return null;
                }
                if (unary) {
                    return Type.SQL_TIMESTAMP.convertToType(session, data[0], this.nodes[0].dataType);
                }
                if (data[1] == null) {
                    return null;
                }
                TimestampData date = (TimestampData)Type.SQL_DATE.convertToType(session, data[0], this.nodes[0].dataType);
                TimeData time = (TimeData)Type.SQL_TIME.convertToType(session, data[1], this.nodes[1].dataType);
                return new TimestampData(date.getSeconds() + (long)time.getSeconds(), time.getNanos());
            }
            case 111: {
                return Math.PI;
            }
            case 113: {
                if (this.nodes[0] == null) {
                    return session.random();
                }
                long seed = ((Number)data[0]).longValue();
                return (double)seed;
            }
            case 101: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.acos(d);
            }
            case 102: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.asin(d);
            }
            case 103: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.atan(d);
            }
            case 105: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.cos(d);
            }
            case 106: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                double c = 1.0 / Math.tan(d);
                return c;
            }
            case 107: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.toDegrees(d);
            }
            case 116: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.sin(d);
            }
            case 117: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.tan(d);
            }
            case 110: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.log10(d);
            }
            case 112: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return Math.toRadians(d);
            }
            case 115: {
                if (data[0] == null) {
                    return null;
                }
                int val = ((NumberType)this.nodes[0].dataType).compareToZero(data[0]);
                return ValuePool.getInt(val);
            }
            case 104: {
                if (data[0] == null) {
                    return null;
                }
                double a = NumberType.toDouble(data[0]);
                double b = NumberType.toDouble(data[1]);
                return Math.atan2(a, b);
            }
            case 122: {
                if (data[0] == null) {
                    return null;
                }
                String arg = this.nodes[0].dataType.isLobType() ? ((ClobData)data[0]).getSubString(session, 0L, 1) : (String)data[0];
                if (arg.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(arg.charAt(0));
            }
            case 123: {
                if (data[0] == null) {
                    return null;
                }
                int arg = ((Number)data[0]).intValue();
                return String.valueOf(arg);
            }
            case 114: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                int i = ((Number)data[1]).intValue();
                d = Library.round(d, i);
                return new Double(d);
            }
            case 121: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                d = Library.roundMagic(d);
                return new Double(d);
            }
            case 138: {
                if (data[0] == null) {
                    return null;
                }
                String s = (String)data[0];
                return Library.soundex(s);
            }
            case 118: 
            case 119: 
            case 120: {
                byte[] v;
                for (int i = 0; i < data.length; ++i) {
                    if (data[0] != null) continue;
                    return null;
                }
                if (this.nodes[0].dataType.isIntegralType()) {
                    long v2 = 0L;
                    long a = ((Number)data[0]).longValue();
                    long b = ((Number)data[1]).longValue();
                    switch (this.funcType) {
                        case 118: {
                            v2 = a & b;
                            break;
                        }
                        case 119: {
                            v2 = a | b;
                            break;
                        }
                        case 120: {
                            v2 = a ^ b;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 25: {
                            return ValuePool.getLong(v2);
                        }
                        case 4: {
                            return ValuePool.getInt((int)v2);
                        }
                        case 5: {
                            return ValuePool.getInt((int)v2 & 0xFFFF);
                        }
                        case -6: {
                            return ValuePool.getInt((int)v2 & 0xFF);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] a = ((BinaryData)data[0]).getBytes();
                byte[] b = ((BinaryData)data[1]).getBytes();
                switch (this.funcType) {
                    case 118: {
                        v = BitMap.and(a, b);
                        break;
                    }
                    case 119: {
                        v = BitMap.or(a, b);
                        break;
                    }
                    case 120: {
                        v = BitMap.xor(a, b);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(v, this.dataType.precision);
            }
            case 125: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[0] != null) continue;
                    return null;
                }
                int v = Library.difference((String)data[0], (String)data[1]);
                return ValuePool.getInt(v);
            }
            case 126: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
            }
            case 132: {
                if (data[0] == null) {
                    return null;
                }
                return this.nodes[0].dataType.convertToString(data[0]);
            }
            case 130: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[0] != null) continue;
                    return null;
                }
                int v = Library.locate((String)data[0], (String)data[1], (Integer)data[2]);
                return ValuePool.getInt(v);
            }
            case 133: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[0] != null) continue;
                    return null;
                }
                return Library.repeat((String)data[0], ValuePool.getInt(((Number)data[1]).intValue()));
            }
            case 134: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[0] != null) continue;
                    return null;
                }
                return Library.replace((String)data[0], (String)data[1], (String)data[2]);
            }
            case 128: 
            case 136: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[0] != null) continue;
                    return null;
                }
                int count = ((Number)data[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, data[0], 0L, count, true, this.funcType == 136);
            }
            case 139: {
                if (data[0] == null) {
                    return null;
                }
                int count = ((Number)data[0]).intValue();
                char[] array = new char[count];
                ArrayUtil.fillArray(array, 0, ' ');
                return String.valueOf(array);
            }
            case 135: {
                if (data[0] == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer((String)data[0]);
                sb = sb.reverse();
                return sb.toString();
            }
            case 83: {
                byte[] bytes = Crypto.getNewKey((String)data[0], (String)data[1]);
                return StringConverter.byteArrayToHexString(bytes);
            }
        }
        throw Error.runtimeError(401, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 5: 
            case 29: 
            case 30: {
                super.resolveTypes(session, parent);
                return;
            }
            case 75: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 76: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 141: {
                int part;
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if ("yy".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 739;
                } else if ("mm".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 737;
                } else if ("dd".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 735;
                } else if ("hh".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 734;
                } else if ("mi".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 733;
                } else if ("ss".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 732;
                } else if ("ms".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 731;
                } else {
                    throw Error.error(5561);
                }
                this.nodes[0].valueData = ValuePool.getInt(part);
                this.funcType = 78;
            }
            case 78: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode != 91 && this.nodes[2].dataType.typeCode != 93 && this.nodes[2].dataType.typeCode != 95) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 142: {
                int part;
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5565);
                }
                if ("yy".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 739;
                } else if ("mm".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 737;
                } else if ("dd".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 735;
                } else if ("hh".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 734;
                } else if ("mi".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 733;
                } else if ("ss".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 732;
                } else if ("ms".equalsIgnoreCase((String)this.nodes[0].valueData)) {
                    part = 731;
                } else {
                    throw Error.error(3472, (String)this.nodes[0].valueData);
                }
                this.nodes[0].valueData = ValuePool.getInt(part);
                this.funcType = 79;
            }
            case 79: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                block33 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode != 91) {
                            throw Error.error(5565);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 735: 
                            case 736: 
                            case 737: 
                            case 738: 
                            case 739: {
                                break block33;
                            }
                        }
                        throw Error.error(5565);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode == 93 || this.nodes[2].dataType.typeCode == 95) break;
                        throw Error.error(5565);
                    }
                    default: {
                        throw Error.error(5565);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 80: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                } else if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5565);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5565);
                }
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 81: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[1].dataType == null || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isExactNumberType() && !this.nodes[0].dataType.isDateTimeType()) {
                    throw Error.error(5565);
                }
                this.dataType = CharacterType.getCharacterType(12, 40L);
                if (this.nodes[1].opType == 1) {
                    this.nodes[1].setAsConstantValue(session);
                }
                return;
            }
            case 82: {
                Type argType = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (argType == null) {
                        argType = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!argType.isCharacterType() && argType.typeCode != 93 && argType.typeCode != 95) {
                        throw Error.error(5561);
                    }
                } else {
                    if (argType == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            argType = this.nodes[1].dataType;
                        } else {
                            argType = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (argType.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (argType.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME;
                        }
                    }
                    if (!(argType.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || argType.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 111: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 113: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5565);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 114: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 112: 
            case 116: 
            case 117: 
            case 121: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 115: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 104: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 138: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.getType(12, 0, 4L, 0);
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType != null) continue;
                    this.nodes[i].dataType = Type.SQL_INTEGER;
                }
                this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 122: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.getType(12, 0, 1L, 0);
                break;
            }
            case 125: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 126: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : Type.getType(61, 0, this.nodes[0].dataType.precision / 2L, 0);
                break;
            }
            case 132: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : Type.getType(12, 0, this.nodes[0].dataType.precision * 2L, 0);
                break;
            }
            case 130: {
                boolean isChar;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                boolean bl = isChar = this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType();
                if (!isChar || !this.nodes[2].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 133: {
                boolean isChar;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!(isChar = this.nodes[0].dataType.isCharacterType()) && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = isChar ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 134: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 128: 
            case 136: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : Type.getType(12, 0, this.nodes[0].dataType.precision, 0);
                break;
            }
            case 139: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 135: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 83: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            default: {
                throw Error.runtimeError(401, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 5: 
            case 29: 
            case 30: {
                return super.getSQL();
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 76: {
                return new StringBuffer("IDENTITY").append("(").append(")").toString();
            }
            case 78: {
                return new StringBuffer("TIMESTAMPADD").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 79: {
                return new StringBuffer("TIMESTAMPDIFF").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 80: {
                return new StringBuffer("TRUNCATE").append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 81: {
                return new StringBuffer("TO_CHAR").append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 111: 
            case 113: {
                return new StringBuffer(this.name).append('(').append(')').toString();
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 121: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 114: {
                return new StringBuffer(655).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 83: {
                return new StringBuffer(614).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
        }
        return super.getSQL();
    }

    static {
        customRegularFuncMap.put(431, 7);
        customRegularFuncMap.put(608, 6);
        customRegularFuncMap.put(647, 8);
        customRegularFuncMap.put(636, 24);
        customRegularFuncMap.put(671, 25);
        customRegularFuncMap.put(638, 12);
        customRegularFuncMap.put(615, 41);
        customRegularFuncMap.put(616, 44);
        customRegularFuncMap.put(663, 21);
        customRegularFuncMap.put(614, 83);
        customRegularFuncMap.put(321, 5);
        customRegularFuncMap.put(171, 5);
        customRegularFuncMap.put(72, 5);
        customRegularFuncMap.put(126, 5);
        customRegularFuncMap.put(167, 5);
        customRegularFuncMap.put(248, 5);
        customRegularFuncMap.put(623, 5);
        customRegularFuncMap.put(642, 5);
        customRegularFuncMap.put(624, 5);
        customRegularFuncMap.put(625, 5);
        customRegularFuncMap.put(626, 5);
        customRegularFuncMap.put(649, 5);
        customRegularFuncMap.put(672, 5);
        customRegularFuncMap.put(658, 5);
        customRegularFuncMap.put(640, 29);
        customRegularFuncMap.put(657, 29);
        customRegularFuncMap.put(151, 128);
        customRegularFuncMap.put(127, 76);
        customRegularFuncMap.put(666, 78);
        customRegularFuncMap.put(667, 79);
        customRegularFuncMap.put(293, 80);
        customRegularFuncMap.put(668, 81);
        customRegularFuncMap.put(280, 82);
        customRegularFuncMap.put(637, 130);
        customRegularFuncMap.put(133, 30);
        customRegularFuncMap.put(654, 135);
        customRegularFuncMap.put(564, 75);
        customRegularFuncMap.put(632, 71);
        customRegularFuncMap.put(635, 72);
        customRegularFuncMap.put(633, 73);
        customRegularFuncMap.put(634, 74);
        customRegularFuncMap.put(601, 101);
        customRegularFuncMap.put(603, 102);
        customRegularFuncMap.put(604, 103);
        customRegularFuncMap.put(605, 104);
        customRegularFuncMap.put(612, 105);
        customRegularFuncMap.put(613, 106);
        customRegularFuncMap.put(627, 107);
        customRegularFuncMap.put(639, 110);
        customRegularFuncMap.put(648, 111);
        customRegularFuncMap.put(650, 112);
        customRegularFuncMap.put(651, 113);
        customRegularFuncMap.put(655, 114);
        customRegularFuncMap.put(659, 115);
        customRegularFuncMap.put(660, 116);
        customRegularFuncMap.put(665, 117);
        customRegularFuncMap.put(607, 118);
        customRegularFuncMap.put(609, 119);
        customRegularFuncMap.put(610, 120);
        customRegularFuncMap.put(656, 121);
        customRegularFuncMap.put(602, 122);
        customRegularFuncMap.put(32, 123);
        customRegularFuncMap.put(611, 124);
        customRegularFuncMap.put(628, 125);
        customRegularFuncMap.put(630, 126);
        customRegularFuncMap.put(652, 132);
        customRegularFuncMap.put(232, 133);
        customRegularFuncMap.put(653, 134);
        customRegularFuncMap.put(238, 136);
        customRegularFuncMap.put(661, 138);
        customRegularFuncMap.put(512, 139);
        customRegularFuncMap.put(617, 141);
        customRegularFuncMap.put(618, 142);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(664, 50);
        customValueFuncMap.put(669, 41);
        customValueFuncMap.put(646, 50);
    }
}

