/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.hsqldb.util.preprocessor.AntResolver;
import org.hsqldb.util.preprocessor.Option;
import org.hsqldb.util.preprocessor.Preprocessor;

public class PreprocessorAntTask
extends MatchingTask {
    private String ifExpr;
    private String unlessExpr;
    private File sourceDir;
    private File targetDir;
    private String defines;
    private String altExt;
    private String encoding;
    private int options = 4;

    public void init() {
        super.init();
    }

    public void setSrcdir(File value) {
        this.sourceDir = value;
    }

    public void setTargetdir(File value) {
        this.targetDir = value;
    }

    public void setSymbols(String value) {
        this.defines = value;
    }

    public void setVerbose(boolean verbose) {
        this.options = Option.setVerbose(this.options, verbose);
    }

    public void setBackup(boolean backup) {
        this.options = Option.setBackup(this.options, backup);
    }

    public void setIndent(boolean indent) {
        this.options = Option.setIndent(this.options, indent);
    }

    public void setTestonly(boolean testOnly) {
        this.options = Option.setTestOnly(this.options, testOnly);
    }

    public void setFilter(boolean filter) {
        this.options = Option.setFilter(this.options, filter);
    }

    public void setAltext(String ext) {
        this.altExt = ext;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIf(String expr) {
        this.ifExpr = expr;
    }

    public void setUnless(String expr) {
        this.unlessExpr = expr;
    }

    public boolean isActive() {
        return this.ifExpr == null || this.getProject().getProperty(this.ifExpr) != null || this.unlessExpr == null || this.getProject().getProperty(this.unlessExpr) == null;
    }

    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        this.checkTargetDir();
        this.sourceDir = this.getProject().resolveFile("" + this.sourceDir);
        AntResolver resolver = new AntResolver(this.getProject());
        String[] files = this.getFiles();
        this.log("Preprocessing " + files.length + " file(s)");
        try {
            Preprocessor.preprocessBatch(this.sourceDir, this.targetDir, files, this.altExt, this.encoding, this.options, this.defines, resolver);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BuildException("Preprocessing failed: " + ex, (Throwable)ex);
        }
    }

    private String[] getFiles() {
        return this.getDirectoryScanner(this.sourceDir).getIncludedFiles();
    }

    private void checkTargetDir() throws BuildException {
        if (this.targetDir == null) {
            throw new BuildException("Target directory required.");
        }
    }
}

