/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

import org.hsqldb.util.preprocessor.Defines;
import org.hsqldb.util.preprocessor.PreprocessorException;
import org.hsqldb.util.preprocessor.Token;
import org.hsqldb.util.preprocessor.Tokenizer;

class Parser {
    Defines defines;
    Tokenizer tokenizer;

    Parser(Defines defines, Tokenizer tokenizer) {
        this.defines = defines;
        this.tokenizer = tokenizer;
    }

    boolean parseExpression() throws PreprocessorException {
        boolean result = this.parseTerm();
        block4: while (true) {
            switch (this.tokenizer.getTokenType()) {
                case 124: {
                    this.tokenizer.next();
                    result |= this.parseTerm();
                    continue block4;
                }
                case 94: {
                    this.tokenizer.next();
                    result ^= this.parseTerm();
                    continue block4;
                }
            }
            break;
        }
        return result;
    }

    boolean parseTerm() throws PreprocessorException {
        boolean result = this.parseFactor();
        while (this.tokenizer.isToken(38)) {
            this.tokenizer.next();
            result &= this.parseFactor();
        }
        return result;
    }

    boolean parseFactor() throws PreprocessorException {
        boolean result;
        switch (this.tokenizer.getTokenType()) {
            case 1: {
                String ident = this.tokenizer.getIdent();
                int type = this.tokenizer.next();
                if (type == -1 || type == 41 || Token.isLogicalOperator(type)) {
                    result = this.defines.isDefined(ident);
                    break;
                }
                if (Token.isComparisonOperator(type)) {
                    result = this.parseComparison(ident, type);
                    break;
                }
                throw new PreprocessorException("Logical or comparison operator token required at position " + this.tokenizer.getStartIndex() + " in [" + this.tokenizer.getSource() + "]");
            }
            case 33: {
                this.tokenizer.next();
                result = !this.parseFactor();
                break;
            }
            case 40: {
                this.tokenizer.next();
                result = this.parseExpression();
                if (!this.tokenizer.isToken(41)) {
                    throw new PreprocessorException("RPAREN token required at position " + this.tokenizer.getStartIndex() + " in [" + this.tokenizer.getSource() + "]");
                }
                this.tokenizer.next();
                break;
            }
            default: {
                throw new PreprocessorException("IDENT, NOT or LPAREN token required at position " + this.tokenizer.getStartIndex() + " in [" + this.tokenizer.getSource() + "]");
            }
        }
        return result;
    }

    boolean parseComparison(String ident, int opType) throws PreprocessorException {
        boolean result;
        Object lhs = this.defines.getDefintion(ident);
        int pos = this.tokenizer.getStartIndex();
        Object rhs = this.parseValue();
        if (lhs == null) {
            throw new PreprocessorException("IDENT " + ident + " is not defined at position" + pos + "in [" + this.tokenizer.getSource() + "]");
        }
        switch (opType) {
            case 122: {
                result = Parser.compare(lhs, rhs) == 0;
                break;
            }
            case 60: {
                result = Parser.compare(lhs, rhs) < 0;
                break;
            }
            case 121: {
                result = Parser.compare(lhs, rhs) <= 0;
                break;
            }
            case 62: {
                result = Parser.compare(lhs, rhs) > 0;
                break;
            }
            case 123: {
                result = Parser.compare(lhs, rhs) >= 0;
                break;
            }
            default: {
                throw new PreprocessorException("Internal error");
            }
        }
        this.tokenizer.next();
        return result;
    }

    static int compare(Object o1, Object o2) {
        if (o1 instanceof Comparable) {
            return o1.getClass().isAssignableFrom(o2.getClass()) ? ((Comparable)o1).compareTo(o2) : String.valueOf(o1).compareTo(String.valueOf(o2));
        }
        return o1.toString().compareTo(o2.toString());
    }

    Object parseValue() throws PreprocessorException {
        Object value;
        switch (this.tokenizer.next()) {
            case 1: {
                String ident = this.tokenizer.getIdent();
                value = this.defines.getDefintion(ident);
                if (value != null) break;
                throw new PreprocessorException("IDENT " + ident + " is not defined at position" + this.tokenizer.getStartIndex() + "in [" + this.tokenizer.getSource() + "]");
            }
            case 3: {
                value = this.tokenizer.getString();
                break;
            }
            case 2: {
                value = this.tokenizer.getNumber();
                break;
            }
            default: {
                throw new PreprocessorException("IDENT, STRINGor NUMBER token required at position " + this.tokenizer.getStartIndex() + " in: [" + this.tokenizer.getSource() + "]");
            }
        }
        return value;
    }
}

