/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.IOException;
import java.io.Reader;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.ClobData;

public final class ClobInputStream
extends Reader {
    final ClobData clob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    char[] buffer;
    boolean isClosed;
    SessionInterface session;

    public ClobInputStream(SessionInterface session, ClobData clob, long offset, long length) {
        long clobLength = clob.length(session);
        if (!ClobInputStream.isInLimits(clobLength, offset, length)) {
            throw new IndexOutOfBoundsException();
        }
        this.clob = clob;
        this.availableLength = offset + length;
        this.currentPosition = offset;
        this.session = session;
    }

    @Override
    public int read() throws IOException {
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (HsqlException e) {
                throw JavaSystem.toIOException(e);
            }
        }
        int val = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return val;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkClosed();
        if (this.currentPosition + (long)len >= this.availableLength) {
            return -1;
        }
        for (int i = off; i < len; ++i) {
            cbuf[i] = (char)this.read();
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (this.currentPosition + n > this.availableLength) {
            n = this.availableLength - this.currentPosition;
        }
        this.currentPosition += n;
        return n;
    }

    public int available() {
        return (int)(this.bufferOffset + (long)this.buffer.length - this.currentPosition);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(Error.getMessage(3475));
        }
    }

    private void readIntoBuffer() {
        long readLength = this.availableLength - this.currentPosition;
        if (readLength <= 0L) {
            // empty if block
        }
        if (readLength > (long)this.session.getStreamBlockSize()) {
            readLength = this.session.getStreamBlockSize();
        }
        this.buffer = this.clob.getChars(this.session, this.currentPosition, (int)readLength);
        this.bufferOffset = this.currentPosition;
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }
}

