/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.BlobData;

public class BlobInputStream
extends InputStream {
    final BlobData blob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    byte[] buffer;
    boolean isClosed;
    SessionInterface session;

    public BlobInputStream(SessionInterface session, BlobData blob, long offset, long length) {
        if (!BlobInputStream.isInLimits(blob.length(session), offset, length)) {
            throw new IndexOutOfBoundsException();
        }
        this.blob = blob;
        this.availableLength = offset + length;
        this.currentPosition = offset;
    }

    @Override
    public int read() throws IOException {
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.checkClosed();
                this.readIntoBuffer();
            }
            catch (HsqlException e) {
                throw JavaSystem.toIOException(e);
            }
        }
        int val = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return val;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (this.currentPosition + n > this.availableLength) {
            n = this.availableLength - this.currentPosition;
        }
        this.currentPosition += n;
        return n;
    }

    @Override
    public int available() {
        return (int)(this.bufferOffset + (long)this.buffer.length - this.currentPosition);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() {
        if (this.isClosed || this.blob.isClosed()) {
            throw Error.error(3475);
        }
    }

    private void readIntoBuffer() {
        long readLength = this.availableLength - this.currentPosition;
        if (readLength <= 0L) {
            // empty if block
        }
        if (readLength > (long)this.session.getStreamBlockSize()) {
            readLength = this.session.getStreamBlockSize();
        }
        this.buffer = this.blob.getBytes(this.session, this.currentPosition, (int)readLength);
        this.bufferOffset = this.currentPosition;
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }
}

