/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.Iterator;
import org.hsqldb.store.HashIndex;

public class BaseHashMap {
    boolean isIntKey;
    boolean isLongKey;
    boolean isObjectKey;
    boolean isNoValue;
    boolean isIntValue;
    boolean isLongValue;
    boolean isObjectValue;
    protected boolean isList;
    private ValuesIterator valuesIterator;
    protected HashIndex hashIndex;
    protected int[] intKeyTable;
    protected Object[] objectKeyTable;
    protected long[] longKeyTable;
    protected int[] intValueTable;
    protected Object[] objectValueTable;
    protected long[] longValueTable;
    int accessMin;
    protected int accessCount;
    protected int[] accessTable;
    protected boolean[] multiValueTable;
    final float loadFactor;
    final int initialCapacity;
    int threshold;
    protected int maxCapacity;
    protected int purgePolicy = 0;
    protected boolean minimizeOnEmpty;
    boolean hasZeroKey;
    int zeroKeyIndex = -1;
    protected static final int noKeyOrValue = 0;
    protected static final int intKeyOrValue = 1;
    protected static final int longKeyOrValue = 2;
    protected static final int objectKeyOrValue = 3;
    protected static final int NO_PURGE = 0;
    protected static final int PURGE_ALL = 1;
    protected static final int PURGE_HALF = 2;
    protected static final int PURGE_QUARTER = 3;

    protected BaseHashMap(int initialCapacity, int keyType, int valueType, boolean hasAccessCount) throws IllegalArgumentException {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < 3) {
            initialCapacity = 3;
        }
        this.loadFactor = 1.0f;
        this.initialCapacity = initialCapacity;
        this.threshold = initialCapacity;
        int hashtablesize = (int)((float)initialCapacity * this.loadFactor);
        if (hashtablesize < 3) {
            hashtablesize = 3;
        }
        this.hashIndex = new HashIndex(hashtablesize, initialCapacity, true);
        int arraySize = this.threshold;
        if (keyType == 1) {
            this.isIntKey = true;
            this.intKeyTable = new int[arraySize];
        } else if (keyType == 3) {
            this.isObjectKey = true;
            this.objectKeyTable = new Object[arraySize];
        } else {
            this.isLongKey = true;
            this.longKeyTable = new long[arraySize];
        }
        if (valueType == 1) {
            this.isIntValue = true;
            this.intValueTable = new int[arraySize];
        } else if (valueType == 3) {
            this.isObjectValue = true;
            this.objectValueTable = new Object[arraySize];
        } else if (valueType == 2) {
            this.isLongValue = true;
            this.longValueTable = new long[arraySize];
        } else {
            this.isNoValue = true;
        }
        if (hasAccessCount) {
            this.accessTable = new int[arraySize];
        }
    }

    protected int getLookup(Object key, int hash) {
        int lookup = this.hashIndex.getLookup(hash);
        while (lookup >= 0) {
            Object tempKey = this.objectKeyTable[lookup];
            if (key.equals(tempKey)) {
                return lookup;
            }
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return lookup;
    }

    protected int getLookup(int key) {
        int lookup = this.hashIndex.getLookup(key);
        while (lookup >= 0) {
            int tempKey = this.intKeyTable[lookup];
            if (key == tempKey) {
                return lookup;
            }
            lookup = this.hashIndex.linkTable[lookup];
        }
        return lookup;
    }

    protected int getLookup(long key) {
        int lookup = this.hashIndex.getLookup((int)key);
        while (lookup >= 0) {
            long tempKey = this.longKeyTable[lookup];
            if (key == tempKey) {
                return lookup;
            }
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return lookup;
    }

    protected Iterator getValuesIterator(Object key, int hash) {
        int lookup = this.getLookup(key, hash);
        if (this.valuesIterator == null) {
            this.valuesIterator = new ValuesIterator();
        }
        this.valuesIterator.reset(key, lookup);
        return this.valuesIterator;
    }

    protected Object addOrRemove(long longKey, long longValue, Object objectKey, Object objectValue, boolean remove) {
        int hash = (int)longKey;
        if (this.isObjectKey) {
            if (objectKey == null) {
                return null;
            }
            hash = objectKey.hashCode();
        }
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        Object returnValue = null;
        while (lookup >= 0 && !(this.isObjectKey ? this.objectKeyTable[lookup].equals(objectKey) : (this.isIntKey ? longKey == (long)this.intKeyTable[lookup] : this.isLongKey && longKey == this.longKeyTable[lookup]))) {
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (lookup >= 0) {
            if (remove) {
                if (this.isObjectKey) {
                    this.objectKeyTable[lookup] = null;
                } else {
                    if (longKey == 0L) {
                        this.hasZeroKey = false;
                        this.zeroKeyIndex = -1;
                    }
                    if (this.isIntKey) {
                        this.intKeyTable[lookup] = 0;
                    } else {
                        this.longKeyTable[lookup] = 0L;
                    }
                }
                if (this.isObjectValue) {
                    returnValue = this.objectValueTable[lookup];
                    this.objectValueTable[lookup] = null;
                } else if (this.isIntValue) {
                    this.intValueTable[lookup] = 0;
                } else if (this.isLongValue) {
                    this.longValueTable[lookup] = 0L;
                }
                this.hashIndex.unlinkNode(index, lastLookup, lookup);
                if (this.accessTable != null) {
                    this.accessTable[lookup] = 0;
                }
                if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
                    this.rehash(this.initialCapacity);
                }
                return returnValue;
            }
            if (this.isObjectValue) {
                returnValue = this.objectValueTable[lookup];
                this.objectValueTable[lookup] = objectValue;
            } else if (this.isIntValue) {
                this.intValueTable[lookup] = (int)longValue;
            } else if (this.isLongValue) {
                this.longValueTable[lookup] = longValue;
            }
            if (this.accessTable != null) {
                ++this.accessCount;
            }
            return returnValue;
        }
        if (remove) {
            return null;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemove(longKey, longValue, objectKey, objectValue, remove);
            }
            return null;
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        if (this.isObjectKey) {
            this.objectKeyTable[lookup] = objectKey;
        } else if (this.isIntKey) {
            this.intKeyTable[lookup] = (int)longKey;
            if (longKey == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = lookup;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[lookup] = longKey;
            if (longKey == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = lookup;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[lookup] = objectValue;
        } else if (this.isIntValue) {
            this.intValueTable[lookup] = (int)longValue;
        } else if (this.isLongValue) {
            this.longValueTable[lookup] = longValue;
        }
        if (this.accessTable != null) {
            ++this.accessCount;
        }
        return returnValue;
    }

    protected Object addOrRemoveMultiVal(long longKey, long longValue, Object objectKey, Object objectValue, boolean removeKey, boolean removeValue) {
        int hash = (int)longKey;
        if (this.isObjectKey) {
            if (objectKey == null) {
                return null;
            }
            hash = objectKey.hashCode();
        }
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        Object returnValue = null;
        boolean multiValue = false;
        while (lookup >= 0) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[lookup].equals(objectKey)) {
                    if (removeKey) {
                        do {
                            this.objectKeyTable[lookup] = null;
                            returnValue = this.objectValueTable[lookup];
                            this.objectValueTable[lookup] = null;
                            this.hashIndex.unlinkNode(index, lastLookup, lookup);
                            this.multiValueTable[lookup] = false;
                        } while ((lookup = this.hashIndex.hashTable[index]) >= 0 && this.objectKeyTable[lookup].equals(objectKey));
                        return returnValue;
                    }
                    if (this.objectValueTable[lookup].equals(objectValue)) {
                        if (removeValue) {
                            this.objectKeyTable[lookup] = null;
                            returnValue = this.objectValueTable[lookup];
                            this.objectValueTable[lookup] = null;
                            this.hashIndex.unlinkNode(index, lastLookup, lookup);
                            this.multiValueTable[lookup] = false;
                            lookup = lastLookup;
                            return returnValue;
                        }
                        return this.objectValueTable[lookup];
                    }
                    multiValue = true;
                }
            } else if (this.isIntKey) {
                if (longKey == (long)this.intKeyTable[lookup]) {
                    if (removeKey) {
                        do {
                            if (longKey == 0L) {
                                this.hasZeroKey = false;
                                this.zeroKeyIndex = -1;
                            }
                            this.intKeyTable[lookup] = 0;
                            this.intValueTable[lookup] = 0;
                            this.hashIndex.unlinkNode(index, lastLookup, lookup);
                            this.multiValueTable[lookup] = false;
                        } while ((lookup = this.hashIndex.hashTable[index]) >= 0 && longKey == (long)this.intKeyTable[lookup]);
                        return null;
                    }
                    if ((long)this.intValueTable[lookup] == longValue) {
                        return null;
                    }
                    multiValue = true;
                }
            } else if (this.isLongKey && longKey == this.longKeyTable[lookup]) {
                if (removeKey) {
                    do {
                        if (longKey == 0L) {
                            this.hasZeroKey = false;
                            this.zeroKeyIndex = -1;
                        }
                        this.longKeyTable[lookup] = 0L;
                        this.longValueTable[lookup] = 0L;
                        this.hashIndex.unlinkNode(index, lastLookup, lookup);
                        this.multiValueTable[lookup] = false;
                    } while ((lookup = this.hashIndex.hashTable[index]) >= 0 && longKey == this.longKeyTable[lookup]);
                    return null;
                }
                if ((long)this.intValueTable[lookup] == longValue) {
                    return null;
                }
                multiValue = true;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (removeKey || removeValue) {
            return returnValue;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemoveMultiVal(longKey, longValue, objectKey, objectValue, removeKey, removeValue);
            }
            return null;
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        if (this.isObjectKey) {
            this.objectKeyTable[lookup] = objectKey;
        } else if (this.isIntKey) {
            this.intKeyTable[lookup] = (int)longKey;
            if (longKey == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = lookup;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[lookup] = longKey;
            if (longKey == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = lookup;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[lookup] = objectValue;
        } else if (this.isIntValue) {
            this.intValueTable[lookup] = (int)longValue;
        } else if (this.isLongValue) {
            this.longValueTable[lookup] = longValue;
        }
        if (multiValue) {
            this.multiValueTable[lookup] = true;
        }
        if (this.accessTable != null) {
            ++this.accessCount;
        }
        return returnValue;
    }

    protected Object addOrRemove(int intKey, Object objectValue, boolean remove) {
        int hash = intKey;
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        Object returnValue = null;
        while (lookup >= 0 && intKey != this.intKeyTable[lookup]) {
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (lookup >= 0) {
            if (remove) {
                if (intKey == 0) {
                    this.hasZeroKey = false;
                    this.zeroKeyIndex = -1;
                }
                this.intKeyTable[lookup] = 0;
                returnValue = this.objectValueTable[lookup];
                this.objectValueTable[lookup] = null;
                this.hashIndex.unlinkNode(index, lastLookup, lookup);
                if (this.accessTable != null) {
                    this.accessTable[lookup] = 0;
                }
                return returnValue;
            }
            if (this.isObjectValue) {
                returnValue = this.objectValueTable[lookup];
                this.objectValueTable[lookup] = objectValue;
            }
            if (this.accessTable != null) {
                ++this.accessCount;
            }
            return returnValue;
        }
        if (remove) {
            return returnValue;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemove(intKey, objectValue, remove);
            }
            return null;
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.intKeyTable[lookup] = intKey;
        if (intKey == 0) {
            this.hasZeroKey = true;
            this.zeroKeyIndex = lookup;
        }
        this.objectValueTable[lookup] = objectValue;
        if (this.accessTable != null) {
            ++this.accessCount;
        }
        return returnValue;
    }

    protected Object removeObject(Object objectKey, boolean removeRow) {
        if (objectKey == null) {
            return null;
        }
        int hash = objectKey.hashCode();
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        Object returnValue = null;
        while (lookup >= 0) {
            if (this.objectKeyTable[lookup].equals(objectKey)) {
                this.objectKeyTable[lookup] = null;
                this.hashIndex.unlinkNode(index, lastLookup, lookup);
                if (this.isObjectValue) {
                    returnValue = this.objectValueTable[lookup];
                    this.objectValueTable[lookup] = null;
                }
                if (removeRow) {
                    this.removeRow(lookup);
                }
                return returnValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        return returnValue;
    }

    protected boolean reset() {
        if (this.maxCapacity == 0 || this.maxCapacity > this.threshold) {
            this.rehash(this.hashIndex.linkTable.length * 2);
            return true;
        }
        if (this.purgePolicy == 1) {
            this.clear();
            return true;
        }
        if (this.purgePolicy == 3) {
            this.clear(this.threshold / 4, this.threshold >> 8);
            return true;
        }
        if (this.purgePolicy == 2) {
            this.clear(this.threshold / 2, this.threshold >> 8);
            return true;
        }
        if (this.purgePolicy == 0) {
            return false;
        }
        return false;
    }

    protected void rehash(int newCapacity) {
        int limitLookup = this.hashIndex.newNodePointer;
        boolean oldZeroKey = this.hasZeroKey;
        int oldZeroKeyIndex = this.zeroKeyIndex;
        if (newCapacity < this.hashIndex.elementCount) {
            return;
        }
        this.hashIndex.reset((int)((float)newCapacity * this.loadFactor), newCapacity);
        if (this.multiValueTable != null) {
            int counter = this.multiValueTable.length;
            while (--counter >= 0) {
                this.multiValueTable[counter] = false;
            }
        }
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.threshold = newCapacity;
        int lookup = -1;
        while ((lookup = this.nextLookup(lookup, limitLookup, oldZeroKey, oldZeroKeyIndex)) < limitLookup) {
            long longKey = 0L;
            long longValue = 0L;
            Object objectKey = null;
            Object objectValue = null;
            if (this.isObjectKey) {
                objectKey = this.objectKeyTable[lookup];
            } else {
                longKey = this.isIntKey ? (long)this.intKeyTable[lookup] : this.longKeyTable[lookup];
            }
            if (this.isObjectValue) {
                objectValue = this.objectValueTable[lookup];
            } else if (this.isIntValue) {
                longValue = this.intValueTable[lookup];
            } else if (this.isLongValue) {
                longValue = this.longValueTable[lookup];
            }
            if (this.multiValueTable == null) {
                this.addOrRemove(longKey, longValue, objectKey, objectValue, false);
            } else {
                this.addOrRemoveMultiVal(longKey, longValue, objectKey, objectValue, false, false);
            }
            if (this.accessTable == null) continue;
            this.accessTable[this.hashIndex.elementCount - 1] = this.accessTable[lookup];
        }
        this.resizeElementArrays(this.hashIndex.newNodePointer, newCapacity);
    }

    private void resizeElementArrays(int dataLength, int newLength) {
        Object[] temp;
        int usedLength;
        int n = usedLength = newLength > dataLength ? dataLength : newLength;
        if (this.isIntKey) {
            temp = this.intKeyTable;
            this.intKeyTable = new int[newLength];
            System.arraycopy(temp, 0, this.intKeyTable, 0, usedLength);
        }
        if (this.isIntValue) {
            temp = this.intValueTable;
            this.intValueTable = new int[newLength];
            System.arraycopy(temp, 0, this.intValueTable, 0, usedLength);
        }
        if (this.isLongKey) {
            temp = this.longKeyTable;
            this.longKeyTable = new long[newLength];
            System.arraycopy(temp, 0, this.longKeyTable, 0, usedLength);
        }
        if (this.isLongValue) {
            temp = this.longValueTable;
            this.longValueTable = new long[newLength];
            System.arraycopy(temp, 0, this.longValueTable, 0, usedLength);
        }
        if (this.isObjectKey) {
            temp = this.objectKeyTable;
            this.objectKeyTable = new Object[newLength];
            System.arraycopy(temp, 0, this.objectKeyTable, 0, usedLength);
        }
        if (this.isObjectValue) {
            temp = this.objectValueTable;
            this.objectValueTable = new Object[newLength];
            System.arraycopy(temp, 0, this.objectValueTable, 0, usedLength);
        }
        if (this.accessTable != null) {
            temp = this.accessTable;
            this.accessTable = new int[newLength];
            System.arraycopy(temp, 0, this.accessTable, 0, usedLength);
        }
        if (this.multiValueTable != null) {
            temp = this.multiValueTable;
            this.multiValueTable = new boolean[newLength];
            System.arraycopy(temp, 0, this.multiValueTable, 0, usedLength);
        }
    }

    private void clearElementArrays(int from, int to) {
        int counter;
        if (this.isIntKey) {
            counter = to;
            while (--counter >= from) {
                this.intKeyTable[counter] = 0;
            }
        } else if (this.isLongKey) {
            counter = to;
            while (--counter >= from) {
                this.longKeyTable[counter] = 0L;
            }
        } else if (this.isObjectKey) {
            counter = to;
            while (--counter >= from) {
                this.objectKeyTable[counter] = null;
            }
        }
        if (this.isIntValue) {
            counter = to;
            while (--counter >= from) {
                this.intValueTable[counter] = 0;
            }
        } else if (this.isLongValue) {
            counter = to;
            while (--counter >= from) {
                this.longValueTable[counter] = 0L;
            }
        } else if (this.isObjectValue) {
            counter = to;
            while (--counter >= from) {
                this.objectValueTable[counter] = null;
            }
        }
        if (this.accessTable != null) {
            counter = to;
            while (--counter >= from) {
                this.accessTable[counter] = 0;
            }
        }
        if (this.multiValueTable != null) {
            counter = to;
            while (--counter >= from) {
                this.multiValueTable[counter] = false;
            }
        }
    }

    void removeFromElementArrays(int lookup) {
        Object[] array;
        int arrayLength = this.hashIndex.linkTable.length;
        if (this.isIntKey) {
            array = this.intKeyTable;
            System.arraycopy(array, lookup + 1, array, lookup, arrayLength - lookup - 1);
            this.intKeyTable[arrayLength - 1] = 0;
        }
        if (this.isLongKey) {
            array = this.longKeyTable;
            System.arraycopy(array, lookup + 1, array, lookup, arrayLength - lookup - 1);
            this.longKeyTable[arrayLength - 1] = 0L;
        }
        if (this.isObjectKey) {
            array = this.objectKeyTable;
            System.arraycopy(array, lookup + 1, array, lookup, arrayLength - lookup - 1);
            this.objectKeyTable[arrayLength - 1] = null;
        }
        if (this.isIntValue) {
            array = this.intValueTable;
            System.arraycopy(array, lookup + 1, array, lookup, arrayLength - lookup - 1);
            this.intValueTable[arrayLength - 1] = 0;
        }
        if (this.isLongValue) {
            array = this.longValueTable;
            System.arraycopy(array, lookup + 1, array, lookup, arrayLength - lookup - 1);
            this.longValueTable[arrayLength - 1] = 0L;
        }
        if (this.isObjectValue) {
            array = this.objectValueTable;
            System.arraycopy(array, lookup + 1, array, lookup, arrayLength - lookup - 1);
            this.objectValueTable[arrayLength - 1] = null;
        }
    }

    int nextLookup(int lookup, int limitLookup, boolean hasZeroKey, int zeroKeyIndex) {
        ++lookup;
        while (lookup < limitLookup) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[lookup] != null) {
                    return lookup;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[lookup] != 0) {
                    return lookup;
                }
                if (hasZeroKey && lookup == zeroKeyIndex) {
                    return lookup;
                }
            } else {
                if (this.longKeyTable[lookup] != 0L) {
                    return lookup;
                }
                if (hasZeroKey && lookup == zeroKeyIndex) {
                    return lookup;
                }
            }
            ++lookup;
        }
        return lookup;
    }

    protected int nextLookup(int lookup) {
        ++lookup;
        while (lookup < this.hashIndex.newNodePointer) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[lookup] != null) {
                    return lookup;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[lookup] != 0) {
                    return lookup;
                }
                if (this.hasZeroKey && lookup == this.zeroKeyIndex) {
                    return lookup;
                }
            } else {
                if (this.longKeyTable[lookup] != 0L) {
                    return lookup;
                }
                if (this.hasZeroKey && lookup == this.zeroKeyIndex) {
                    return lookup;
                }
            }
            ++lookup;
        }
        return -1;
    }

    protected void removeRow(int lookup) {
        this.hashIndex.removeEmptyNode(lookup);
        this.removeFromElementArrays(lookup);
    }

    public void clear() {
        if (this.hashIndex.modified) {
            this.accessMin = this.accessCount = 0;
            this.hasZeroKey = false;
            this.zeroKeyIndex = -1;
            this.clearElementArrays(0, this.hashIndex.linkTable.length);
            this.hashIndex.clear();
            if (this.minimizeOnEmpty) {
                this.rehash(this.initialCapacity);
            }
        }
    }

    public int getAccessCountCeiling(int count, int margin) {
        return ArrayCounter.rank(this.accessTable, this.hashIndex.newNodePointer, count, this.accessMin + 1, this.accessCount, margin);
    }

    public void setAccessCountFloor(int count) {
        this.accessMin = count;
    }

    public int incrementAccessCount() {
        return ++this.accessCount;
    }

    protected void clear(int count, int margin) {
        if (margin < 64) {
            margin = 64;
        }
        int maxlookup = this.hashIndex.newNodePointer;
        int accessBase = this.getAccessCountCeiling(count, margin);
        for (int lookup = 0; lookup < maxlookup; ++lookup) {
            Object o = this.objectKeyTable[lookup];
            if (o == null || this.accessTable[lookup] >= accessBase) continue;
            this.removeObject(o, false);
        }
        this.accessMin = accessBase;
    }

    protected void resetAccessCount() {
        if (this.accessCount < Integer.MAX_VALUE) {
            return;
        }
        this.accessMin >>= 2;
        this.accessCount >>= 2;
        int i = this.accessTable.length;
        while (--i >= 0) {
            int n = i;
            this.accessTable[n] = this.accessTable[n] >> 2;
        }
    }

    public int capacity() {
        return this.hashIndex.linkTable.length;
    }

    public int size() {
        return this.hashIndex.elementCount;
    }

    public boolean isEmpty() {
        return this.hashIndex.elementCount == 0;
    }

    protected boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        int lookup = this.getLookup(key, key.hashCode());
        return lookup != -1;
    }

    protected boolean containsKey(int key) {
        int lookup = this.getLookup(key);
        return lookup != -1;
    }

    protected boolean containsKey(long key) {
        int lookup = this.getLookup(key);
        return lookup != -1;
    }

    protected boolean containsValue(Object value) {
        int lookup;
        if (value == null) {
            for (lookup = 0; lookup < this.hashIndex.newNodePointer; ++lookup) {
                if (this.objectValueTable[lookup] != null) continue;
                if (this.isObjectKey) {
                    if (this.objectKeyTable[lookup] == null) continue;
                    return true;
                }
                if (this.isIntKey) {
                    if (this.intKeyTable[lookup] != 0) {
                        return true;
                    }
                    if (!this.hasZeroKey || lookup != this.zeroKeyIndex) continue;
                    return true;
                }
                if (this.longKeyTable[lookup] != 0L) {
                    return true;
                }
                if (!this.hasZeroKey || lookup != this.zeroKeyIndex) continue;
                return true;
            }
        } else {
            while (lookup < this.hashIndex.newNodePointer) {
                if (value.equals(this.objectValueTable[lookup])) {
                    return true;
                }
                ++lookup;
            }
        }
        return false;
    }

    protected class BaseHashIterator
    implements Iterator {
        boolean keys;
        int lookup = -1;
        int counter;
        boolean removed;

        public BaseHashIterator() {
        }

        public BaseHashIterator(boolean keys) {
            this.keys = keys;
        }

        @Override
        public boolean hasNext() {
            return this.counter < BaseHashMap.this.hashIndex.elementCount;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isObjectKey || !this.keys && !BaseHashMap.this.isObjectValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.objectKeyTable[this.lookup];
                }
                return BaseHashMap.this.objectValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isIntKey || !this.keys && !BaseHashMap.this.isIntValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.intKeyTable[this.lookup];
                }
                return BaseHashMap.this.intValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            if (!BaseHashMap.this.isLongKey || !this.keys) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.longKeyTable[this.lookup];
                }
                return BaseHashMap.this.longValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            if (this.removed) {
                throw new NoSuchElementException("Hash Iterator");
            }
            --this.counter;
            this.removed = true;
            if (BaseHashMap.this.isObjectKey) {
                if (BaseHashMap.this.multiValueTable == null) {
                    BaseHashMap.this.addOrRemove(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], null, true);
                } else if (this.keys) {
                    BaseHashMap.this.addOrRemoveMultiVal(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], null, true, false);
                } else {
                    BaseHashMap.this.addOrRemoveMultiVal(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], BaseHashMap.this.objectValueTable[this.lookup], false, true);
                }
            } else if (BaseHashMap.this.isIntKey) {
                BaseHashMap.this.addOrRemove(BaseHashMap.this.intKeyTable[this.lookup], 0L, null, null, true);
            } else {
                BaseHashMap.this.addOrRemove(BaseHashMap.this.longKeyTable[this.lookup], 0L, null, null, true);
            }
            if (BaseHashMap.this.isList) {
                --this.lookup;
            }
        }

        @Override
        public void setValue(Object value) {
            if (this.keys) {
                throw new NoSuchElementException();
            }
            BaseHashMap.this.objectValueTable[this.lookup] = value;
        }

        public int getAccessCount() {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            return BaseHashMap.this.accessTable[this.lookup];
        }

        public int getLookup() {
            return this.lookup;
        }
    }

    protected class MultiValueKeyIterator
    implements Iterator {
        boolean keys;
        int lookup = -1;
        int counter;
        boolean removed;

        public MultiValueKeyIterator() {
            this.toNextLookup();
        }

        private void toNextLookup() {
            do {
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
            } while (this.lookup != -1 && BaseHashMap.this.multiValueTable[this.lookup]);
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            Object value = BaseHashMap.this.objectKeyTable[this.lookup];
            this.toNextLookup();
            return value;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void setValue(Object value) {
            throw new NoSuchElementException("Hash Iterator");
        }
    }

    protected class ValuesIterator
    implements Iterator {
        int lookup = -1;
        Object key;

        protected ValuesIterator() {
        }

        private void reset(Object key, int lookup) {
            this.key = key;
            this.lookup = lookup;
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.lookup == -1) {
                return null;
            }
            Object value = BaseHashMap.this.objectValueTable[this.lookup];
            do {
                this.lookup = BaseHashMap.this.hashIndex.getNextLookup(this.lookup);
            } while (this.lookup != -1 && !BaseHashMap.this.objectKeyTable[this.lookup].equals(this.key));
            return value;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void setValue(Object value) {
            throw new NoSuchElementException("Hash Iterator");
        }
    }
}

