/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;

public abstract class ScriptWriterBase
implements Runnable {
    Database database;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    HsqlNameManager.HsqlName schemaToLog;
    boolean isClosed;
    boolean isDump;
    boolean includeCachedData;
    long byteCount;
    volatile boolean needsSync;
    volatile boolean forceSync;
    volatile boolean busyWriting;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    private Object timerTask;
    protected volatile int writeDelay = 60000;

    ScriptWriterBase(Database db, String file, boolean includeCachedData, boolean isNewFile, boolean isDump) {
        this.isDump = isDump;
        this.initBuffers();
        boolean exists = false;
        exists = isDump ? FileUtil.getFileUtil().exists(file) : db.logger.getFileAccess().isStreamElement(file);
        if (exists && isNewFile) {
            throw Error.error(29, file);
        }
        this.database = db;
        this.includeCachedData = includeCachedData;
        this.outFile = file;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.openFile();
    }

    public void reopen() {
        this.openFile();
    }

    protected abstract void initBuffers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (this.isClosed) {
            return;
        }
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            if (this.needsSync) {
                if (this.busyWriting) {
                    this.forceSync = true;
                    return;
                }
                try {
                    this.fileStreamOut.flush();
                    this.outDescriptor.sync();
                    ++this.syncCount;
                }
                catch (IOException e) {
                    Error.printSystemOut("flush() or sync() error: " + e.toString());
                }
                this.needsSync = false;
                this.forceSync = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stop();
        if (this.isClosed) {
            return;
        }
        try {
            OutputStream outputStream = this.fileStreamOut;
            synchronized (outputStream) {
                this.needsSync = false;
                this.isClosed = true;
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                this.fileStreamOut.close();
            }
        }
        catch (IOException e) {
            throw Error.error(29);
        }
        this.byteCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() {
        try {
            this.writeDDL();
            this.writeExistingData();
            this.finishStream();
        }
        catch (IOException e) {
            throw Error.error(29);
        }
    }

    protected void openFile() {
        try {
            FileUtil fa = this.isDump ? FileUtil.getFileUtil() : this.database.logger.getFileAccess();
            OutputStream fos = fa.openOutputStreamElement(this.outFile);
            this.outDescriptor = fa.getFileSync(fos);
            this.fileStreamOut = new BufferedOutputStream(fos, 8192);
        }
        catch (IOException e) {
            throw Error.error(e, 29, 115, new Object[]{e.getMessage(), this.outFile});
        }
    }

    protected void finishStream() throws IOException {
    }

    protected void writeDDL() throws IOException {
        Result ddlPart = this.database.getScript(!this.includeCachedData);
        this.writeSingleColumnResult(ddlPart);
    }

    protected void writeExistingData() throws IOException {
        this.currentSession.loggedSchema = null;
        Iterator schemas = this.database.schemaManager.allSchemaNameIterator();
        while (schemas.hasNext()) {
            String schema = (String)schemas.next();
            Iterator tables = this.database.schemaManager.databaseObjectIterator(schema, 3);
            while (tables.hasNext()) {
                Table t = (Table)tables.next();
                boolean script = false;
                switch (t.getTableType()) {
                    case 3: {
                        script = true;
                        break;
                    }
                    case 4: {
                        script = this.includeCachedData;
                        break;
                    }
                    case 6: {
                        script = this.includeCachedData && !t.isReadOnly();
                    }
                }
                try {
                    if (!script) continue;
                    this.schemaToLog = t.getName().schema;
                    this.writeTableInit(t);
                    RowIterator it = t.rowIterator(this.currentSession);
                    while (it.hasNext()) {
                        this.writeRow(this.currentSession, t, it.getNextRow().getData());
                    }
                    this.writeTableTerm(t);
                }
                catch (Exception e) {
                    throw Error.error(29, e.toString());
                }
            }
        }
        this.writeDataTerm();
    }

    protected void writeTableInit(Table t) throws IOException {
    }

    protected void writeTableTerm(Table t) throws IOException {
        if (t.isDataReadOnly() && !t.isTemp() && !t.isText()) {
            StringBuffer a = new StringBuffer("SET TABLE ");
            a.append(t.getName().statementName);
            a.append(" READONLY TRUE");
            this.writeLogStatement(this.currentSession, a.toString());
        }
    }

    protected void writeSingleColumnResult(Result r) throws IOException {
        RowSetNavigator nav = r.initialiseNavigator();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            this.writeLogStatement(this.currentSession, (String)data[0]);
        }
    }

    abstract void writeRow(Session var1, Table var2, Object[] var3) throws IOException;

    protected abstract void writeDataTerm() throws IOException;

    protected abstract void addSessionId(Session var1) throws IOException;

    public abstract void writeLogStatement(Session var1, String var2) throws IOException;

    public abstract void writeInsertStatement(Session var1, Table var2, Object[] var3) throws IOException;

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3) throws IOException;

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2) throws IOException;

    public abstract void writeCommitStatement(Session var1) throws IOException;

    @Override
    public void run() {
        try {
            if (this.writeDelay != 0) {
                this.sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWriteDelay(int delay) {
        this.writeDelay = delay;
        int period = this.writeDelay == 0 ? 1000 : this.writeDelay;
        HsqlTimer.setPeriod(this.timerTask, period);
    }

    public void start() {
        int period = this.writeDelay == 0 ? 1000 : this.writeDelay;
        this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, period, this, false);
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

