/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputBinary
extends RowOutputBase {
    protected static final int INT_STORE_SIZE = 4;
    int storageSize;
    final int scale;

    public RowOutputBinary(int initialSize, int scale) {
        super(initialSize);
        this.scale = scale;
    }

    public RowOutputBinary(byte[] buffer) {
        super(buffer);
        this.scale = 1;
    }

    @Override
    public void writeIntData(int i, int position) {
        int temp = this.count;
        this.count = position;
        this.writeInt(i);
        if (this.count < temp) {
            this.count = temp;
        }
    }

    @Override
    public void writeData(Object[] data, Type[] types) {
        super.writeData(data, types);
    }

    @Override
    public void writeEnd() {
        if (this.count > this.storageSize) {
            Error.runtimeError(401, "RowOutputBinary");
        }
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    @Override
    public void writeSize(int size) {
        this.storageSize = size;
        this.writeInt(size);
    }

    @Override
    public void writeType(int type) {
        this.writeShort(type);
    }

    @Override
    public void writeString(String s) {
        int temp = this.count;
        this.writeInt(0);
        if (s != null && s.length() != 0) {
            StringConverter.stringToUTFBytes(s, this);
            this.writeIntData(this.count - temp - 4, temp);
        }
    }

    @Override
    public int getSize(Row row) {
        Object[] data = row.getData();
        Type[] types = row.getTable().getColumnTypes();
        int cols = row.getTable().getDataColumnCount();
        return 4 + this.getSize(data, cols, types);
    }

    @Override
    public int getStorageSize(int size) {
        return this.scale == 1 ? size : (size + this.scale - 1) / this.scale * this.scale;
    }

    @Override
    protected void writeFieldType(Type type) {
        this.write(1);
    }

    @Override
    protected void writeNull(Type type) {
        this.write(0);
    }

    @Override
    protected void writeChar(String s, Type t) {
        this.writeString(s);
    }

    @Override
    protected void writeSmallint(Number o) {
        this.writeShort(o.intValue());
    }

    @Override
    protected void writeInteger(Number o) {
        this.writeInt(o.intValue());
    }

    @Override
    protected void writeBigint(Number o) {
        this.writeLong(o.longValue());
    }

    @Override
    protected void writeReal(Double o) {
        this.writeLong(Double.doubleToLongBits(o));
    }

    @Override
    protected void writeDecimal(BigDecimal o, Type type) {
        int scale = o.scale();
        BigInteger bigint = JavaSystem.unscaledValue(o);
        byte[] bytearr = bigint.toByteArray();
        this.writeByteArray(bytearr);
        this.writeInt(scale);
    }

    @Override
    protected void writeBoolean(Boolean o) {
        this.write(o != false ? 1 : 0);
    }

    @Override
    protected void writeDate(TimestampData o, Type type) {
        this.writeLong(o.getSeconds());
    }

    @Override
    protected void writeTime(TimeData o, Type type) {
        this.writeInt(o.getSeconds());
        this.writeInt(o.getNanos());
        if (type.typeCode == 94) {
            this.writeInt(o.getZone());
        }
    }

    @Override
    protected void writeTimestamp(TimestampData o, Type type) {
        this.writeLong(o.getSeconds());
        this.writeInt(o.getNanos());
        if (type.typeCode == 95) {
            this.writeInt(o.getZone());
        }
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData o, Type type) {
        this.writeLong(o.units);
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData o, Type type) {
        this.writeLong(o.units);
        this.writeInt(o.nanos);
    }

    @Override
    protected void writeOther(JavaObjectData o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeBit(BinaryData o) {
        this.writeInt((int)o.bitLength(null));
        this.write(o.getBytes(), 0, o.getBytes().length);
    }

    @Override
    protected void writeBinary(BinaryData o) {
        this.writeByteArray(o.getBytes());
    }

    @Override
    protected void writeClob(ClobData o, Type type) {
        this.writeLong(o.getId());
    }

    @Override
    protected void writeBlob(BlobData o, Type type) {
        this.writeLong(o.getId());
    }

    public void writeByteArray(byte[] b) {
        this.writeInt(b.length);
        this.write(b, 0, b.length);
    }

    public void writeCharArray(char[] c) {
        this.writeInt(c.length);
        this.write(c, 0, c.length);
    }

    private int getSize(Object[] data, int l, Type[] types) {
        int s = 0;
        block20: for (int i = 0; i < l; ++i) {
            Object o = data[i];
            ++s;
            if (o == null) continue;
            switch (types[i].typeCode) {
                case 0: {
                    throw Error.runtimeError(401, "RowOutputBinary");
                }
                case 1: 
                case 12: 
                case 100: {
                    s += 4;
                    s += StringConverter.getUTFSize((String)o);
                    continue block20;
                }
                case -6: 
                case 5: {
                    s += 2;
                    continue block20;
                }
                case 4: {
                    s += 4;
                    continue block20;
                }
                case 6: 
                case 7: 
                case 8: 
                case 25: {
                    s += 8;
                    continue block20;
                }
                case 2: 
                case 3: {
                    s += 8;
                    BigDecimal bigdecimal = (BigDecimal)o;
                    BigInteger bigint = JavaSystem.unscaledValue(bigdecimal);
                    s += bigint.toByteArray().length;
                    continue block20;
                }
                case 16: {
                    ++s;
                    continue block20;
                }
                case 91: {
                    s += 8;
                    continue block20;
                }
                case 92: {
                    s += 8;
                    continue block20;
                }
                case 94: {
                    s += 12;
                    continue block20;
                }
                case 93: {
                    s += 12;
                    continue block20;
                }
                case 95: {
                    s += 16;
                    continue block20;
                }
                case 101: 
                case 102: 
                case 107: {
                    s += 8;
                    continue block20;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    s += 12;
                    continue block20;
                }
                case 60: 
                case 61: {
                    s += 4;
                    s = (int)((long)s + ((BinaryData)o).length(null));
                    continue block20;
                }
                case 14: 
                case 15: {
                    s += 4;
                    s = (int)((long)s + ((BinaryData)o).length(null));
                    continue block20;
                }
                case 30: 
                case 40: {
                    s += 8;
                    continue block20;
                }
                case 1111: {
                    JavaObjectData jo = (JavaObjectData)o;
                    s += 4;
                    s += jo.getBytesLength();
                    continue block20;
                }
                default: {
                    throw Error.runtimeError(401, "RowOutputBinary");
                }
            }
        }
        return s;
    }

    @Override
    public void ensureRoom(int extra) {
        super.ensureRoom(extra);
    }

    @Override
    public void reset() {
        super.reset();
        this.storageSize = 0;
    }

    @Override
    public void reset(int newSize) {
        super.reset(newSize);
        this.storageSize = 0;
    }

    @Override
    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.reset();
    }
}

