/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.types.Type;

public class Grantee
implements SchemaObject {
    boolean isRole;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    boolean isSchemaCreator = false;
    boolean isPublic = false;
    boolean isSystem = false;
    protected HsqlNameManager.HsqlName granteeName;
    private MultiValueHashMap directRightsMap;
    private HashMap fullRightsMap = new HashMap();
    OrderedHashSet roles;
    private MultiValueHashMap grantedRightsMap;
    protected GranteeManager granteeManager;
    protected Right ownerRights;

    Grantee(HsqlNameManager.HsqlName name, GranteeManager man) {
        this.directRightsMap = new MultiValueHashMap();
        this.grantedRightsMap = new MultiValueHashMap();
        this.granteeName = name;
        this.granteeManager = man;
        this.roles = new OrderedHashSet();
        this.ownerRights = new Right();
        this.ownerRights.isFull = true;
        this.ownerRights.grantor = GranteeManager.systemAuthorisation;
        this.ownerRights.grantee = this;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.granteeName;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return null;
    }

    @Override
    public OrderedHashSet getReferences() {
        return null;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("ROLE");
        sb.append(' ').append(this.granteeName.statementName);
        return sb.toString();
    }

    public String getNameString() {
        return this.granteeName.name;
    }

    public String getStatementName() {
        return this.granteeName.statementName;
    }

    public boolean isRole() {
        return this.isRole;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public MultiValueHashMap getRights() {
        return this.directRightsMap;
    }

    public void grant(Grantee role) {
        this.roles.add(role);
    }

    public void revoke(Grantee role) {
        if (!this.hasRoleDirect(role)) {
            throw Error.error(2253, role.getNameString());
        }
        this.roles.remove(role);
    }

    public OrderedHashSet getDirectRoles() {
        return this.roles;
    }

    String getAllRolesAsString() {
        return this.roleMapToString(this.getAllRoles());
    }

    public String getDirectRolesAsString() {
        return this.roleMapToString(this.roles);
    }

    public String roleMapToString(OrderedHashSet roles) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < roles.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            Grantee role = (Grantee)roles.get(i);
            sb.append(role.getStatementName());
        }
        return sb.toString();
    }

    public OrderedHashSet getAllRoles() {
        OrderedHashSet set = this.getGranteeAndAllRoles();
        set.remove(this);
        return set;
    }

    public OrderedHashSet getGranteeAndAllRoles() {
        OrderedHashSet set = new OrderedHashSet();
        this.addGranteeAndRoles(set);
        return set;
    }

    public OrderedHashSet getGranteeAndAllRolesWithPublic() {
        OrderedHashSet set = new OrderedHashSet();
        this.addGranteeAndRoles(set);
        set.add(this.granteeManager.publicRole);
        return set;
    }

    private OrderedHashSet addGranteeAndRoles(OrderedHashSet set) {
        set.add(this);
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee candidateRole = (Grantee)this.roles.get(i);
            if (set.contains(candidateRole)) continue;
            candidateRole.addGranteeAndRoles(set);
        }
        return set;
    }

    public void addAllRoles(HashMap map) {
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee role = (Grantee)this.roles.get(i);
            map.put(role.granteeName.name, role.roles);
        }
    }

    public boolean hasRoleDirect(Grantee role) {
        return this.roles.contains(role);
    }

    public boolean hasRole(Grantee role) {
        return this.getAllRoles().contains(role);
    }

    void grant(HsqlNameManager.HsqlName name, Right right, Grantee grantor, boolean withGrant) {
        Right grantableRights = grantor.getAllGrantableRights(name);
        Right existingRight = null;
        if (right == Right.fullRights) {
            if (grantableRights.isEmpty()) {
                return;
            }
            right = grantableRights;
        } else if (!grantableRights.contains(right)) {
            throw Error.error(2000);
        }
        Iterator it = this.directRightsMap.get(name);
        while (it.hasNext()) {
            Right existing = (Right)it.next();
            if (existing.grantor != grantor) continue;
            existingRight = existing;
            existingRight.add(right);
            break;
        }
        if (existingRight == null) {
            existingRight = right.duplicate();
            existingRight.grantor = grantor;
            existingRight.grantee = this;
            this.directRightsMap.put(name, existingRight);
        }
        if (withGrant) {
            if (existingRight.grantableRights == null) {
                existingRight.grantableRights = right.duplicate();
            } else {
                existingRight.grantableRights.add(right);
            }
        }
        if (!grantor.isSystem) {
            grantor.grantedRightsMap.put(name, existingRight);
        }
        this.updateAllRights();
    }

    void revoke(SchemaObject object, Right right, Grantee grantor, boolean grantOption) {
        HsqlNameManager.HsqlName name = object.getType() == 24 ? ((Routine)object).getSpecificName() : object.getName();
        Iterator it = this.directRightsMap.get(name);
        Right existing = null;
        while (it.hasNext()) {
            existing = (Right)it.next();
            if (existing.grantor != grantor) continue;
        }
        if (existing == null) {
            return;
        }
        if (existing.grantableRights != null) {
            existing.grantableRights.remove(object, right);
        }
        if (grantOption) {
            return;
        }
        if (right.isFull) {
            this.directRightsMap.remove(name, existing);
            grantor.grantedRightsMap.remove(name, existing);
            this.updateAllRights();
            return;
        }
        existing.remove(object, right);
        if (existing.isEmpty()) {
            this.directRightsMap.remove(name, existing);
            grantor.grantedRightsMap.remove(name, existing);
        }
        this.updateAllRights();
    }

    void revokeDbObject(HsqlNameManager.HsqlName name) {
        this.directRightsMap.remove(name);
        this.grantedRightsMap.remove(name);
        this.fullRightsMap.remove(name);
    }

    void clearPrivileges() {
        this.roles.clear();
        this.directRightsMap.clear();
        this.grantedRightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdmin = false;
    }

    public OrderedHashSet getColumnsForAllPrivileges(Table table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return table.getColumnNameSet();
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        return right == null ? Right.emptySet : right.getColumnsForAllRights(table);
    }

    public OrderedHashSet getAllDirectPrivileges(SchemaObject object) {
        if (object.getOwner() == this) {
            OrderedHashSet set = new OrderedHashSet();
            set.add(this.ownerRights);
            return set;
        }
        Iterator rights = this.directRightsMap.get(object.getName());
        if (rights.hasNext()) {
            OrderedHashSet set = new OrderedHashSet();
            while (rights.hasNext()) {
                set.add(rights.next());
            }
            return set;
        }
        return Right.emptySet;
    }

    public OrderedHashSet getAllGrantedPrivileges(SchemaObject object) {
        Iterator rights = this.grantedRightsMap.get(object.getName());
        if (rights.hasNext()) {
            OrderedHashSet set = new OrderedHashSet();
            while (rights.hasNext()) {
                set.add(rights.next());
            }
            return set;
        }
        return Right.emptySet;
    }

    public void checkSelect(Table table, boolean[] checkList) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canSelect(table, checkList)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkInsert(Table table, boolean[] checkList) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canInsert(table, checkList)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkUpdate(Table table, boolean[] checkList) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canUpdate(table, checkList)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkReferences(Table table, boolean[] checkList) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canReference(table, checkList)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkTrigger(Table table, boolean[] checkList) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canReference(table, checkList)) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkDelete(Table table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right != null && right.canDelete()) {
            return;
        }
        throw Error.error(5501, table.getName().name);
    }

    public void checkAccess(SchemaObject object) {
        if (this.isFullyAccessibleByRole(object.getName())) {
            return;
        }
        Right right = (Right)this.fullRightsMap.get(object.getName());
        if (right != null && !right.isEmpty()) {
            return;
        }
        throw Error.error(5501, object.getName().name);
    }

    public void checkSchemaUpdateOrGrantRights(String schemaName) {
        if (!this.hasSchemaUpdateOrGrantRights(schemaName)) {
            throw Error.error(5501, schemaName);
        }
    }

    public boolean hasSchemaUpdateOrGrantRights(String schemaName) {
        if (this.isAdmin()) {
            return true;
        }
        Grantee schemaOwner = this.granteeManager.database.schemaManager.toSchemaOwner(schemaName);
        if (schemaOwner == this) {
            return true;
        }
        return this.hasRole(schemaOwner);
    }

    public boolean isGrantable(SchemaObject object, Right right) {
        if (this.isFullyAccessibleByRole(object.getName())) {
            return true;
        }
        Right grantableRights = this.getAllGrantableRights(object.getName());
        return grantableRights.contains(right);
    }

    public boolean isGrantable(Grantee role) {
        return this.isAdmin;
    }

    public boolean isFullyAccessibleByRole(HsqlNameManager.HsqlName name) {
        if (this.isAdmin) {
            return true;
        }
        if (name.schema == null) {
            return false;
        }
        Grantee owner = name.schema.owner;
        if (owner == this) {
            return true;
        }
        return this.hasRole(owner);
    }

    public void checkAdmin() {
        if (!this.isAdmin()) {
            throw Error.error(5507);
        }
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isSchemaCreator() {
        return this.isAdmin || this.hasRole(this.granteeManager.schemaRole);
    }

    public boolean canChangeAuthorisation() {
        return this.isAdmin || this.hasRole(this.granteeManager.changeAuthRole);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(Grantee role) {
        boolean hasNested = false;
        if (role != this) {
            for (int i = 0; i < this.roles.size(); ++i) {
                Grantee currentRole = (Grantee)this.roles.get(i);
                hasNested |= currentRole.updateNestedRoles(role);
            }
        }
        if (hasNested) {
            this.updateAllRights();
        }
        return hasNested || role == this;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        for (int i = 0; i < this.roles.size(); ++i) {
            Grantee currentRole = (Grantee)this.roles.get(i);
            this.addToFullRights(currentRole.fullRightsMap);
            this.isAdmin |= currentRole.isAdmin();
        }
        this.addToFullRights(this.directRightsMap);
        if (!(this.isRole || this.isPublic || this.isSystem)) {
            this.addToFullRights(this.granteeManager.publicRole.fullRightsMap);
        }
    }

    void addToFullRights(HashMap map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Right add = (Right)map.get(key);
            Right existing = (Right)this.fullRightsMap.get(key);
            if (existing == null) {
                existing = add.duplicate();
                this.fullRightsMap.put(key, existing);
            } else {
                existing.add(add);
            }
            if (add.grantableRights == null) continue;
            if (existing.grantableRights == null) {
                existing.grantableRights = add.grantableRights.duplicate();
                continue;
            }
            existing.grantableRights.add(add.grantableRights);
        }
    }

    void addToFullRights(MultiValueHashMap map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Iterator values = map.get(key);
            Right existing = (Right)this.fullRightsMap.get(key);
            while (values.hasNext()) {
                Right add = (Right)values.next();
                if (existing == null) {
                    existing = add.duplicate();
                    this.fullRightsMap.put(key, existing);
                } else {
                    existing.add(add);
                }
                if (add.grantableRights == null) continue;
                if (existing.grantableRights == null) {
                    existing.grantableRights = add.grantableRights.duplicate();
                    continue;
                }
                existing.grantableRights.add(add.grantableRights);
            }
        }
    }

    public Set visibleGrantees() {
        HashSet grantees = new HashSet();
        GranteeManager gm = this.granteeManager;
        if (this.isAdmin()) {
            grantees.addAll(gm.getGrantees());
        } else {
            grantees.add(this);
            Iterator it = this.getAllRoles().iterator();
            while (it.hasNext()) {
                grantees.add(it.next());
            }
        }
        return grantees;
    }

    public Set nonReservedVisibleGrantees(boolean andPublic) {
        Set grantees = this.visibleGrantees();
        GranteeManager gm = this.granteeManager;
        grantees.remove(gm.dbaRole);
        grantees.remove(GranteeManager.systemAuthorisation);
        if (!andPublic) {
            grantees.remove(gm.publicRole);
        }
        return grantees;
    }

    public boolean hasNonSelectTableRight(Table table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right == null) {
            return false;
        }
        return right.isFull || right.isFullDelete || right.isFullInsert || right.isFullUpdate || right.isFullReferences || right.isFullTrigger;
    }

    public boolean hasTableRight(Table table) {
        if (this.isFullyAccessibleByRole(table.getName())) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(table.getName());
        if (right == null) {
            return false;
        }
        return right.isFull || right.isFullDelete || right.isFullInsert || right.isFullUpdate || right.isFullReferences || right.isFullTrigger || right.isFullSelect;
    }

    public Iterator getAllDirectFullRights(SchemaObject object) {
        Grantee owner = object.getOwner();
        if (owner == this) {
            return new WrapperIterator(this.ownerRights);
        }
        return this.directRightsMap.get(object.getName());
    }

    public Right getAllGrantableRights(HsqlNameManager.HsqlName name) {
        if (this.isAdmin) {
            return name.schema.owner.ownerRights;
        }
        if (name.schema.owner == this) {
            return this.ownerRights;
        }
        if (this.roles.contains(name.schema.owner)) {
            return name.schema.owner.ownerRights;
        }
        OrderedHashSet set = this.getAllRoles();
        for (int i = 0; i < set.size(); ++i) {
            Grantee role = (Grantee)set.get(i);
            if (name.schema.owner != role) continue;
            return role.ownerRights;
        }
        Right right = (Right)this.fullRightsMap.get(name);
        return right == null || right.grantableRights == null ? Right.noRights : right.grantableRights;
    }

    public boolean isAccessible(HsqlNameManager.HsqlName name, int privilegeType) {
        if (this.isFullyAccessibleByRole(name)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(name);
        if (right == null) {
            return false;
        }
        return right.canAccess(privilegeType);
    }

    public boolean isAccessible(SchemaObject object) {
        return this.isAccessible(object.getName());
    }

    public boolean isAccessible(HsqlNameManager.HsqlName name) {
        if (this.isFullyAccessibleByRole(name)) {
            return true;
        }
        Right right = (Right)this.fullRightsMap.get(name);
        if (right != null && !right.isEmpty()) {
            return true;
        }
        if (!this.isPublic) {
            return this.granteeManager.publicRole.isAccessible(name);
        }
        return false;
    }

    public HsqlArrayList getRightsSQL() {
        HsqlArrayList list = new HsqlArrayList();
        String roleString = this.getDirectRolesAsString();
        if (roleString.length() != 0) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("GRANT").append(' ').append(roleString);
            sb.append(' ').append("TO").append(' ');
            sb.append(this.getStatementName());
            list.add(sb.toString());
        }
        MultiValueHashMap rightsMap = this.getRights();
        Iterator dbObjects = rightsMap.keySet().iterator();
        while (dbObjects.hasNext()) {
            Object nameObject = dbObjects.next();
            Iterator rights = rightsMap.get(nameObject);
            while (rights.hasNext()) {
                Right right = (Right)rights.next();
                StringBuffer sb = new StringBuffer(128);
                HsqlNameManager.HsqlName hsqlname = (HsqlNameManager.HsqlName)nameObject;
                switch (hsqlname.type) {
                    case 3: 
                    case 4: {
                        Table table = this.granteeManager.database.schemaManager.findUserTable(null, hsqlname.name, hsqlname.schema.name);
                        if (table == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append(right.getTableRightsSQL(table));
                        sb.append(' ').append("ON").append(' ');
                        sb.append("TABLE").append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 7: {
                        NumberSequence sequence = (NumberSequence)this.granteeManager.database.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 7);
                        if (sequence == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append("USAGE");
                        sb.append(' ').append("ON").append(' ');
                        sb.append("SEQUENCE").append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 13: {
                        Type domain = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 13);
                        if (domain == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append("USAGE");
                        sb.append(' ').append("ON").append(' ');
                        sb.append("DOMAIN").append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 12: {
                        Type type = (Type)this.granteeManager.database.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, 13);
                        if (type == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append("USAGE");
                        sb.append(' ').append("ON").append(' ');
                        sb.append("TYPE").append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 24: {
                        SchemaObject routine = this.granteeManager.database.schemaManager.findSchemaObject(hsqlname.name, hsqlname.schema.name, hsqlname.type);
                        if (routine == null) break;
                        sb.append("GRANT").append(' ');
                        sb.append("EXECUTE").append(' ');
                        sb.append("ON").append(' ');
                        sb.append("SPECIFIC").append(' ');
                        if (routine.getType() == 17) {
                            sb.append("PROCEDURE");
                        } else {
                            sb.append("FUNCTION");
                        }
                        sb.append(' ');
                        sb.append(hsqlname.getSchemaQualifiedStatementName());
                    }
                }
                if (sb.length() == 0) continue;
                sb.append(' ').append("TO").append(' ');
                sb.append(this.getStatementName());
                list.add(sb.toString());
            }
        }
        return list;
    }
}

