/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.ScaledRAInterface;

final class ScaledRAFileNIO
implements ScaledRAInterface {
    private final Database database;
    private final boolean readOnly;
    private final long bufferLength;
    private RandomAccessFile file;
    private MappedByteBuffer buffer;
    private FileChannel channel;
    private boolean bufferModified;
    private static final String JVM_ERROR = "JVM threw unsupported Exception";

    ScaledRAFileNIO(Database database, String name, boolean readOnly, int bufferLength) throws Throwable {
        block17: {
            long fileLength;
            this.database = database;
            if (bufferLength < 262144) {
                bufferLength = 262144;
            }
            this.file = new RandomAccessFile(name, readOnly ? "r" : "rw");
            try {
                fileLength = this.file.length();
            }
            catch (Throwable e) {
                this.file.close();
                throw e;
            }
            if (fileLength > 0x10000000L) {
                this.file.close();
                throw new IOException("length exceeds nio limit");
            }
            if ((long)bufferLength < fileLength) {
                bufferLength = (int)fileLength;
            }
            bufferLength = ScaledRAFileNIO.newNIOBufferSize(bufferLength);
            if (readOnly) {
                bufferLength = (int)fileLength;
            }
            if (fileLength < (long)bufferLength) {
                try {
                    this.file.seek(bufferLength - 1);
                    this.file.writeByte(0);
                    this.file.getFD().sync();
                    this.file.close();
                    this.file = new RandomAccessFile(name, readOnly ? "r" : "rw");
                }
                catch (Throwable e) {
                    this.file.close();
                    throw e;
                }
            }
            this.readOnly = readOnly;
            this.bufferLength = bufferLength;
            this.channel = this.file.getChannel();
            try {
                this.buffer = this.channel.map(readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, bufferLength);
                Error.printSystemOut("NIO file instance created. mode: " + readOnly);
                if (readOnly) break block17;
                long tempSize = (long)bufferLength - fileLength;
                if (tempSize > 262144L) {
                    tempSize = 262144L;
                }
                byte[] temp = new byte[(int)tempSize];
                try {
                    long pos;
                    for (pos = fileLength; pos < (long)bufferLength - tempSize; pos += tempSize) {
                        this.buffer.position((int)pos);
                        this.buffer.put(temp, 0, temp.length);
                    }
                    this.buffer.position((int)pos);
                    this.buffer.put(temp, 0, (int)((long)bufferLength - pos));
                    this.buffer.force();
                }
                catch (Throwable t) {
                    database.logger.logWarningEvent("JVM threw unsupported Exception length: " + bufferLength, t);
                }
                this.buffer.position(0);
            }
            catch (Throwable e) {
                Error.printSystemOut("NIO constructor failed:  " + bufferLength);
                this.buffer = null;
                this.channel = null;
                this.file.close();
                throw e;
            }
        }
    }

    @Override
    public long length() throws IOException {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            this.database.logger.logWarningEvent("nio", e);
            throw e;
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public void seek(long newPos) throws IOException {
        try {
            this.buffer.position((int)newPos);
        }
        catch (IllegalArgumentException e) {
            this.database.logger.logWarningEvent("nio", e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        try {
            return this.buffer.position();
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public void read(byte[] b, int offset, int length) throws IOException {
        try {
            this.buffer.get(b, offset, length);
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.put(b, offset, len);
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public void writeInt(int i) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putInt(i);
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public void writeLong(long i) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putLong(i);
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent(JVM_ERROR, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            Error.printSystemOut("NIO close() start - fileLength = " + this.bufferLength);
            if (this.buffer != null && this.bufferModified) {
                try {
                    this.buffer.force();
                }
                catch (Throwable t) {
                    try {
                        this.buffer.force();
                    }
                    catch (Throwable t1) {
                        this.database.logger.logWarningEvent("JVM threw unsupported Exception length: " + this.bufferLength, t);
                    }
                }
            }
            this.buffer = null;
            this.channel = null;
            this.file.close();
        }
        catch (Throwable e) {
            this.database.logger.logWarningEvent("length: " + this.bufferLength, e);
            IOException io = new IOException(e.getMessage());
            try {
                io.initCause(e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw io;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean wasNio() {
        return true;
    }

    @Override
    public boolean canAccess(int length) {
        return (long)(this.buffer.position() + length) <= this.bufferLength;
    }

    @Override
    public boolean canSeek(long position) {
        return position <= this.bufferLength;
    }

    @Override
    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        try {
            this.buffer.force();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static int newNIOBufferSize(int newSize) {
        int bufSize = 0;
        for (int scale = 20; scale < 30 && (bufSize = 1 << scale) < newSize; ++scale) {
        }
        return bufSize;
    }
}

