/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.rowio.RowInputInterface;

public abstract class RowStoreAVL
implements PersistentStore {
    PersistentStoreCollection manager;
    Index[] indexList = Index.emptyArray;
    CachedObject[] accessorList = CachedObject.emptyArray;
    long timestamp;

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public abstract int getAccessCount();

    @Override
    public abstract void set(CachedObject var1);

    @Override
    public abstract CachedObject get(int var1, boolean var2);

    @Override
    public abstract CachedObject get(CachedObject var1, boolean var2);

    @Override
    public abstract int getStorageSize(int var1);

    @Override
    public abstract void add(CachedObject var1);

    @Override
    public abstract CachedObject get(RowInputInterface var1);

    @Override
    public abstract CachedObject getNewInstance(int var1);

    @Override
    public abstract CachedObject getNewCachedObject(Session var1, Object var2);

    @Override
    public abstract void removePersistence(int var1);

    @Override
    public abstract void removeAll();

    @Override
    public abstract void remove(int var1);

    @Override
    public abstract void release(int var1);

    @Override
    public abstract void commitPersistence(CachedObject var1);

    @Override
    public abstract DataFileCache getCache();

    @Override
    public abstract void setCache(DataFileCache var1);

    @Override
    public abstract void release();

    @Override
    public PersistentStore getAccessorStore(Index index) {
        return null;
    }

    @Override
    public CachedObject getAccessor(Index key) {
        int position = key.getPosition();
        if (position >= this.accessorList.length) {
            throw Error.runtimeError(401, "RowStoreAVL");
        }
        return this.accessorList[position];
    }

    @Override
    public abstract void setAccessor(Index var1, CachedObject var2);

    @Override
    public abstract void setAccessor(Index var1, int var2);

    @Override
    public abstract void resetAccessorKeys(Index[] var1);

    @Override
    public final void delete(Row row) {
        for (int i = this.indexList.length - 1; i >= 0; --i) {
            this.indexList[i].delete(this, row);
        }
    }

    @Override
    public final void indexRow(Session session, Row row) {
        int i;
        try {
            for (i = 0; i < this.indexList.length; ++i) {
                this.indexList[i].insert(session, this, row);
            }
        }
        catch (HsqlException e) {
            --i;
            while (i >= 0) {
                this.indexList[i].delete(this, row);
                --i;
            }
            this.remove(row.getPos());
            throw e;
        }
    }

    @Override
    public final void indexRows() {
        RowIterator it = this.rowIterator();
        for (int i = 1; i < this.indexList.length; ++i) {
            this.setAccessor(this.indexList[i], null);
        }
        while (it.hasNext()) {
            Row row = it.getNextRow();
            if (row instanceof RowAVL) {
                ((RowAVL)row).clearNonPrimaryNodes();
            }
            for (int i = 1; i < this.indexList.length; ++i) {
                this.indexList[i].insert(null, this, row);
            }
        }
    }

    @Override
    public final RowIterator rowIterator() {
        if (this.indexList.length == 0 || this.indexList[0] == null) {
            throw Error.runtimeError(401, "RowStoreAVL");
        }
        return this.indexList[0].firstRow(this);
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }
}

