/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.BitMap;

public class RAShadowFile {
    final Database database;
    final String pathName;
    final Storage source;
    RandomAccessFile dest;
    final int pageSize;
    final long maxSize;
    final BitMap bitMap;
    boolean zeroPageSet;
    HsqlByteArrayOutputStream byteArrayOutputStream = new HsqlByteArrayOutputStream(new byte[0]);

    RAShadowFile(Database database, Storage source, String pathName, long maxSize, int pageSize) {
        this.database = database;
        this.pathName = pathName;
        this.source = source;
        this.pageSize = pageSize;
        this.maxSize = maxSize;
        int bitSize = (int)(maxSize / (long)pageSize);
        if (maxSize % (long)pageSize != 0L) {
            ++bitSize;
        }
        this.bitMap = new BitMap(bitSize);
    }

    void copy(long fileOffset, int size) throws IOException {
        if (!this.zeroPageSet) {
            this.copy(0);
            this.bitMap.set(0);
            this.zeroPageSet = true;
        }
        if (fileOffset >= this.maxSize) {
            return;
        }
        long endOffset = fileOffset + (long)size;
        int startPageOffset = (int)(fileOffset / (long)this.pageSize);
        int endPageOffset = (int)(endOffset / (long)this.pageSize);
        if (endOffset % (long)this.pageSize == 0L) {
            --endPageOffset;
        }
        while (startPageOffset <= endPageOffset) {
            this.copy(startPageOffset);
            ++startPageOffset;
        }
    }

    private void copy(int pageOffset) throws IOException {
        if (this.bitMap.set(pageOffset) == 1) {
            return;
        }
        long position = (long)pageOffset * (long)this.pageSize;
        int readSize = this.pageSize;
        if (this.maxSize - position < (long)this.pageSize) {
            readSize = (int)(this.maxSize - position);
        }
        try {
            if (this.dest == null) {
                this.open();
            }
            long writePos = this.dest.length();
            byte[] buffer = new byte[this.pageSize + 12];
            this.byteArrayOutputStream.setBuffer(buffer);
            this.byteArrayOutputStream.writeInt(this.pageSize);
            this.byteArrayOutputStream.writeLong(position);
            this.source.seek(position);
            this.source.read(buffer, 12, readSize);
            this.dest.seek(writePos);
            this.dest.write(buffer);
        }
        catch (Throwable t) {
            this.bitMap.unset(pageOffset);
            this.close();
            this.database.logger.logWarningEvent("pos" + position + " " + readSize, t);
            throw JavaSystem.toIOException(t);
        }
    }

    private void open() throws IOException {
        this.dest = new RandomAccessFile(this.pathName, "rws");
    }

    void close() throws IOException {
        if (this.dest != null) {
            this.dest.close();
            this.dest = null;
        }
    }

    public static void restoreFile(String sourceName, String destName) throws IOException {
        RandomAccessFile source = new RandomAccessFile(sourceName, "r");
        RandomAccessFile dest = new RandomAccessFile(destName, "rw");
        while (source.getFilePointer() != source.length()) {
            int size = source.readInt();
            long position = source.readLong();
            byte[] buffer = new byte[size];
            source.read(buffer);
            dest.seek(position);
            dest.write(buffer);
        }
        source.close();
        dest.close();
    }
}

