/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;

public class PersistentStoreCollectionSession
implements PersistentStoreCollection {
    private final Session session;
    private final LongKeyHashMap rowStoreMapSession = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapTransaction = new LongKeyHashMap();
    private LongKeyHashMap rowStoreMapStatement = new LongKeyHashMap();

    public PersistentStoreCollectionSession(Session session) {
        this.session = session;
    }

    @Override
    public void setStore(Object key, PersistentStore store) {
        TableBase table = (TableBase)key;
        switch (table.persistenceScope) {
            case 11: {
                if (store == null) {
                    this.rowStoreMapStatement.remove(table.getPersistenceId());
                    break;
                }
                this.rowStoreMapStatement.put(table.getPersistenceId(), store);
                break;
            }
            case 12: {
                if (store == null) {
                    this.rowStoreMapTransaction.remove(table.getPersistenceId());
                    break;
                }
                this.rowStoreMapTransaction.put(table.getPersistenceId(), store);
                break;
            }
            case 13: {
                if (store == null) {
                    this.rowStoreMapSession.remove(table.getPersistenceId());
                    break;
                }
                this.rowStoreMapSession.put(table.getPersistenceId(), store);
                break;
            }
            default: {
                throw Error.runtimeError(401, "PersistentStoreCollectionSession");
            }
        }
    }

    @Override
    public PersistentStore getStore(Object key) {
        try {
            TableBase table = (TableBase)key;
            switch (table.persistenceScope) {
                case 11: {
                    PersistentStore store = (PersistentStore)this.rowStoreMapStatement.get(table.getPersistenceId());
                    if (store == null) {
                        store = this.session.database.logger.newStore(this.session, this, table, true);
                    }
                    return store;
                }
                case 12: {
                    PersistentStore store = (PersistentStore)this.rowStoreMapTransaction.get(table.getPersistenceId());
                    if (store == null) {
                        store = this.session.database.logger.newStore(this.session, this, table, true);
                    }
                    return store;
                }
                case 13: {
                    PersistentStore store = (PersistentStore)this.rowStoreMapSession.get(table.getPersistenceId());
                    if (store == null) {
                        store = this.session.database.logger.newStore(this.session, this, table, true);
                    }
                    return store;
                }
            }
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        throw Error.runtimeError(401, "PersistentStoreCollectionSession");
    }

    public void clearAllTables() {
        this.clearSessionTables();
        this.clearTransactionTables();
        this.clearStatementTables();
    }

    public void clearResultTables(long actionTimestamp) {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapSession.values().iterator();
        while (it.hasNext()) {
            RowStoreAVL store = (RowStoreAVL)it.next();
            if (store.timestamp != actionTimestamp) continue;
            store.release();
        }
    }

    public void clearSessionTables() {
        if (this.rowStoreMapSession.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapSession.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapSession.clear();
    }

    public void clearTransactionTables() {
        if (this.rowStoreMapTransaction.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapTransaction.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapTransaction.clear();
    }

    public void clearStatementTables() {
        if (this.rowStoreMapStatement.isEmpty()) {
            return;
        }
        Iterator it = this.rowStoreMapStatement.values().iterator();
        while (it.hasNext()) {
            PersistentStore store = (PersistentStore)it.next();
            store.release();
        }
        this.rowStoreMapStatement.clear();
    }
}

