/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.TableBase;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;

public class PersistentStoreCollectionDatabase
implements PersistentStoreCollection {
    private long persistentStoreIdSequence;
    private final LongKeyHashMap rowStoreMap = new LongKeyHashMap();

    @Override
    public void setStore(Object key, PersistentStore store) {
        long persistenceId = ((TableBase)key).getPersistenceId();
        if (store == null) {
            this.rowStoreMap.remove(persistenceId);
        } else {
            this.rowStoreMap.put(persistenceId, store);
        }
    }

    @Override
    public PersistentStore getStore(Object key) {
        long persistenceId = ((TableBase)key).getPersistenceId();
        PersistentStore store = (PersistentStore)this.rowStoreMap.get(persistenceId);
        return store;
    }

    public void releaseStore(TableBase table) {
        PersistentStore store = (PersistentStore)this.rowStoreMap.get(table.getPersistenceId());
        if (store != null) {
            store.release();
            this.rowStoreMap.remove(table.getPersistenceId());
        }
    }

    public long getNextId() {
        return this.persistentStoreIdSequence++;
    }
}

