/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.DbBackup;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.RowStoreAVLDiskData;
import org.hsqldb.persist.RowStoreAVLHybrid;
import org.hsqldb.persist.RowStoreAVLMemory;

public class Logger {
    public SimpleLog appLog;
    Log log;
    private Database database;
    private LockFile lockFile;
    public boolean checkpointRequired;
    public boolean checkpointDue;
    public boolean checkpointDisabled;
    private boolean logsStatements;
    private boolean loggingEnabled;
    private boolean syncFile = false;
    boolean propFilesReadOnly;
    boolean propDatabaseReadOnly;
    boolean propIncrementBackup;
    boolean propNioDataFile;
    int propMaxFreeBlocks;
    int propCacheMaxRows;
    int propCacheMaxSize;
    int propCacheFileScale;
    int propCacheDefragLimit;
    String propTextSourceDefault = "";
    HsqlProperties propTextSourceProps;
    boolean propTextAllowFullPath;
    int propWriteDelay;
    int propLogSize;
    int propEventLogLevel;
    int propGC;
    int propTxMode = 0;
    private Crypto crypto;
    public FileAccess fileAccess;
    public boolean isStoredFileAccess;
    String tempDirectoryPath;
    public boolean isNewDatabase;
    FrameworkLogger fwLogger;
    private static SimpleDateFormat backupFileFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private static Character runtimeFileDelim = null;

    public Logger(Database database) {
        this.database = database;
    }

    public void openPersistence() {
        String fileaccess_class_name = this.database.getURLProperties().getProperty("fileaccess_class_name");
        if (fileaccess_class_name != null) {
            String storagekey = this.database.getURLProperties().getProperty("storage_key");
            try {
                Class<?> zclass = Class.forName(fileaccess_class_name);
                Constructor<?> constructor = zclass.getConstructor(Object.class);
                this.fileAccess = (FileAccess)constructor.newInstance(storagekey);
                this.isStoredFileAccess = true;
            }
            catch (ClassNotFoundException e) {
                System.out.println("ClassNotFoundException");
            }
            catch (InstantiationException e) {
                System.out.println("InstantiationException");
            }
            catch (IllegalAccessException e) {
                System.out.println("IllegalAccessException");
            }
            catch (Exception e) {
                System.out.println("Exception");
            }
        } else {
            this.fileAccess = FileUtil.getFileAccess(this.database.isFilesInJar());
        }
        boolean isFile = DatabaseURL.isFileBasedDatabaseType(this.database.getType());
        this.database.databaseProperties = new HsqlDatabaseProperties(this.database);
        boolean bl = this.isNewDatabase = !isFile || !this.fileAccess.isStreamElement(this.database.getPath() + ".script");
        if (this.isNewDatabase) {
            boolean checkExists;
            String name = this.newUniqueName();
            this.database.setUniqueName(name);
            boolean bl2 = checkExists = this.database.isFilesInJar() || this.database.urlProperties.isPropertyTrue("ifexists");
            if (checkExists) {
                throw Error.error(94, this.database.getPath());
            }
            this.database.databaseProperties.setURLProperties(this.database.urlProperties);
        } else {
            this.database.databaseProperties.load();
            if (this.database.urlProperties.isPropertyTrue("files_readonly")) {
                this.database.databaseProperties.setProperty("files_readonly", true);
            }
            if (this.database.urlProperties.isPropertyTrue("readonly")) {
                this.database.databaseProperties.setProperty("readonly", true);
            }
        }
        this.setVariables();
        String logPath = null;
        if (DatabaseURL.isFileBasedDatabaseType(this.database.getType()) && !this.database.isFilesReadOnly()) {
            logPath = this.database.getPath() + ".app.log";
        }
        this.appLog = new SimpleLog(logPath, this.propEventLogLevel);
        if (!isFile) {
            return;
        }
        this.checkpointRequired = false;
        this.loggingEnabled = false;
        boolean useLock = this.database.getProperties().isPropertyTrue("hsqldb.lock_file");
        if (useLock && !this.database.isFilesReadOnly()) {
            this.acquireLock(this.database.getPath());
        }
        this.log = new Log(this.database);
        this.log.open();
        this.loggingEnabled = !this.database.isFilesReadOnly();
        this.logsStatements = this.loggingEnabled;
        String version = this.database.databaseProperties.getStringProperty("version");
        if (version.substring(0, 5).equals("1.8.0")) {
            HsqlNameManager.HsqlName name = this.database.schemaManager.findSchemaHsqlName("PUBLIC");
            if (name != null) {
                this.database.schemaManager.setDefaultSchemaHsqlName(name);
            }
            this.database.setUniqueName(this.newUniqueName());
            this.checkpoint(false);
        }
        if (this.database.getUniqueName() == null) {
            this.database.setUniqueName(this.newUniqueName());
        }
    }

    public void setVariables() {
        String txMode;
        String tableType;
        String cryptKey = this.database.urlProperties.getProperty("crypt_key");
        if (cryptKey != null) {
            String cryptType = this.database.urlProperties.getProperty("crypt_type");
            String cryptProvider = this.database.urlProperties.getProperty("crypt_provider");
            this.crypto = new Crypto(cryptKey, cryptType, cryptProvider);
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (!this.database.isFilesReadOnly()) {
            this.tempDirectoryPath = this.database.getType() == "mem:" ? this.database.getProperties().getStringProperty("hsqldb.temp_directory") : this.database.getPath() + ".tmp";
            if (this.tempDirectoryPath != null) {
                this.tempDirectoryPath = FileUtil.makeDirectories(this.tempDirectoryPath);
            }
        }
        if (this.tempDirectoryPath != null) {
            int rows = this.database.databaseProperties.getIntegerProperty("hsqldb.result_max_memory_rows");
            this.database.setResultMaxMemoryRows(rows);
        }
        if ("CACHED".equalsIgnoreCase(tableType = this.database.databaseProperties.getStringProperty("hsqldb.default_table_type"))) {
            this.database.schemaManager.setDefaultTableType(4);
        }
        if ("MVCC".equalsIgnoreCase(txMode = this.database.databaseProperties.getStringProperty("hsqldb.tx"))) {
            this.propTxMode = 2;
        } else if ("MVLOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 1;
        } else if ("LOCKS".equalsIgnoreCase(txMode)) {
            this.propTxMode = 0;
        }
        switch (this.propTxMode) {
            case 0: {
                this.database.txManager = new TransactionManager2PL(this.database);
                break;
            }
            case 1: {
                this.database.txManager = new TransactionManagerMV2PL(this.database);
                break;
            }
            case 2: {
                this.database.txManager = new TransactionManagerMVCC(this.database);
            }
        }
        this.database.sqlEnforceSize = this.database.databaseProperties.isPropertyTrue("sql.enforce_strict_size");
        this.database.sqlEnforceSize = this.database.databaseProperties.isPropertyTrue("sql.enforce_size");
        this.database.sqlEnforceNames = this.database.databaseProperties.isPropertyTrue("sql.enforce_names");
        if (this.database.databaseProperties.isPropertyTrue("sql.compare_in_locale")) {
            this.database.collation.setCollationAsLocale();
        }
        this.propEventLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.applog");
        this.propFilesReadOnly = this.database.databaseProperties.isPropertyTrue("files_readonly");
        this.propDatabaseReadOnly = this.database.databaseProperties.isPropertyTrue("readonly");
        this.propIncrementBackup = this.database.databaseProperties.isPropertyTrue("hsqldb.incremental_backup");
        this.propNioDataFile = this.database.databaseProperties.isPropertyTrue("hsqldb.nio_data_file");
        this.propCacheMaxRows = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_rows");
        this.propCacheMaxSize = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_size") * 1024;
        this.propCacheFileScale = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_file_scale");
        this.propCacheDefragLimit = this.database.databaseProperties.getIntegerProperty("hsqldb.defrag_limit");
        this.propMaxFreeBlocks = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_free_count_scale");
        this.propMaxFreeBlocks = 1 << this.propMaxFreeBlocks;
        this.propTextAllowFullPath = this.database.databaseProperties.isPropertyTrue("textdb.allow_full_path");
        this.propWriteDelay = this.database.databaseProperties.isPropertyTrue("hsqldb.write_delay") ? 10000 : 0;
        this.propLogSize = this.database.databaseProperties.getIntegerProperty("hsqldb.log_size");
        this.propGC = this.database.databaseProperties.getIntegerProperty("runtime.gc_interval");
        this.database.setMetaDirty(false);
    }

    public boolean closePersistence(int closemode) {
        if (this.log == null) {
            return true;
        }
        try {
            switch (closemode) {
                case -1: {
                    this.log.shutdown();
                    break;
                }
                case 0: {
                    this.log.close(false);
                    break;
                }
                case 1: 
                case 2: {
                    this.log.close(true);
                }
            }
        }
        catch (Throwable e) {
            this.logSevereEvent("error closing log", e);
            this.log = null;
            return false;
        }
        this.logInfoEvent("Database closed");
        this.log = null;
        this.appLog.close();
        return true;
    }

    String newUniqueName() {
        String name = StringUtil.toPaddedString(Long.toHexString(System.currentTimeMillis()), 16, '0', false);
        name = "HSQLDB" + name.substring(6).toUpperCase(Locale.ENGLISH);
        return name;
    }

    public boolean hasPersistence() {
        return this.log != null;
    }

    private FrameworkLogger getEventLogger() {
        if (this.fwLogger != null) {
            return this.fwLogger;
        }
        String name = this.database.getUniqueName();
        if (name == null) {
            return null;
        }
        this.fwLogger = FrameworkLogger.getLog(Logger.class, this.database.getUniqueName());
        return this.fwLogger;
    }

    public void setEventLogLevel(int level) {
        this.propEventLogLevel = level;
        this.appLog.setLevel(level);
    }

    public void logSevereEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.severe(message, t);
        }
        if (this.appLog != null) {
            this.appLog.logContext(t, message);
        }
    }

    public void logWarningEvent(String message, Throwable t) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.warning(message, t);
        }
        this.appLog.logContext(t, message);
    }

    public void logInfoEvent(String message) {
        this.getEventLogger();
        if (this.fwLogger != null) {
            this.fwLogger.info(message);
        }
        this.appLog.logContext(2, message);
    }

    public DataFileCache getCache() {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    public boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void logStartSession(Session session) {
        if (this.loggingEnabled) {
            this.writeToLog(session, session.getUser().getConnectUserSQL());
        }
    }

    public synchronized void writeToLog(Session session, String statement) {
        if (this.loggingEnabled && this.log != null) {
            this.log.writeStatement(session, statement);
        }
    }

    public synchronized void writeInsertStatement(Session session, Table table, Object[] row) {
        if (this.loggingEnabled) {
            this.log.writeInsertStatement(session, table, row);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table t, Object[] row) {
        if (this.loggingEnabled) {
            this.log.writeDeleteStatement(session, t, row);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence s) {
        if (this.loggingEnabled) {
            this.log.writeSequenceStatement(session, s);
        }
    }

    public synchronized void writeCommitStatement(Session session) {
        if (this.loggingEnabled) {
            this.log.writeCommitStatement(session);
            this.synchLog();
        }
    }

    public synchronized void synchLog() {
        if (this.loggingEnabled && this.syncFile) {
            this.log.synchLog();
        }
    }

    public synchronized void synchLogForce() {
        if (this.loggingEnabled) {
            this.log.synchLog();
        }
    }

    public synchronized void checkpoint(boolean mode) {
        if (this.loggingEnabled) {
            this.logInfoEvent("Checkpoint start");
            this.log.checkpoint(mode);
            this.database.sessionManager.resetLoggedSchemas();
            this.logInfoEvent("Checkpoint end");
        }
        this.checkpointDue = false;
    }

    public synchronized void setLogSize(int megas) {
        this.propLogSize = megas;
        if (this.log != null) {
            this.log.setLogSize(this.propLogSize);
        }
    }

    public synchronized void setScriptType(int i) {
        if (this.log != null) {
            // empty if block
        }
    }

    public synchronized void setWriteDelay(int delay) {
        this.propWriteDelay = delay;
        if (this.log != null) {
            this.syncFile = delay == 0;
            this.log.setWriteDelay(delay);
        }
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public int getWriteDelay() {
        return this.propWriteDelay;
    }

    public int getLogSize() {
        return this.propLogSize;
    }

    public int getScriptType() {
        return this.log != null ? this.log.getScriptType() : 0;
    }

    public synchronized void setIncrementBackup(boolean val) {
        if (val == this.propIncrementBackup) {
            return;
        }
        this.propIncrementBackup = val;
        if (this.log != null) {
            this.log.setIncrementBackup(val);
            if (this.log.hasCache()) {
                this.database.logger.checkpointRequired = true;
            }
        }
    }

    public void setCacheMaxRows(int value) {
        this.propCacheMaxRows = value;
    }

    public int getCacheRowsDefault() {
        return this.propCacheMaxRows;
    }

    public void setCacheSize(int value) {
        this.propCacheMaxSize = value * 1024;
    }

    public int getCacheSize() {
        return this.propCacheMaxSize;
    }

    public void setCacheFileScale(int value) {
        this.propCacheFileScale = value;
    }

    public int getCacheFileScale() {
        return this.propCacheFileScale;
    }

    public void setDefagLimit(int value) {
        this.propCacheDefragLimit = value;
    }

    public int getDefragLimit() {
        return this.propCacheDefragLimit;
    }

    public void setDefaultTextTableProperties(String source, HsqlProperties props) {
        this.propTextSourceDefault = source;
        this.propTextSourceProps = props;
    }

    public DataFileCache openTextFilePersistence(Table table, String source, boolean readOnlyData, boolean reversed) {
        return this.log.openTextCache(table, source, readOnlyData, reversed);
    }

    public void closeTextCache(Table table) {
        this.log.closeTextCache(table);
    }

    public synchronized boolean needsCheckpointReset() {
        if (this.checkpointRequired && !this.checkpointDue && !this.checkpointDisabled) {
            this.checkpointDue = true;
            this.checkpointRequired = false;
            return true;
        }
        this.checkpointRequired = false;
        return false;
    }

    public void stopLogging() {
        this.loggingEnabled = false;
    }

    public void restartLogging() {
        this.loggingEnabled = this.logsStatements;
    }

    public boolean hasLockFile() {
        return this.lockFile != null;
    }

    public void acquireLock(String path) {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = LockFile.newLockFileLock(path);
    }

    public void releaseLock() {
        try {
            if (this.lockFile != null) {
                this.lockFile.tryRelease();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lockFile = null;
    }

    public void setNioDataFile(boolean value) {
        this.propNioDataFile = value;
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    public boolean isStoredFileAccess() {
        return this.isStoredFileAccess;
    }

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    public PersistentStore newStore(Session session, PersistentStoreCollection collection, TableBase table, boolean diskBased) {
        switch (table.getTableType()) {
            case 4: {
                DataFileCache cache = this.getCache();
                if (cache == null) break;
                return new RowStoreAVLDisk(collection, cache, (Table)table);
            }
            case 0: 
            case 3: {
                return new RowStoreAVLMemory(collection, (Table)table);
            }
            case 6: {
                return new RowStoreAVLDiskData(collection, (Table)table);
            }
            case 2: {
                diskBased = false;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                if (session == null) {
                    return null;
                }
                switch (table.persistenceScope) {
                    case 11: {
                        return new RowStoreAVLHybrid(session, collection, table, diskBased);
                    }
                    case 12: {
                        return new RowStoreAVLHybrid(session, collection, table, diskBased);
                    }
                    case 13: {
                        return new RowStoreAVLHybrid(session, collection, table, diskBased);
                    }
                }
            }
        }
        throw Error.runtimeError(401, "Logger");
    }

    public String[] getPropertiesSQL() {
        HsqlArrayList list = new HsqlArrayList();
        StringBuffer sb = new StringBuffer();
        sb.append("SET DATABASE ").append("UNIQUE").append(' ');
        sb.append("NAME").append(' ').append(this.database.getUniqueName());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("GC").append(' ');
        sb.append(this.propGC);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("DEFAULT").append(' ');
        sb.append("RESULT").append(' ').append("MEMORY");
        sb.append(' ').append("ROWS").append(' ');
        sb.append(this.database.getResultMaxMemoryRows());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("EVENT").append(' ');
        sb.append("LOG").append(' ').append("LEVEL");
        sb.append(' ').append(this.propEventLogLevel);
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("SIZE").append(' ');
        sb.append(this.database.sqlEnforceSize ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("SQL").append(' ');
        sb.append("NAMES").append(' ');
        sb.append(this.database.sqlEnforceNames ? "TRUE" : "FALSE");
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET DATABASE ").append("TRANSACTION");
        sb.append(' ').append("CONTROL").append(' ');
        switch (this.database.txManager.getTransactionControl()) {
            case 2: {
                sb.append("MVCC");
                break;
            }
            case 1: {
                sb.append("MVLOCKS");
                break;
            }
            case 0: {
                sb.append("LOCKS");
            }
        }
        list.add(sb.toString());
        sb.setLength(0);
        if (this.hasPersistence()) {
            int delay;
            boolean millis;
            if (this.database.schemaManager.getDefaultTableType() == 4) {
                list.add("SET DATABASE DEFAULT TABLE TYPE CACHED");
            }
            boolean bl = millis = (delay = this.propWriteDelay) > 0 && delay < 1000;
            if (millis) {
                if (delay < 20) {
                    delay = 20;
                }
            } else {
                delay /= 1000;
            }
            sb.setLength(0);
            sb.append("SET FILES ").append("WRITE").append(' ');
            sb.append("DELAY").append(' ').append(delay);
            if (millis) {
                sb.append(' ').append("MILLIS");
            }
            list.add(sb.toString());
            sb.setLength(0);
            sb.append("SET FILES ").append("BACKUP");
            sb.append(' ').append("INCREMENT").append(' ');
            sb.append(this.propIncrementBackup ? "TRUE" : "FALSE");
            list.add(sb.toString());
            sb.setLength(0);
            sb.append("SET FILES ").append("CACHE");
            sb.append(' ').append("SIZE").append(' ');
            sb.append(this.propCacheMaxSize / 1024);
            list.add(sb.toString());
            sb.setLength(0);
            sb.append("SET FILES ").append("CACHE");
            sb.append(' ').append("ROWS").append(' ');
            sb.append(this.propCacheMaxRows);
            list.add(sb.toString());
            sb.setLength(0);
            sb.append("SET FILES ").append("SCALE");
            sb.append(' ').append(this.propCacheFileScale);
            list.add(sb.toString());
            sb.setLength(0);
            sb.append("SET FILES ").append("DEFRAG");
            sb.append(' ').append(this.propCacheDefragLimit);
            list.add(sb.toString());
            sb.setLength(0);
            sb.append("SET FILES ").append("NIO");
            sb.append(' ').append("TRUE");
            list.add(sb.toString());
            sb.setLength(0);
            sb.append("SET FILES ").append("LOG").append(' ');
            sb.append("SIZE").append(' ').append(this.propLogSize);
            list.add(sb.toString());
            sb.setLength(0);
            sb.append("SET DATABASE ").append("TEXT").append(' ');
            sb.append("TABLE").append(' ').append("DEFAULTS");
            sb.append(' ').append('\'');
            sb.append(this.propTextSourceDefault).append('\'');
            list.add(sb.toString());
            sb.setLength(0);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public synchronized void backup(String destPath, String dbPath, boolean script, boolean blocking, boolean compressed) {
        boolean nameImpliesCompress;
        if (runtimeFileDelim == null) {
            runtimeFileDelim = new Character(System.getProperty("file.separator").charAt(0));
        }
        String instanceName = new File(dbPath).getName();
        if (destPath == null || destPath.length() < 1) {
            throw Error.error(3414, "0-length destination path");
        }
        char lastChar = destPath.charAt(destPath.length() - 1);
        boolean generateName = lastChar == '/' || lastChar == runtimeFileDelim.charValue();
        String defaultCompressionSuffix = compressed ? ".tar.gz" : ".tar";
        File archiveFile = generateName ? new File(destPath.substring(0, destPath.length() - 1), instanceName + '-' + backupFileFormat.format(new Date()) + defaultCompressionSuffix) : new File(destPath);
        boolean bl = nameImpliesCompress = archiveFile.getName().endsWith(".tar.gz") || archiveFile.getName().endsWith(".tgz");
        if (!nameImpliesCompress && !archiveFile.getName().endsWith(".tar")) {
            throw Error.error(null, 79, 0, new String[]{archiveFile.getName(), ".tar, .tar.gz, .tgz"});
        }
        if (compressed != nameImpliesCompress) {
            throw Error.error(null, 80, 0, new Object[]{new Boolean(compressed), archiveFile.getName()});
        }
        this.log.checkpointClose();
        try {
            this.logInfoEvent("Initiating backup of instance '" + instanceName + "'");
            DbBackup backup = new DbBackup(archiveFile, dbPath);
            backup.setAbortUponModify(false);
            backup.write();
            this.logInfoEvent("Successfully backed up instance '" + instanceName + "' to '" + destPath + "'");
        }
        catch (IllegalArgumentException iae) {
            throw Error.error(6609, iae.getMessage());
        }
        catch (IOException ioe) {
            throw Error.error(29, ioe.getMessage());
        }
        catch (TarMalformatException tme) {
            throw Error.error(29, tme.getMessage());
        }
        finally {
            this.log.checkpointReopen();
        }
    }
}

