/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.StringConverter;

public class LockFile {
    public static final long HEARTBEAT_INTERVAL = 10000L;
    public static final long HEARTBEAT_INTERVAL_PADDED = 10100L;
    protected static final byte[] MAGIC = new byte[]{72, 83, 81, 76, 76, 79, 67, 75};
    public static final int USED_REGION = 16;
    public static final int POLL_RETRIES_DEFAULT = 10;
    public static final String POLL_RETRIES_PROPERTY = "hsqldb.lockfile.poll.retries";
    public static final String POLL_INTERVAL_PROPERTY = "hsqldb.lockfile.poll.interval";
    public static final boolean USE_NIO_FILELOCK_DEFAULT = false;
    public static final String USE_NIO_FILELOCK_PROPERTY = "hsqldb.lockfile.nio.filelock";
    public static final boolean NIO_FILELOCK_AVAILABLE;
    public static final Class NIO_LOCKFILE_CLASS;
    protected static final HsqlTimer timer;
    protected File file;
    private String cpath;
    protected volatile RandomAccessFile raf;
    protected volatile boolean locked;
    private volatile Object timerTask;

    private static final LockFile newNIOLockFile() {
        if (NIO_FILELOCK_AVAILABLE && NIO_LOCKFILE_CLASS != null) {
            try {
                return (LockFile)NIO_LOCKFILE_CLASS.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected LockFile() {
    }

    public static final LockFile newLockFile(String path) throws FileCanonicalizationException, FileSecurityException {
        LockFile lockFile = LockFile.newNIOLockFile();
        if (lockFile == null) {
            lockFile = new LockFile();
        }
        lockFile.setPath(path);
        return lockFile;
    }

    public static final LockFile newLockFileLock(String path) throws HsqlException {
        LockFile lockFile = null;
        try {
            lockFile = LockFile.newLockFile(path + ".lck");
        }
        catch (BaseException e) {
            throw Error.error(11, e.getMessage());
        }
        boolean locked = false;
        try {
            locked = lockFile.tryLock();
        }
        catch (BaseException e) {
            throw Error.error(11, e.getMessage());
        }
        if (!locked) {
            throw Error.error(11, lockFile.toString());
        }
        return lockFile;
    }

    private final void checkHeartbeat(boolean withCreateNewFile) throws FileSecurityException, LockHeldExternallyException, UnexpectedEndOfFileException, UnexpectedFileIOException, UnexpectedFileNotFoundException, WrongLengthException, WrongMagicException {
        long lastHeartbeat;
        long length = 0L;
        try {
            if (withCreateNewFile) {
                try {
                    if (this.file.createNewFile()) {
                        return;
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (!this.file.exists()) {
                return;
            }
            length = this.file.length();
        }
        catch (SecurityException se) {
            throw new FileSecurityException(this, "checkHeartbeat", se);
        }
        if (length != 16L) {
            throw new WrongLengthException(this, "checkHeartbeat", length);
        }
        long now = System.currentTimeMillis();
        if (Math.abs(now - (lastHeartbeat = this.readHeartbeat())) <= 10100L) {
            throw new LockHeldExternallyException(this, "checkHeartbeat", now, lastHeartbeat);
        }
    }

    private final void closeRAF() throws UnexpectedFileIOException {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException ex) {
                throw new UnexpectedFileIOException(this, "closeRAF", ex);
            }
            finally {
                this.raf = null;
            }
        }
    }

    protected boolean doOptionalLockActions() {
        return false;
    }

    protected boolean doOptionalReleaseActions() {
        return false;
    }

    private final void setPath(String path) throws FileCanonicalizationException, FileSecurityException {
        path = FileUtil.getFileUtil().canonicalOrAbsolutePath(path);
        this.file = new File(path);
        try {
            FileUtil.getFileUtil().makeParentDirectories(this.file);
        }
        catch (SecurityException ex) {
            throw new FileSecurityException(this, "setPath", ex);
        }
        try {
            this.file = FileUtil.getFileUtil().canonicalFile(path);
        }
        catch (SecurityException ex) {
            throw new FileSecurityException(this, "setPath", ex);
        }
        catch (IOException ex) {
            throw new FileCanonicalizationException(this, "setPath", ex);
        }
        this.cpath = this.file.getPath();
    }

    private final void openRAF() throws UnexpectedFileNotFoundException, FileSecurityException, UnexpectedFileIOException {
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        catch (SecurityException ex) {
            throw new FileSecurityException(this, "openRAF", ex);
        }
        catch (FileNotFoundException ex) {
            throw new UnexpectedFileNotFoundException(this, "openRAF", ex);
        }
        catch (IOException ex) {
            throw new UnexpectedFileIOException(this, "openRAF", ex);
        }
    }

    private final void checkMagic(DataInputStream dis) throws FileSecurityException, UnexpectedEndOfFileException, UnexpectedFileIOException, WrongMagicException {
        boolean success = true;
        byte[] magic = new byte[MAGIC.length];
        try {
            for (int i = 0; i < MAGIC.length; ++i) {
                magic[i] = dis.readByte();
                if (MAGIC[i] == magic[i]) continue;
                success = false;
            }
        }
        catch (SecurityException ex) {
            throw new FileSecurityException(this, "checkMagic", ex);
        }
        catch (EOFException ex) {
            throw new UnexpectedEndOfFileException(this, "checkMagic", ex);
        }
        catch (IOException ex) {
            throw new UnexpectedFileIOException(this, "checkMagic", ex);
        }
        if (!success) {
            throw new WrongMagicException(this, "checkMagic", magic);
        }
    }

    private final long readHeartbeat() throws FileSecurityException, UnexpectedFileNotFoundException, UnexpectedEndOfFileException, UnexpectedFileIOException, WrongMagicException {
        long l;
        FileInputStream fis = null;
        DataInputStream dis = null;
        try {
            if (!this.file.exists()) {
                long l2 = Long.MIN_VALUE;
                return l2;
            }
            fis = new FileInputStream(this.file);
            dis = new DataInputStream(fis);
            this.checkMagic(dis);
            l = dis.readLong();
        }
        catch (SecurityException ex) {
            throw new FileSecurityException(this, "readHeartbeat", ex);
        }
        catch (FileNotFoundException ex) {
            throw new UnexpectedFileNotFoundException(this, "readHeartbeat", ex);
        }
        catch (EOFException ex) {
            throw new UnexpectedEndOfFileException(this, "readHeartbeat", ex);
        }
        catch (IOException ex) {
            throw new UnexpectedFileIOException(this, "readHeartbeat", ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return l;
    }

    private final void startHeartbeat() {
        if (this.timerTask == null || HsqlTimer.isCancelled(this.timerTask)) {
            HeartbeatRunner runner = new HeartbeatRunner();
            this.timerTask = timer.schedulePeriodicallyAfter(0L, 10000L, runner, true);
        }
    }

    private final void stopHeartbeat() {
        if (this.timerTask != null && !HsqlTimer.isCancelled(this.timerTask)) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    private final void writeMagic() throws FileSecurityException, UnexpectedEndOfFileException, UnexpectedFileIOException {
        try {
            this.raf.seek(0L);
            this.raf.write(MAGIC);
        }
        catch (SecurityException ex) {
            throw new FileSecurityException(this, "writeMagic", ex);
        }
        catch (EOFException ex) {
            throw new UnexpectedEndOfFileException(this, "writeMagic", ex);
        }
        catch (IOException ex) {
            throw new UnexpectedFileIOException(this, "writeMagic", ex);
        }
    }

    private final void writeHeartbeat() throws FileSecurityException, UnexpectedEndOfFileException, UnexpectedFileIOException {
        try {
            this.raf.seek(MAGIC.length);
            this.raf.writeLong(System.currentTimeMillis());
        }
        catch (SecurityException ex) {
            throw new FileSecurityException(this, "writeHeartbeat", ex);
        }
        catch (EOFException ex) {
            throw new UnexpectedEndOfFileException(this, "writeHeartbeat", ex);
        }
        catch (IOException ex) {
            throw new UnexpectedFileIOException(this, "writeHeartbeat", ex);
        }
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LockFile) {
            LockFile other = (LockFile)obj;
            return this.file == null ? other.file == null : this.file.equals(other.file);
        }
        return false;
    }

    public final String getCanonicalPath() {
        return this.cpath;
    }

    public final int hashCode() {
        return this.file == null ? 0 : this.file.hashCode();
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public static final boolean isLocked(String path) {
        boolean locked = true;
        try {
            LockFile lockFile = LockFile.newLockFile(path);
            lockFile.checkHeartbeat(false);
            locked = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locked;
    }

    public boolean isValid() {
        return this.isLocked() && this.file != null && this.file.exists() && this.raf != null;
    }

    public String toString() {
        return new StringBuffer(super.toString()).append("[file =").append(this.cpath).append(", exists=").append(this.file.exists()).append(", locked=").append(this.isLocked()).append(", valid=").append(this.isValid()).append(", ").append(this.toStringImpl()).append("]").toString();
    }

    protected String toStringImpl() {
        return "";
    }

    public int getPollHeartbeatRetries() {
        int retries = 10;
        try {
            retries = Integer.getInteger("hsqldb.lockfile_poll_retries", retries);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (retries < 1) {
            retries = 1;
        }
        return retries;
    }

    public long getPollHeartbeatInterval() {
        int retries = this.getPollHeartbeatRetries();
        long interval = 10L + 10100L / (long)retries;
        try {
            interval = Long.getLong(POLL_INTERVAL_PROPERTY, interval);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (interval <= 0L) {
            interval = 10L + 10100L / (long)retries;
        }
        return interval;
    }

    private final void pollHeartbeat() throws FileSecurityException, LockHeldExternallyException, UnexpectedFileNotFoundException, UnexpectedEndOfFileException, UnexpectedFileIOException, WrongLengthException, WrongMagicException {
        boolean success = false;
        int retries = this.getPollHeartbeatRetries();
        long interval = this.getPollHeartbeatInterval();
        BaseException reason = null;
        for (int i = retries; i > 0; --i) {
            try {
                this.checkHeartbeat(true);
                success = true;
                break;
            }
            catch (BaseException ex) {
                reason = ex;
                try {
                    Thread.sleep(interval);
                    continue;
                }
                catch (InterruptedException ex2) {
                    break;
                }
            }
        }
        if (!success) {
            if (reason instanceof FileSecurityException) {
                throw (FileSecurityException)reason;
            }
            if (reason instanceof LockHeldExternallyException) {
                throw (LockHeldExternallyException)reason;
            }
            if (reason instanceof UnexpectedFileNotFoundException) {
                throw (UnexpectedFileNotFoundException)reason;
            }
            if (reason instanceof UnexpectedEndOfFileException) {
                throw (UnexpectedEndOfFileException)reason;
            }
            if (reason instanceof UnexpectedFileIOException) {
                throw (UnexpectedFileIOException)reason;
            }
            if (reason instanceof WrongLengthException) {
                throw (WrongLengthException)reason;
            }
            if (reason instanceof WrongMagicException) {
                throw (WrongMagicException)reason;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryLock() throws FileSecurityException, LockHeldExternallyException, UnexpectedFileNotFoundException, UnexpectedEndOfFileException, UnexpectedFileIOException, WrongLengthException, WrongMagicException {
        if (this.locked) {
            return true;
        }
        try {
            this.pollHeartbeat();
            this.openRAF();
            this.doOptionalLockActions();
            this.writeMagic();
            this.writeHeartbeat();
            FileUtil.getFileUtil().deleteOnExit(this.file);
            this.locked = true;
            this.startHeartbeat();
        }
        finally {
            if (!this.locked) {
                this.doOptionalReleaseActions();
                try {
                    this.closeRAF();
                }
                catch (Exception exception) {}
            }
        }
        return this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryRelease() throws FileSecurityException, UnexpectedFileIOException {
        boolean released;
        boolean bl = released = !this.locked;
        if (released) {
            return true;
        }
        this.stopHeartbeat();
        this.doOptionalReleaseActions();
        UnexpectedFileIOException closeRAFReason = null;
        FileSecurityException securityReason = null;
        try {
            try {
                this.closeRAF();
            }
            catch (UnexpectedFileIOException ex) {
                closeRAFReason = ex;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                released = this.file.delete();
            }
            catch (SecurityException ex) {
                securityReason = new FileSecurityException(this, "tryRelease", ex);
            }
        }
        finally {
            this.locked = false;
        }
        if (closeRAFReason != null) {
            throw closeRAFReason;
        }
        if (securityReason != null) {
            throw securityReason;
        }
        return released;
    }

    protected final void finalize() throws Throwable {
        this.tryRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        timer = DatabaseManager.getTimer();
        Class<LockFile> clazz = LockFile.class;
        synchronized (LockFile.class) {
            boolean use = false;
            try {
                use = "true".equalsIgnoreCase(System.getProperty(USE_NIO_FILELOCK_PROPERTY, use ? "true" : "false"));
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean avail = false;
            Class<?> clazz2 = null;
            if (use) {
                try {
                    Class.forName("java.nio.channels.FileLock");
                    clazz2 = Class.forName("org.hsqldb.persist.NIOLockFile");
                    avail = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            NIO_FILELOCK_AVAILABLE = avail;
            NIO_LOCKFILE_CLASS = clazz2;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static final class WrongMagicException
    extends BaseException {
        private final byte[] magic;

        public WrongMagicException(LockFile lockFile, String inMethod, byte[] magic) {
            super(lockFile, inMethod);
            this.magic = magic;
        }

        @Override
        public String getMessage() {
            String message = super.getMessage() + " magic: ";
            message = message + (this.magic == null ? "null" : "'" + StringConverter.byteArrayToHexString(this.magic) + "'");
            return message;
        }

        public byte[] getMagic() {
            return this.magic == null ? null : (byte[])this.magic.clone();
        }
    }

    public static final class WrongLengthException
    extends BaseException {
        private final long length;

        public WrongLengthException(LockFile lockFile, String inMethod, long length) {
            super(lockFile, inMethod);
            this.length = length;
        }

        public long getLength() {
            return this.length;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " length: " + this.length;
        }
    }

    public static final class UnexpectedFileNotFoundException
    extends BaseException {
        private final FileNotFoundException reason;

        public UnexpectedFileNotFoundException(LockFile lockFile, String inMethod, FileNotFoundException reason) {
            super(lockFile, inMethod);
            this.reason = reason;
        }

        public FileNotFoundException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static final class UnexpectedFileIOException
    extends BaseException {
        private final IOException reason;

        public UnexpectedFileIOException(LockFile lockFile, String inMethod, IOException reason) {
            super(lockFile, inMethod);
            this.reason = reason;
        }

        public IOException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static final class UnexpectedEndOfFileException
    extends BaseException {
        private final EOFException reason;

        public UnexpectedEndOfFileException(LockFile lockFile, String inMethod, EOFException reason) {
            super(lockFile, inMethod);
            this.reason = reason;
        }

        public EOFException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static final class LockHeldExternallyException
    extends BaseException {
        private final long read;
        private final long heartbeat;

        public LockHeldExternallyException(LockFile lockFile, String inMethod, long read, long heartbeat) {
            super(lockFile, inMethod);
            this.read = read;
            this.heartbeat = heartbeat;
        }

        public long getHeartbeat() {
            return this.heartbeat;
        }

        public long getRead() {
            return this.read;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " read: " + HsqlDateTime.getTimestampString(this.read) + " heartbeat - read: " + (this.heartbeat - this.read) + " ms.";
        }
    }

    public static final class FileSecurityException
    extends BaseException {
        private final SecurityException reason;

        public FileSecurityException(LockFile lockFile, String inMethod, SecurityException reason) {
            super(lockFile, inMethod);
            this.reason = reason;
        }

        public SecurityException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static final class FileCanonicalizationException
    extends BaseException {
        private final IOException reason;

        public FileCanonicalizationException(LockFile lockFile, String inMethod, IOException reason) {
            super(lockFile, inMethod);
            this.reason = reason;
        }

        public IOException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static abstract class BaseException
    extends Exception {
        private final LockFile lockFile;
        private final String inMethod;

        public BaseException(LockFile lockFile, String inMethod) {
            if (lockFile == null) {
                throw new NullPointerException("lockFile");
            }
            if (inMethod == null) {
                throw new NullPointerException("inMethod");
            }
            this.lockFile = lockFile;
            this.inMethod = inMethod;
        }

        @Override
        public String getMessage() {
            return "lockFile: " + this.lockFile + " method: " + this.inMethod;
        }

        public String getInMethod() {
            return this.inMethod;
        }

        public LockFile getLockFile() {
            return this.lockFile;
        }
    }

    private final class HeartbeatRunner
    implements Runnable {
        private HeartbeatRunner() {
        }

        @Override
        public void run() {
            try {
                LockFile.this.writeHeartbeat();
            }
            catch (Throwable t) {
                Error.printSystemOut(t.toString());
            }
        }
    }
}

