/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;

public class LobStoreInJar
implements LobStore {
    int lobBlockSize = 32768;
    Database database;
    DataInputStream file;
    final String fileName;
    long realPosition;

    public LobStoreInJar(Database database, int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.database = database;
        try {
            this.fileName = database.getPath() + ".lobs";
        }
        catch (Throwable t) {
            throw Error.error(129, t);
        }
    }

    @Override
    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        if (this.file == null) {
            throw Error.error(29);
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            byte[] dataBytes = new byte[count];
            this.fileSeek(address);
            this.file.readFully(dataBytes, 0, count);
            this.realPosition = address + (long)count;
            return dataBytes;
        }
        catch (Throwable t) {
            throw Error.error(129, t);
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Throwable t) {
            throw Error.error(129, t);
        }
    }

    private void resetStream() throws IOException {
        InputStream fis;
        if (this.file != null) {
            this.file.close();
        }
        if ((fis = this.getClass().getResourceAsStream(this.fileName)) == null) {
            return;
        }
        this.file = new DataInputStream(fis);
        this.realPosition = 0L;
    }

    private void fileSeek(long position) throws IOException {
        long skipPosition;
        if (this.file == null) {
            this.resetStream();
        }
        if (position < (skipPosition = this.realPosition)) {
            this.resetStream();
            skipPosition = 0L;
        }
        while (position > skipPosition) {
            skipPosition += this.file.skip(position - skipPosition);
        }
        this.realPosition = position;
    }
}

