/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.LineGroupReader;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.LobStoreInJar;
import org.hsqldb.persist.LobStoreMem;
import org.hsqldb.persist.LobStoreRAFile;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;

public class LobManager {
    static final String resourceFileName = "/org/hsqldb/resources/lob-schema.sql";
    static final String[] starters = new String[]{"/*"};
    Database database;
    LobStore lobStore;
    Session sysLobSession;
    int lobBlockSize = 32768;
    int totalBlockLimitCount = 0x40000000;
    Statement getLob;
    Statement getLobPart;
    Statement deleteLob;
    Statement deleteLobPart;
    Statement divideLobPart;
    Statement createLob;
    Statement createLobPart;
    Statement setLobLength;
    Statement setLobUsage;
    Statement getNextLobId;
    private static String initialiseBlocksSQL = "INSERT INTO SYSTEM_LOBS.BLOCKS VALUES(?,?,?)";
    private static String getLobSQL = "SELECT * FROM SYSTEM_LOBS.LOB_IDS WHERE LOB_ID = ?";
    private static String getLobPartSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOB_ID = ? AND BLOCK_OFFSET + BLOCK_COUNT > ? AND BLOCK_OFFSET < ? ORDER BY BLOCK_OFFSET";
    private static String deleteLobPartSQL = "CALL SYSTEM_LOBS.DELETE_BLOCKS(?,?,?,?)";
    private static String createLobSQL = "INSERT INTO SYSTEM_LOBS.LOB_IDS VALUES(?, ?, ?, ?)";
    private static String updateLobLengthSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_LENGTH = ? WHERE LOB_ID = ?";
    private static String createLobPartSQL = "CALL SYSTEM_LOBS.ALLOC_BLOCKS(?, ?, ?)";
    private static String divideLobPartSQL = "CALL SYSTEM_LOBS.DIVIDE_BLOCK(?, ?)";
    private static String getSpanningBlockSQL = "SELECT * FROM SYSTEM_LOBS.LOBS WHERE LOB_ID = ? AND ? > BLOCK_OFFSET AND ? < BLOCK_OFFSET + BLOCK_COUNT";
    private static String updateLobUsageSQL = "UPDATE SYSTEM_LOBS.LOB_IDS SET LOB_USAGE_COUNT = ? WHERE LOB_ID = ?";
    private static String getNextLobIdSQL = "VALUES NEXT VALUE FOR SYSTEM_LOBS.LOB_ID";
    private static String deleteLobSQL = "CALL SYSTEM_LOBS.DELETE_LOB(?, ?)";

    public LobManager(Database database) {
        this.database = database;
    }

    public void createSchema() {
        Session session = this.sysLobSession = this.database.sessionManager.getSysLobSession();
        InputStream fis = this.getClass().getResourceAsStream(resourceFileName);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(fis, "ISO-8859-1");
        }
        catch (Exception e) {
            // empty catch block
        }
        LineNumberReader lineReader = new LineNumberReader(reader);
        LineGroupReader lg = new LineGroupReader(lineReader, starters);
        HashMappedList map = lg.getAsMap();
        lg.close();
        String sql = (String)map.get("/*lob_schema_definition*/");
        Statement statement = session.compileStatement(sql);
        Result result = statement.execute(session);
        HsqlNameManager.HsqlName name = this.database.schemaManager.getSchemaHsqlName("SYSTEM_LOBS");
        name.owner = SqlInvariants.LOBS_SCHEMA_HSQLNAME.owner;
        Table table = this.database.schemaManager.getTable(session, "BLOCKS", "SYSTEM_LOBS");
        this.getLob = session.compileStatement(getLobSQL);
        this.getLobPart = session.compileStatement(getLobPartSQL);
        this.createLob = session.compileStatement(createLobSQL);
        this.createLobPart = session.compileStatement(createLobPartSQL);
        this.divideLobPart = session.compileStatement(divideLobPartSQL);
        this.deleteLob = session.compileStatement(deleteLobSQL);
        this.deleteLobPart = session.compileStatement(deleteLobPartSQL);
        this.setLobLength = session.compileStatement(updateLobLengthSQL);
        this.setLobUsage = session.compileStatement(updateLobUsageSQL);
        this.getNextLobId = session.compileStatement(getNextLobIdSQL);
    }

    public void initialiseLobSpace() {
        Statement statement = this.sysLobSession.compileStatement(initialiseBlocksSQL);
        Object[] args = new Object[]{0, this.totalBlockLimitCount, 0L};
        this.sysLobSession.executeCompiledStatement(statement, args);
    }

    public void open() {
        this.lobStore = this.database.getType() == "res:" ? new LobStoreInJar(this.database, this.lobBlockSize) : (this.database.getType() == "file:" ? new LobStoreRAFile(this.database, this.lobBlockSize) : new LobStoreMem(this.lobBlockSize));
    }

    public void close() {
    }

    private long getNewLobID(Session session) {
        Result result = this.getNextLobId.execute(session);
        if (result.isError()) {
            return 0L;
        }
        RowSetNavigator navigator = result.getNavigator();
        boolean next = navigator.next();
        if (!next) {
            navigator.close();
            return 0L;
        }
        Object[] data = navigator.getCurrent();
        return (Long)data[0];
    }

    private Object[] getLobHeader(Session session, long lobID) {
        ResultMetaData meta = this.getLob.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = lobID;
        session.sessionContext.pushDynamicArguments(params);
        Result result = this.getLob.execute(session);
        session.sessionContext.popDynamicArguments();
        if (result.isError()) {
            return null;
        }
        RowSetNavigator navigator = result.getNavigator();
        boolean next = navigator.next();
        if (!next) {
            navigator.close();
            return null;
        }
        Object[] data = navigator.getCurrent();
        return data;
    }

    public BlobData getBlob(Session session, long lobID) {
        Object[] data = this.getLobHeader(session, lobID);
        if (data == null) {
            return null;
        }
        BlobDataID blob = new BlobDataID(lobID);
        return blob;
    }

    public ClobData getClob(Session session, long lobID) {
        Object[] data = this.getLobHeader(session, lobID);
        if (data == null) {
            return null;
        }
        ClobDataID clob = new ClobDataID(lobID);
        return clob;
    }

    public long createBlob(long length) {
        long lobID = this.getNewLobID(this.sysLobSession);
        ResultMetaData meta = this.createLob.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = lobID;
        params[1] = length;
        params[2] = 1L;
        params[3] = 30;
        Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params);
        return lobID;
    }

    public long createClob(long length) {
        long lobID = this.getNewLobID(this.sysLobSession);
        ResultMetaData meta = this.createLob.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = lobID;
        params[1] = length;
        params[2] = 1L;
        params[3] = 40;
        Result result = this.sysLobSession.executeCompiledStatement(this.createLob, params);
        return lobID;
    }

    public Result deleteLob(long lobID) {
        Session session = this.sysLobSession;
        ResultMetaData meta = this.deleteLob.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = lobID;
        params[1] = 0L;
        Result result = session.executeCompiledStatement(this.deleteLob, params);
        return result;
    }

    public Result getLength(Session session, long lobID) {
        try {
            long length = this.getLengthValue(session, lobID);
            return ResultLob.newLobSetResponse(lobID, length);
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
    }

    public long getLengthValue(Session session, long lobID) {
        Object[] data = this.getLobHeader(session, lobID);
        if (data == null) {
            throw Error.error(3474);
        }
        long length = (Long)data[1];
        return length;
    }

    public Result getLob(Session session, long lobID, long offset, long length) {
        throw Error.runtimeError(401, "LobManager");
    }

    public Result createDuplicateLob(Session session, long lobID) {
        long length;
        Object[] data = this.getLobHeader(session, lobID);
        if (data == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long newLobID = this.getNewLobID(session);
        Object[] params = new Object[data.length];
        params[0] = newLobID;
        params[1] = data[1];
        params[2] = data[2];
        params[3] = data[3];
        Result result = session.executeCompiledStatement(this.createLob, params);
        if (result.isError()) {
            return result;
        }
        long byteLength = length = ((Long)data[1]).longValue();
        int lobType = (Integer)data[1];
        if (lobType == 40) {
            byteLength *= 2L;
        }
        int newBlockCount = (int)byteLength / this.lobBlockSize;
        if (byteLength % (long)this.lobBlockSize != 0L) {
            ++newBlockCount;
        }
        this.createBlockAddresses(session, newLobID, 0, newBlockCount);
        int[][] sourceBlocks = this.getBlockAddresses(session, lobID, 0, Integer.MAX_VALUE);
        int[][] targetBlocks = this.getBlockAddresses(session, newLobID, 0, Integer.MAX_VALUE);
        try {
            this.copyBlockSet(sourceBlocks, targetBlocks);
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        return ResultLob.newLobSetResponse(newLobID, length);
    }

    private void copyBlockSet(int[][] source, int[][] target) {
        int sourceIndex = 0;
        int targetIndex = 0;
        do {
            int sourceOffset = source[sourceIndex][2] + sourceIndex;
            int targetOffset = target[targetIndex][2] + targetIndex;
            byte[] bytes = this.lobStore.getBlockBytes(sourceOffset, 1);
            this.lobStore.setBlockBytes(bytes, targetOffset, 1);
            ++targetOffset;
            if (++sourceOffset == source[sourceIndex][1]) {
                sourceOffset = 0;
                ++sourceIndex;
            }
            if (targetOffset != target[sourceIndex][1]) continue;
            targetOffset = 0;
            ++targetIndex;
        } while (sourceIndex != source.length);
    }

    public Result getChars(Session session, long lobID, long offset, int length) {
        Result result = this.getBytes(session, lobID, offset * 2L, length * 2);
        if (result.isError()) {
            return result;
        }
        byte[] bytes = ((ResultLob)result).getByteArray();
        HsqlByteArrayInputStream be = new HsqlByteArrayInputStream(bytes);
        char[] chars = new char[bytes.length / 2];
        try {
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = be.readChar();
            }
        }
        catch (Exception e) {
            return Result.newErrorResult(e);
        }
        return ResultLob.newLobGetCharsResponse(lobID, offset, chars);
    }

    public Result getBytes(Session session, long lobID, long offset, int length) {
        byte[] bytes;
        int blockOffset = (int)(offset / (long)this.lobBlockSize);
        int byteBlockOffset = (int)(offset % (long)this.lobBlockSize);
        int blockLimit = (int)((offset + (long)length) / (long)this.lobBlockSize);
        int byteLimitOffset = (int)((offset + (long)length) % (long)this.lobBlockSize);
        if (byteLimitOffset == 0) {
            byteLimitOffset = this.lobBlockSize;
        } else {
            ++blockLimit;
        }
        int dataBytesPosition = 0;
        byte[] dataBytes = new byte[length];
        int[][] blockAddresses = this.getBlockAddresses(session, lobID, blockOffset, blockLimit);
        if (blockAddresses.length == 0) {
            return Result.newErrorResult(Error.error(3474));
        }
        int i = 0;
        int blockCount = blockAddresses[i][1] + blockAddresses[i][2] - blockOffset;
        if (blockAddresses[i][1] + blockAddresses[i][2] > blockLimit) {
            blockCount -= blockAddresses[i][1] + blockAddresses[i][2] - blockLimit;
        }
        try {
            bytes = this.lobStore.getBlockBytes(blockAddresses[i][0] + blockOffset, blockCount);
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        int subLength = this.lobBlockSize * blockCount - byteBlockOffset;
        if (subLength > length) {
            subLength = length;
        }
        System.arraycopy(bytes, byteBlockOffset, dataBytes, dataBytesPosition, subLength);
        dataBytesPosition += subLength;
        ++i;
        while (i < blockAddresses.length && dataBytesPosition < length) {
            blockCount = blockAddresses[i][1];
            if (blockAddresses[i][1] + blockAddresses[i][2] > blockLimit) {
                blockCount -= blockAddresses[i][1] + blockAddresses[i][2] - blockLimit;
            }
            try {
                bytes = this.lobStore.getBlockBytes(blockAddresses[i][0], blockCount);
            }
            catch (HsqlException e) {
                return Result.newErrorResult(e);
            }
            subLength = this.lobBlockSize * blockCount;
            if (subLength > length - dataBytesPosition) {
                subLength = length - dataBytesPosition;
            }
            System.arraycopy(bytes, 0, dataBytes, dataBytesPosition, subLength);
            dataBytesPosition += subLength;
            ++i;
        }
        return ResultLob.newLobGetBytesResponse(lobID, offset, dataBytes);
    }

    public Result setBytesBA(Session session, long lobID, byte[] dataBytes, long offset, int length) {
        Object[] data = this.getLobHeader(session, lobID);
        if (data == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long oldLength = (Long)data[1];
        int blockOffset = (int)(offset / (long)this.lobBlockSize);
        int byteBlockOffset = (int)(offset % (long)this.lobBlockSize);
        int blockLimit = (int)((offset + (long)length) / (long)this.lobBlockSize);
        int byteLimitOffset = (int)((offset + (long)length) % (long)this.lobBlockSize);
        if (byteLimitOffset == 0) {
            byteLimitOffset = this.lobBlockSize;
        } else {
            ++blockLimit;
        }
        int[][] blockAddresses = this.getBlockAddresses(session, lobID, blockOffset, blockLimit);
        byte[] newBytes = new byte[(blockLimit - blockOffset) * this.lobBlockSize];
        if (blockAddresses.length > 0) {
            int blockAddress = blockAddresses[0][0] + (blockOffset - blockAddresses[0][2]);
            try {
                byte[] block = this.lobStore.getBlockBytes(blockAddress, 1);
                System.arraycopy(block, 0, newBytes, 0, this.lobBlockSize);
                if (blockAddresses.length > 1) {
                    blockAddress = blockAddresses[blockAddresses.length - 1][0] + (blockLimit - blockAddresses[blockAddresses.length - 1][2] - 1);
                    block = this.lobStore.getBlockBytes(blockAddress, 1);
                    System.arraycopy(block, 0, newBytes, blockLimit - blockOffset - 1, this.lobBlockSize);
                } else if (blockLimit - blockOffset > 1) {
                    blockAddress = blockAddresses[0][0] + (blockLimit - blockAddresses[0][2] - 1);
                    block = this.lobStore.getBlockBytes(blockAddress, 1);
                    System.arraycopy(block, 0, newBytes, (blockLimit - blockOffset - 1) * this.lobBlockSize, this.lobBlockSize);
                }
            }
            catch (HsqlException e) {
                return Result.newErrorResult(e);
            }
            this.divideBlockAddresses(session, lobID, blockOffset);
            this.divideBlockAddresses(session, lobID, blockLimit);
            this.deleteBlockAddresses(session, lobID, blockOffset, blockLimit);
        }
        this.createBlockAddresses(session, lobID, blockOffset, blockLimit - blockOffset);
        System.arraycopy(dataBytes, 0, newBytes, byteBlockOffset, length);
        blockAddresses = this.getBlockAddresses(session, lobID, blockOffset, blockLimit);
        try {
            for (int i = 0; i < blockAddresses.length; ++i) {
                this.lobStore.setBlockBytes(newBytes, blockAddresses[i][0], blockAddresses[i][1]);
            }
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e);
        }
        if (offset + (long)length > oldLength) {
            oldLength = offset + (long)length;
            this.setLength(session, lobID, oldLength);
        }
        return ResultLob.newLobSetResponse(lobID, 0L);
    }

    private Result setBytesIS(Session session, long lobID, InputStream inputStream, long length) {
        int blockLimit = (int)(length / (long)this.lobBlockSize);
        int byteLimitOffset = (int)(length % (long)this.lobBlockSize);
        if (byteLimitOffset == 0) {
            byteLimitOffset = this.lobBlockSize;
        } else {
            ++blockLimit;
        }
        this.createBlockAddresses(session, lobID, 0, blockLimit);
        int[][] blockAddresses = this.getBlockAddresses(session, lobID, 0, blockLimit);
        byte[] dataBytes = new byte[this.lobBlockSize];
        for (int i = 0; i < blockAddresses.length; ++i) {
            for (int j = 0; j < blockAddresses[i][1]; ++j) {
                int localLength = this.lobBlockSize;
                if (i == blockAddresses.length - 1 && j == blockAddresses[i][1] - 1) {
                    for (int k = localLength = byteLimitOffset; k < this.lobBlockSize; ++k) {
                        dataBytes[k] = 0;
                    }
                }
                try {
                    int count = 0;
                    while (localLength > 0) {
                        int read = inputStream.read(dataBytes, count, localLength);
                        if (read == -1) {
                            return Result.newErrorResult(new EOFException());
                        }
                        localLength -= read;
                        count += read;
                    }
                }
                catch (IOException e) {
                    return Result.newErrorResult(e);
                }
                try {
                    this.lobStore.setBlockBytes(dataBytes, blockAddresses[i][0] + j, 1);
                    continue;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e);
                }
            }
        }
        return ResultLob.newLobSetResponse(lobID, 0L);
    }

    public Result setBytes(Session session, long lobID, byte[] dataBytes, long offset) {
        if (dataBytes.length == 0) {
            return ResultLob.newLobSetResponse(lobID, 0L);
        }
        Object[] data = this.getLobHeader(session, lobID);
        if (data == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long length = (Long)data[1];
        Result result = this.setBytesBA(session, lobID, dataBytes, offset, dataBytes.length);
        if (offset + (long)dataBytes.length > length) {
            this.setLength(session, lobID, offset + (long)dataBytes.length);
        }
        return result;
    }

    public Result setBytesForNewBlob(long lobID, InputStream inputStream, long length) {
        Session session = this.sysLobSession;
        if (length == 0L) {
            return ResultLob.newLobSetResponse(lobID, 0L);
        }
        Result result = this.setBytesIS(session, lobID, inputStream, length);
        return result;
    }

    public Result setChars(Session session, long lobID, long offset, char[] chars) {
        if (chars.length == 0) {
            return ResultLob.newLobSetResponse(lobID, 0L);
        }
        Object[] data = this.getLobHeader(session, lobID);
        if (data == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long length = (Long)data[1];
        HsqlByteArrayOutputStream os = new HsqlByteArrayOutputStream(chars.length * 2);
        os.write(chars, 0, chars.length);
        Result result = this.setBytesBA(session, lobID, os.getBuffer(), offset * 2L, os.getBuffer().length);
        if (result.isError()) {
            return result;
        }
        if (offset + (long)chars.length > length && (result = this.setLength(session, lobID, offset + (long)chars.length)).isError()) {
            return result;
        }
        return ResultLob.newLobSetResponse(lobID, 0L);
    }

    public Result setCharsForNewClob(long lobID, InputStream inputStream, long length) {
        Session session = this.sysLobSession;
        if (length == 0L) {
            return ResultLob.newLobSetResponse(lobID, 0L);
        }
        Result result = this.setBytesIS(session, lobID, inputStream, length * 2L);
        if (result.isError()) {
            return result;
        }
        return ResultLob.newLobSetResponse(lobID, 0L);
    }

    public Result truncate(Session session, long lobID, long offset) {
        Object[] data = this.getLobHeader(session, lobID);
        if (data == null) {
            return Result.newErrorResult(Error.error(3474));
        }
        long length = (Long)data[1];
        int blockOffset = (int)(offset / (long)this.lobBlockSize);
        int blockLimit = (int)((offset + length) / (long)this.lobBlockSize);
        int byteLimitOffset = (int)((offset + length) % (long)this.lobBlockSize);
        if (byteLimitOffset != 0) {
            ++blockLimit;
        }
        ResultMetaData meta = this.deleteLobPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = lobID;
        params[1] = blockOffset;
        params[2] = blockLimit;
        params[3] = session.getTransactionTimestamp();
        Result result = session.executeCompiledStatement(this.deleteLobPart, params);
        this.setLength(session, lobID, offset);
        return ResultLob.newLobTruncateResponse(lobID);
    }

    public Result setLength(Session session, long lobID, long length) {
        ResultMetaData meta = this.setLobLength.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = length;
        params[1] = lobID;
        Result result = session.executeCompiledStatement(this.setLobLength, params);
        return result;
    }

    public Result adjustUsageCount(long lobID, int delta) {
        Object[] data = this.getLobHeader(this.sysLobSession, lobID);
        int count = ((Number)data[2]).intValue();
        if (count + delta == 0) {
            return this.deleteLob(lobID);
        }
        ResultMetaData meta = this.setLobUsage.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = (long)(count + delta);
        params[1] = lobID;
        Result result = this.sysLobSession.executeCompiledStatement(this.setLobLength, params);
        return result;
    }

    int[][] getBlockAddresses(Session session, long lobID, int offset, int limit) {
        ResultMetaData meta = this.getLobPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = lobID;
        params[1] = offset;
        params[2] = limit;
        session.sessionContext.pushDynamicArguments(params);
        Result result = this.getLobPart.execute(session);
        session.sessionContext.popDynamicArguments();
        RowSetNavigator navigator = result.getNavigator();
        int size = navigator.getSize();
        int[][] blocks = new int[size][3];
        for (int i = 0; i < size; ++i) {
            navigator.absolute(i);
            Object[] data = navigator.getCurrent();
            blocks[i][0] = (Integer)data[0];
            blocks[i][1] = (Integer)data[1];
            blocks[i][2] = (Integer)data[2];
        }
        navigator.close();
        return blocks;
    }

    void deleteBlockAddresses(Session session, long lobID, int offset, int count) {
        ResultMetaData meta = this.deleteLobPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = lobID;
        params[1] = offset;
        params[2] = count;
        Result result = session.executeCompiledStatement(this.deleteLobPart, params);
    }

    void divideBlockAddresses(Session session, long lobID, int offset) {
        ResultMetaData meta = this.divideLobPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = lobID;
        params[1] = offset;
        Result result = session.executeCompiledStatement(this.divideLobPart, params);
    }

    void createBlockAddresses(Session session, long lobID, int offset, int count) {
        ResultMetaData meta = this.createLobPart.getParametersMetaData();
        Object[] params = new Object[meta.getColumnCount()];
        params[0] = count;
        params[1] = offset;
        params[2] = lobID;
        Result result = session.executeCompiledStatement(this.createLobPart, params);
    }

    private static interface ALLOC_BLOCKS {
        public static final int BLOCK_COUNT = 0;
        public static final int BLOCK_OFFSET = 1;
        public static final int LOB_ID = 2;
    }

    private static interface LOBS {
        public static final int BLOCK_ADDR = 0;
        public static final int BLOCK_COUNT = 1;
        public static final int BLOCK_OFFSET = 2;
        public static final int LOB_ID = 3;
    }
}

