/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.hsqldb.Row;
import org.hsqldb.lib.HsqlLinkedList;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorLinkedList
extends RowSetNavigator {
    HsqlLinkedList list = new HsqlLinkedList();
    final HsqlLinkedList.Node root;
    HsqlLinkedList.Node previous;
    HsqlLinkedList.Node current = this.root = this.list.getHeadNode();

    @Override
    public Object[] getCurrent() {
        return ((Row)this.current.data).getData();
    }

    @Override
    public Row getCurrentRow() {
        return (Row)this.current.data;
    }

    @Override
    public void remove() {
        if (this.previous == null) {
            throw new NoSuchElementException();
        }
        if (this.currentPos < this.size && this.currentPos != -1) {
            this.list.removeAfter(this.previous);
            this.current = this.previous;
            --this.size;
            --this.currentPos;
            return;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean next() {
        boolean result = super.next();
        if (result) {
            this.previous = this.current;
            this.current = this.current.next;
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.current = this.root;
        this.previous = null;
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) throws IOException {
        this.beforeFirst();
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(0);
        out.writeInt(this.size);
        while (this.hasNext()) {
            Object[] data = this.getNext();
            out.writeData(meta.getColumnCount(), meta.columnTypes, data, null, null);
        }
        this.beforeFirst();
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) throws IOException {
        this.id = in.readLong();
        int count = in.readInt();
        in.readInt();
        in.readInt();
        while (count-- > 0) {
            this.add(in.readData(meta.columnTypes));
        }
    }

    @Override
    public void clear() {
        this.reset();
        this.list.clear();
        this.size = 0;
    }

    @Override
    public void add(Object d) {
        this.list.add(d);
        ++this.size;
    }
}

